/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.BytecodeLoadStore;
import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodeStore
extends BytecodeLoadStore {
    BytecodeStore(Method method, int bci) {
        super(method, bci);
    }

    public void verify() {
        Assert.that(this.isValid(), "check store");
    }

    public boolean isValid() {
        int jcode = this.javaCode();
        switch (jcode) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return true;
            }
        }
        return false;
    }

    public static BytecodeStore at(Method method, int bci) {
        BytecodeStore b = new BytecodeStore(method, bci);
        b.verify();
        return b;
    }

    public static BytecodeStore atCheck(Method method, int bci) {
        BytecodeStore b = new BytecodeStore(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeStore at(BytecodeStream bcs) {
        return new BytecodeStore(bcs.method(), bcs.bci());
    }
}

