/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.jdi.BooleanValueImpl;
import sun.jvm.hotspot.jdi.ByteValueImpl;
import sun.jvm.hotspot.jdi.CharValueImpl;
import sun.jvm.hotspot.jdi.DoubleValueImpl;
import sun.jvm.hotspot.jdi.FloatValueImpl;
import sun.jvm.hotspot.jdi.IntegerValueImpl;
import sun.jvm.hotspot.jdi.LocalVariableImpl;
import sun.jvm.hotspot.jdi.LocationImpl;
import sun.jvm.hotspot.jdi.LongValueImpl;
import sun.jvm.hotspot.jdi.MethodImpl;
import sun.jvm.hotspot.jdi.MirrorImpl;
import sun.jvm.hotspot.jdi.ReferenceTypeImpl;
import sun.jvm.hotspot.jdi.ShortValueImpl;
import sun.jvm.hotspot.jdi.ThreadReferenceImpl;
import sun.jvm.hotspot.jdi.ValueImpl;
import sun.jvm.hotspot.jdi.VirtualMachineImpl;
import sun.jvm.hotspot.jdi.VoidValueImpl;
import sun.jvm.hotspot.oops.Array;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.StackValueCollection;
import sun.jvm.hotspot.utilities.Assert;

public class StackFrameImpl
extends MirrorImpl
implements StackFrame {
    private boolean isValid = true;
    private final ThreadReferenceImpl thread;
    private final JavaVFrame saFrame;
    private final Location location;
    private Map visibleVariables = null;
    private ObjectReference thisObject = null;

    StackFrameImpl(VirtualMachine vm, ThreadReferenceImpl thread, JavaVFrame jvf) {
        super(vm);
        this.thread = thread;
        this.saFrame = jvf;
        Method SAMethod = jvf.getMethod();
        ReferenceTypeImpl rt = ((VirtualMachineImpl)vm).referenceType(SAMethod.getMethodHolder());
        this.location = new LocationImpl(vm, rt, SAMethod, jvf.getBCI());
    }

    private void validateStackFrame() {
        if (!this.isValid) {
            throw new InvalidStackFrameException("Thread has been resumed");
        }
    }

    JavaVFrame getJavaVFrame() {
        return this.saFrame;
    }

    public Location location() {
        this.validateStackFrame();
        return this.location;
    }

    public ThreadReference thread() {
        this.validateStackFrame();
        return this.thread;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof StackFrameImpl) {
            StackFrameImpl other = (StackFrameImpl)obj;
            return this.saFrame.equals(other.saFrame);
        }
        return false;
    }

    public int hashCode() {
        return this.saFrame.hashCode();
    }

    public ObjectReference thisObject() {
        this.validateStackFrame();
        MethodImpl currentMethod = (MethodImpl)this.location.method();
        if (currentMethod.isStatic() || currentMethod.isNative()) {
            return null;
        }
        if (this.thisObject == null) {
            StackValueCollection values = this.saFrame.getLocals();
            Assert.that(values.size() > 0, "this is missing");
            OopHandle handle = values.oopHandleAt(0);
            ObjectHeap heap = this.vm.saObjectHeap();
            this.thisObject = this.vm.objectMirror(heap.newOop(handle));
        }
        return this.thisObject;
    }

    private void createVisibleVariables() throws AbsentInformationException {
        if (this.visibleVariables == null) {
            List<LocalVariable> allVariables = this.location.method().variables();
            HashMap<String, LocalVariableImpl> map = new HashMap<String, LocalVariableImpl>(allVariables.size());
            Iterator<LocalVariable> iter = allVariables.iterator();
            while (iter.hasNext()) {
                LocalVariable existing;
                LocalVariableImpl variable = (LocalVariableImpl)iter.next();
                String name = variable.name();
                if (!variable.isVisible(this) || (existing = (LocalVariable)map.get(name)) != null && !variable.hides(existing)) continue;
                map.put(name, variable);
            }
            this.visibleVariables = map;
        }
    }

    public List visibleVariables() throws AbsentInformationException {
        this.validateStackFrame();
        this.createVisibleVariables();
        ArrayList mapAsList = new ArrayList(this.visibleVariables.values());
        Collections.sort(mapAsList);
        return mapAsList;
    }

    public LocalVariable visibleVariableByName(String name) throws AbsentInformationException {
        this.validateStackFrame();
        this.createVisibleVariables();
        return (LocalVariable)this.visibleVariables.get(name);
    }

    public Value getValue(LocalVariable variable) {
        ArrayList<LocalVariable> list = new ArrayList<LocalVariable>(1);
        list.add(variable);
        Map map = this.getValues(list);
        return (Value)map.get(variable);
    }

    /*
     * WARNING - void declaration
     */
    public Map getValues(List variables) {
        this.validateStackFrame();
        StackValueCollection values = this.saFrame.getLocals();
        int count = variables.size();
        HashMap<LocalVariableImpl, void> map = new HashMap<LocalVariableImpl, void>(count);
        for (int ii = 0; ii < count; ++ii) {
            void var7_7;
            ValueImpl valueImpl;
            LocalVariableImpl variable = (LocalVariableImpl)variables.get(ii);
            if (!variable.isVisible(this)) {
                throw new IllegalArgumentException(variable.name() + " is not valid at this frame location");
            }
            int ss = variable.slot();
            char c = variable.signature().charAt(0);
            BasicType variableType = BasicType.charToBasicType(c);
            OopHandle handle = null;
            ObjectHeap heap = this.vm.saObjectHeap();
            if (variableType == BasicType.T_BOOLEAN) {
                valueImpl = (BooleanValueImpl)this.vm.mirrorOf(values.booleanAt(ss));
            } else if (variableType == BasicType.T_CHAR) {
                valueImpl = (CharValueImpl)this.vm.mirrorOf(values.charAt(ss));
            } else if (variableType == BasicType.T_FLOAT) {
                valueImpl = (FloatValueImpl)this.vm.mirrorOf(values.floatAt(ss));
            } else if (variableType == BasicType.T_DOUBLE) {
                valueImpl = (DoubleValueImpl)this.vm.mirrorOf(values.doubleAt(ss));
            } else if (variableType == BasicType.T_BYTE) {
                valueImpl = (ByteValueImpl)this.vm.mirrorOf(values.byteAt(ss));
            } else if (variableType == BasicType.T_SHORT) {
                valueImpl = (ShortValueImpl)this.vm.mirrorOf(values.shortAt(ss));
            } else if (variableType == BasicType.T_INT) {
                valueImpl = (IntegerValueImpl)this.vm.mirrorOf(values.intAt(ss));
            } else if (variableType == BasicType.T_LONG) {
                valueImpl = (LongValueImpl)this.vm.mirrorOf(values.longAt(ss));
            } else if (variableType == BasicType.T_OBJECT) {
                handle = values.oopHandleAt(ss);
                valueImpl = this.vm.objectMirror(heap.newOop(handle));
            } else if (variableType == BasicType.T_ARRAY) {
                handle = values.oopHandleAt(ss);
                valueImpl = this.vm.arrayMirror((Array)heap.newOop(handle));
            } else if (variableType == BasicType.T_VOID) {
                valueImpl = new VoidValueImpl(this.vm);
            } else {
                throw new RuntimeException("Should not read here");
            }
            map.put(variable, var7_7);
        }
        return map;
    }

    public void setValue(LocalVariable variableIntf, Value valueIntf) throws InvalidTypeException, ClassNotLoadedException {
        this.vm.throwNotReadOnlyException("StackFrame.setValue()");
    }

    public String toString() {
        return this.location.toString() + " in thread " + this.thread.toString();
    }
}

