/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.Dictionary;
import sun.jvm.hotspot.memory.LoaderConstraintTable;
import sun.jvm.hotspot.memory.PlaceholderTable;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.OopField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class SystemDictionary {
    private static AddressField dictionaryField;
    private static AddressField sharedDictionaryField;
    private static AddressField placeholdersField;
    private static AddressField loaderConstraintTableField;
    private static OopField javaSystemLoaderField;
    private static int nofBuckets;
    private InstanceKlass objectKlass;
    private InstanceKlass classLoaderKlass;
    private InstanceKlass stringKlass;
    private InstanceKlass systemKlass;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("SystemDictionary");
        dictionaryField = type.getAddressField("_dictionary");
        sharedDictionaryField = type.getAddressField("_shared_dictionary");
        placeholdersField = type.getAddressField("_placeholders");
        loaderConstraintTableField = type.getAddressField("_loader_constraints");
        javaSystemLoaderField = type.getOopField("_java_system_loader");
        nofBuckets = db.lookupIntConstant("SystemDictionary::_nof_buckets");
    }

    public Dictionary dictionary() {
        Address tmp = dictionaryField.getValue();
        return (Dictionary)VMObjectFactory.newObject(Dictionary.class, tmp);
    }

    public Dictionary sharedDictionary() {
        Address tmp = sharedDictionaryField.getValue();
        return (Dictionary)VMObjectFactory.newObject(Dictionary.class, tmp);
    }

    public PlaceholderTable placeholders() {
        Address tmp = placeholdersField.getValue();
        return (PlaceholderTable)VMObjectFactory.newObject(PlaceholderTable.class, tmp);
    }

    public LoaderConstraintTable constraints() {
        Address tmp = placeholdersField.getValue();
        return (LoaderConstraintTable)VMObjectFactory.newObject(LoaderConstraintTable.class, tmp);
    }

    public InstanceKlass getObjectKlass() {
        if (this.objectKlass == null) {
            this.objectKlass = (InstanceKlass)this.find("java/lang/Object", null, null);
        }
        return this.objectKlass;
    }

    public InstanceKlass getStringKlass() {
        if (this.stringKlass == null) {
            this.stringKlass = (InstanceKlass)this.find("java/lang/String", null, null);
        }
        return this.stringKlass;
    }

    public InstanceKlass getClassLoaderKlass() {
        if (this.classLoaderKlass == null) {
            this.classLoaderKlass = (InstanceKlass)this.find("java/lang/ClassLoader", null, null);
        }
        return this.classLoaderKlass;
    }

    public InstanceKlass getSystemKlass() {
        if (this.systemKlass == null) {
            this.systemKlass = (InstanceKlass)this.find("java/lang/System", null, null);
        }
        return this.systemKlass;
    }

    public Oop javaSystemLoader() {
        return VM.getVM().getObjectHeap().newOop(javaSystemLoaderField.getValue());
    }

    public static int getNumOfBuckets() {
        return nofBuckets;
    }

    public Klass find(String className, Oop classLoader, Oop protectionDomain) {
        Symbol sym = VM.getVM().getSymbolTable().probe(className);
        if (sym == null) {
            return null;
        }
        return this.find(sym, classLoader, protectionDomain);
    }

    public Klass find(Symbol className, Oop classLoader, Oop protectionDomain) {
        Dictionary dict = this.dictionary();
        long hash = dict.computeHash(className, classLoader);
        int index = dict.hashToIndex(hash);
        return dict.find(index, hash, className, classLoader, protectionDomain);
    }

    public void allClassesDo(final ClassVisitor v) {
        ClassVisitor visitor = new ClassVisitor(){

            public void visit(Klass k) {
                for (Klass l = k; l != null; l = l.arrayKlassOrNull()) {
                    v.visit(l);
                }
            }
        };
        this.classesDo(visitor);
        VM.getVM().getUniverse().basicTypeClassesDo(visitor);
    }

    public void classesDo(ClassVisitor v) {
        this.dictionary().classesDo(v);
    }

    public void classesDo(ClassAndLoaderVisitor v) {
        this.dictionary().classesDo(v);
    }

    public void primArrayClassesDo(ClassAndLoaderVisitor v) {
        this.placeholders().primArrayClassesDo(v);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                SystemDictionary.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }

    public static interface ClassAndLoaderVisitor {
        public void visit(Klass var1, Oop var2);
    }

    public static interface ClassVisitor {
        public void visit(Klass var1);
    }
}

