/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp;

import java.util.Enumeration;
import java.util.Vector;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.Timestamp;

public class SnmpVarBindList
extends Vector {
    public String identity = "VarBindList ";
    Timestamp timestamp;

    public SnmpVarBindList() {
        super(5, 5);
    }

    public SnmpVarBindList(int n) {
        super(n);
    }

    public SnmpVarBindList(String string) {
        super(5, 5);
        this.identity = string;
    }

    public SnmpVarBindList(String string, Vector vector) {
        this(vector);
        this.identity = string;
    }

    public SnmpVarBindList(Vector vector) {
        super(vector.size(), 5);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            this.addElement((SnmpVarBind)snmpVarBind.clone());
        }
    }

    public SnmpVarBindList(SnmpVarBindList snmpVarBindList) {
        super(snmpVarBindList.size(), 5);
        snmpVarBindList.copyInto(this.elementData);
        this.elementCount = snmpVarBindList.size();
    }

    public synchronized void addInstance(String string) throws SnmpStatusException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ((SnmpVarBind)this.elementData[n2]).addInstance(string);
            ++n2;
        }
    }

    public synchronized void addVarBind(String string) throws SnmpStatusException {
        SnmpVarBind snmpVarBind = new SnmpVarBind(string);
        this.addVarBind(snmpVarBind);
    }

    public synchronized void addVarBind(SnmpVarBind snmpVarBind) {
        this.addElement(snmpVarBind);
    }

    public synchronized void addVarBind(String[] stringArray) throws SnmpStatusException {
        this.addVarBind(stringArray, null);
    }

    public final synchronized void addVarBind(String[] stringArray, String string) throws SnmpStatusException {
        int n = 0;
        while (n < stringArray.length) {
            SnmpVarBind snmpVarBind = new SnmpVarBind(stringArray[n]);
            snmpVarBind.addInstance(string);
            this.addElement(snmpVarBind);
            ++n;
        }
    }

    public synchronized void addVarBindList(SnmpVarBindList snmpVarBindList) {
        this.ensureCapacity(snmpVarBindList.size() + this.size());
        int n = 0;
        while (n < snmpVarBindList.size()) {
            this.addElement(snmpVarBindList.getVarBindAt(n));
            ++n;
        }
    }

    public synchronized boolean checkForUnspecifiedValue() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[n2];
            if (snmpVarBind.isUnspecifiedValue()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public synchronized boolean checkForValidValues() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[n2];
            if (!snmpVarBind.isValidValue()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public synchronized Object clone() {
        return this.cloneWithValue();
    }

    public synchronized SnmpVarBindList cloneWithValue() {
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList();
        snmpVarBindList.setTimestamp(this.getTimestamp());
        snmpVarBindList.ensureCapacity(this.size());
        int n = 0;
        while (n < this.size()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[n];
            snmpVarBindList.addElement(snmpVarBind.clone());
            ++n;
        }
        return snmpVarBindList;
    }

    public synchronized SnmpVarBindList cloneWithoutValue() {
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList();
        int n = this.size();
        snmpVarBindList.ensureCapacity(n);
        int n2 = 0;
        while (n2 < n) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[n2];
            snmpVarBindList.addElement(snmpVarBind.cloneWithoutValue());
            ++n2;
        }
        return snmpVarBindList;
    }

    public final synchronized void concat(Vector vector) {
        this.ensureCapacity(this.size() + vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addElement(enumeration.nextElement());
        }
    }

    public void finalize() {
        this.removeAllElements();
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public final synchronized SnmpVarBind getVarBindAt(int n) {
        return (SnmpVarBind)this.elementAt(n);
    }

    public synchronized int getVarBindCount() {
        return this.size();
    }

    public synchronized Enumeration getVarBindList() {
        return this.elements();
    }

    public synchronized int indexOfOid(SnmpOid snmpOid) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[n2];
            if (snmpOid.equals(snmpVarBind.getOid())) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public synchronized int indexOfOid(SnmpVarBind snmpVarBind) {
        return this.indexOfOid(snmpVarBind, 0, this.size());
    }

    public synchronized int indexOfOid(SnmpVarBind snmpVarBind, int n, int n2) {
        SnmpOid snmpOid = snmpVarBind.getOid();
        int n3 = n;
        while (n3 < n2) {
            SnmpVarBind snmpVarBind2 = (SnmpVarBind)this.elementData[n3];
            if (snmpOid.equals(snmpVarBind2.getOid())) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public String oidListToString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        int n = 0;
        while (n < this.elementCount) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[n];
            stringBuffer.append(String.valueOf(snmpVarBind.getOid().toString()) + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public synchronized boolean removeVarBind(String string) throws SnmpStatusException {
        SnmpVarBind snmpVarBind = new SnmpVarBind(string);
        int n = this.indexOfOid(snmpVarBind);
        try {
            this.removeElementAt(n);
            return true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public synchronized boolean removeVarBind(SnmpVarBind snmpVarBind) {
        return this.removeElement(snmpVarBind);
    }

    public synchronized boolean removeVarBind(String[] stringArray) throws SnmpStatusException {
        return this.removeVarBind(stringArray, null);
    }

    public synchronized boolean removeVarBind(String[] stringArray, String string) throws SnmpStatusException {
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            SnmpVarBind snmpVarBind = new SnmpVarBind(stringArray[n]);
            snmpVarBind.addInstance(string);
            int n2 = this.indexOfOid(snmpVarBind);
            try {
                this.removeElementAt(n2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public synchronized boolean removeVarBindList(SnmpVarBindList snmpVarBindList) {
        boolean bl = true;
        int n = 0;
        while (n < snmpVarBindList.size()) {
            bl = this.removeElement(snmpVarBindList.getVarBindAt(n));
            ++n;
        }
        return bl;
    }

    public final synchronized void replaceVarBind(SnmpVarBind snmpVarBind, int n) {
        this.setElementAt(snmpVarBind, n);
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public final synchronized void setVarBindList(Vector vector) {
        this.setVarBindList(vector, false);
    }

    public final synchronized void setVarBindList(Vector vector, boolean bl) {
        Vector vector2 = vector;
        synchronized (vector2) {
            int n = vector.size();
            this.setSize(n);
            vector.copyInto(this.elementData);
            if (bl) {
                int n2 = 0;
                while (n2 < n) {
                    SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[n2];
                    this.elementData[n2] = snmpVarBind.clone();
                    ++n2;
                }
            }
        }
    }

    public synchronized SnmpVarBindList splitAt(int n) {
        SnmpVarBindList snmpVarBindList = null;
        if (n > this.elementCount) {
            return snmpVarBindList;
        }
        snmpVarBindList = new SnmpVarBindList();
        int n2 = this.size();
        int n3 = n;
        while (n3 < n2) {
            snmpVarBindList.addElement(this.elementData[n3]);
            ++n3;
        }
        this.elementCount = n;
        this.trimToSize();
        return snmpVarBindList;
    }

    public synchronized Vector toVector(boolean bl) {
        int n = this.elementCount;
        if (!bl) {
            return (Vector)super.clone();
        }
        Vector<Object> vector = new Vector<Object>(n, 5);
        int n2 = 0;
        while (n2 < n) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[n2];
            vector.addElement(snmpVarBind.clone());
            ++n2;
        }
        return vector;
    }

    public synchronized String varBindListToString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        int n = 0;
        while (n < this.elementCount) {
            stringBuffer.append(String.valueOf(this.elementData[n].toString()) + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

