/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.CalendarSync;

import com.sun.pdasync.Conduits.CalendarSync.CalendarSyncConstants;
import com.sun.pdasync.Conduits.CalendarSync.CalendarSyncException;
import com.sun.pdasync.Conduits.CalendarSync.CalendarSyncRecord;
import com.sun.pdasync.Conduits.CalendarSync.CalendarSyncUtils;
import com.sun.pdasync.Conduits.CalendarSync.CalendarSyncWriter;
import com.sun.pdasync.Logger.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import palm.conduit.Record;
import palm.conduit.RecordManager;
import palm.conduit.SyncException;
import palm.conduit.SyncManager;
import palm.conduit.SyncProperties;
import sunw.jdt.cal.csa.Appointment;
import sunw.jdt.cal.csa.CalendarException;

public class CalendarSyncRecMgr
extends RecordManager {
    SyncProperties props;
    Vector hhRecords;
    Vector pcRecords;
    Vector archivedRecords;
    Vector backupRecords;
    Vector saveDeletedRecs;
    Vector slowPCRecords;
    Class recordClass;
    int db;
    int recordIndex;
    int recordCount;
    boolean slowSync;
    CalendarSyncException cse;
    CalendarSyncWriter dtWriter;
    private static final String MODIFY_BOTH_MSG1 = "The following record was modified on both the Palm organizer and the Desktop: ";
    private static final String MODIFY_BOTH_MSG2 = "This record will be duplicated on each platform. Delete the unwanted record and HotSync again.";
    private static final String MOD_DELETE_MSG1 = "The following record was modified on one platform and deleted on the other: ";
    private static final String MOD_DELETE_MSG2 = "The modified version will appear on both platforms.";
    private static Locale theLocale;
    private static ResourceBundle messages;

    static {
        try {
            theLocale = Locale.getDefault();
            messages = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.PDASyncMessages", theLocale);
        }
        catch (MissingResourceException e) {
            Logger.doLogging((String)"PDASync: can't find properties", (boolean)true);
            Logger.doLogging((String)("PDASync:" + e.getMessage()), (boolean)true);
            System.exit(1);
        }
    }

    public CalendarSyncRecMgr(SyncProperties props, int db, Class recordClass, CalendarSyncWriter calSyncWriter) {
        super(props, db, recordClass);
        this.props = props;
        this.db = db;
        this.recordClass = recordClass;
        this.dtWriter = calSyncWriter;
        this.hhRecords = new Vector();
        this.saveDeletedRecs = new Vector();
        this.slowSync = false;
    }

    private void addPCRecord(Record record) {
        if (this.slowSync) {
            this.slowPCRecords.addElement(record);
        } else {
            this.pcRecords.addElement(record);
        }
    }

    private void addRecord(Record record) throws CalendarSyncException {
        CalendarSyncUtils.doDebug("In addRecord()");
        CalendarSyncUtils.doDebug(((CalendarSyncRecord)record).toFormattedString());
        try {
            Appointment dtAppt = this.dtWriter.populateDtAppt((CalendarSyncRecord)record, null);
            dtAppt = CalendarSyncWriter.cal.insertAppt(dtAppt);
            ((CalendarSyncRecord)record).setApptId(dtAppt.getIdentifier());
            this.dtWriter.createNote((CalendarSyncRecord)record, dtAppt);
            this.addPCRecord(record);
        }
        catch (IOException iOException) {
            this.cse = new CalendarSyncException(4114);
            throw this.cse;
        }
        catch (CalendarException e) {
            this.cse = new CalendarSyncException(4097, e);
            throw this.cse;
        }
    }

    public void addToPcRecords(CalendarSyncRecord buRecord, Vector pcRecords, Date lookupRangeStartDate, Date lookupRangeEndDate) {
        Date date;
        int i = 0;
        while (i < pcRecords.size()) {
            CalendarSyncRecord pcRec = (CalendarSyncRecord)((Object)pcRecords.elementAt(i));
            if (buRecord.getApptId() == pcRec.getApptId()) break;
            ++i;
        }
        if (i == pcRecords.size() && (date = buRecord.getStartDate()) != null && date.before(lookupRangeEndDate) && ((date = buRecord.getRepeatType() == 0 ? buRecord.getEndDate() : buRecord.getRepeatEndDate()) == null || date.after(lookupRangeStartDate))) {
            File noteFile;
            buRecord.setIsDeleted(true);
            pcRecords.addElement(buRecord);
            if (buRecord.getNote() != null && (noteFile = new File(String.valueOf(CalendarSyncConstants.CALENDAR_DIR_PATH) + "/notes/" + buRecord.getId() + ".txt")).exists()) {
                noteFile.delete();
            }
        }
    }

    private void archiveRecord(Record record) throws SyncException {
        this.resetAttributes(record);
        this.archivedRecords.addElement(record);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkNote(CalendarSyncRecord buRec, CalendarSyncRecord pcRecord) throws IOException {
        block5: {
            CalendarSyncUtils.doDebug("In checkNote");
            if (buRec.getNote() == null) return;
            if (pcRecord.getNote() != null) return;
            CalendarSyncUtils.doDebug("backupRec not null, pcRecNote is null");
            File noteFile = new File(String.valueOf(CalendarSyncConstants.CALENDAR_DIR_PATH) + "/notes/" + buRec.getId() + ".txt");
            if (noteFile.exists()) {
                pcRecord.setNote(buRec.getNote());
                this.dtWriter.updateVectorList.addElement(pcRecord);
                CalendarSyncUtils.doDebug("Notefile Exists: Adding element to updateVectorList");
                return;
            }
            if (!pcRecord.isModified()) return;
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(noteFile);
                    String note = buRec.getNote();
                    fos.write(note.getBytes(), 0, note.length());
                }
                catch (IOException iOException) {
                    this.cse = new CalendarSyncException(4114);
                    throw this.cse;
                }
                Object var6_6 = null;
                if (fos == null) break block5;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            fos.close();
        }
        pcRecord.setIsModified(false);
    }

    private boolean compareRecords(Record firstRecord, Record secondRecord) throws IOException {
        CalendarSyncUtils.doDebug("In compareRecords()");
        boolean bothRepeating = false;
        CalendarSyncRecord csre1 = (CalendarSyncRecord)firstRecord;
        CalendarSyncRecord csre2 = (CalendarSyncRecord)secondRecord;
        Date repeatEndDate2 = null;
        Calendar gcal = Calendar.getInstance();
        gcal.setTime(csre1.getStartDate());
        gcal.set(13, 0);
        gcal.set(14, 0);
        gcal.setTime(csre2.getStartDate());
        gcal.set(13, 0);
        gcal.set(14, 0);
        gcal.setTime(csre1.getEndDate());
        gcal.set(13, 0);
        gcal.set(14, 0);
        gcal.setTime(csre2.getEndDate());
        gcal.set(13, 0);
        gcal.set(14, 0);
        Date red = csre1.getRepeatEndDate();
        if (red != null) {
            gcal.setTime(red);
            gcal.set(13, 0);
            gcal.set(14, 0);
        }
        if ((red = csre2.getRepeatEndDate()) != null) {
            gcal.setTime(red);
            gcal.set(13, 0);
            gcal.set(14, 0);
        }
        gcal = null;
        if (firstRecord.isPrivate() != secondRecord.isPrivate()) {
            CalendarSyncUtils.doDebug("Records are different because of different isPrivate");
            return false;
        }
        if (csre1.getIsRepeating() && csre2.getIsRepeating()) {
            int nTimes2;
            if (csre1.getRepeatType() != csre2.getRepeatType()) {
                CalendarSyncUtils.doDebug("Records are different because of different RepeatType");
                return false;
            }
            int nTimes1 = csre1.getRepeatEndDate() == null ? 0 : this.dtWriter.calculateNtimes(csre1.getStartDate(), csre1.getRepeatEndDate(), csre1, csre1.getRepeatType());
            if (nTimes1 != (nTimes2 = csre2.getRepeatEndDate() == null ? 0 : this.dtWriter.calculateNtimes(csre2.getStartDate(), csre2.getRepeatEndDate(), csre2, csre2.getRepeatType()))) {
                CalendarSyncUtils.doDebug("Records are different because of different nTimes");
                CalendarSyncUtils.doDebug("ntimes1 is " + nTimes1);
                CalendarSyncUtils.doDebug("ntimes2 is " + nTimes2);
                return false;
            }
            bothRepeating = true;
            Date repeatEndDate1 = csre1.getRepeatEndDate();
            repeatEndDate2 = csre2.getRepeatEndDate();
            csre2.setRepeatEndDate(repeatEndDate1);
        }
        int a_id1 = csre1.getApptId();
        csre1.setApptId(0);
        int a_id2 = csre2.getApptId();
        csre2.setApptId(0);
        boolean compare = firstRecord.equals(secondRecord);
        csre1.setApptId(a_id1);
        csre2.setApptId(a_id2);
        if (bothRepeating) {
            csre2.setRepeatEndDate(repeatEndDate2);
        }
        if (compare) {
            CalendarSyncUtils.doDebug("Records are the same");
            CalendarSyncUtils.doDebug("firstRecord is: ");
            CalendarSyncUtils.doDebug(((CalendarSyncRecord)firstRecord).toFormattedString());
            CalendarSyncUtils.doDebug("secondRecord is: ");
            CalendarSyncUtils.doDebug(((CalendarSyncRecord)secondRecord).toFormattedString());
        } else {
            CalendarSyncUtils.doDebug("Records are different");
            CalendarSyncUtils.doDebug("firstRecord is: ");
            CalendarSyncUtils.doDebug(((CalendarSyncRecord)firstRecord).toFormattedString());
            CalendarSyncUtils.doDebug("secondRecord is: ");
            CalendarSyncUtils.doDebug(((CalendarSyncRecord)secondRecord).toFormattedString());
        }
        return compare;
    }

    public Vector copyHHRecords() throws SyncException, IOException {
        this.pcRecords = new Vector();
        this.recordCount = SyncManager.getDBRecordCount((int)this.db);
        this.recordIndex = 0;
        while (this.recordIndex < this.recordCount) {
            Record hhRecord = this.getNewRecord();
            hhRecord.setIndex(this.recordIndex);
            SyncManager.readRecordByIndex((int)this.db, (Record)hhRecord);
            if (!hhRecord.isDeleted() && !hhRecord.isArchived()) {
                this.resetAttributes(hhRecord);
                this.addPCRecord(hhRecord);
            }
            ++this.recordIndex;
        }
        SyncManager.purgeDeletedRecs((int)this.db);
        SyncManager.resetSyncFlags((int)this.db);
        return this.pcRecords;
    }

    public Vector copyRangePCRecords(Vector pcRecs, Vector cbkRecs, Date start, Date end) throws SyncException, IOException {
        Record tmpRecord;
        this.hhRecords = this.pcRecords = pcRecs;
        CalendarSyncUtils.doDebug("In copyRangePCRecords");
        CalendarSyncUtils.doDebug("recordCound " + this.recordCount);
        this.recordCount = SyncManager.getDBRecordCount((int)this.db);
        this.recordIndex = 0;
        while (this.recordIndex < this.recordCount) {
            tmpRecord = this.getNewRecord();
            tmpRecord.setIndex(this.recordIndex);
            SyncManager.readRecordByIndex((int)this.db, (Record)tmpRecord);
            Date date = ((CalendarSyncRecord)tmpRecord).getStartDate();
            if (date != null && date.before(end)) {
                CalendarSyncRecord cfr_ignored_0 = (CalendarSyncRecord)tmpRecord;
                date = ((CalendarSyncRecord)tmpRecord).getRepeatType() == 0 ? ((CalendarSyncRecord)tmpRecord).getEndDate() : ((CalendarSyncRecord)tmpRecord).getRepeatEndDate();
                if (date == null || date.after(start)) {
                    SyncManager.deleteRecord((int)this.db, (Record)tmpRecord);
                    --this.recordIndex;
                    --this.recordCount;
                }
            }
            ++this.recordIndex;
        }
        int i = 0;
        while (i < this.hhRecords.size()) {
            tmpRecord = (Record)this.hhRecords.elementAt(i);
            tmpRecord.setId(0);
            ++i;
        }
        if (this.hhRecords != null) {
            i = 0;
            while (i < this.hhRecords.size()) {
                tmpRecord = (Record)this.hhRecords.elementAt(i);
                this.resetAttributes(tmpRecord);
                SyncManager.writeRec((int)this.db, (Record)tmpRecord);
                cbkRecs.addElement(tmpRecord);
                ++i;
            }
        }
        return this.pcRecords;
    }

    public void copyRecsInRange(Vector recs, Date rangeStartDate, Date rangeEndDate) {
        int i = 0;
        while (i < recs.size()) {
            CalendarSyncRecord csr = (CalendarSyncRecord)((Object)recs.elementAt(i));
            Date date = csr.getStartDate();
            if (date != null && date.after(rangeEndDate)) {
                recs.removeElement((Object)csr);
                continue;
            }
            date = csr.getRepeatType() == 0 ? csr.getEndDate() : csr.getRepeatEndDate();
            if (date != null && date.before(rangeStartDate)) {
                recs.removeElement((Object)csr);
                continue;
            }
            ++i;
        }
    }

    private void deleteHHRecord(Record record) throws SyncException {
        SyncManager.deleteRecord((int)this.db, (Record)record);
        this.removeElementById(record);
        --this.recordCount;
        --this.recordIndex;
    }

    private void deletePCRecord(Record pcRecord) {
        this.pcRecords.removeElement(pcRecord);
        this.saveDeletedRecs.addElement(pcRecord);
    }

    private void deleteRecord(Record pcRecord) throws CalendarSyncException {
        CalendarSyncUtils.doDebug("In deleteRecord()");
        CalendarSyncUtils.doDebug(((CalendarSyncRecord)pcRecord).toFormattedString());
        try {
            this.deleteRecordFromDT(pcRecord);
            this.deletePCRecord(pcRecord);
        }
        catch (CalendarException e) {
            this.cse = new CalendarSyncException(4098, e);
            throw this.cse;
        }
    }

    private void deleteRecordFromDT(Record pcRecord) throws CalendarException {
        CalendarSyncUtils.doDebug("In deleteRecordFromDT()");
        CalendarSyncUtils.doDebug(((CalendarSyncRecord)pcRecord).toFormattedString());
        Appointment dtAppt = null;
        int i = 0;
        while (this.dtWriter.localAppts != null && i < this.dtWriter.localAppts.size()) {
            dtAppt = (Appointment)this.dtWriter.localAppts.elementAt(i);
            if (((CalendarSyncRecord)pcRecord).getApptId() == dtAppt.getIdentifier()) break;
            ++i;
        }
        if (dtAppt == null || i == this.dtWriter.localAppts.size()) {
            dtAppt = CalendarSyncWriter.cal.lookupApptById(((CalendarSyncRecord)pcRecord).getApptId());
        }
        if (dtAppt != null) {
            CalendarSyncWriter.cal.deleteAppt(dtAppt);
            this.dtWriter.updateVectorList.removeElement(pcRecord);
            this.dtWriter.removeNote(dtAppt);
        }
    }

    public Vector fastSyncData(Vector pcRecords, Vector archivedRecords, Vector buRecords, Vector allCbkRecords, Date lookupRangeStartDate, Date lookupRangeEndDate) throws SyncException, IOException {
        Object pcRecord;
        Date date;
        CalendarSyncUtils.doDebug("In fastSyncData()");
        boolean allRecordsRead = false;
        Vector<Object> cbkRecords = new Vector<Object>();
        this.pcRecords = pcRecords;
        this.archivedRecords = archivedRecords;
        if (this.pcRecords == null) {
            this.pcRecords = new Vector();
        }
        this.updatePCrecordFlags(pcRecords, buRecords, lookupRangeStartDate, lookupRangeEndDate);
        CalendarSyncRecord rec = null;
        this.recordIndex = 0;
        while (!allRecordsRead) {
            try {
                Record hhRecord = this.getNewRecord();
                SyncManager.readNextModifiedRec((int)this.db, (Record)hhRecord);
                if (!hhRecord.isDeleted()) {
                    cbkRecords.addElement(hhRecord);
                }
                if ((date = ((CalendarSyncRecord)hhRecord).getStartDate()) == null && hhRecord.isDeleted() && (rec = (CalendarSyncRecord)this.getRecordById(hhRecord.getId(), buRecords)) != null) {
                    date = rec.getStartDate();
                }
                if (date != null && date.after(lookupRangeEndDate)) continue;
                CalendarSyncRecord cfr_ignored_0 = (CalendarSyncRecord)hhRecord;
                if (((CalendarSyncRecord)hhRecord).getRepeatType() == 0) {
                    date = ((CalendarSyncRecord)hhRecord).getEndDate();
                    if (date == null && rec != null) {
                        date = rec.getEndDate();
                    }
                } else {
                    date = ((CalendarSyncRecord)hhRecord).getRepeatEndDate();
                    if (date == null && rec != null) {
                        date = rec.getRepeatEndDate();
                    }
                }
                if (date != null && date.before(lookupRangeStartDate)) continue;
                this.hhRecords.addElement(hhRecord);
                this.synchronizeHHRecord(hhRecord, false);
            }
            catch (SyncException syncException) {
                allRecordsRead = true;
            }
        }
        allCbkRecords = this.mergeCbkRecords(cbkRecords, allCbkRecords);
        cbkRecords = null;
        cbkRecords = new Vector();
        int i = 0;
        while (i < allCbkRecords.size()) {
            CalendarSyncRecord cbkRecord = (CalendarSyncRecord)((Object)allCbkRecords.elementAt(i));
            if (!cbkRecord.isDeleted()) {
                date = cbkRecord.getStartDate();
                if (date.after(lookupRangeEndDate)) {
                    cbkRecords.addElement((Object)cbkRecord);
                } else {
                    date = cbkRecord.getRepeatType() == 0 ? cbkRecord.getEndDate() : cbkRecord.getRepeatEndDate();
                    if (date != null && date.before(lookupRangeStartDate)) {
                        cbkRecords.addElement((Object)cbkRecord);
                    }
                }
            }
            ++i;
        }
        allRecordsRead = false;
        this.recordIndex = 0;
        while (!allRecordsRead) {
            pcRecord = this.getNextModifiedRecord();
            if (pcRecord != null) {
                this.synchronizePCRecord((Record)pcRecord);
                this.resetAttributes((Record)pcRecord);
                continue;
            }
            allRecordsRead = true;
        }
        i = 0;
        while (i < pcRecords.size()) {
            pcRecord = (CalendarSyncRecord)((Object)pcRecords.elementAt(i));
            if (!pcRecord.isDeleted()) {
                cbkRecords.addElement(pcRecord);
            }
            ++i;
        }
        this.writeHHRecords();
        return cbkRecords;
    }

    private Record getNewRecord() {
        Record hhRecord = null;
        try {
            hhRecord = (Record)this.recordClass.newInstance();
        }
        catch (Throwable t) {
            System.out.println("Uncaught exception: " + t);
            t.printStackTrace();
        }
        return hhRecord;
    }

    private Record getNextModifiedRecord() {
        if (this.pcRecords != null) {
            int i = this.recordIndex;
            while (i < this.pcRecords.size()) {
                Record record = (Record)this.pcRecords.elementAt(i);
                ++this.recordIndex;
                if (this.props.firstDevice == 2 || record.isModified() || record.isNew() || record.isDeleted() || record.isArchived()) {
                    return record;
                }
                ++i;
            }
        }
        return null;
    }

    private Record getRecordById(int id, Vector records) {
        if (records != null) {
            int i = 0;
            while (i < records.size()) {
                Record tempRecord = (Record)records.elementAt(i);
                if (tempRecord.getId() == id) {
                    return tempRecord;
                }
                ++i;
            }
        }
        return null;
    }

    public void handleArchived(Record hhRecord, Record pcRecord) throws IOException {
        Record backupRecord;
        CalendarSyncUtils.doDebug("In handleArchived()");
        if (!pcRecord.isModified()) {
            this.archiveRecord(hhRecord);
            this.deleteHHRecord(hhRecord);
            this.deleteRecord(pcRecord);
            return;
        }
        if (!(hhRecord.isModified() || hhRecord.isNew() || hhRecord.isDeleted() || this.props.syncType != 1 || (backupRecord = this.getRecordById(hhRecord.getId(), this.backupRecords)) != null && this.compareRecords(hhRecord, backupRecord))) {
            hhRecord.setIsModified(true);
        }
        if (hhRecord.isModified()) {
            if (this.compareRecords(hhRecord, pcRecord)) {
                this.archiveRecord(hhRecord);
                this.deleteHHRecord(hhRecord);
                this.deleteRecord(pcRecord);
            } else {
                pcRecord.setId(0);
                pcRecord.setIsNew(true);
                this.resetAttributes(hhRecord);
                this.addRecord(hhRecord);
            }
        } else if (pcRecord.isArchived() || pcRecord.isDeleted()) {
            this.archiveRecord(hhRecord);
            this.deleteRecord(pcRecord);
            this.deleteHHRecord(hhRecord);
        } else {
            this.resetAttributes(pcRecord);
            this.deleteHHRecord(hhRecord);
            this.hhRecords.addElement(pcRecord);
        }
    }

    public void handleDeleted(Record hhRecord, Record pcRecord) throws IOException {
        CalendarSyncUtils.doDebug("In handleDeleted()");
        if (pcRecord.isModified()) {
            CalendarSyncUtils.doDebug("pcRecord is Modified");
            this.deleteHHRecord(hhRecord);
            this.resetAttributes(pcRecord);
            this.hhRecords.addElement(pcRecord);
            if (this.slowSync) {
                this.slowPCRecords.addElement(pcRecord);
            }
            Logger.doLogging((String)" ");
            Logger.doLogging((String)messages.getString(MOD_DELETE_MSG1));
            Logger.doLogging((String)pcRecord.toString());
            Logger.doLogging((String)messages.getString(MOD_DELETE_MSG2));
            Logger.doLogging((String)" ");
        } else {
            CalendarSyncUtils.doDebug("pcRecord is not Modified");
            this.deleteHHRecord(hhRecord);
            this.deleteRecord(pcRecord);
        }
    }

    public void handleModified(Record hhRecord, Record pcRecord) throws IOException {
        CalendarSyncUtils.doDebug("In handleModified()");
        if (!hhRecord.isModified()) {
            CalendarSyncUtils.doDebug("hhRecord is not modified");
            Record backupRecord = this.getRecordById(hhRecord.getId(), this.backupRecords);
            if (backupRecord == null || !this.compareRecords(hhRecord, backupRecord)) {
                hhRecord.setIsModified(true);
            }
        }
        if (hhRecord.isModified()) {
            CalendarSyncUtils.doDebug("hhRecord is modified");
            if (pcRecord.isDeleted()) {
                CalendarSyncUtils.doDebug("pcRecord is deleted, adding pcRecord");
                this.addRecord(hhRecord);
                Logger.doLogging((String)" ");
                Logger.doLogging((String)messages.getString(MOD_DELETE_MSG1));
                Logger.doLogging((String)hhRecord.toString());
                Logger.doLogging((String)messages.getString(MOD_DELETE_MSG2));
                Logger.doLogging((String)" ");
            } else if (!pcRecord.isModified()) {
                CalendarSyncUtils.doDebug("pcRecord is not modified");
                this.resetAttributes(hhRecord);
                this.updateRecord(pcRecord, hhRecord);
            } else if (this.compareRecords(hhRecord, pcRecord)) {
                CalendarSyncUtils.doDebug("records same");
                if (pcRecord.isDeleted()) {
                    CalendarSyncUtils.doDebug("same and pcRecord deleted");
                    this.deleteRecord(pcRecord);
                    this.deleteHHRecord(hhRecord);
                } else {
                    this.resetAttributes(pcRecord);
                    if (this.slowSync) {
                        this.slowPCRecords.addElement(pcRecord);
                    }
                }
            } else {
                this.resetAttributes(pcRecord);
                pcRecord.setIsNew(true);
                pcRecord.setId(0);
                this.resetAttributes(hhRecord);
                this.addRecord(hhRecord);
                Logger.doLogging((String)" ");
                Logger.doLogging((String)messages.getString(MODIFY_BOTH_MSG1));
                Logger.doLogging((String)hhRecord.toString());
                Logger.doLogging((String)messages.getString(MODIFY_BOTH_MSG2));
                Logger.doLogging((String)" ");
            }
        } else {
            if (pcRecord.isDeleted()) {
                this.deleteHHRecord(hhRecord);
            } else if (pcRecord.isModified() && !this.compareRecords(hhRecord, pcRecord)) {
                this.hhRecords.addElement(pcRecord);
                this.slowPCRecords.addElement(pcRecord);
            } else {
                this.slowPCRecords.addElement(pcRecord);
            }
            this.pcRecords.removeElement(pcRecord);
        }
    }

    private Vector mergeCbkRecords(Vector cbkRecords, Vector allCbkRecords) throws IOException {
        CalendarSyncUtils.doDebug("In mergeCbkRecords()");
        int i = 0;
        while (i < cbkRecords.size()) {
            CalendarSyncRecord cbkRecord = (CalendarSyncRecord)((Object)cbkRecords.elementAt(i));
            int j = 0;
            while (j < allCbkRecords.size()) {
                if (cbkRecord.getId() == ((CalendarSyncRecord)((Object)allCbkRecords.elementAt(j))).getId()) {
                    allCbkRecords.removeElementAt(j);
                    allCbkRecords.insertElementAt(cbkRecord, j);
                    break;
                }
                ++j;
            }
            if (j == allCbkRecords.size()) {
                allCbkRecords.addElement(cbkRecord);
            }
            ++i;
        }
        allCbkRecords.trimToSize();
        return allCbkRecords;
    }

    private void removeElementById(Record hhRecord) {
        int i = 0;
        while (i < this.hhRecords.size()) {
            CalendarSyncRecord hhRecordElement = (CalendarSyncRecord)((Object)this.hhRecords.elementAt(i));
            if (hhRecord.getId() == hhRecordElement.getId()) {
                this.hhRecords.removeElementAt(i);
                break;
            }
            ++i;
        }
    }

    private void resetAttributes(Record record) {
        record.setIsModified(false);
        record.setIsArchived(false);
        record.setIsDeleted(false);
        record.setIsNew(false);
    }

    private Record retrieveHHRecord(Record pcRecord) throws IOException {
        Record hhRecord = this.getNewRecord();
        hhRecord.setId(pcRecord.getId());
        try {
            SyncManager.readRecordById((int)this.db, (Record)hhRecord);
        }
        catch (SyncException syncException) {
            return null;
        }
        return hhRecord;
    }

    public void setPcRecFlags(CalendarSyncRecord pcRecord, Vector buRecords) throws IOException {
        CalendarSyncUtils.doDebug("In setPcRecFlags()");
        CalendarSyncRecord buRec = null;
        int i = 0;
        while (i < buRecords.size()) {
            buRec = (CalendarSyncRecord)((Object)buRecords.elementAt(i));
            if (buRec.getApptId() == pcRecord.getApptId()) {
                pcRecord.setId(buRec.getId());
                CalendarSyncUtils.doDebug("pcRecord Id is " + pcRecord.getId());
                break;
            }
            ++i;
        }
        if (i < buRecords.size()) {
            this.checkNote(buRec, pcRecord);
            Appointment dtAppt = this.dtWriter.getApptById(pcRecord.getApptId());
            if (dtAppt != null && this.dtWriter.getLastSyncDate() != null) {
                Date md = dtAppt.getModificationDate();
                if (md != null && this.dtWriter.getLastSyncDate().getTime() < md.getTime()) {
                    pcRecord.setIsModified(true);
                    CalendarSyncUtils.doDebug("pcRecord is marked Modified");
                    CalendarSyncUtils.doDebug("pcRecord's ApptId is " + pcRecord.getApptId());
                    CalendarSyncUtils.doDebug("pcRecord's record Id is " + pcRecord.getId());
                } else if (buRec.getNote() != null && pcRecord.getNote() != null && !buRec.getNote().equals(pcRecord.getNote())) {
                    pcRecord.setIsModified(true);
                }
            } else if (!this.compareRecords((Record)buRec, (Record)pcRecord)) {
                pcRecord.setIsModified(true);
                CalendarSyncUtils.doDebug("pcRecord is marked Modified");
                CalendarSyncUtils.doDebug("pcRecord's ApptId is " + pcRecord.getApptId());
                CalendarSyncUtils.doDebug("pcRecord's record Id is " + pcRecord.getId());
            }
        } else {
            pcRecord.setIsNew(true);
        }
    }

    public Vector slowSyncData(Vector pcRecords, Vector archivedRecords, Vector backupRecords, Vector cbkRecords, Date lookupRangeStartDate, Date lookupRangeEndDate) throws SyncException, IOException {
        CalendarSyncRecord pcRecord;
        int i;
        CalendarSyncUtils.doDebug("In slowSyncData()");
        boolean allRecordsRead = false;
        boolean firstSync = false;
        this.backupRecords = backupRecords;
        this.pcRecords = pcRecords;
        this.archivedRecords = archivedRecords;
        if (this.pcRecords == null) {
            this.pcRecords = new Vector();
        }
        this.recordIndex = 0;
        this.slowPCRecords = new Vector();
        this.slowSync = true;
        if (backupRecords.size() > 0) {
            this.updatePCrecordFlags(pcRecords, backupRecords, lookupRangeStartDate, lookupRangeEndDate);
        } else {
            if (backupRecords.size() == 0) {
                firstSync = true;
            }
            i = 0;
            while (i < pcRecords.size()) {
                ((Record)pcRecords.elementAt(i)).setIsNew(true);
                ++i;
            }
        }
        if (firstSync) {
            SyncManager.purgeDeletedRecs((int)this.db);
        }
        this.recordCount = SyncManager.getDBRecordCount((int)this.db);
        CalendarSyncRecord rec = null;
        Date date = null;
        this.recordIndex = 0;
        while (this.recordIndex < this.recordCount) {
            Record hhRecord = this.getNewRecord();
            hhRecord.setIndex(this.recordIndex);
            SyncManager.readRecordByIndex((int)this.db, (Record)hhRecord);
            date = ((CalendarSyncRecord)hhRecord).getStartDate();
            if (date == null && hhRecord.isDeleted() && (rec = (CalendarSyncRecord)this.getRecordById(hhRecord.getId(), backupRecords)) != null) {
                date = rec.getStartDate();
            }
            if (date != null && date.after(lookupRangeEndDate)) {
                if (!hhRecord.isDeleted()) {
                    cbkRecords.addElement(hhRecord);
                }
            } else {
                CalendarSyncRecord cfr_ignored_0 = (CalendarSyncRecord)hhRecord;
                if (((CalendarSyncRecord)hhRecord).getRepeatType() == 0) {
                    date = ((CalendarSyncRecord)hhRecord).getEndDate();
                    if (date == null && rec != null) {
                        date = rec.getEndDate();
                    }
                } else {
                    date = ((CalendarSyncRecord)hhRecord).getRepeatEndDate();
                    if (date == null && rec != null) {
                        date = rec.getRepeatEndDate();
                    }
                }
                if (date != null && date.before(lookupRangeStartDate)) {
                    if (!hhRecord.isDeleted()) {
                        cbkRecords.addElement(hhRecord);
                    }
                } else {
                    if (hhRecord == null) {
                        CalendarSyncUtils.doDebug("hhRecord is null\n");
                    } else {
                        CalendarSyncUtils.doDebug("recordIndex is " + this.recordIndex);
                        CalendarSyncUtils.doDebug("recordCount is " + this.recordCount);
                        CalendarSyncUtils.doDebug(((CalendarSyncRecord)hhRecord).toFormattedString());
                    }
                    this.synchronizeHHRecord(hhRecord, firstSync);
                }
            }
            ++this.recordIndex;
        }
        i = 0;
        while (i < pcRecords.size()) {
            Record newRecord = (Record)pcRecords.elementAt(i);
            if (newRecord.isNew() || newRecord.isModified()) {
                this.resetAttributes(newRecord);
                this.addPCRecord(newRecord);
                this.hhRecords.addElement(newRecord);
                ++i;
                continue;
            }
            pcRecord = this.getRecordById(newRecord.getId(), this.slowPCRecords);
            if (pcRecord == null) {
                try {
                    this.deleteRecord(newRecord);
                }
                catch (Exception exception) {}
                continue;
            }
            ++i;
        }
        i = 0;
        while (i < this.slowPCRecords.size()) {
            pcRecord = (CalendarSyncRecord)((Object)this.slowPCRecords.elementAt(i));
            if (!pcRecord.isDeleted()) {
                cbkRecords.addElement(pcRecord);
            }
            ++i;
        }
        this.writeHHRecords();
        return this.slowPCRecords;
    }

    public void synchronizeHHRecord(Record hhRecord, boolean firstSync) throws SyncException, IOException {
        block18: {
            CalendarSyncUtils.doDebug("In synchronizeHHRecord()");
            Object pcRecord = null;
            if (firstSync) {
                if (!hhRecord.isDeleted()) {
                    int i = 0;
                    while (i < this.pcRecords.size()) {
                        pcRecord = (CalendarSyncRecord)((Object)this.pcRecords.elementAt(i));
                        if (this.compareRecords(hhRecord, (Record)pcRecord)) {
                            this.resetAttributes((Record)pcRecord);
                            pcRecord.setId(hhRecord.getId());
                            this.slowPCRecords.addElement(pcRecord);
                            return;
                        }
                        ++i;
                    }
                    if (i == this.pcRecords.size()) {
                        pcRecord = null;
                    }
                }
            } else {
                pcRecord = this.getRecordById(hhRecord.getId(), this.pcRecords);
            }
            if (pcRecord == null) {
                if (hhRecord.isArchived()) {
                    this.archiveRecord(hhRecord);
                    this.deleteHHRecord(hhRecord);
                } else if (hhRecord.isDeleted()) {
                    this.deleteHHRecord(hhRecord);
                } else {
                    this.resetAttributes(hhRecord);
                    try {
                        this.addRecord(hhRecord);
                    }
                    catch (CalendarSyncException cse) {
                        CalendarSyncUtils.doLog(cse.getMessage());
                    }
                    this.removeElementById(hhRecord);
                }
            } else {
                try {
                    if (hhRecord.isArchived()) {
                        this.handleArchived(hhRecord, (Record)pcRecord);
                        break block18;
                    }
                    if (hhRecord.isDeleted()) {
                        this.handleDeleted(hhRecord, (Record)pcRecord);
                        break block18;
                    }
                    this.handleModified(hhRecord, (Record)pcRecord);
                }
                catch (CalendarSyncException cse) {
                    CalendarSyncUtils.doLog(cse.getMessage());
                }
            }
        }
    }

    public void synchronizePCRecord(Record pcRecord) throws IOException, SyncException {
        CalendarSyncUtils.doDebug("In synchronizePCRecord()");
        if (!pcRecord.isNew()) {
            Record hhRecord = this.retrieveHHRecord(pcRecord);
            if (hhRecord == null) {
                if (this.props.firstDevice == 2) {
                    this.hhRecords.addElement(pcRecord);
                }
                SyncManager.writeRec((int)this.db, (Record)pcRecord);
            } else if (pcRecord.isDeleted()) {
                this.deleteRecord(pcRecord);
                this.deleteHHRecord(hhRecord);
            } else if (!this.compareRecords(hhRecord, pcRecord)) {
                this.hhRecords.addElement(pcRecord);
            }
        } else if (pcRecord.isDeleted()) {
            this.deleteRecord(pcRecord);
        } else {
            this.resetAttributes(pcRecord);
            this.hhRecords.addElement(pcRecord);
        }
    }

    public void updatePCrecordFlags(Vector pcRecords, Vector buRecords, Date lookupRangeStartDate, Date lookupRangeEndDate) throws IOException {
        int i = 0;
        while (i < pcRecords.size()) {
            this.setPcRecFlags((CalendarSyncRecord)((Object)pcRecords.elementAt(i)), buRecords);
            ++i;
        }
        i = 0;
        while (i < buRecords.size()) {
            this.addToPcRecords((CalendarSyncRecord)((Object)buRecords.elementAt(i)), pcRecords, lookupRangeStartDate, lookupRangeEndDate);
            ++i;
        }
    }

    private void updateRecord(Record pcRecordOld, Record pcRecordNew) throws CalendarSyncException {
        CalendarSyncUtils.doDebug("In updateRecord()");
        CalendarSyncUtils.doDebug("New Record:");
        CalendarSyncUtils.doDebug(((CalendarSyncRecord)pcRecordNew).toFormattedString());
        CalendarSyncUtils.doDebug("Old Record:");
        CalendarSyncUtils.doDebug(((CalendarSyncRecord)pcRecordOld).toFormattedString());
        CalendarSyncUtils.doDebug("Appt Id Old:" + ((CalendarSyncRecord)pcRecordOld).getApptId());
        CalendarSyncUtils.doDebug("Appt Id New:" + ((CalendarSyncRecord)pcRecordNew).getApptId());
        try {
            Appointment dtAppt = null;
            int i = 0;
            while (this.dtWriter.localAppts != null && i < this.dtWriter.localAppts.size()) {
                dtAppt = (Appointment)this.dtWriter.localAppts.elementAt(i);
                if (((CalendarSyncRecord)pcRecordOld).getApptId() == dtAppt.getIdentifier()) break;
                ++i;
            }
            if (dtAppt == null || i == this.dtWriter.localAppts.size()) {
                dtAppt = CalendarSyncWriter.cal.lookupApptById(((CalendarSyncRecord)pcRecordOld).getApptId());
            }
            if (dtAppt != null) {
                CalendarSyncUtils.doDebug("lookupApptById returns appt");
                dtAppt = this.dtWriter.populateDtAppt((CalendarSyncRecord)pcRecordNew, dtAppt);
                CalendarSyncWriter.cal.updateAppt(dtAppt);
                this.dtWriter.updateNote((CalendarSyncRecord)pcRecordNew, ((CalendarSyncRecord)pcRecordOld).getNote(), dtAppt);
                this.dtWriter.updateVectorList.removeElement(pcRecordOld);
                ((CalendarSyncRecord)pcRecordNew).setApptId(dtAppt.getIdentifier());
                this.deletePCRecord(pcRecordOld);
                this.addPCRecord(pcRecordNew);
            } else {
                CalendarSyncUtils.doDebug("lookupApptById returns null");
            }
        }
        catch (IOException iOException) {
            this.cse = new CalendarSyncException(4114);
            throw this.cse;
        }
        catch (CalendarException e) {
            this.cse = new CalendarSyncException(4099, e);
            throw this.cse;
        }
    }

    private void writeHHRecords() throws IOException {
        if (this.hhRecords != null) {
            int i = 0;
            while (i < this.hhRecords.size()) {
                Record hhRecord = (Record)this.hhRecords.elementAt(i);
                SyncManager.writeRec((int)this.db, (Record)hhRecord);
                ++i;
            }
            SyncManager.purgeDeletedRecs((int)this.db);
            SyncManager.resetSyncFlags((int)this.db);
        }
    }
}

