/*
 * Decompiled with CFR 0.152.
 */
package com.scmmicro.smartos.core;

import com.scmmicro.smartos.core.ATR;
import com.scmmicro.smartos.core.Parameters;
import com.scmmicro.smartos.core.Protocol;
import com.scmmicro.smartos.core.ProtocolT0;
import com.scmmicro.smartos.core.ProtocolT1;
import com.scmmicro.smartos.core.ReaderAcces;
import com.scmmicro.smartos.core.SessionListener;
import com.scmmicro.smartos.core.SpecificATR;
import com.scmmicro.smartos.exceptions.BadCommandException;
import com.scmmicro.smartos.exceptions.BadParameterException;
import com.scmmicro.smartos.exceptions.BadParameterValueException;
import com.scmmicro.smartos.exceptions.CardException;
import com.scmmicro.smartos.exceptions.CommunicationException;
import com.scmmicro.smartos.exceptions.TimeOutException;
import com.scmmicro.smartos.physical.Drive;
import com.scmmicro.smartos.physical.DriveListener;
import com.scmmicro.smartos.util.Buffer;
import com.sun.opencard.common.OCFDebug;
import java.math.BigInteger;

public class Session
implements DriveListener {
    private boolean verbose = true;
    public static final byte CMD_RESET = 0;
    public static final byte CMD_WARMRESET = 1;
    public static final byte CMD_DEACTIVATE_CONTACTS = 2;
    protected Drive m_rDrive;
    protected ReaderAcces m_rReaderAccess;
    protected Protocol m_rProtocol;
    protected SessionListener m_rSessionListener;
    Parameters m_rParameters = new Parameters();
    private boolean m_bProcolLoadEnable = false;

    public Session(Drive drive) throws CommunicationException, CardException, TimeOutException, Exception {
        this.m_rParameters.init();
        this.m_rDrive = drive;
        try {
            drive.setListener(this);
            this.m_rParameters.CLP_CardState = (byte)this.m_rDrive.getParameter((byte)14);
            this.debug(" Session opened1");
        }
        catch (CommunicationException communicationException) {
            throw new Exception("Unable to open the session");
        }
        catch (BadParameterException badParameterException) {
            throw new CommunicationException("Wrong parameter");
        }
        this.debug(" Session opened1");
        this.m_rReaderAccess = null;
        this.m_rProtocol = null;
    }

    public static String BytesToString(byte[] byArray) {
        String string = "";
        byte[] byArray2 = new byte[2];
        byArray2[0] = 0;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byArray2[1] = byArray[n2];
            BigInteger bigInteger = new BigInteger(byArray2);
            if (byArray[n2] < 16 && byArray[n2] >= 0) {
                string = String.valueOf(string) + "0";
            }
            string = String.valueOf(string) + bigInteger.toString(16);
            ++n2;
        }
        return string;
    }

    public void cardExchange(Buffer buffer, Buffer buffer2) throws CommunicationException, CardException, BadParameterValueException, TimeOutException, BadParameterException, Exception {
        if (this.m_rDrive == null) {
            throw new CardException();
        }
        byte by = (byte)this.m_rDrive.getParameter((byte)14);
        if (by == 0) {
            this.debug(" card not present");
            throw new CardException();
        }
        if (this.m_rProtocol == null) {
            if (this.m_rParameters.CLP_PTSNecessary) {
                this.m_rReaderAccess.getATR().pts(this.m_rDrive);
                this.m_rParameters.CLP_PTSNecessary = false;
            }
            switch (this.m_rParameters.CLP_Protocol) {
                case 1: {
                    this.debug("loading protocol T=0");
                    this.m_rProtocol = new ProtocolT0();
                    this.m_rProtocol.setSession(this);
                    break;
                }
                case 2: {
                    this.m_rProtocol = new ProtocolT1();
                    this.debug("loading protocol T=1");
                    this.m_rProtocol.setSession(this);
                    break;
                }
                default: {
                    throw new CardException("Protocol not implemented");
                }
            }
            this.m_bProcolLoadEnable = false;
        }
        this.m_rProtocol.cardExchange(buffer, buffer2, this.m_rDrive);
        this.debug("CardResponse > " + Session.BytesToString(buffer2.getData()));
    }

    public void cardMovement(byte by) {
        if (by == -96) {
            try {
                this.debug("Card inserted! ");
            }
            catch (Exception exception) {}
            this.m_rParameters.CLP_CardState = 1;
            this.m_rParameters.Just_Atr = 0;
        } else {
            try {
                this.debug("Card Removed!");
            }
            catch (Exception exception) {}
            this.m_rParameters.CLP_CardState = 0;
        }
        if (this.m_rSessionListener != null) {
            this.m_rSessionListener.cardMovement(by);
        } else {
            try {
                this.debug("m_rSessionListener not defined!");
            }
            catch (Exception exception) {}
        }
    }

    public void close() throws CommunicationException, CardException, TimeOutException, Exception {
        this.m_rDrive.close();
        this.m_rReaderAccess = null;
        this.m_rProtocol = null;
        this.m_rParameters = null;
        this.debug("Session Closed");
    }

    void debug(String string) throws Exception {
        if (this.verbose) {
            System.out.println("Session:: " + string);
        } else {
            try {
                OCFDebug.debugln((String)("Session : " + string));
            }
            catch (Exception exception) {}
        }
    }

    public long getParameter(byte by) throws BadParameterException {
        long l = this.m_rParameters.getParameter(by);
        return l;
    }

    Parameters getParameters() {
        return this.m_rParameters;
    }

    public void readerExchange(byte by, Buffer buffer, Buffer buffer2) throws CommunicationException, CardException, BadParameterValueException, BadCommandException, TimeOutException, BadParameterException, Exception {
        this.debug("reader Exchange occuring");
        if (this.m_rDrive == null) {
            throw new CardException();
        }
        byte by2 = (byte)this.m_rDrive.getParameter((byte)14);
        if (by2 == 0) {
            this.debug("readerexchange :==>>> card not present");
            throw new CardException();
        }
        if (this.m_rReaderAccess == null) {
            SpecificATR specificATR = new SpecificATR();
            this.m_rParameters.CLP_PTSNecessary = false;
            specificATR.setSession(this);
            this.m_rReaderAccess = new ReaderAcces(specificATR);
        }
        this.m_rReaderAccess.sendCommand(by, buffer, buffer2, this.m_rDrive);
        this.debug("ReaderResponse > " + Session.BytesToString(buffer2.getData()));
        if (by == 0) {
            this.m_bProcolLoadEnable = true;
        }
        this.m_rProtocol = null;
    }

    public void setATR(ATR aTR) {
        if (this.m_rReaderAccess == null) {
            this.m_rReaderAccess = new ReaderAcces(aTR);
        }
        aTR.setSession(this);
    }

    public void setListener(SessionListener sessionListener) {
        this.m_rSessionListener = sessionListener;
    }

    public void setParameter(byte by, long l) throws BadParameterException, BadParameterValueException {
        this.m_rParameters.setParameter(by, l);
    }

    public void setProtocol(Protocol protocol) throws CommunicationException, CardException, TimeOutException, Exception {
        if (this.m_bProcolLoadEnable) {
            this.m_rProtocol = protocol;
            protocol.setSession(this);
            if (this.m_rParameters.CLP_PTSNecessary) {
                this.m_rReaderAccess.getATR().pts(this.m_rDrive);
                this.m_rParameters.CLP_PTSNecessary = false;
            }
        } else {
            throw new CardException("must perform Reset before setting protocol");
        }
        this.m_bProcolLoadEnable = false;
    }
}

