/*
 * Decompiled with CFR 0.152.
 */
package com.scmmicro.smartos.util;

import com.scmmicro.smartos.util.Buffer;

public class Fifo {
    private int m_nLength;
    private int m_nCapacity;
    private int m_nOffset;
    private byte[] m_rData;

    public Fifo(int n) {
        this.m_rData = new byte[n];
        this.m_nCapacity = n;
        this.m_nLength = 0;
    }

    public synchronized void addBytes(Buffer buffer) {
        this.addBytes(buffer.getData(), buffer.getLength());
    }

    public synchronized void addBytes(byte[] byArray, int n) {
        if (n > byArray.length || this.m_nLength + n > this.m_nCapacity) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = 0;
        while (n2 < n) {
            this.m_rData[this.m_nLength + n2] = byArray[n2];
            ++n2;
        }
        this.m_nLength += n;
    }

    public synchronized byte getByte() throws ArrayIndexOutOfBoundsException {
        if (this.m_nLength < 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte by = this.m_rData[0];
        int n = 0;
        while (n < this.m_nLength - 1) {
            this.m_rData[n] = this.m_rData[n + 1];
            ++n;
        }
        --this.m_nLength;
        return by;
    }

    public void getBytes(Buffer buffer) {
        this.getBytes(buffer.getData(), buffer.getLength());
    }

    public synchronized void getBytes(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        if (n > this.m_nLength || n > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = this.m_rData[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < this.m_nLength - n) {
            this.m_rData[n2] = this.m_rData[n + n2];
            ++n2;
        }
        this.m_nLength -= n;
    }

    public synchronized int getLength() {
        return this.m_nLength;
    }

    public void setLength(int n) {
        this.m_nLength = n;
    }
}

