/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.security;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.client.SolarisPasswordCredential;
import com.sun.wbem.client.SolarisUserPrincipal;
import com.sun.wbem.security.RmiClientSecurity;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Arrays;

public class SolarisRmiClientSecurity
extends RmiClientSecurity {
    private String roleName;
    private byte[] rolePswd;

    public SolarisRmiClientSecurity() throws NoSuchAlgorithmException {
        this.roleName = null;
        this.rolePswd = new byte[0];
    }

    public SolarisRmiClientSecurity(CIMNameSpace cIMNameSpace, Principal principal, Object object) throws NoSuchAlgorithmException, CIMException {
        this.setNameSpace(cIMNameSpace);
        this.setPrincipal(principal);
        this.setCredential(object);
    }

    public void dispose() {
        super.dispose();
        this.roleName = null;
        Arrays.fill(this.rolePswd, (byte)0);
        this.rolePswd = new byte[0];
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getRolePassword() {
        String string = null;
        if (this.rolePswd.length > 0) {
            char[] cArray = new char[this.rolePswd.length];
            int n = 0;
            while (n < this.rolePswd.length) {
                cArray[n] = (char)(this.rolePswd[n] & 0xFF);
                ++n;
            }
            string = new String(cArray);
        }
        return string;
    }

    public void setCredential(Object object) throws CIMException {
        String string;
        super.setCredential(object);
        if (object instanceof SolarisPasswordCredential && (string = ((SolarisPasswordCredential)object).getRolePassword()) != null) {
            int n = string.length();
            this.rolePswd = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                this.rolePswd[n2] = (byte)c;
                ++n2;
            }
        }
    }

    public void setPrincipal(Principal principal) throws CIMException {
        super.setPrincipal(principal);
        this.roleName = null;
        if (principal instanceof SolarisUserPrincipal) {
            this.roleName = ((SolarisUserPrincipal)principal).getRoleName();
        }
    }
}

