/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.jnlp.BasicServiceImpl;
import com.sun.jnlp.ClipboardServiceImpl;
import com.sun.jnlp.DownloadServiceImpl;
import com.sun.jnlp.ExtendedServiceImpl;
import com.sun.jnlp.ExtensionInstallerServiceImpl;
import com.sun.jnlp.FileOpenServiceImpl;
import com.sun.jnlp.FileSaveServiceImpl;
import com.sun.jnlp.PersistenceServiceImpl;
import com.sun.jnlp.PrintServiceImpl;
import com.sun.jnlp.SingleInstanceServiceImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.ServiceManagerStub;
import javax.jnlp.UnavailableServiceException;

public final class JnlpLookupStub
implements ServiceManagerStub {
    public Object lookup(final String string) throws UnavailableServiceException {
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return JnlpLookupStub.this.findService(string);
            }
        });
        if (t == null) {
            throw new UnavailableServiceException(string);
        }
        return t;
    }

    private Object findService(String string) {
        if (string != null) {
            if (string.equals("javax.jnlp.BasicService")) {
                return BasicServiceImpl.getInstance();
            }
            if (string.equals("javax.jnlp.FileOpenService")) {
                return FileOpenServiceImpl.getInstance();
            }
            if (string.equals("javax.jnlp.FileSaveService")) {
                return FileSaveServiceImpl.getInstance();
            }
            if (string.equals("javax.jnlp.ExtensionInstallerService")) {
                return ExtensionInstallerServiceImpl.getInstance();
            }
            if (string.equals("javax.jnlp.DownloadService")) {
                return DownloadServiceImpl.getInstance();
            }
            if (string.equals("javax.jnlp.ClipboardService")) {
                return ClipboardServiceImpl.getInstance();
            }
            if (string.equals("javax.jnlp.PrintService")) {
                return PrintServiceImpl.getInstance();
            }
            if (string.equals("javax.jnlp.PersistenceService")) {
                return PersistenceServiceImpl.getInstance();
            }
            if (string.equals("javax.jnlp.ExtendedService")) {
                return ExtendedServiceImpl.getInstance();
            }
            if (string.equals("javax.jnlp.SingleInstanceService")) {
                return SingleInstanceServiceImpl.getInstance();
            }
        }
        return null;
    }

    public String[] getServiceNames() {
        if (ExtensionInstallerServiceImpl.getInstance() != null) {
            return new String[]{"javax.jnlp.BasicService", "javax.jnlp.FileOpenService", "javax.jnlp.FileSaveService", "javax.jnlp.ExtensionInstallerService", "javax.jnlp.DownloadService", "javax.jnlp.ClipboardService", "javax.jnlp.PersistenceService", "javax.jnlp.PrintService", "javax.jnlp.ExtendedService", "javax.jnlp.SingleInstanceService"};
        }
        return new String[]{"javax.jnlp.BasicService", "javax.jnlp.FileOpenService", "javax.jnlp.FileSaveService", "javax.jnlp.DownloadService", "javax.jnlp.ClipboardService", "javax.jnlp.PersistenceService", "javax.jnlp.PrintService", "javax.jnlp.ExtendedService", "javax.jnlp.SingleInstanceService"};
    }
}

