/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.IClientResource;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.client.ServiceWrapper;
import com.sun.admin.usermgr.client.WbemServiceWrapper;
import com.sun.admin.usermgr.common.UserException;
import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.client.ExternalClientList;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMSecurityException;
import com.sun.wbem.client.CIMClient;
import java.util.ResourceBundle;

public class ApplicationContext {
    private IClientResource theApp;
    private ToolContext toolContext;
    private AdminMgmtScope scope = null;

    public ApplicationContext(IClientResource iClientResource, ToolContext toolContext) {
        this.theApp = iClientResource;
        this.toolContext = toolContext;
        this.scope = (AdminMgmtScope)toolContext.getParameter("ToolContext.MGMTSCOPE");
    }

    public String getExecPolicy() {
        String string = (String)this.toolContext.getParameter("policy");
        if (string == null) {
            return "suser";
        }
        return string;
    }

    public AdminMgmtScope getMgmtScope() {
        return this.scope;
    }

    public String getMgmtServer() {
        return this.scope.getMgmtServerName();
    }

    private String getServiceType() {
        String string = "Wbem";
        try {
            String string2 = System.getProperty("usermgr.serviceType");
            if (string2 != null) {
                string = string2;
            }
        }
        catch (Exception exception) {}
        return string;
    }

    public ServiceWrapper getServiceWrapper(ToolInfrastructure toolInfrastructure) throws AdminException {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        String string = this.getServiceType();
        String string2 = "com.sun.admin.usermgr.client." + string + "ServiceWrapper";
        ServiceWrapper serviceWrapper = null;
        try {
            serviceWrapper = (ServiceWrapper)Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UserException("EXM_GUI_SERVICE_NOT_REACHABLE", string, ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"), string2);
        }
        catch (Exception exception) {
            UserException userException = new UserException("EXM_GUI_CANT_GET_SERVICE_WRAPPER", string, ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"), string2);
            userException.addArg(exception.getMessage());
            throw userException;
        }
        int n = 2;
        int n2 = 1;
        while (n2 <= n) {
            block13: {
                try {
                    if (serviceWrapper instanceof WbemServiceWrapper) {
                        String string3 = this.scope.getMgmtServerName();
                        CIMNameSpace cIMNameSpace = new CIMNameSpace(string3, "root\\cimv2");
                        Object[] objectArray = new Object[]{cIMNameSpace, new Integer(1)};
                        CIMClient cIMClient = (CIMClient)toolInfrastructure.getExternalClient(ExternalClientList.CIMWBEM, objectArray);
                        serviceWrapper.init(cIMClient, toolInfrastructure, this.scope);
                        break;
                    }
                }
                catch (CIMSecurityException cIMSecurityException) {
                    String string4 = cIMSecurityException.getID();
                    if (string4.equals("CIM_ERR_ACCESS_DENIED")) {
                        throw new UserException("EXM_CIM_ERR_ACCESS_DENIED");
                    }
                    if (string4.equals("INVALID_CREDENTIAL")) {
                        throw new UserException("EXM_INVALID_CREDENTIAL");
                    }
                    if (string4.equals("NO_SUCH_PRINCIPAL")) {
                        throw new UserException("EXM_NO_SUCH_PRINCIPAL");
                    }
                    if (string4.equals("CANNOT_ASSUME_ROLE")) {
                        throw new UserException("EXM_CANNOT_ASSUME_ROLE");
                    }
                    throw new UserException("EXM_GENERIC_CIMSEC");
                }
                catch (Exception exception) {
                    if (exception.getMessage().equals("TIMED_OUT") && n2 <= n) break block13;
                    if (exception.getMessage().equals("NO_CIMOM")) {
                        throw new UserException("EXM_GUI_CANT_CONNECT_NO_CIMOM", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"));
                    }
                    throw new UserException("EXM_GUI_CANT_CONNECT_TO_SERVER", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"), exception.getMessage());
                }
            }
            ++n2;
        }
        return serviceWrapper;
    }

    public boolean isLocalScope() {
        String string = this.scope.getMgmtScopeType();
        return string.equals("file");
    }

    public boolean isScopeLDAP() {
        String string = this.scope.getMgmtScopeType();
        return string.equals("ldap");
    }

    public boolean isScopeNISplus() {
        String string = this.scope.getMgmtScopeType();
        return string.equals("nisplus");
    }
}

