/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.JLabel;

class WindowsUtils {
    WindowsUtils() {
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    static void repaintMnemonicsInWindow(Window window) {
        if (window == null || !window.isShowing()) {
            return;
        }
        Window[] windowArray = window.getOwnedWindows();
        for (int i = 0; i < windowArray.length; ++i) {
            WindowsUtils.repaintMnemonicsInWindow(windowArray[i]);
        }
        WindowsUtils.repaintMnemonicsInContainer(window);
    }

    static void repaintMnemonicsInContainer(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component == null || !component.isVisible()) continue;
            if (component instanceof AbstractButton && ((AbstractButton)component).getMnemonic() != 0) {
                component.repaint();
                continue;
            }
            if (component instanceof JLabel && ((JLabel)component).getDisplayedMnemonic() != 0) {
                component.repaint();
                continue;
            }
            if (!(component instanceof Container)) continue;
            WindowsUtils.repaintMnemonicsInContainer((Container)component);
        }
    }
}

