/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.AdaptiveCoding;
import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.Code;
import com.sun.java.util.jar.pack.Coding;
import com.sun.java.util.jar.pack.CodingChooser;
import com.sun.java.util.jar.pack.CodingMethod;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Instruction;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.PackageReader;
import com.sun.java.util.jar.pack.PopulationCoding;
import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.Utils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;

abstract class BandStructure
implements Constants {
    static final int MAX_EFFORT = 9;
    static final int MIN_EFFORT = 1;
    static final int DEFAULT_EFFORT = 5;
    PropMap p200 = Utils.currentPropMap();
    int verbose = this.p200.getInteger("com.sun.java.util.jar.pack.verbose");
    int effort = this.p200.getInteger("pack.effort");
    boolean optDumpBands;
    boolean optDebugBands;
    boolean optVaryCodings;
    boolean optBigStrings;
    private final boolean isReader;
    static final Coding BYTE1;
    static final Coding CHAR3;
    static final Coding BCI5;
    static final Coding BRANCH5;
    static final Coding UNSIGNED5;
    static final Coding UDELTA5;
    static final Coding SIGNED5;
    static final Coding DELTA5;
    static final Coding MDELTA5;
    private static final Coding[] basicCodings;
    private static final HashMap basicCodingIndexes;
    protected byte[] bandHeaderBytes;
    protected int bandHeaderBytePos;
    protected int bandHeaderBytePos0;
    static final int SHORT_BAND_HEURISTIC = 100;
    public static final int NO_PHASE = 0;
    public static final int COLLECT_PHASE = 1;
    public static final int WRITE_PHASE = 3;
    public static final int EXPECT_PHASE = 2;
    public static final int READ_PHASE = 4;
    public static final int DISBURSE_PHASE = 6;
    public static final int DONE_PHASE = 8;
    private ArrayList allKQBands;
    private ArrayList needPredefIndex;
    private CodingChooser codingChooser;
    static final byte[] defaultMetaCoding;
    static final byte[] noMetaCoding;
    ByteCounter outputCounter;
    protected int archiveOptions;
    protected long archiveSize0;
    protected long archiveSize1;
    protected int archiveNextCount;
    static final int AH_LENGTH_0 = 3;
    static final int AH_ARCHIVE_SIZE_HI = 0;
    static final int AH_ARCHIVE_SIZE_LO = 1;
    static final int AH_LENGTH_S = 2;
    static final int AH_LENGTH = 26;
    static final int AH_FILE_HEADER_LEN = 5;
    static final int AH_SPECIAL_FORMAT_LEN = 2;
    static final int AH_CP_NUMBER_LEN = 4;
    static final int AH_LENGTH_MIN = 15;
    static final int AB_FLAGS_HI = 0;
    static final int AB_FLAGS_LO = 1;
    static final int AB_ATTR_COUNT = 2;
    static final int AB_ATTR_INDEXES = 3;
    static final int AB_ATTR_CALLS = 4;
    private static final boolean NULL_IS_OK = true;
    MultiBand all_bands;
    ByteBand archive_magic;
    IntBand archive_header_0;
    IntBand archive_header_S;
    IntBand archive_header_1;
    ByteBand band_headers;
    MultiBand cp_bands;
    IntBand cp_Utf8_prefix;
    IntBand cp_Utf8_suffix;
    IntBand cp_Utf8_chars;
    IntBand cp_Utf8_big_suffix;
    MultiBand cp_Utf8_big_chars;
    IntBand cp_Int;
    IntBand cp_Float;
    IntBand cp_Long_hi;
    IntBand cp_Long_lo;
    IntBand cp_Double_hi;
    IntBand cp_Double_lo;
    CPRefBand cp_String;
    CPRefBand cp_Class;
    CPRefBand cp_Signature_form;
    CPRefBand cp_Signature_classes;
    CPRefBand cp_Descr_name;
    CPRefBand cp_Descr_type;
    CPRefBand cp_Field_class;
    CPRefBand cp_Field_desc;
    CPRefBand cp_Method_class;
    CPRefBand cp_Method_desc;
    CPRefBand cp_Imethod_class;
    CPRefBand cp_Imethod_desc;
    MultiBand attr_definition_bands;
    ByteBand attr_definition_headers;
    CPRefBand attr_definition_name;
    CPRefBand attr_definition_layout;
    MultiBand ic_bands;
    CPRefBand ic_this_class;
    IntBand ic_flags;
    CPRefBand ic_outer_class;
    CPRefBand ic_name;
    MultiBand class_bands;
    CPRefBand class_this;
    CPRefBand class_super;
    IntBand class_interface_count;
    CPRefBand class_interface;
    IntBand class_field_count;
    IntBand class_method_count;
    CPRefBand field_descr;
    MultiBand field_attr_bands;
    IntBand field_flags_hi;
    IntBand field_flags_lo;
    IntBand field_attr_count;
    IntBand field_attr_indexes;
    IntBand field_attr_calls;
    CPRefBand field_ConstantValue_KQ;
    CPRefBand field_Signature_RS;
    MultiBand field_metadata_bands;
    CPRefBand method_descr;
    MultiBand method_attr_bands;
    IntBand method_flags_hi;
    IntBand method_flags_lo;
    IntBand method_attr_count;
    IntBand method_attr_indexes;
    IntBand method_attr_calls;
    IntBand method_Exceptions_N;
    CPRefBand method_Exceptions_RC;
    CPRefBand method_Signature_RS;
    MultiBand method_metadata_bands;
    MultiBand class_attr_bands;
    IntBand class_flags_hi;
    IntBand class_flags_lo;
    IntBand class_attr_count;
    IntBand class_attr_indexes;
    IntBand class_attr_calls;
    CPRefBand class_SourceFile_RUN;
    CPRefBand class_EnclosingMethod_RC;
    CPRefBand class_EnclosingMethod_RDN;
    CPRefBand class_Signature_RS;
    MultiBand class_metadata_bands;
    IntBand class_InnerClasses_N;
    CPRefBand class_InnerClasses_RC;
    IntBand class_InnerClasses_F;
    CPRefBand class_InnerClasses_outer_RCN;
    CPRefBand class_InnerClasses_name_RUN;
    IntBand class_ClassFile_version_minor_H;
    IntBand class_ClassFile_version_major_H;
    MultiBand code_bands;
    ByteBand code_headers;
    IntBand code_max_stack;
    IntBand code_max_na_locals;
    IntBand code_handler_count;
    IntBand code_handler_start_P;
    IntBand code_handler_end_PO;
    IntBand code_handler_catch_PO;
    CPRefBand code_handler_class_RCN;
    MultiBand code_attr_bands;
    IntBand code_flags_hi;
    IntBand code_flags_lo;
    IntBand code_attr_count;
    IntBand code_attr_indexes;
    IntBand code_attr_calls;
    IntBand code_LineNumberTable_N;
    IntBand code_LineNumberTable_bci_P;
    IntBand code_LineNumberTable_line;
    IntBand code_LocalVariableTable_N;
    IntBand code_LocalVariableTable_bci_P;
    IntBand code_LocalVariableTable_span_O;
    CPRefBand code_LocalVariableTable_name_RU;
    CPRefBand code_LocalVariableTable_type_RS;
    IntBand code_LocalVariableTable_slot;
    IntBand code_LocalVariableTypeTable_N;
    IntBand code_LocalVariableTypeTable_bci_P;
    IntBand code_LocalVariableTypeTable_span_O;
    CPRefBand code_LocalVariableTypeTable_name_RU;
    CPRefBand code_LocalVariableTypeTable_type_RS;
    IntBand code_LocalVariableTypeTable_slot;
    MultiBand bc_bands;
    ByteBand bc_codes;
    IntBand bc_case_count;
    IntBand bc_case_value;
    ByteBand bc_byte;
    IntBand bc_short;
    IntBand bc_local;
    IntBand bc_label;
    CPRefBand bc_intref;
    CPRefBand bc_floatref;
    CPRefBand bc_longref;
    CPRefBand bc_doubleref;
    CPRefBand bc_stringref;
    CPRefBand bc_classref;
    CPRefBand bc_fieldref;
    CPRefBand bc_methodref;
    CPRefBand bc_imethodref;
    CPRefBand bc_thisfield;
    CPRefBand bc_superfield;
    CPRefBand bc_thismethod;
    CPRefBand bc_supermethod;
    IntBand bc_initref;
    CPRefBand bc_escref;
    IntBand bc_escrefsize;
    IntBand bc_escsize;
    ByteBand bc_escbyte;
    MultiBand file_bands;
    CPRefBand file_name;
    IntBand file_size_hi;
    IntBand file_size_lo;
    IntBand file_modtime;
    IntBand file_options;
    ByteBand file_bits;
    protected MultiBand[] metadataBands;
    public static final int ADH_CONTEXT_MASK = 3;
    public static final int ADH_BIT_SHIFT = 2;
    public static final int ADH_BIT_IS_LSB = 1;
    public static final int ATTR_INDEX_OVERFLOW = -1;
    public int[] attrIndexLimit;
    protected long[] attrFlagMask;
    protected long[] attrDefSeen;
    protected int[] attrOverflowMask;
    protected int attrClassFileVersionMask;
    protected HashMap attrBandTable;
    protected final Attribute.Layout attrCodeEmpty;
    protected final Attribute.Layout attrInnerClassesEmpty;
    protected final Attribute.Layout attrClassFileVersion;
    protected final Attribute.Layout attrConstantValue;
    HashMap attrIndexTable;
    protected ArrayList[] attrDefs;
    protected MultiBand[] attrBands;
    private static final int[][] shortCodeLimits;
    public final int shortCodeHeader_h_limit;
    static final int LONG_CODE_HEADER = 0;
    static int nextSeqForDebug;
    static File dumpDir;
    private HashMap prevForAssertMap;
    private static int[] noInts;
    private static byte[] noBytes;

    protected abstract ConstantPool.Index getCPIndex(byte var1);

    protected BandStructure(boolean bl) {
        int n;
        if (this.effort == 0) {
            this.effort = 5;
        }
        this.optDumpBands = this.p200.getBoolean("com.sun.java.util.jar.pack.dump.bands");
        this.optDebugBands = this.p200.getBoolean("com.sun.java.util.jar.pack.debug.bands");
        this.optVaryCodings = !this.p200.getBoolean("com.sun.java.util.jar.pack.no.vary.codings");
        this.optBigStrings = !this.p200.getBoolean("com.sun.java.util.jar.pack.no.big.strings");
        this.isReader = this instanceof PackageReader;
        this.allKQBands = new ArrayList();
        this.needPredefIndex = new ArrayList();
        this.all_bands = (MultiBand)new MultiBand("(package)", UNSIGNED5).init();
        this.archive_magic = this.all_bands.newByteBand("archive_magic");
        this.archive_header_0 = this.all_bands.newIntBand("archive_header_0", UNSIGNED5);
        this.archive_header_S = this.all_bands.newIntBand("archive_header_S", UNSIGNED5);
        this.archive_header_1 = this.all_bands.newIntBand("archive_header_1", UNSIGNED5);
        this.band_headers = this.all_bands.newByteBand("band_headers");
        this.cp_bands = this.all_bands.newMultiBand("(constant_pool)", DELTA5);
        this.cp_Utf8_prefix = this.cp_bands.newIntBand("cp_Utf8_prefix");
        this.cp_Utf8_suffix = this.cp_bands.newIntBand("cp_Utf8_suffix", UNSIGNED5);
        this.cp_Utf8_chars = this.cp_bands.newIntBand("cp_Utf8_chars", CHAR3);
        this.cp_Utf8_big_suffix = this.cp_bands.newIntBand("cp_Utf8_big_suffix");
        this.cp_Utf8_big_chars = this.cp_bands.newMultiBand("(cp_Utf8_big_chars)", DELTA5);
        this.cp_Int = this.cp_bands.newIntBand("cp_Int", UDELTA5);
        this.cp_Float = this.cp_bands.newIntBand("cp_Float", UDELTA5);
        this.cp_Long_hi = this.cp_bands.newIntBand("cp_Long_hi", UDELTA5);
        this.cp_Long_lo = this.cp_bands.newIntBand("cp_Long_lo");
        this.cp_Double_hi = this.cp_bands.newIntBand("cp_Double_hi", UDELTA5);
        this.cp_Double_lo = this.cp_bands.newIntBand("cp_Double_lo");
        this.cp_String = this.cp_bands.newCPRefBand("cp_String", UDELTA5, (byte)1);
        this.cp_Class = this.cp_bands.newCPRefBand("cp_Class", UDELTA5, (byte)1);
        this.cp_Signature_form = this.cp_bands.newCPRefBand("cp_Signature_form", (byte)1);
        this.cp_Signature_classes = this.cp_bands.newCPRefBand("cp_Signature_classes", UDELTA5, (byte)7);
        this.cp_Descr_name = this.cp_bands.newCPRefBand("cp_Descr_name", (byte)1);
        this.cp_Descr_type = this.cp_bands.newCPRefBand("cp_Descr_type", UDELTA5, (byte)13);
        this.cp_Field_class = this.cp_bands.newCPRefBand("cp_Field_class", (byte)7);
        this.cp_Field_desc = this.cp_bands.newCPRefBand("cp_Field_desc", UDELTA5, (byte)12);
        this.cp_Method_class = this.cp_bands.newCPRefBand("cp_Method_class", (byte)7);
        this.cp_Method_desc = this.cp_bands.newCPRefBand("cp_Method_desc", UDELTA5, (byte)12);
        this.cp_Imethod_class = this.cp_bands.newCPRefBand("cp_Imethod_class", (byte)7);
        this.cp_Imethod_desc = this.cp_bands.newCPRefBand("cp_Imethod_desc", UDELTA5, (byte)12);
        this.attr_definition_bands = this.all_bands.newMultiBand("(attr_definition_bands)", UNSIGNED5);
        this.attr_definition_headers = this.attr_definition_bands.newByteBand("attr_definition_headers");
        this.attr_definition_name = this.attr_definition_bands.newCPRefBand("attr_definition_name", (byte)1);
        this.attr_definition_layout = this.attr_definition_bands.newCPRefBand("attr_definition_layout", (byte)1);
        this.ic_bands = this.all_bands.newMultiBand("(ic_bands)", DELTA5);
        this.ic_this_class = this.ic_bands.newCPRefBand("ic_this_class", UDELTA5, (byte)7);
        this.ic_flags = this.ic_bands.newIntBand("ic_flags", UNSIGNED5);
        this.ic_outer_class = this.ic_bands.newCPRefBand("ic_outer_class", DELTA5, (byte)7, true);
        this.ic_name = this.ic_bands.newCPRefBand("ic_name", DELTA5, (byte)1, true);
        this.class_bands = this.all_bands.newMultiBand("(class_bands)", DELTA5);
        this.class_this = this.class_bands.newCPRefBand("class_this", (byte)7);
        this.class_super = this.class_bands.newCPRefBand("class_super", (byte)7);
        this.class_interface_count = this.class_bands.newIntBand("class_interface_count");
        this.class_interface = this.class_bands.newCPRefBand("class_interface", (byte)7);
        this.class_field_count = this.class_bands.newIntBand("class_field_count");
        this.class_method_count = this.class_bands.newIntBand("class_method_count");
        this.field_descr = this.class_bands.newCPRefBand("field_descr", (byte)12);
        this.field_attr_bands = this.class_bands.newMultiBand("(field_attr_bands)", UNSIGNED5);
        this.field_flags_hi = this.field_attr_bands.newIntBand("field_flags_hi");
        this.field_flags_lo = this.field_attr_bands.newIntBand("field_flags_lo");
        this.field_attr_count = this.field_attr_bands.newIntBand("field_attr_count");
        this.field_attr_indexes = this.field_attr_bands.newIntBand("field_attr_indexes");
        this.field_attr_calls = this.field_attr_bands.newIntBand("field_attr_calls");
        this.field_ConstantValue_KQ = this.field_attr_bands.newCPRefBand("field_ConstantValue_KQ", (byte)20);
        this.field_Signature_RS = this.field_attr_bands.newCPRefBand("field_Signature_RS", (byte)13);
        this.field_metadata_bands = this.field_attr_bands.newMultiBand("(field_metadata_bands)", UNSIGNED5);
        this.method_descr = this.class_bands.newCPRefBand("method_descr", MDELTA5, (byte)12);
        this.method_attr_bands = this.class_bands.newMultiBand("(method_attr_bands)", UNSIGNED5);
        this.method_flags_hi = this.method_attr_bands.newIntBand("method_flags_hi");
        this.method_flags_lo = this.method_attr_bands.newIntBand("method_flags_lo");
        this.method_attr_count = this.method_attr_bands.newIntBand("method_attr_count");
        this.method_attr_indexes = this.method_attr_bands.newIntBand("method_attr_indexes");
        this.method_attr_calls = this.method_attr_bands.newIntBand("method_attr_calls");
        this.method_Exceptions_N = this.method_attr_bands.newIntBand("method_Exceptions_N");
        this.method_Exceptions_RC = this.method_attr_bands.newCPRefBand("method_Exceptions_RC", (byte)7);
        this.method_Signature_RS = this.method_attr_bands.newCPRefBand("method_Signature_RS", (byte)13);
        this.method_metadata_bands = this.method_attr_bands.newMultiBand("(method_metadata_bands)", UNSIGNED5);
        this.class_attr_bands = this.class_bands.newMultiBand("(class_attr_bands)", UNSIGNED5);
        this.class_flags_hi = this.class_attr_bands.newIntBand("class_flags_hi");
        this.class_flags_lo = this.class_attr_bands.newIntBand("class_flags_lo");
        this.class_attr_count = this.class_attr_bands.newIntBand("class_attr_count");
        this.class_attr_indexes = this.class_attr_bands.newIntBand("class_attr_indexes");
        this.class_attr_calls = this.class_attr_bands.newIntBand("class_attr_calls");
        this.class_SourceFile_RUN = this.class_attr_bands.newCPRefBand("class_SourceFile_RUN", UNSIGNED5, (byte)1, true);
        this.class_EnclosingMethod_RC = this.class_attr_bands.newCPRefBand("class_EnclosingMethod_RC", (byte)7);
        this.class_EnclosingMethod_RDN = this.class_attr_bands.newCPRefBand("class_EnclosingMethod_RDN", UNSIGNED5, (byte)12, true);
        this.class_Signature_RS = this.class_attr_bands.newCPRefBand("class_Signature_RS", (byte)13);
        this.class_metadata_bands = this.class_attr_bands.newMultiBand("(class_metadata_bands)", UNSIGNED5);
        this.class_InnerClasses_N = this.class_attr_bands.newIntBand("class_InnerClasses_N");
        this.class_InnerClasses_RC = this.class_attr_bands.newCPRefBand("class_InnerClasses_RC", (byte)7);
        this.class_InnerClasses_F = this.class_attr_bands.newIntBand("class_InnerClasses_F");
        this.class_InnerClasses_outer_RCN = this.class_attr_bands.newCPRefBand("class_InnerClasses_outer_RCN", UNSIGNED5, (byte)7, true);
        this.class_InnerClasses_name_RUN = this.class_attr_bands.newCPRefBand("class_InnerClasses_name_RUN", UNSIGNED5, (byte)1, true);
        this.class_ClassFile_version_minor_H = this.class_attr_bands.newIntBand("class_ClassFile_version_minor_H");
        this.class_ClassFile_version_major_H = this.class_attr_bands.newIntBand("class_ClassFile_version_major_H");
        this.code_bands = this.class_bands.newMultiBand("(code_bands)", UNSIGNED5);
        this.code_headers = this.code_bands.newByteBand("code_headers");
        this.code_max_stack = this.code_bands.newIntBand("code_max_stack", UNSIGNED5);
        this.code_max_na_locals = this.code_bands.newIntBand("code_max_na_locals", UNSIGNED5);
        this.code_handler_count = this.code_bands.newIntBand("code_handler_count", UNSIGNED5);
        this.code_handler_start_P = this.code_bands.newIntBand("code_handler_start_P", BCI5);
        this.code_handler_end_PO = this.code_bands.newIntBand("code_handler_end_PO", BRANCH5);
        this.code_handler_catch_PO = this.code_bands.newIntBand("code_handler_catch_PO", BRANCH5);
        this.code_handler_class_RCN = this.code_bands.newCPRefBand("code_handler_class_RCN", UNSIGNED5, (byte)7, true);
        this.code_attr_bands = this.class_bands.newMultiBand("(code_attr_bands)", UNSIGNED5);
        this.code_flags_hi = this.code_attr_bands.newIntBand("code_flags_hi");
        this.code_flags_lo = this.code_attr_bands.newIntBand("code_flags_lo");
        this.code_attr_count = this.code_attr_bands.newIntBand("code_attr_count");
        this.code_attr_indexes = this.code_attr_bands.newIntBand("code_attr_indexes");
        this.code_attr_calls = this.code_attr_bands.newIntBand("code_attr_calls");
        this.code_LineNumberTable_N = this.code_attr_bands.newIntBand("code_LineNumberTable_N");
        this.code_LineNumberTable_bci_P = this.code_attr_bands.newIntBand("code_LineNumberTable_bci_P", BCI5);
        this.code_LineNumberTable_line = this.code_attr_bands.newIntBand("code_LineNumberTable_line");
        this.code_LocalVariableTable_N = this.code_attr_bands.newIntBand("code_LocalVariableTable_N");
        this.code_LocalVariableTable_bci_P = this.code_attr_bands.newIntBand("code_LocalVariableTable_bci_P", BCI5);
        this.code_LocalVariableTable_span_O = this.code_attr_bands.newIntBand("code_LocalVariableTable_span_O", BRANCH5);
        this.code_LocalVariableTable_name_RU = this.code_attr_bands.newCPRefBand("code_LocalVariableTable_name_RU", (byte)1);
        this.code_LocalVariableTable_type_RS = this.code_attr_bands.newCPRefBand("code_LocalVariableTable_type_RS", (byte)13);
        this.code_LocalVariableTable_slot = this.code_attr_bands.newIntBand("code_LocalVariableTable_slot");
        this.code_LocalVariableTypeTable_N = this.code_attr_bands.newIntBand("code_LocalVariableTypeTable_N");
        this.code_LocalVariableTypeTable_bci_P = this.code_attr_bands.newIntBand("code_LocalVariableTypeTable_bci_P", BCI5);
        this.code_LocalVariableTypeTable_span_O = this.code_attr_bands.newIntBand("code_LocalVariableTypeTable_span_O", BRANCH5);
        this.code_LocalVariableTypeTable_name_RU = this.code_attr_bands.newCPRefBand("code_LocalVariableTypeTable_name_RU", (byte)1);
        this.code_LocalVariableTypeTable_type_RS = this.code_attr_bands.newCPRefBand("code_LocalVariableTypeTable_type_RS", (byte)13);
        this.code_LocalVariableTypeTable_slot = this.code_attr_bands.newIntBand("code_LocalVariableTypeTable_slot");
        this.bc_bands = this.all_bands.newMultiBand("(byte_codes)", UNSIGNED5);
        this.bc_codes = this.bc_bands.newByteBand("bc_codes");
        this.bc_case_count = this.bc_bands.newIntBand("bc_case_count");
        this.bc_case_value = this.bc_bands.newIntBand("bc_case_value", DELTA5);
        this.bc_byte = this.bc_bands.newByteBand("bc_byte");
        this.bc_short = this.bc_bands.newIntBand("bc_short", DELTA5);
        this.bc_local = this.bc_bands.newIntBand("bc_local");
        this.bc_label = this.bc_bands.newIntBand("bc_label", BRANCH5);
        this.bc_intref = this.bc_bands.newCPRefBand("bc_intref", DELTA5, (byte)3);
        this.bc_floatref = this.bc_bands.newCPRefBand("bc_floatref", DELTA5, (byte)4);
        this.bc_longref = this.bc_bands.newCPRefBand("bc_longref", DELTA5, (byte)5);
        this.bc_doubleref = this.bc_bands.newCPRefBand("bc_doubleref", DELTA5, (byte)6);
        this.bc_stringref = this.bc_bands.newCPRefBand("bc_stringref", DELTA5, (byte)8);
        this.bc_classref = this.bc_bands.newCPRefBand("bc_classref", UNSIGNED5, (byte)7, true);
        this.bc_fieldref = this.bc_bands.newCPRefBand("bc_fieldref", DELTA5, (byte)9);
        this.bc_methodref = this.bc_bands.newCPRefBand("bc_methodref", (byte)10);
        this.bc_imethodref = this.bc_bands.newCPRefBand("bc_imethodref", DELTA5, (byte)11);
        this.bc_thisfield = this.bc_bands.newCPRefBand("bc_thisfield", (byte)0);
        this.bc_superfield = this.bc_bands.newCPRefBand("bc_superfield", (byte)0);
        this.bc_thismethod = this.bc_bands.newCPRefBand("bc_thismethod", (byte)0);
        this.bc_supermethod = this.bc_bands.newCPRefBand("bc_supermethod", (byte)0);
        this.bc_initref = this.bc_bands.newIntBand("bc_initref");
        this.bc_escref = this.bc_bands.newCPRefBand("bc_escref", (byte)19);
        this.bc_escrefsize = this.bc_bands.newIntBand("bc_escrefsize");
        this.bc_escsize = this.bc_bands.newIntBand("bc_escsize");
        this.bc_escbyte = this.bc_bands.newByteBand("bc_escbyte");
        this.file_bands = this.all_bands.newMultiBand("(file_bands)", UNSIGNED5);
        this.file_name = this.file_bands.newCPRefBand("file_name", (byte)1);
        this.file_size_hi = this.file_bands.newIntBand("file_size_hi");
        this.file_size_lo = this.file_bands.newIntBand("file_size_lo");
        this.file_modtime = this.file_bands.newIntBand("file_modtime", DELTA5);
        this.file_options = this.file_bands.newIntBand("file_options");
        this.file_bits = this.file_bands.newByteBand("file_bits");
        this.metadataBands = new MultiBand[4];
        this.metadataBands[0] = this.class_metadata_bands;
        this.metadataBands[1] = this.field_metadata_bands;
        this.metadataBands[2] = this.method_metadata_bands;
        this.attrIndexLimit = new int[4];
        this.attrFlagMask = new long[4];
        this.attrDefSeen = new long[4];
        this.attrOverflowMask = new int[4];
        this.attrBandTable = new HashMap();
        this.attrIndexTable = new HashMap();
        this.attrDefs = new ArrayList[4];
        for (n = 0; n < 4; ++n) {
            assert (this.attrIndexLimit[n] == 0);
            this.attrIndexLimit[n] = 32;
            this.attrDefs[n] = new ArrayList<Object>(Collections.nCopies(this.attrIndexLimit[n], null));
        }
        this.attrInnerClassesEmpty = this.predefineAttribute(23, 0, null, "InnerClasses", "");
        assert (this.attrInnerClassesEmpty == Package.attrInnerClassesEmpty);
        this.predefineAttribute(17, 0, new Band[]{this.class_SourceFile_RUN}, "SourceFile", "RUNH");
        this.predefineAttribute(18, 0, new Band[]{this.class_EnclosingMethod_RC, this.class_EnclosingMethod_RDN}, "EnclosingMethod", "RCHRDNH");
        this.attrClassFileVersion = this.predefineAttribute(24, 0, new Band[]{this.class_ClassFile_version_minor_H, this.class_ClassFile_version_major_H}, ".ClassFile.version", "HH");
        this.predefineAttribute(19, 0, new Band[]{this.class_Signature_RS}, "Signature", "RSH");
        this.predefineAttribute(20, 0, null, "Deprecated", "");
        this.predefineAttribute(16, 0, null, ".Overflow", "");
        this.attrConstantValue = this.predefineAttribute(17, 1, new Band[]{this.field_ConstantValue_KQ}, "ConstantValue", "KQH");
        this.predefineAttribute(19, 1, new Band[]{this.field_Signature_RS}, "Signature", "RSH");
        this.predefineAttribute(20, 1, null, "Deprecated", "");
        this.predefineAttribute(16, 1, null, ".Overflow", "");
        this.attrCodeEmpty = this.predefineAttribute(17, 2, null, "Code", "");
        this.predefineAttribute(18, 2, new Band[]{this.method_Exceptions_N, this.method_Exceptions_RC}, "Exceptions", "NH[RCH]");
        assert (this.attrCodeEmpty == Package.attrCodeEmpty);
        this.predefineAttribute(19, 2, new Band[]{this.method_Signature_RS}, "Signature", "RSH");
        this.predefineAttribute(20, 2, null, "Deprecated", "");
        this.predefineAttribute(16, 2, null, ".Overflow", "");
        for (n = 0; n < 4; ++n) {
            MultiBand multiBand = this.metadataBands[n];
            if (multiBand == null) continue;
            this.predefineAttribute(21, ATTR_CONTEXT_NAME[n] + "_RVA_", multiBand, Attribute.lookup(null, n, "RuntimeVisibleAnnotations"));
            this.predefineAttribute(22, ATTR_CONTEXT_NAME[n] + "_RIA_", multiBand, Attribute.lookup(null, n, "RuntimeInvisibleAnnotations"));
            if (n != 2) continue;
            this.predefineAttribute(23, "method_RVPA_", multiBand, Attribute.lookup(null, n, "RuntimeVisibleParameterAnnotations"));
            this.predefineAttribute(24, "method_RIPA_", multiBand, Attribute.lookup(null, n, "RuntimeInvisibleParameterAnnotations"));
            this.predefineAttribute(25, "method_AD_", multiBand, Attribute.lookup(null, n, "AnnotationDefault"));
        }
        this.predefineAttribute(1, 3, new Band[]{this.code_LineNumberTable_N, this.code_LineNumberTable_bci_P, this.code_LineNumberTable_line}, "LineNumberTable", "NH[PHH]");
        this.predefineAttribute(2, 3, new Band[]{this.code_LocalVariableTable_N, this.code_LocalVariableTable_bci_P, this.code_LocalVariableTable_span_O, this.code_LocalVariableTable_name_RU, this.code_LocalVariableTable_type_RS, this.code_LocalVariableTable_slot}, "LocalVariableTable", "NH[PHOHRUHRSHH]");
        this.predefineAttribute(3, 3, new Band[]{this.code_LocalVariableTypeTable_N, this.code_LocalVariableTypeTable_bci_P, this.code_LocalVariableTypeTable_span_O, this.code_LocalVariableTypeTable_name_RU, this.code_LocalVariableTypeTable_type_RS, this.code_LocalVariableTypeTable_slot}, "LocalVariableTypeTable", "NH[PHOHRUHRSHH]");
        this.predefineAttribute(16, 3, null, ".Overflow", "");
        for (n = 0; n < 4; ++n) {
            this.attrDefSeen[n] = 0L;
        }
        for (n = 0; n < 4; ++n) {
            this.attrOverflowMask[n] = 65536;
            this.attrIndexLimit[n] = 0;
        }
        this.attrClassFileVersionMask = 0x1000000;
        this.attrBands = new MultiBand[4];
        this.attrBands[0] = this.class_attr_bands;
        this.attrBands[1] = this.field_attr_bands;
        this.attrBands[2] = this.method_attr_bands;
        this.attrBands[3] = this.code_attr_bands;
        this.shortCodeHeader_h_limit = shortCodeLimits.length;
        assert (this.isReader == bl);
    }

    public static Coding codingForIndex(int n) {
        return n < basicCodings.length ? basicCodings[n] : null;
    }

    public static int indexOf(Coding coding) {
        Integer n = (Integer)basicCodingIndexes.get(coding);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public static Coding[] getBasicCodings() {
        return (Coding[])basicCodings.clone();
    }

    protected CodingMethod getBandHeader(int n, Coding coding) {
        CodingMethod[] codingMethodArray = new CodingMethod[]{null};
        this.bandHeaderBytes[--this.bandHeaderBytePos] = (byte)n;
        this.bandHeaderBytePos0 = this.bandHeaderBytePos;
        this.bandHeaderBytePos = BandStructure.parseMetaCoding(this.bandHeaderBytes, this.bandHeaderBytePos, coding, codingMethodArray);
        return codingMethodArray[0];
    }

    public static int parseMetaCoding(byte[] byArray, int n, Coding coding, CodingMethod[] codingMethodArray) {
        if ((byArray[n] & 0xFF) == 0) {
            codingMethodArray[0] = coding;
            return n + 1;
        }
        int n2 = Coding.parseMetaCoding(byArray, n, coding, codingMethodArray);
        if (n2 > n) {
            return n2;
        }
        n2 = PopulationCoding.parseMetaCoding(byArray, n, coding, codingMethodArray);
        if (n2 > n) {
            return n2;
        }
        n2 = AdaptiveCoding.parseMetaCoding(byArray, n, coding, codingMethodArray);
        if (n2 > n) {
            return n2;
        }
        throw new RuntimeException("Bad meta-coding op " + (byArray[n] & 0xFF));
    }

    static boolean phaseIsRead(int n) {
        return n % 2 == 0;
    }

    static int phaseCmp(int n, int n2) {
        assert (n % 2 == n2 % 2 || n % 8 == 0 || n2 % 8 == 0);
        return n - n2;
    }

    static int getIntTotal(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    int encodeRef(ConstantPool.Entry entry, ConstantPool.Index index) {
        int n = index.indexOf(entry);
        if (this.verbose > 2) {
            Utils.log.fine("putRef " + n + " => " + entry);
        }
        return n;
    }

    ConstantPool.Entry decodeRef(int n, ConstantPool.Index index) {
        if (n < 0 || n >= index.size()) {
            Utils.log.warning("decoding bad ref " + n + " in " + index);
        }
        ConstantPool.Entry entry = index.getEntry(n);
        if (this.verbose > 2) {
            Utils.log.fine("getRef " + n + " => " + entry);
        }
        return entry;
    }

    protected CodingChooser getCodingChooser() {
        if (this.codingChooser == null) {
            this.codingChooser = new CodingChooser(this.effort, basicCodings);
        }
        return this.codingChooser;
    }

    public CodingMethod chooseCoding(int[] nArray, int n, int n2, Coding coding, String string, int[] nArray2) {
        assert (this.optVaryCodings);
        if (this.effort <= 1) {
            return coding;
        }
        CodingChooser codingChooser = this.getCodingChooser();
        if (this.verbose > 1 || codingChooser.verbose > 1) {
            Utils.log.fine("--- chooseCoding " + string);
        }
        return this.getCodingChooser().choose(nArray, n, n2, coding, nArray2);
    }

    protected static int decodeEscapeValue(int n, Coding coding) {
        if (coding.B() == 1 || coding.L() == 0) {
            return -1;
        }
        if (coding.S() != 0) {
            if (-256 <= n && n <= -1 && coding.min() <= -256) {
                int n2 = -1 - n;
                assert (n2 >= 0 && n2 < 256);
                return n2;
            }
        } else {
            int n3 = coding.L();
            if (n3 <= n && n <= n3 + 255 && coding.max() >= n3 + 255) {
                int n4 = n - n3;
                assert (n4 >= 0 && n4 < 256);
                return n4;
            }
        }
        return -1;
    }

    protected static int encodeEscapeValue(int n, Coding coding) {
        int n2;
        assert (n >= 0 && n < 256);
        assert (coding.B() > 1 && coding.L() > 0);
        if (coding.S() != 0) {
            assert (coding.min() <= -256);
            n2 = -1 - n;
        } else {
            int n3 = coding.L();
            assert (coding.max() >= n3 + 255);
            n2 = n + n3;
        }
        assert (BandStructure.decodeEscapeValue(n2, coding) == n) : coding + " XB=" + n + " X=" + n2;
        return n2;
    }

    void writeAllBandsTo(OutputStream outputStream) throws IOException {
        this.outputCounter = new ByteCounter(outputStream);
        outputStream = this.outputCounter;
        this.all_bands.writeTo(outputStream);
        if (this.verbose > 0) {
            long l = this.outputCounter.getCount();
            Utils.log.info("Wrote total of " + l + " bytes.");
            assert (l == this.archiveSize0 + this.archiveSize1);
        }
        this.outputCounter = null;
    }

    static IntBand getAttrBand(MultiBand multiBand, int n) {
        IntBand intBand = (IntBand)multiBand.get(n);
        switch (n) {
            case 0: {
                assert (intBand.name().endsWith("_flags_hi"));
                break;
            }
            case 1: {
                assert (intBand.name().endsWith("_flags_lo"));
                break;
            }
            case 2: {
                assert (intBand.name().endsWith("_attr_count"));
                break;
            }
            case 3: {
                assert (intBand.name().endsWith("_attr_indexes"));
                break;
            }
            case 4: {
                assert (intBand.name().endsWith("_attr_calls"));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return intBand;
    }

    protected void setBandIndexes() {
        for (Object[] objectArray : this.needPredefIndex) {
            CPRefBand cPRefBand = (CPRefBand)objectArray[0];
            Byte by = (Byte)objectArray[1];
            cPRefBand.setIndex(this.getCPIndex(by));
        }
        this.needPredefIndex = null;
        if (this.verbose > 3) {
            BandStructure.printCDecl(this.all_bands);
        }
    }

    protected void setBandIndex(CPRefBand cPRefBand, byte by) {
        Object[] objectArray = new Object[]{cPRefBand, new Byte(by)};
        if (by == 20) {
            this.allKQBands.add(cPRefBand);
        } else if (this.needPredefIndex != null) {
            this.needPredefIndex.add(objectArray);
        } else {
            cPRefBand.setIndex(this.getCPIndex(by));
        }
    }

    protected void setConstantValueIndex(Package.Class.Field field) {
        ConstantPool.Index index = null;
        if (field != null) {
            byte by = field.getLiteralTag();
            index = this.getCPIndex(by);
            if (this.verbose > 2) {
                Utils.log.fine("setConstantValueIndex " + field + " " + ConstantPool.tagName(by) + " => " + index);
            }
            assert (index != null);
        }
        for (CPRefBand cPRefBand : this.allKQBands) {
            cPRefBand.setIndex(index);
        }
    }

    protected void initAttrIndexLimit() {
        for (int i = 0; i < 4; ++i) {
            assert (this.attrIndexLimit[i] == 0);
            int n = this.attrIndexLimit[i] = this.haveFlagsHi(i) ? 63 : 32;
            assert (this.attrDefs[i].size() == 32);
            int n2 = this.attrIndexLimit[i] - this.attrDefs[i].size();
            this.attrDefs[i].addAll(Collections.nCopies(n2, null));
        }
    }

    protected boolean haveFlagsHi(int n) {
        int n2 = 1 << 9 + n;
        switch (n) {
            case 0: {
                assert (n2 == 512);
                break;
            }
            case 1: {
                assert (n2 == 1024);
                break;
            }
            case 2: {
                assert (n2 == 2048);
                break;
            }
            case 3: {
                assert (n2 == 4096);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return BandStructure.testBit(this.archiveOptions, n2);
    }

    protected ArrayList getPredefinedAttrs(int n) {
        assert (this.attrIndexLimit[n] != 0);
        ArrayList<Attribute.Layout> arrayList = new ArrayList<Attribute.Layout>(this.attrIndexLimit[n]);
        for (int i = 0; i < this.attrIndexLimit[n]; ++i) {
            Attribute.Layout layout;
            if (BandStructure.testBit(this.attrDefSeen[n], 1L << i) || (layout = (Attribute.Layout)this.attrDefs[n].get(i)) == null) continue;
            assert (this.isPredefinedAttr(n, i));
            arrayList.add(layout);
        }
        return arrayList;
    }

    protected boolean isPredefinedAttr(int n, int n2) {
        assert (this.attrIndexLimit[n] != 0);
        if (n2 >= this.attrIndexLimit[n]) {
            return false;
        }
        if (BandStructure.testBit(this.attrDefSeen[n], 1L << n2)) {
            return false;
        }
        return this.attrDefs[n].get(n2) != null;
    }

    protected void adjustSpecialAttrMasks() {
        this.attrClassFileVersionMask = (int)((long)this.attrClassFileVersionMask & (this.attrDefSeen[0] ^ 0xFFFFFFFFFFFFFFFFL));
        for (int i = 0; i < 4; ++i) {
            int n = i;
            this.attrOverflowMask[n] = (int)((long)this.attrOverflowMask[n] & (this.attrDefSeen[i] ^ 0xFFFFFFFFFFFFFFFFL));
        }
    }

    protected Attribute makeClassFileVersionAttr(int n, int n2) {
        byte[] byArray = new byte[]{(byte)(n >> 8), (byte)n, (byte)(n2 >> 8), (byte)n2};
        return this.attrClassFileVersion.addContent(byArray);
    }

    protected short[] parseClassFileVersionAttr(Attribute attribute) {
        assert (attribute.layout() == this.attrClassFileVersion);
        assert (attribute.size() == 4);
        byte[] byArray = attribute.bytes();
        int n = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
        int n2 = (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        return new short[]{(short)n, (short)n2};
    }

    private boolean assertBandOKForElems(Band[] bandArray, Attribute.Layout.Element[] elementArray) {
        for (int i = 0; i < elementArray.length; ++i) {
            assert (this.assertBandOKForElem(bandArray, elementArray[i]));
        }
        return true;
    }

    private boolean assertBandOKForElem(Band[] bandArray, Attribute.Layout.Element element) {
        Band band = null;
        if (element.bandIndex != -1) {
            band = bandArray[element.bandIndex];
        }
        Coding coding = UNSIGNED5;
        boolean bl = true;
        switch (element.kind) {
            case 1: {
                if (element.flagTest((byte)1)) {
                    coding = SIGNED5;
                    break;
                }
                if (element.len != 1) break;
                coding = BYTE1;
                break;
            }
            case 2: {
                if (!element.flagTest((byte)2)) {
                    coding = BCI5;
                    break;
                }
                coding = BRANCH5;
                break;
            }
            case 3: {
                coding = BRANCH5;
                break;
            }
            case 4: {
                if (element.len != 1) break;
                coding = BYTE1;
                break;
            }
            case 5: {
                if (element.len == 1) {
                    coding = BYTE1;
                }
                this.assertBandOKForElems(bandArray, element.body);
                break;
            }
            case 7: {
                if (element.flagTest((byte)1)) {
                    coding = SIGNED5;
                } else if (element.len == 1) {
                    coding = BYTE1;
                }
                this.assertBandOKForElems(bandArray, element.body);
                break;
            }
            case 8: {
                assert (band == null);
                this.assertBandOKForElems(bandArray, element.body);
                return true;
            }
            case 9: {
                assert (band == null);
                return true;
            }
            case 10: {
                assert (band == null);
                this.assertBandOKForElems(bandArray, element.body);
                return true;
            }
            case 6: {
                bl = false;
                assert (band instanceof CPRefBand);
                assert (((CPRefBand)band).nullOK == element.flagTest((byte)4));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        assert (band.regularCoding == coding) : element + " // " + band;
        if (bl) assert (band instanceof IntBand);
        return true;
    }

    private Attribute.Layout predefineAttribute(int n, int n2, Band[] bandArray, String string, String string2) {
        Attribute.Layout layout = Attribute.find(n2, string, string2).layout();
        if (n >= 0) {
            this.setAttributeLayoutIndex(layout, n);
        }
        if (bandArray == null) {
            bandArray = new Band[]{};
        }
        assert (this.attrBandTable.get(layout) == null);
        this.attrBandTable.put(layout, bandArray);
        assert (layout.bandCount == bandArray.length) : layout + " // " + Arrays.asList(bandArray);
        assert (this.assertBandOKForElems(bandArray, layout.elems));
        return layout;
    }

    private Attribute.Layout predefineAttribute(int n, String string, MultiBand multiBand, Attribute attribute) {
        Attribute.Layout layout = attribute.layout();
        int n2 = layout.ctype();
        return this.predefineAttribute(n, n2, this.makeNewAttributeBands(string, layout, multiBand), layout.name(), layout.layout());
    }

    void makeNewAttributeBands() {
        this.adjustSpecialAttrMasks();
        for (int i = 0; i < 4; ++i) {
            String string = ATTR_CONTEXT_NAME[i];
            MultiBand multiBand = this.attrBands[i];
            long l = this.attrDefSeen[i];
            assert ((l & (this.attrFlagMask[i] ^ 0xFFFFFFFFFFFFFFFFL)) == 0L);
            for (int j = 0; j < this.attrDefs[i].size(); ++j) {
                Attribute.Layout layout = (Attribute.Layout)this.attrDefs[i].get(j);
                if (layout == null || layout.bandCount == 0) continue;
                if (j < this.attrIndexLimit[i] && !BandStructure.testBit(l, 1L << j)) {
                    assert (this.attrBandTable.get(layout) != null);
                    continue;
                }
                int n = multiBand.size();
                String string2 = string + "_" + layout.name() + "_";
                if (this.verbose > 1) {
                    Utils.log.fine("Making new bands for " + layout);
                }
                Band[] bandArray = this.makeNewAttributeBands(string2, layout, multiBand);
                assert (bandArray.length == layout.bandCount);
                Band[] bandArray2 = this.attrBandTable.put(layout, bandArray);
                if (bandArray2 == null) continue;
                for (int k = 0; k < bandArray2.length; ++k) {
                    bandArray2[k].doneWithUnusedBand();
                }
            }
        }
    }

    private Band[] makeNewAttributeBands(String string, Attribute.Layout layout, MultiBand multiBand) {
        int n = multiBand.size();
        this.makeNewAttributeBands(string, layout.elems, multiBand);
        int n2 = multiBand.size() - n;
        Band[] bandArray = new Band[n2];
        for (int i = 0; i < n2; ++i) {
            bandArray[i] = multiBand.get(n + i);
        }
        return bandArray;
    }

    private void makeNewAttributeBands(String string, Attribute.Layout.Element[] elementArray, MultiBand multiBand) {
        block12: for (int i = 0; i < elementArray.length; ++i) {
            Band band;
            Attribute.Layout.Element element = elementArray[i];
            String string2 = string + multiBand.size() + "_" + element.layout;
            int n = string2.indexOf(91);
            if (n > 0) {
                string2 = string2.substring(0, n);
            }
            if ((n = string2.indexOf(40)) > 0) {
                string2 = string2.substring(0, n);
            }
            if (string2.endsWith("H")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            switch (element.kind) {
                case 1: {
                    band = this.newElemBand(element, string2, multiBand);
                    break;
                }
                case 2: {
                    if (!element.flagTest((byte)2)) {
                        band = multiBand.newIntBand(string2, BCI5);
                        break;
                    }
                    band = multiBand.newIntBand(string2, BRANCH5);
                    break;
                }
                case 3: {
                    band = multiBand.newIntBand(string2, BRANCH5);
                    break;
                }
                case 4: {
                    assert (!element.flagTest((byte)1));
                    band = this.newElemBand(element, string2, multiBand);
                    break;
                }
                case 5: {
                    assert (!element.flagTest((byte)1));
                    band = this.newElemBand(element, string2, multiBand);
                    this.makeNewAttributeBands(string, element.body, multiBand);
                    break;
                }
                case 7: {
                    band = this.newElemBand(element, string2, multiBand);
                    this.makeNewAttributeBands(string, element.body, multiBand);
                    break;
                }
                case 8: {
                    if (element.flagTest((byte)8)) continue block12;
                    this.makeNewAttributeBands(string, element.body, multiBand);
                    continue block12;
                }
                case 6: {
                    byte by = element.refKind;
                    boolean bl = element.flagTest((byte)4);
                    band = multiBand.newCPRefBand(string2, UNSIGNED5, by, bl);
                    break;
                }
                case 9: {
                    continue block12;
                }
                case 10: {
                    this.makeNewAttributeBands(string, element.body, multiBand);
                    continue block12;
                }
                default: {
                    assert (false);
                    continue block12;
                }
            }
            if (this.verbose <= 1) continue;
            Utils.log.fine("New attribute band " + band);
        }
    }

    private Band newElemBand(Attribute.Layout.Element element, String string, MultiBand multiBand) {
        if (element.flagTest((byte)1)) {
            return multiBand.newIntBand(string, SIGNED5);
        }
        if (element.len == 1) {
            return multiBand.newIntBand(string, BYTE1);
        }
        return multiBand.newIntBand(string, UNSIGNED5);
    }

    protected int setAttributeLayoutIndex(Attribute.Layout layout, int n) {
        int n2 = layout.ctype;
        assert (-1 <= n && n < this.attrIndexLimit[n2]);
        ArrayList arrayList = this.attrDefs[n2];
        if (n == -1) {
            n = arrayList.size();
            arrayList.add(layout);
            if (this.verbose > 0) {
                Utils.log.info("Adding new attribute at " + layout + ": " + n);
            }
            this.attrIndexTable.put(layout, new Integer(n));
            return n;
        }
        if (BandStructure.testBit(this.attrDefSeen[n2], 1L << n)) {
            throw new RuntimeException("Multiple explicit definition at " + n + ": " + layout);
        }
        int n3 = n2;
        this.attrDefSeen[n3] = this.attrDefSeen[n3] | 1L << n;
        assert (0 <= n && n < this.attrIndexLimit[n2]);
        if (this.verbose > (this.attrClassFileVersionMask == 0 ? 2 : 0)) {
            Utils.log.fine("Fixing new attribute at " + n + ": " + layout + (arrayList.get(n) == null ? "" : "; replacing " + arrayList.get(n)));
        }
        int n4 = n2;
        this.attrFlagMask[n4] = this.attrFlagMask[n4] | 1L << n;
        this.attrIndexTable.put(arrayList.get(n), null);
        arrayList.set(n, layout);
        this.attrIndexTable.put(layout, new Integer(n));
        return n;
    }

    static int shortCodeHeader(Code code) {
        int n = code.max_stack;
        int n2 = code.max_locals;
        int n3 = code.handler_class.length;
        if (n3 >= shortCodeLimits.length) {
            return 0;
        }
        int n4 = code.getMethod().getArgumentSize();
        assert (n2 >= n4);
        if (n2 < n4) {
            return 0;
        }
        int n5 = n2 - n4;
        int n6 = shortCodeLimits[n3][0];
        int n7 = shortCodeLimits[n3][1];
        if (n >= n6 || n5 >= n7) {
            return 0;
        }
        int n8 = BandStructure.shortCodeHeader_h_base(n3);
        if ((n8 += n + n6 * n5) > 255) {
            return 0;
        }
        assert (BandStructure.shortCodeHeader_max_stack(n8) == n);
        assert (BandStructure.shortCodeHeader_max_na_locals(n8) == n5);
        assert (BandStructure.shortCodeHeader_handler_count(n8) == n3);
        return n8;
    }

    static int shortCodeHeader_handler_count(int n) {
        assert (n > 0 && n <= 255);
        int n2 = 0;
        while (n >= BandStructure.shortCodeHeader_h_base(n2 + 1)) {
            ++n2;
        }
        return n2;
    }

    static int shortCodeHeader_max_stack(int n) {
        int n2 = BandStructure.shortCodeHeader_handler_count(n);
        int n3 = shortCodeLimits[n2][0];
        return (n - BandStructure.shortCodeHeader_h_base(n2)) % n3;
    }

    static int shortCodeHeader_max_na_locals(int n) {
        int n2 = BandStructure.shortCodeHeader_handler_count(n);
        int n3 = shortCodeLimits[n2][0];
        return (n - BandStructure.shortCodeHeader_h_base(n2)) / n3;
    }

    private static int shortCodeHeader_h_base(int n) {
        assert (n <= shortCodeLimits.length);
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            int n3 = shortCodeLimits[i][0];
            int n4 = shortCodeLimits[i][1];
            n2 += n3 * n4;
        }
        return n2;
    }

    protected void putLabel(IntBand intBand, Code code, int n, int n2) {
        intBand.putInt(code.encodeBCI(n2) - code.encodeBCI(n));
    }

    protected int getLabel(IntBand intBand, Code code, int n) {
        return code.decodeBCI(intBand.getInt() + code.encodeBCI(n));
    }

    protected CPRefBand getCPRefOpBand(int n) {
        switch (Instruction.getCPRefOpTag(n)) {
            case 7: {
                return this.bc_classref;
            }
            case 9: {
                return this.bc_fieldref;
            }
            case 10: {
                return this.bc_methodref;
            }
            case 11: {
                return this.bc_imethodref;
            }
            case 20: {
                switch (n) {
                    case 234: 
                    case 237: {
                        return this.bc_intref;
                    }
                    case 235: 
                    case 238: {
                        return this.bc_floatref;
                    }
                    case 20: {
                        return this.bc_longref;
                    }
                    case 239: {
                        return this.bc_doubleref;
                    }
                    case 18: 
                    case 19: {
                        return this.bc_stringref;
                    }
                    case 233: 
                    case 236: {
                        return this.bc_classref;
                    }
                }
            }
        }
        assert (false);
        return null;
    }

    protected CPRefBand selfOpRefBand(int n) {
        boolean bl;
        boolean bl2;
        assert (Instruction.isSelfLinkerOp(n));
        int n2 = n - 202;
        boolean bl3 = bl2 = n2 >= 14;
        if (bl2) {
            n2 -= 14;
        }
        boolean bl4 = bl = n2 >= 7;
        if (bl) {
            n2 -= 7;
        }
        int n3 = 178 + n2;
        boolean bl5 = Instruction.isFieldOp(n3);
        if (!bl2) {
            return bl5 ? this.bc_thisfield : this.bc_thismethod;
        }
        return bl5 ? this.bc_superfield : this.bc_supermethod;
    }

    static OutputStream getDumpStream(Band band, String string) throws IOException {
        return BandStructure.getDumpStream(band.name, band.seqForDebug, string, band);
    }

    static OutputStream getDumpStream(ConstantPool.Index index, String string) throws IOException {
        if (index.size() == 0) {
            return new ByteArrayOutputStream();
        }
        byte by = ConstantPool.TAG_ORDER[index.cpMap[0].tag];
        return BandStructure.getDumpStream(index.debugName, by, string, index);
    }

    static OutputStream getDumpStream(String string, int n, String string2, Object object) throws IOException {
        if (dumpDir == null) {
            dumpDir = File.createTempFile("BD_", "", new File("."));
            dumpDir.delete();
            if (dumpDir.mkdir()) {
                Utils.log.info("Dumping bands to " + dumpDir);
            }
        }
        string = string.replace('(', ' ').replace(')', ' ');
        string = string.replace('/', ' ');
        string = string.replace('*', ' ');
        string = string.trim().replace(' ', '_');
        string = (10000 + n + "_" + string).substring(1);
        File file = new File(dumpDir, string + string2);
        Utils.log.info("Dumping " + object + " to " + file);
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    static boolean assertCanChangeLength(Band band) {
        switch (band.phase) {
            case 1: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    static boolean assertPhase(Band band, int n) {
        if (band.phase() != n) {
            Utils.log.warning("phase expected " + n + " was " + band.phase() + " in " + band);
            return false;
        }
        return true;
    }

    static int verbose() {
        return Utils.currentPropMap().getInteger("com.sun.java.util.jar.pack.verbose");
    }

    static boolean assertPhaseChangeOK(Band band, int n, int n2) {
        switch (n * 10 + n2) {
            case 1: {
                assert (!band.isReader());
                assert (band.capacity() >= 0);
                assert (band.length() == 0);
                return true;
            }
            case 13: {
                return true;
            }
            case 38: {
                return true;
            }
            case 2: {
                assert (band.isReader());
                assert (band.capacity() < 0);
                return true;
            }
            case 24: {
                assert (Math.max(0, band.capacity()) >= band.valuesExpected());
                assert (band.length() <= 0);
                return true;
            }
            case 46: {
                assert (band.valuesRemainingForDebug() == band.length());
                return true;
            }
            case 68: {
                assert (BandStructure.assertDoneDisbursing(band));
                return true;
            }
        }
        if (n == n2) {
            Utils.log.warning("Already in phase " + n);
        } else {
            Utils.log.warning("Unexpected phase " + n + " -> " + n2);
        }
        return false;
    }

    private static boolean assertDoneDisbursing(Band band) {
        int n;
        if (band.phase != 6) {
            Utils.log.warning("assertDoneDisbursing: still in phase " + band.phase + ": " + band);
            if (BandStructure.verbose() <= 1) {
                return false;
            }
        }
        if ((n = band.valuesRemainingForDebug()) > 0) {
            Utils.log.warning("assertDoneDisbursing: " + n + " values left in " + band);
            if (BandStructure.verbose() <= 1) {
                return false;
            }
        }
        if (band instanceof MultiBand) {
            MultiBand multiBand = (MultiBand)band;
            for (int i = 0; i < multiBand.bandCount; ++i) {
                Band band2 = multiBand.bands[i];
                if (band2.phase == 8) continue;
                Utils.log.warning("assertDoneDisbursing: sub-band still in phase " + band2.phase + ": " + band2);
                if (BandStructure.verbose() > 1) continue;
                return false;
            }
        }
        return true;
    }

    private static void printCDecl(Band band) {
        Coding[] codingArray;
        if (band instanceof MultiBand) {
            MultiBand multiBand = (MultiBand)band;
            for (int i = 0; i < multiBand.bandCount; ++i) {
                BandStructure.printCDecl(multiBand.bands[i]);
            }
            return;
        }
        String string = "NULL";
        if (band instanceof CPRefBand && (codingArray = ((CPRefBand)band).index) != null) {
            string = "INDEX(" + codingArray.debugName + ")";
        }
        codingArray = new Coding[]{BYTE1, CHAR3, BCI5, BRANCH5, UNSIGNED5, UDELTA5, SIGNED5, DELTA5, MDELTA5};
        String[] stringArray = new String[]{"BYTE1", "CHAR3", "BCI5", "BRANCH5", "UNSIGNED5", "UDELTA5", "SIGNED5", "DELTA5", "MDELTA5"};
        Coding coding = band.regularCoding;
        int n = Arrays.asList(codingArray).indexOf(coding);
        String string2 = n >= 0 ? stringArray[n] : "CODING" + coding.keyString();
        System.out.println("  BAND_INIT(\"" + band.name() + "\"" + ", " + string2 + ", " + string + "),");
    }

    boolean notePrevForAssert(Band band, Band band2) {
        if (this.prevForAssertMap == null) {
            this.prevForAssertMap = new HashMap();
        }
        this.prevForAssertMap.put(band, band2);
        return true;
    }

    private boolean assertReadyToReadFrom(Band band, InputStream inputStream) throws IOException {
        Band band2 = (Band)this.prevForAssertMap.get(band);
        if (band2 != null && BandStructure.phaseCmp(band2.phase(), 6) < 0) {
            Utils.log.warning("Previous band not done reading.");
            Utils.log.info("    Previous band: " + band2);
            Utils.log.info("        Next band: " + band);
            Thread.dumpStack();
            assert (this.verbose > 0);
        }
        String string = band.name;
        if (this.optDebugBands && !string.startsWith("(")) {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = inputStream.read()) > 0) {
                stringBuffer.append((char)n);
            }
            String string2 = stringBuffer.toString();
            if (!string2.equals(string)) {
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("Expected " + string + " but read: ");
                string2 = string2 + (char)n;
                while (string2.length() < 10) {
                    string2 = string2 + (char)inputStream.read();
                }
                for (int i = 0; i < string2.length(); ++i) {
                    stringBuffer2.append(string2.charAt(i));
                }
                Utils.log.warning(stringBuffer2.toString());
                return false;
            }
        }
        return true;
    }

    private boolean assertValidCPRefs(CPRefBand cPRefBand) {
        if (cPRefBand.index == null) {
            return true;
        }
        int n = cPRefBand.index.size() + 1;
        for (int i = 0; i < cPRefBand.length(); ++i) {
            int n2 = cPRefBand.valueAtForDebug(i);
            if (n2 >= 0 && n2 < n) continue;
            Utils.log.warning("CP ref out of range [" + i + "] = " + n2 + " in " + cPRefBand);
            return false;
        }
        return true;
    }

    private boolean assertReadyToWriteTo(Band band, OutputStream outputStream) throws IOException {
        Band band2 = (Band)this.prevForAssertMap.get(band);
        if (band2 != null && BandStructure.phaseCmp(band2.phase(), 8) < 0) {
            Utils.log.warning("Previous band not done writing.");
            Utils.log.info("    Previous band: " + band2);
            Utils.log.info("        Next band: " + band);
            Thread.dumpStack();
            assert (this.verbose > 0);
        }
        String string = band.name;
        if (this.optDebugBands && !string.startsWith("(")) {
            for (int i = 0; i < string.length(); ++i) {
                outputStream.write((byte)string.charAt(i));
            }
            outputStream.write(0);
        }
        return true;
    }

    protected static boolean testBit(int n, int n2) {
        return (n & n2) != 0;
    }

    protected static int setBit(int n, int n2, boolean bl) {
        return bl ? n | n2 : n & ~n2;
    }

    protected static boolean testBit(long l, long l2) {
        return (l & l2) != 0L;
    }

    protected static long setBit(long l, long l2, boolean bl) {
        return bl ? l | l2 : l & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    static void printArrayTo(PrintStream printStream, int[] nArray, int n, int n2) {
        int n3 = n2 - n;
        for (int i = 0; i < n3; ++i) {
            if (i % 10 == 0) {
                printStream.println();
            } else {
                printStream.print(" ");
            }
            printStream.print(nArray[n + i]);
        }
        printStream.println();
    }

    static void printArrayTo(PrintStream printStream, ConstantPool.Entry[] entryArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2 - n;
        for (int i = 0; i < n3; ++i) {
            String string = entryArray[n + i].stringValue();
            stringBuffer.setLength(0);
            for (int j = 0; j < string.length(); ++j) {
                char c = string.charAt(j);
                if (c >= ' ' && c <= '~' && c != '\\') {
                    stringBuffer.append(c);
                    continue;
                }
                if (c == '\n') {
                    stringBuffer.append("\\n");
                    continue;
                }
                if (c == '\t') {
                    stringBuffer.append("\\t");
                    continue;
                }
                if (c == '\r') {
                    stringBuffer.append("\\r");
                    continue;
                }
                stringBuffer.append("\\x" + Integer.toHexString(c));
            }
            printStream.println(stringBuffer);
        }
    }

    protected static Object[] realloc(Object[] objectArray, int n) {
        Class<?> clazz = objectArray.getClass().getComponentType();
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, n);
        System.arraycopy(objectArray, 0, objectArray2, 0, Math.min(objectArray.length, n));
        return objectArray2;
    }

    protected static Object[] realloc(Object[] objectArray) {
        return BandStructure.realloc(objectArray, Math.max(10, objectArray.length * 2));
    }

    protected static int[] realloc(int[] nArray, int n) {
        if (n == 0) {
            return noInts;
        }
        if (nArray == null) {
            return new int[n];
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, Math.min(nArray.length, n));
        return nArray2;
    }

    protected static int[] realloc(int[] nArray) {
        return BandStructure.realloc(nArray, Math.max(10, nArray.length * 2));
    }

    protected static byte[] realloc(byte[] byArray, int n) {
        if (n == 0) {
            return noBytes;
        }
        if (byArray == null) {
            return new byte[n];
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n));
        return byArray2;
    }

    protected static byte[] realloc(byte[] byArray) {
        return BandStructure.realloc(byArray, Math.max(10, byArray.length * 2));
    }

    static {
        Coding coding;
        int n;
        BYTE1 = Coding.of(1, 256);
        CHAR3 = Coding.of(3, 128);
        BCI5 = Coding.of(5, 4);
        BRANCH5 = Coding.of(5, 4, 2);
        UNSIGNED5 = Coding.of(5, 64);
        UDELTA5 = UNSIGNED5.getDeltaCoding();
        SIGNED5 = Coding.of(5, 64, 1);
        DELTA5 = SIGNED5.getDeltaCoding();
        MDELTA5 = Coding.of(5, 64, 2).getDeltaCoding();
        basicCodings = new Coding[]{null, Coding.of(1, 256, 0), Coding.of(1, 256, 1), Coding.of(1, 256, 0).getDeltaCoding(), Coding.of(1, 256, 1).getDeltaCoding(), Coding.of(2, 256, 0), Coding.of(2, 256, 1), Coding.of(2, 256, 0).getDeltaCoding(), Coding.of(2, 256, 1).getDeltaCoding(), Coding.of(3, 256, 0), Coding.of(3, 256, 1), Coding.of(3, 256, 0).getDeltaCoding(), Coding.of(3, 256, 1).getDeltaCoding(), Coding.of(4, 256, 0), Coding.of(4, 256, 1), Coding.of(4, 256, 0).getDeltaCoding(), Coding.of(4, 256, 1).getDeltaCoding(), Coding.of(5, 4, 0), Coding.of(5, 4, 1), Coding.of(5, 4, 2), Coding.of(5, 16, 0), Coding.of(5, 16, 1), Coding.of(5, 16, 2), Coding.of(5, 32, 0), Coding.of(5, 32, 1), Coding.of(5, 32, 2), Coding.of(5, 64, 0), Coding.of(5, 64, 1), Coding.of(5, 64, 2), Coding.of(5, 128, 0), Coding.of(5, 128, 1), Coding.of(5, 128, 2), Coding.of(5, 4, 0).getDeltaCoding(), Coding.of(5, 4, 1).getDeltaCoding(), Coding.of(5, 4, 2).getDeltaCoding(), Coding.of(5, 16, 0).getDeltaCoding(), Coding.of(5, 16, 1).getDeltaCoding(), Coding.of(5, 16, 2).getDeltaCoding(), Coding.of(5, 32, 0).getDeltaCoding(), Coding.of(5, 32, 1).getDeltaCoding(), Coding.of(5, 32, 2).getDeltaCoding(), Coding.of(5, 64, 0).getDeltaCoding(), Coding.of(5, 64, 1).getDeltaCoding(), Coding.of(5, 64, 2).getDeltaCoding(), Coding.of(5, 128, 0).getDeltaCoding(), Coding.of(5, 128, 1).getDeltaCoding(), Coding.of(5, 128, 2).getDeltaCoding(), Coding.of(2, 192, 0), Coding.of(2, 224, 0), Coding.of(2, 240, 0), Coding.of(2, 248, 0), Coding.of(2, 252, 0), Coding.of(2, 8, 0).getDeltaCoding(), Coding.of(2, 8, 1).getDeltaCoding(), Coding.of(2, 16, 0).getDeltaCoding(), Coding.of(2, 16, 1).getDeltaCoding(), Coding.of(2, 32, 0).getDeltaCoding(), Coding.of(2, 32, 1).getDeltaCoding(), Coding.of(2, 64, 0).getDeltaCoding(), Coding.of(2, 64, 1).getDeltaCoding(), Coding.of(2, 128, 0).getDeltaCoding(), Coding.of(2, 128, 1).getDeltaCoding(), Coding.of(2, 192, 0).getDeltaCoding(), Coding.of(2, 192, 1).getDeltaCoding(), Coding.of(2, 224, 0).getDeltaCoding(), Coding.of(2, 224, 1).getDeltaCoding(), Coding.of(2, 240, 0).getDeltaCoding(), Coding.of(2, 240, 1).getDeltaCoding(), Coding.of(2, 248, 0).getDeltaCoding(), Coding.of(2, 248, 1).getDeltaCoding(), Coding.of(3, 192, 0), Coding.of(3, 224, 0), Coding.of(3, 240, 0), Coding.of(3, 248, 0), Coding.of(3, 252, 0), Coding.of(3, 8, 0).getDeltaCoding(), Coding.of(3, 8, 1).getDeltaCoding(), Coding.of(3, 16, 0).getDeltaCoding(), Coding.of(3, 16, 1).getDeltaCoding(), Coding.of(3, 32, 0).getDeltaCoding(), Coding.of(3, 32, 1).getDeltaCoding(), Coding.of(3, 64, 0).getDeltaCoding(), Coding.of(3, 64, 1).getDeltaCoding(), Coding.of(3, 128, 0).getDeltaCoding(), Coding.of(3, 128, 1).getDeltaCoding(), Coding.of(3, 192, 0).getDeltaCoding(), Coding.of(3, 192, 1).getDeltaCoding(), Coding.of(3, 224, 0).getDeltaCoding(), Coding.of(3, 224, 1).getDeltaCoding(), Coding.of(3, 240, 0).getDeltaCoding(), Coding.of(3, 240, 1).getDeltaCoding(), Coding.of(3, 248, 0).getDeltaCoding(), Coding.of(3, 248, 1).getDeltaCoding(), Coding.of(4, 192, 0), Coding.of(4, 224, 0), Coding.of(4, 240, 0), Coding.of(4, 248, 0), Coding.of(4, 252, 0), Coding.of(4, 8, 0).getDeltaCoding(), Coding.of(4, 8, 1).getDeltaCoding(), Coding.of(4, 16, 0).getDeltaCoding(), Coding.of(4, 16, 1).getDeltaCoding(), Coding.of(4, 32, 0).getDeltaCoding(), Coding.of(4, 32, 1).getDeltaCoding(), Coding.of(4, 64, 0).getDeltaCoding(), Coding.of(4, 64, 1).getDeltaCoding(), Coding.of(4, 128, 0).getDeltaCoding(), Coding.of(4, 128, 1).getDeltaCoding(), Coding.of(4, 192, 0).getDeltaCoding(), Coding.of(4, 192, 1).getDeltaCoding(), Coding.of(4, 224, 0).getDeltaCoding(), Coding.of(4, 224, 1).getDeltaCoding(), Coding.of(4, 240, 0).getDeltaCoding(), Coding.of(4, 240, 1).getDeltaCoding(), Coding.of(4, 248, 0).getDeltaCoding(), Coding.of(4, 248, 1).getDeltaCoding(), null};
        assert (basicCodings[0] == null);
        assert (basicCodings[1] != null);
        assert (basicCodings[115] != null);
        HashMap<Coding, Integer> hashMap = new HashMap<Coding, Integer>();
        for (n = 0; n < basicCodings.length; ++n) {
            coding = basicCodings[n];
            if (coding == null) continue;
            assert (n >= 1);
            assert (n <= 115);
            hashMap.put(coding, new Integer(n));
        }
        basicCodingIndexes = hashMap;
        defaultMetaCoding = new byte[]{0};
        noMetaCoding = new byte[0];
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl) {
            for (n = 0; n < basicCodings.length; ++n) {
                coding = basicCodings[n];
                if (coding == null || coding.B() == 1 || coding.L() == 0) continue;
                for (int i = 0; i <= 255; ++i) {
                    BandStructure.encodeEscapeValue(i, coding);
                }
            }
        }
        shortCodeLimits = new int[][]{{12, 12}, {8, 8}, {7, 7}};
        noInts = new int[0];
        noBytes = new byte[0];
    }

    abstract class Band {
        private int phase = 0;
        private final String name;
        private int valuesExpected;
        protected long outputSize = -1L;
        public final Coding regularCoding;
        public final int seqForDebug;
        public int elementCountForDebug;
        protected int lengthForDebug = -1;

        protected Band(String string, Coding coding) {
            this.name = string;
            this.regularCoding = coding;
            this.seqForDebug = ++nextSeqForDebug;
            if (BandStructure.this.verbose > 2) {
                Utils.log.fine("Band " + this.seqForDebug + " is " + string);
            }
        }

        public Band init() {
            if (BandStructure.this.isReader) {
                this.readyToExpect();
            } else {
                this.readyToCollect();
            }
            return this;
        }

        boolean isReader() {
            return BandStructure.this.isReader;
        }

        int phase() {
            return this.phase;
        }

        String name() {
            return this.name;
        }

        public abstract int capacity();

        protected abstract void setCapacity(int var1);

        public abstract int length();

        protected abstract int valuesRemainingForDebug();

        public final int valuesExpected() {
            return this.valuesExpected;
        }

        public final void writeTo(OutputStream outputStream) throws IOException {
            assert (BandStructure.this.assertReadyToWriteTo(this, outputStream));
            this.setPhase(3);
            this.writeDataTo(outputStream);
            this.doneWriting();
        }

        abstract void chooseBandCodings() throws IOException;

        public final long outputSize() {
            if (this.outputSize >= 0L) {
                long l = this.outputSize;
                assert (l == this.computeOutputSize());
                return l;
            }
            return this.computeOutputSize();
        }

        protected abstract long computeOutputSize();

        protected abstract void writeDataTo(OutputStream var1) throws IOException;

        void expectLength(int n) {
            assert (BandStructure.assertPhase(this, 2));
            assert (this.valuesExpected == 0);
            assert (n >= 0);
            this.valuesExpected = n;
        }

        void expectMoreLength(int n) {
            assert (BandStructure.assertPhase(this, 2));
            this.valuesExpected += n;
        }

        private void readyToCollect() {
            this.setCapacity(1);
            this.setPhase(1);
        }

        protected void doneWriting() {
            assert (BandStructure.assertPhase(this, 3));
            this.setPhase(8);
        }

        private void readyToExpect() {
            this.setPhase(2);
        }

        public final void readFrom(InputStream inputStream) throws IOException {
            assert (BandStructure.this.assertReadyToReadFrom(this, inputStream));
            this.setCapacity(this.valuesExpected());
            this.setPhase(4);
            this.readDataFrom(inputStream);
            this.readyToDisburse();
        }

        protected abstract void readDataFrom(InputStream var1) throws IOException;

        protected void readyToDisburse() {
            if (BandStructure.this.verbose > 1) {
                Utils.log.fine("readyToDisburse " + this);
            }
            this.setPhase(6);
        }

        public void doneDisbursing() {
            assert (BandStructure.assertPhase(this, 6));
            this.setPhase(8);
        }

        public final void doneWithUnusedBand() {
            assert (BandStructure.assertPhase(this, 2));
            assert (this.valuesExpected() == 0);
            this.setPhase(4);
            this.setPhase(6);
            this.setPhase(8);
        }

        protected void setPhase(int n) {
            assert (BandStructure.assertPhaseChangeOK(this, this.phase, n));
            this.phase = n;
        }

        public String toString() {
            int n = this.lengthForDebug != -1 ? this.lengthForDebug : this.length();
            String string = this.name;
            if (n != 0) {
                string = string + "[" + n + "]";
            }
            if (this.elementCountForDebug != 0) {
                string = string + "(" + this.elementCountForDebug + ")";
            }
            return string;
        }
    }

    class ByteBand
    extends Band {
        private ByteArrayOutputStream bytes;
        private ByteArrayOutputStream bytesForDump;
        private InputStream in;

        public ByteBand(String string) {
            super(string, BYTE1);
        }

        public int capacity() {
            return this.bytes == null ? -1 : Integer.MAX_VALUE;
        }

        protected void setCapacity(int n) {
            assert (this.bytes == null);
            this.bytes = new ByteArrayOutputStream(n);
        }

        public void destroy() {
            this.lengthForDebug = this.length();
            this.bytes = null;
        }

        public int length() {
            return this.bytes == null ? -1 : this.bytes.size();
        }

        public void reset() {
            this.bytes.reset();
        }

        protected int valuesRemainingForDebug() {
            return this.bytes == null ? -1 : ((ByteArrayInputStream)this.in).available();
        }

        protected void chooseBandCodings() throws IOException {
            assert (BandStructure.decodeEscapeValue(this.regularCoding.min(), this.regularCoding) < 0);
            assert (BandStructure.decodeEscapeValue(this.regularCoding.max(), this.regularCoding) < 0);
        }

        protected long computeOutputSize() {
            return this.bytes.size();
        }

        public void writeDataTo(OutputStream outputStream) throws IOException {
            if (this.length() == 0) {
                return;
            }
            this.bytes.writeTo(outputStream);
            if (BandStructure.this.optDumpBands) {
                this.dumpBand();
            }
            this.destroy();
        }

        private void dumpBand() throws IOException {
            assert (BandStructure.this.optDumpBands);
            OutputStream outputStream = BandStructure.getDumpStream(this, ".bnd");
            if (this.bytesForDump != null) {
                this.bytesForDump.writeTo(outputStream);
            } else {
                this.bytes.writeTo(outputStream);
            }
            outputStream.close();
        }

        public void readDataFrom(InputStream inputStream) throws IOException {
            int n = this.valuesExpected();
            if (n == 0) {
                return;
            }
            if (BandStructure.this.verbose > 1) {
                this.lengthForDebug = n;
                Utils.log.fine("Reading band " + this);
                this.lengthForDebug = -1;
            }
            byte[] byArray = new byte[Math.min(n, 16384)];
            while (n > 0) {
                int n2 = inputStream.read(byArray, 0, Math.min(n, byArray.length));
                if (n2 < 0) {
                    throw new EOFException();
                }
                this.bytes.write(byArray, 0, n2);
                n -= n2;
            }
            if (BandStructure.this.optDumpBands) {
                this.dumpBand();
            }
        }

        public void readyToDisburse() {
            this.in = new ByteArrayInputStream(this.bytes.toByteArray());
            super.readyToDisburse();
        }

        public void doneDisbursing() {
            super.doneDisbursing();
            if (BandStructure.this.optDumpBands && this.bytesForDump != null && this.bytesForDump.size() > 0) {
                try {
                    this.dumpBand();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            this.in = null;
            this.bytes = null;
            this.bytesForDump = null;
        }

        public void setInputStreamFrom(InputStream inputStream) throws IOException {
            assert (this.bytes == null);
            assert (BandStructure.this.assertReadyToReadFrom(this, inputStream));
            this.setPhase(4);
            this.in = inputStream;
            if (BandStructure.this.optDumpBands) {
                this.bytesForDump = new ByteArrayOutputStream();
                this.in = new FilterInputStream(inputStream){

                    public int read() throws IOException {
                        int n = this.in.read();
                        if (n >= 0) {
                            ByteBand.this.bytesForDump.write(n);
                        }
                        return n;
                    }

                    public int read(byte[] byArray, int n, int n2) throws IOException {
                        int n3 = this.in.read(byArray, n, n2);
                        if (n3 >= 0) {
                            ByteBand.this.bytesForDump.write(byArray, n, n3);
                        }
                        return n3;
                    }
                };
            }
            super.readyToDisburse();
        }

        public OutputStream collectorStream() {
            assert (this.phase() == 1);
            assert (this.bytes != null);
            return this.bytes;
        }

        public InputStream getInputStream() {
            assert (this.phase() == 6);
            assert (this.in != null);
            return this.in;
        }

        public int getByte() throws IOException {
            int n = this.getInputStream().read();
            if (n < 0) {
                throw new EOFException();
            }
            return n;
        }

        public void putByte(int n) throws IOException {
            assert (n == (n & 0xFF));
            this.collectorStream().write(n);
        }

        public String toString() {
            return "byte " + super.toString();
        }
    }

    private static class ByteCounter
    extends FilterOutputStream {
        private long count;

        public ByteCounter(OutputStream outputStream) {
            super(outputStream);
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long l) {
            this.count = l;
        }

        public void write(int n) throws IOException {
            ++this.count;
            if (this.out != null) {
                this.out.write(n);
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.count += (long)n2;
            if (this.out != null) {
                this.out.write(byArray, n, n2);
            }
        }

        public String toString() {
            return String.valueOf(this.getCount());
        }
    }

    class CPRefBand
    extends ValueBand {
        ConstantPool.Index index;
        boolean nullOK;

        public CPRefBand(String string, Coding coding, byte by, boolean bl) {
            super(string, coding);
            this.nullOK = bl;
            if (by != 0) {
                BandStructure.this.setBandIndex(this, by);
            }
        }

        public CPRefBand(String string, Coding coding, byte by) {
            this(string, coding, by, false);
        }

        public CPRefBand(String string, Coding coding, Object object) {
            this(string, coding, 0, false);
        }

        public void setIndex(ConstantPool.Index index) {
            this.index = index;
        }

        protected void readDataFrom(InputStream inputStream) throws IOException {
            super.readDataFrom(inputStream);
            assert (BandStructure.this.assertValidCPRefs(this));
        }

        public void putRef(ConstantPool.Entry entry) {
            assert (this.index != null);
            this.addValue(this.encodeRefOrNull(entry, this.index));
        }

        public void putRef(ConstantPool.Entry entry, ConstantPool.Index index) {
            assert (this.index == null);
            this.addValue(this.encodeRefOrNull(entry, index));
        }

        public void putRef(ConstantPool.Entry entry, byte by) {
            this.putRef(entry, BandStructure.this.getCPIndex(by));
        }

        public ConstantPool.Entry getRef() {
            if (this.index == null) {
                Utils.log.warning("No index for " + this);
            }
            assert (this.index != null);
            return this.decodeRefOrNull(this.getValue(), this.index);
        }

        public ConstantPool.Entry getRef(ConstantPool.Index index) {
            assert (this.index == null);
            return this.decodeRefOrNull(this.getValue(), index);
        }

        public ConstantPool.Entry getRef(byte by) {
            return this.getRef(BandStructure.this.getCPIndex(by));
        }

        private int encodeRefOrNull(ConstantPool.Entry entry, ConstantPool.Index index) {
            int n = entry == null ? -1 : BandStructure.this.encodeRef(entry, index);
            return (this.nullOK ? 1 : 0) + n;
        }

        private ConstantPool.Entry decodeRefOrNull(int n, ConstantPool.Index index) {
            int n2 = n - (this.nullOK ? 1 : 0);
            if (n2 == -1) {
                return null;
            }
            return BandStructure.this.decodeRef(n2, index);
        }
    }

    class IntBand
    extends ValueBand {
        public IntBand(String string, Coding coding) {
            super(string, coding);
        }

        public void putInt(int n) {
            assert (this.phase() == 1);
            this.addValue(n);
        }

        public int getInt() {
            return this.getValue();
        }

        public int getIntTotal() {
            assert (this.phase() == 6);
            assert (this.valuesRemainingForDebug() == this.length());
            int n = 0;
            for (int i = this.length(); i > 0; --i) {
                n += this.getInt();
            }
            this.resetForSecondPass();
            return n;
        }

        public int getIntCount(int n) {
            assert (this.phase() == 6);
            assert (this.valuesRemainingForDebug() == this.length());
            int n2 = 0;
            for (int i = this.length(); i > 0; --i) {
                if (this.getInt() != n) continue;
                ++n2;
            }
            this.resetForSecondPass();
            return n2;
        }
    }

    class MultiBand
    extends Band {
        Band[] bands;
        int bandCount;
        private int cap;

        MultiBand(String string, Coding coding) {
            super(string, coding);
            this.bands = new Band[10];
            this.bandCount = 0;
            this.cap = -1;
        }

        public Band init() {
            super.init();
            this.setCapacity(0);
            if (this.phase() == 2) {
                this.setPhase(4);
                this.setPhase(6);
            }
            return this;
        }

        int size() {
            return this.bandCount;
        }

        Band get(int n) {
            assert (n < this.bandCount);
            return this.bands[n];
        }

        Band[] toArray() {
            return (Band[])BandStructure.realloc(this.bands, this.bandCount);
        }

        void add(Band band) {
            assert (this.bandCount == 0 || BandStructure.this.notePrevForAssert(band, this.bands[this.bandCount - 1]));
            if (this.bandCount == this.bands.length) {
                this.bands = (Band[])BandStructure.realloc(this.bands);
            }
            this.bands[this.bandCount++] = band;
        }

        ByteBand newByteBand(String string) {
            ByteBand byteBand = new ByteBand(string);
            byteBand.init();
            this.add(byteBand);
            return byteBand;
        }

        IntBand newIntBand(String string) {
            IntBand intBand = new IntBand(string, this.regularCoding);
            intBand.init();
            this.add(intBand);
            return intBand;
        }

        IntBand newIntBand(String string, Coding coding) {
            IntBand intBand = new IntBand(string, coding);
            intBand.init();
            this.add(intBand);
            return intBand;
        }

        MultiBand newMultiBand(String string, Coding coding) {
            MultiBand multiBand = new MultiBand(string, coding);
            multiBand.init();
            this.add(multiBand);
            return multiBand;
        }

        CPRefBand newCPRefBand(String string, byte by) {
            CPRefBand cPRefBand = new CPRefBand(string, this.regularCoding, by);
            cPRefBand.init();
            this.add(cPRefBand);
            return cPRefBand;
        }

        CPRefBand newCPRefBand(String string, Coding coding, byte by) {
            CPRefBand cPRefBand = new CPRefBand(string, coding, by);
            cPRefBand.init();
            this.add(cPRefBand);
            return cPRefBand;
        }

        CPRefBand newCPRefBand(String string, Coding coding, byte by, boolean bl) {
            CPRefBand cPRefBand = new CPRefBand(string, coding, by, bl);
            cPRefBand.init();
            this.add(cPRefBand);
            return cPRefBand;
        }

        int bandCount() {
            return this.bandCount;
        }

        public int capacity() {
            return this.cap;
        }

        public void setCapacity(int n) {
            this.cap = n;
        }

        public int length() {
            return 0;
        }

        public int valuesRemainingForDebug() {
            return 0;
        }

        protected void chooseBandCodings() throws IOException {
            for (int i = 0; i < this.bandCount; ++i) {
                Band band = this.bands[i];
                band.chooseBandCodings();
            }
        }

        protected long computeOutputSize() {
            long l = 0L;
            for (int i = 0; i < this.bandCount; ++i) {
                Band band = this.bands[i];
                long l2 = band.outputSize();
                assert (l2 >= 0L) : band;
                l += l2;
            }
            return l;
        }

        protected void writeDataTo(OutputStream outputStream) throws IOException {
            long l = 0L;
            if (BandStructure.this.outputCounter != null) {
                l = BandStructure.this.outputCounter.getCount();
            }
            for (int i = 0; i < this.bandCount; ++i) {
                Band band = this.bands[i];
                band.writeTo(outputStream);
                if (BandStructure.this.outputCounter == null) continue;
                long l2 = BandStructure.this.outputCounter.getCount();
                long l3 = l2 - l;
                l = l2;
                if ((BandStructure.this.verbose <= 0 || l3 <= 0L) && BandStructure.this.verbose <= 1) continue;
                Utils.log.info("  ...wrote " + l3 + " bytes from " + band);
            }
        }

        protected void readDataFrom(InputStream inputStream) throws IOException {
            assert (false);
            for (int i = 0; i < this.bandCount; ++i) {
                Band band = this.bands[i];
                band.readFrom(inputStream);
                if ((BandStructure.this.verbose <= 0 || band.length() <= 0) && BandStructure.this.verbose <= 1) continue;
                Utils.log.info("  ...read " + band);
            }
        }

        public String toString() {
            return "{" + this.bandCount() + " bands: " + super.toString() + "}";
        }
    }

    class ValueBand
    extends Band {
        private int[] values;
        private int length;
        private int valuesDisbursed;
        private CodingMethod bandCoding;
        private byte[] metaCoding;

        protected ValueBand(String string, Coding coding) {
            super(string, coding);
        }

        public int capacity() {
            return this.values == null ? -1 : this.values.length;
        }

        protected void setCapacity(int n) {
            assert (this.length <= n);
            if (n == -1) {
                this.values = null;
                return;
            }
            this.values = BandStructure.realloc(this.values, n);
        }

        public int length() {
            return this.length;
        }

        protected int valuesRemainingForDebug() {
            return this.length - this.valuesDisbursed;
        }

        protected int valueAtForDebug(int n) {
            return this.values[n];
        }

        void patchValue(int n, int n2) {
            assert (this == BandStructure.this.archive_header_S);
            assert (n == 0 || n == 1);
            assert (n < this.length);
            this.values[n] = n2;
            this.outputSize = -1L;
        }

        protected void initializeValues(int[] nArray) {
            assert (BandStructure.assertCanChangeLength(this));
            assert (this.length == 0);
            this.values = nArray;
            this.length = nArray.length;
        }

        protected void addValue(int n) {
            assert (BandStructure.assertCanChangeLength(this));
            if (this.length == this.values.length) {
                this.setCapacity(this.length < 1000 ? this.length * 10 : this.length * 2);
            }
            this.values[this.length++] = n;
        }

        private boolean canVaryCoding() {
            if (!BandStructure.this.optVaryCodings) {
                return false;
            }
            if (this.length == 0) {
                return false;
            }
            if (this == BandStructure.this.archive_header_0) {
                return false;
            }
            if (this == BandStructure.this.archive_header_S) {
                return false;
            }
            if (this == BandStructure.this.archive_header_1) {
                return false;
            }
            return this.regularCoding.min() <= -256 || this.regularCoding.max() >= 256;
        }

        private boolean shouldVaryCoding() {
            assert (this.canVaryCoding());
            return BandStructure.this.effort >= 9 || this.length >= 100;
        }

        protected void chooseBandCodings() throws IOException {
            Object object;
            boolean bl = this.canVaryCoding();
            if (!bl || !this.shouldVaryCoding()) {
                if (this.regularCoding.canRepresent(this.values, 0, this.length)) {
                    this.bandCoding = this.regularCoding;
                } else {
                    assert (bl);
                    if (BandStructure.this.verbose > 1) {
                        Utils.log.fine("regular coding fails in band " + this.name());
                    }
                    this.bandCoding = UNSIGNED5;
                }
                this.outputSize = -1L;
            } else {
                object = new int[]{0, 0};
                this.bandCoding = BandStructure.this.chooseCoding(this.values, 0, this.length, this.regularCoding, this.name(), (int[])object);
                this.outputSize = object[0];
                if (this.outputSize == 0L) {
                    this.outputSize = -1L;
                }
            }
            if (this.bandCoding != this.regularCoding) {
                this.metaCoding = this.bandCoding.getMetaCoding(this.regularCoding);
                if (BandStructure.this.verbose > 1) {
                    Utils.log.fine("alternate coding " + this + " " + this.bandCoding);
                }
            } else {
                this.metaCoding = bl && BandStructure.decodeEscapeValue(this.values[0], this.regularCoding) >= 0 ? defaultMetaCoding : noMetaCoding;
            }
            if (this.metaCoding.length > 0 && (BandStructure.this.verbose > 2 || BandStructure.this.verbose > 1 && this.metaCoding.length > 1)) {
                object = new StringBuffer();
                for (int i = 0; i < this.metaCoding.length; ++i) {
                    if (i == 1) {
                        ((StringBuffer)object).append(" /");
                    }
                    ((StringBuffer)object).append(" ").append(this.metaCoding[i] & 0xFF);
                }
                Utils.log.fine("   meta-coding " + object);
            }
            assert (this.outputSize < 0L || !(this.bandCoding instanceof Coding) || this.outputSize == (long)((Coding)this.bandCoding).getLength(this.values, 0, this.length)) : this.bandCoding + " : " + this.outputSize + " != " + ((Coding)this.bandCoding).getLength(this.values, 0, this.length) + " ?= " + BandStructure.this.getCodingChooser().computeByteSize(this.bandCoding, this.values, 0, this.length);
            if (this.metaCoding.length > 0) {
                if (this.outputSize >= 0L) {
                    this.outputSize += (long)this.computeEscapeSize();
                }
                for (int i = 1; i < this.metaCoding.length; ++i) {
                    BandStructure.this.band_headers.putByte(this.metaCoding[i] & 0xFF);
                }
            }
        }

        protected long computeOutputSize() {
            this.outputSize = BandStructure.this.getCodingChooser().computeByteSize(this.bandCoding, this.values, 0, this.length);
            assert (this.outputSize < Integer.MAX_VALUE);
            this.outputSize += (long)this.computeEscapeSize();
            return this.outputSize;
        }

        protected int computeEscapeSize() {
            if (this.metaCoding.length == 0) {
                return 0;
            }
            int n = this.metaCoding[0] & 0xFF;
            int n2 = BandStructure.encodeEscapeValue(n, this.regularCoding);
            return this.regularCoding.setD(0).getLength(n2);
        }

        protected void writeDataTo(OutputStream outputStream) throws IOException {
            if (this.length == 0) {
                return;
            }
            long l = 0L;
            if (outputStream == BandStructure.this.outputCounter) {
                l = BandStructure.this.outputCounter.getCount();
            }
            if (this.metaCoding.length > 0) {
                int n = this.metaCoding[0] & 0xFF;
                int n2 = BandStructure.encodeEscapeValue(n, this.regularCoding);
                this.regularCoding.setD(0).writeTo(outputStream, n2);
            }
            this.bandCoding.writeArrayTo(outputStream, this.values, 0, this.length);
            if (outputStream == BandStructure.this.outputCounter) {
                long l2 = BandStructure.this.outputCounter.getCount();
                assert (this.outputSize == BandStructure.this.outputCounter.getCount() - l) : this.outputSize + " != " + BandStructure.this.outputCounter.getCount() + "-" + l;
            }
            if (BandStructure.this.optDumpBands) {
                this.dumpBand();
            }
        }

        protected void readDataFrom(InputStream inputStream) throws IOException {
            this.length = this.valuesExpected();
            if (this.length == 0) {
                return;
            }
            if (BandStructure.this.verbose > 1) {
                Utils.log.fine("Reading band " + this);
            }
            if (!this.canVaryCoding()) {
                this.bandCoding = this.regularCoding;
                this.metaCoding = noMetaCoding;
            } else {
                assert (inputStream.markSupported());
                inputStream.mark(5);
                int n = this.regularCoding.setD(0).readFrom(inputStream);
                int n2 = BandStructure.decodeEscapeValue(n, this.regularCoding);
                if (n2 < 0) {
                    inputStream.reset();
                    n2 = 0;
                    this.bandCoding = this.regularCoding;
                    this.metaCoding = noMetaCoding;
                } else if (n2 == 0) {
                    this.bandCoding = this.regularCoding;
                    this.metaCoding = defaultMetaCoding;
                } else {
                    if (BandStructure.this.verbose > 2) {
                        Utils.log.fine("found X=" + n + " => XB=" + n2);
                    }
                    this.bandCoding = BandStructure.this.getBandHeader(n2, this.regularCoding);
                    int n3 = BandStructure.this.bandHeaderBytePos0;
                    int n4 = BandStructure.this.bandHeaderBytePos;
                    this.metaCoding = new byte[n4 - n3];
                    System.arraycopy(BandStructure.this.bandHeaderBytes, n3, this.metaCoding, 0, this.metaCoding.length);
                }
            }
            if (this.bandCoding != this.regularCoding && BandStructure.this.verbose > 1) {
                Utils.log.fine(this.name() + ": irregular coding " + this.bandCoding);
            }
            this.bandCoding.readArrayFrom(inputStream, this.values, 0, this.length);
            if (BandStructure.this.optDumpBands) {
                this.dumpBand();
            }
        }

        public void doneDisbursing() {
            super.doneDisbursing();
            this.values = null;
        }

        private void dumpBand() throws IOException {
            Object object;
            assert (BandStructure.this.optDumpBands);
            PrintStream printStream = new PrintStream(BandStructure.getDumpStream(this, ".txt"));
            String string = this.bandCoding == this.regularCoding ? "" : " irregular";
            printStream.print("# length=" + this.length + " size=" + this.outputSize() + string + " coding=" + this.bandCoding);
            if (this.metaCoding != noMetaCoding) {
                object = new StringBuffer();
                for (int i = 0; i < this.metaCoding.length; ++i) {
                    if (i == 1) {
                        ((StringBuffer)object).append(" /");
                    }
                    ((StringBuffer)object).append(" ").append(this.metaCoding[i] & 0xFF);
                }
                printStream.print(" //header: " + object);
            }
            BandStructure.printArrayTo(printStream, this.values, 0, this.length);
            printStream.close();
            object = BandStructure.getDumpStream(this, ".bnd");
            this.bandCoding.writeArrayTo((OutputStream)object, this.values, 0, this.length);
            ((OutputStream)object).close();
        }

        protected int getValue() {
            assert (this.phase() == 6);
            assert (this.valuesDisbursed < this.length);
            return this.values[this.valuesDisbursed++];
        }

        public void resetForSecondPass() {
            assert (this.phase() == 6);
            assert (this.valuesDisbursed == this.length());
            this.valuesDisbursed = 0;
        }
    }
}

