/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Driver {
    private static final String PACK200_OPTION_MAP = "--repack                 $ \n  -r +>- @--repack              $ \n--no-gzip                $ \n  -g +>- @--no-gzip             $ \n--strip-debug            $ \n  -G +>- @--strip-debug         $ \n--no-keep-file-order     $ \n  -O +>- @--no-keep-file-order  $ \n--segment-limit=      *> = \n  -S +>  @--segment-limit=      = \n--effort=             *> = \n  -E +>  @--effort=             = \n--deflate-hint=       *> = \n  -H +>  @--deflate-hint=       = \n--modification-time=  *> = \n  -m +>  @--modification-time=  = \n--pass-file=        *> &\u0000 \n  -P +>  @--pass-file=        &\u0000 \n--unknown-attribute=  *> = \n  -U +>  @--unknown-attribute=  = \n--class-attribute=  *> &\u0000 \n  -C +>  @--class-attribute=  &\u0000 \n--field-attribute=  *> &\u0000 \n  -F +>  @--field-attribute=  &\u0000 \n--method-attribute= *> &\u0000 \n  -M +>  @--method-attribute= &\u0000 \n--code-attribute=   *> &\u0000 \n  -D +>  @--code-attribute=   &\u0000 \n--config-file=      *>   . \n  -f +>  @--config-file=        . \n--no-strip-debug  !--strip-debug         \n--gzip            !--no-gzip             \n--keep-file-order !--no-keep-file-order  \n--verbose                $ \n  -v +>- @--verbose             $ \n--quiet        !--verbose  \n  -q +>- !--verbose               \n--log-file=           *> = \n  -l +>  @--log-file=           = \n--version                . \n  -V +>  @--version             . \n--help               . \n  -? +> @--help . \n  -h +> @--help . \n--           . \n-   +?    >- . \n";
    private static final String UNPACK200_OPTION_MAP = "--deflate-hint=       *> = \n  -H +>  @--deflate-hint=       = \n--verbose                $ \n  -v +>- @--verbose             $ \n--quiet        !--verbose  \n  -q +>- !--verbose               \n--remove-pack-file       $ \n  -r +>- @--remove-pack-file    $ \n--log-file=           *> = \n  -l +>  @--log-file=           = \n--config-file=        *> . \n  -f +>  @--config-file=        . \n--           . \n-   +?    >- . \n--version                . \n  -V +>  @--version             . \n--help               . \n  -? +> @--help . \n  -h +> @--help . \n";
    private static final String[] PACK200_PROPERTY_TO_OPTION = new String[]{"pack.segment.limit", "--segment-limit=", "pack.keep.file.order", "--no-keep-file-order", "pack.effort", "--effort=", "pack.deflate.hint", "--deflate-hint=", "pack.modification.time", "--modification-time=", "pack.pass.file.", "--pass-file=", "pack.unknown.attribute", "--unknown-attribute=", "pack.class.attribute.", "--class-attribute=", "pack.field.attribute.", "--field-attribute=", "pack.method.attribute.", "--method-attribute=", "pack.code.attribute.", "--code-attribute=", "com.sun.java.util.jar.pack.verbose", "--verbose", "com.sun.java.util.jar.pack.strip.debug", "--strip-debug"};
    private static final String[] UNPACK200_PROPERTY_TO_OPTION = new String[]{"unpack.deflate.hint", "--deflate-hint=", "com.sun.java.util.jar.pack.verbose", "--verbose", "com.sun.java.util.jar.pack.unpack.remove.packfile", "--remove-pack-file"};

    Driver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object6;
        String[] stringArray2;
        String string;
        Object object7;
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        Object object8 = null;
        String string2 = "com.sun.java.util.jar.pack.verbose";
        Object object4 = object7 = arrayList.isEmpty() ? "" : arrayList.get(0);
        if (((String)object7).equals("--pack")) {
            arrayList.remove(0);
        } else if (((String)object7).equals("--unpack")) {
            arrayList.remove(0);
            bl = false;
            bl2 = true;
        }
        object7 = new HashMap();
        ((HashMap)object7).put(string2, System.getProperty(string2));
        if (bl) {
            string = PACK200_OPTION_MAP;
            stringArray2 = PACK200_PROPERTY_TO_OPTION;
        } else {
            string = UNPACK200_OPTION_MAP;
            stringArray2 = UNPACK200_PROPERTY_TO_OPTION;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            block5: while (true) {
                object6 = Driver.parseCommandOptions(arrayList, string, hashMap);
                Iterator<String> iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    object3 = iterator.next();
                    object2 = null;
                    for (int i = 0; i < stringArray2.length; i += 2) {
                        if (!((String)object3).equals(stringArray2[1 + i])) continue;
                        object2 = stringArray2[0 + i];
                        break;
                    }
                    if (object2 == null) continue;
                    String string3 = hashMap.get(object3);
                    iterator.remove();
                    if (!((String)object2).endsWith(".")) {
                        if (!((String)object3).equals("--verbose") && !((String)object3).endsWith("=")) {
                            boolean bl6;
                            boolean bl7 = bl6 = string3 != null;
                            if (((String)object3).startsWith("--no-")) {
                                bl6 = !bl6;
                            }
                            string3 = bl6 ? "true" : "false";
                        }
                        ((HashMap)object7).put(object2, string3);
                        continue;
                    }
                    if (((String)object2).contains(".attribute.")) {
                        for (String string4 : string3.split("\u0000")) {
                            String[] stringArray3 = string4.split("=", 2);
                            ((HashMap)object7).put((String)object2 + stringArray3[0], stringArray3[1]);
                        }
                        continue;
                    }
                    int n = 1;
                    for (String string5 : string3.split("\u0000")) {
                        while (((HashMap)object7).containsKey(object = (String)object2 + "cli." + n++)) {
                        }
                        ((HashMap)object7).put(object, string5);
                    }
                }
                if (object6 != "--config-file=") break;
                String object52 = arrayList.remove(0);
                object3 = new FileInputStream(object52);
                object2 = new Properties();
                ((Properties)object2).load(new BufferedInputStream((InputStream)object3));
                if (((HashMap)object7).get(string2) != null) {
                    ((Properties)object2).list(System.out);
                }
                ((InputStream)object3).close();
                Iterator iterator2 = ((Hashtable)object2).entrySet().iterator();
                while (true) {
                    if (!iterator2.hasNext()) continue block5;
                    Map.Entry entry = iterator2.next();
                    ((HashMap)object7).put((String)entry.getKey(), (String)entry.getValue());
                }
                break;
            }
            if (object6 == "--version") {
                System.out.println(Driver.class.getName() + " version 1.23, 06/04/14");
                return;
            }
            if (object6 == "--help") {
                Driver.printUsage(bl, true, System.out);
                System.exit(1);
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Bad argument:  " + illegalArgumentException);
            Driver.printUsage(bl, false, System.err);
            System.exit(2);
            return;
        }
        for (String string6 : hashMap.keySet()) {
            object3 = hashMap.get(string6);
            if (string6 == "--repack") {
                bl3 = true;
                continue;
            }
            if (string6 == "--no-gzip") {
                bl5 = object3 == null;
                continue;
            }
            if (string6 == "--log-file=") {
                object8 = object3;
                continue;
            }
            throw new InternalError("Bad option: " + string6 + "=" + hashMap.get(string6));
        }
        if (object8 != null && !((String)object8).equals("")) {
            if (((String)object8).equals("-")) {
                System.setErr(System.out);
            } else {
                object6 = new FileOutputStream((String)object8);
                System.setErr(new PrintStream((OutputStream)object6));
            }
        }
        boolean bl8 = ((HashMap)object7).get(string2) != null;
        String string7 = "";
        if (!arrayList.isEmpty()) {
            String string8 = arrayList.remove(0);
        }
        object3 = "";
        if (!arrayList.isEmpty()) {
            object3 = arrayList.remove(0);
        }
        object2 = "";
        String string9 = "";
        String string10 = "";
        if (bl3) {
            void var14_22;
            if (var14_22.toLowerCase().endsWith(".pack") || var14_22.toLowerCase().endsWith(".pac") || var14_22.toLowerCase().endsWith(".gz")) {
                System.err.println("Bad --repack output: " + (String)var14_22);
                Driver.printUsage(bl, false, System.err);
                System.exit(2);
            }
            object2 = var14_22;
            if (((String)object3).equals("")) {
                object3 = object2;
            }
            String string11 = string10 = Driver.createTempFile((String)object2, ".pack").getPath();
            bl5 = false;
        }
        if (!(arrayList.isEmpty() && (((String)object3).toLowerCase().endsWith(".jar") || ((String)object3).toLowerCase().endsWith(".zip") || ((String)object3).equals("-") && !bl))) {
            Driver.printUsage(bl, false, System.err);
            System.exit(2);
            return;
        }
        if (bl3) {
            bl2 = true;
            bl = true;
        } else if (bl) {
            bl2 = false;
        }
        Pack200.Packer packer = Pack200.newPacker();
        Pack200.Unpacker unpacker = Pack200.newUnpacker();
        packer.properties().putAll((Map<String, String>)object7);
        unpacker.properties().putAll((Map<String, String>)object7);
        if (bl3 && ((String)object2).equals(object3)) {
            String string12 = Driver.getZipComment((String)object3);
            if (bl8 && string12.length() > 0) {
                System.out.println("Detected ZIP comment: " + string12);
            }
            if (string12.indexOf("PACK200") >= 0) {
                System.out.println("Skipping because already repacked: " + (String)object3);
                bl = false;
                bl2 = false;
                bl3 = false;
            }
        }
        try {
            void var14_24;
            if (bl) {
                void var22_57;
                JarFile jarFile = new JarFile(new File((String)object3));
                if (var14_24.equals("-")) {
                    PrintStream printStream = System.out;
                    System.setOut(System.err);
                } else if (bl5) {
                    if (!var14_24.endsWith(".gz")) {
                        System.err.println("To write a *.pack file, specify --no-gzip: " + (String)var14_24);
                        Driver.printUsage(bl, false, System.err);
                        System.exit(2);
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream((String)var14_24);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(bufferedOutputStream);
                } else {
                    if (!var14_24.toLowerCase().endsWith(".pack") && !var14_24.toLowerCase().endsWith(".pac")) {
                        System.err.println("To write a *.pack.gz file, specify --gzip: " + (String)var14_24);
                        Driver.printUsage(bl, false, System.err);
                        System.exit(2);
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream((String)var14_24);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                }
                packer.pack(jarFile, (OutputStream)var22_57);
                var22_57.close();
            }
            if (bl3 && ((String)object2).equals(object3)) {
                File file = Driver.createTempFile((String)object3, ".bak");
                file.delete();
                boolean bl9 = new File((String)object3).renameTo(file);
                if (!bl9) {
                    throw new Error("Skipping unpack because move failed: " + string9);
                }
                string9 = file.getPath();
            }
            if (bl2) {
                InputStream inputStream = var14_24.equals("-") ? System.in : new FileInputStream(new File((String)var14_24));
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                inputStream = bufferedInputStream;
                if (Utils.isGZIPMagic(Utils.readMagic(bufferedInputStream))) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                object = ((String)object2).equals("") ? object3 : object2;
                OutputStream outputStream = ((String)object).equals("-") ? System.out : new FileOutputStream((String)object);
                outputStream = new BufferedOutputStream(outputStream);
                JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
                unpacker.unpack(inputStream, jarOutputStream);
                jarOutputStream.close();
            }
            if (!string9.equals("")) {
                new File(string9).delete();
                string9 = "";
            }
        }
        finally {
            if (!string9.equals("")) {
                File file = new File((String)object3);
                file.delete();
                new File(string9).renameTo(file);
            }
            if (!string10.equals("")) {
                new File(string10).delete();
            }
        }
    }

    private static File createTempFile(String string, String string2) throws IOException {
        File file = new File(string);
        String string3 = file.getName();
        if (string3.length() < 3) {
            string3 = string3 + "tmp";
        }
        File file2 = file.getParentFile();
        if (file.getParentFile() == null && string2.equals(".bak")) {
            file2 = new File(".").getAbsoluteFile();
        }
        File file3 = File.createTempFile(string3, string2, file2);
        return file3;
    }

    private static void printUsage(boolean bl, boolean bl2, PrintStream printStream) {
        String string = bl ? "pack200" : "unpack200";
        String[] stringArray = new String[]{"Usage:  " + string + " [-opt... | --option=value]... x.pack[.gz] y.jar", "", "Packing Options", "  -g, --no-gzip                   output a plain *.pack file with no zipping", "  --gzip                          (default) post-process the pack output with gzip", "  -G, --strip-debug               remove debugging attributes while packing", "  -O, --no-keep-file-order        do not transmit file ordering information", "  --keep-file-order               (default) preserve input file ordering", "  -S{N}, --segment-limit={N}      output segment limit (default N=1Mb)", "  -E{N}, --effort={N}             packing effort (default N=5)", "  -H{h}, --deflate-hint={h}       transmit deflate hint: true, false, or keep (default)", "  -m{V}, --modification-time={V}  transmit modtimes: latest or keep (default)", "  -P{F}, --pass-file={F}          transmit the given input element(s) uncompressed", "  -U{a}, --unknown-attribute={a}  unknown attribute action: error, strip, or pass (default)", "  -C{N}={L}, --class-attribute={N}={L}  (user-defined attribute)", "  -F{N}={L}, --field-attribute={N}={L}  (user-defined attribute)", "  -M{N}={L}, --method-attribute={N}={L} (user-defined attribute)", "  -D{N}={L}, --code-attribute={N}={L}   (user-defined attribute)", "  -f{F}, --config-file={F}        read file F for Pack200.Packer properties", "  -v, --verbose                   increase program verbosity", "  -q, --quiet                     set verbosity to lowest level", "  -l{F}, --log-file={F}           output to the given log file, or '-' for System.out", "  -?, -h, --help                  print this message", "  -V, --version                   print program version", "  -J{X}                           pass option X to underlying Java VM", "", "Notes:", "  The -P, -C, -F, -M, and -D options accumulate.", "  Example attribute definition:  -C SourceFile=RUH .", "  Config. file properties are defined by the Pack200 API.", "  For meaning of -S, -E, -H-, -m, -U values, see Pack200 API.", "  Layout definitions (like RUH) are defined by JSR 200.", "", "Repacking mode updates the JAR file with a pack/unpack cycle:", "    " + string + " [-r|--repack] [-opt | --option=value]... [repackedy.jar] y.jar"};
        String[] stringArray2 = new String[]{"Usage:  " + string + " [-opt... | --option=value]... x.pack[.gz] y.jar", "", "Unpacking Options", "  -H{h}, --deflate-hint={h}     override transmitted deflate hint: true, false, or keep (default)", "  -r, --remove-pack-file        remove input file after unpacking", "  -v, --verbose                 increase program verbosity", "  -q, --quiet                   set verbosity to lowest level", "  -l{F}, --log-file={F}         output to the given log file, or '-' for System.out", "  -?, -h, --help                print this message", "  -V, --version                 print program version", "  -J{X}                         pass option X to underlying Java VM"};
        String[] stringArray3 = bl ? stringArray : stringArray2;
        for (int i = 0; i < stringArray3.length; ++i) {
            printStream.println(stringArray3[i]);
            if (bl2) continue;
            printStream.println("(For more information, run " + string + " --help .)");
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getZipComment(String string) throws IOException {
        byte[] byArray = new byte[1000];
        long l = new File(string).length();
        if (l <= 0L) {
            return "";
        }
        long l2 = Math.max(0L, l - (long)byArray.length);
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        try {
            ((InputStream)fileInputStream).skip(l2);
            ((InputStream)fileInputStream).read(byArray);
            for (int i = byArray.length - 4; i >= 0; --i) {
                if (byArray[i + 0] != 80 || byArray[i + 1] != 75 || byArray[i + 2] != 5 || byArray[i + 3] != 6) continue;
                if ((i += 22) < byArray.length) {
                    String string2 = new String(byArray, i, byArray.length - i, "UTF8");
                    return string2;
                }
                String string3 = "";
                return string3;
            }
            String string4 = "";
            return string4;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    private static String parseCommandOptions(List<String> list, String string, Map<String, String> map) {
        ListIterator<String> listIterator;
        ListIterator<String> listIterator2;
        Object object;
        block32: {
            String string2;
            SortedMap sortedMap;
            Object object2;
            object = null;
            TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
            for (String string3 : string.split("\n")) {
                String[] stringArray;
                object2 = string3.split("\\p{Space}+");
                if (((String[])object2).length == 0) continue;
                sortedMap = object2[0];
                object2[0] = "";
                if (((String)((Object)sortedMap)).length() == 0 && ((String[])object2).length >= 1) {
                    sortedMap = object2[1];
                    object2[1] = "";
                }
                if (((String)((Object)sortedMap)).length() == 0 || (stringArray = treeMap.put(sortedMap, object2)) == null) continue;
                throw new RuntimeException("duplicate option: " + string3.trim());
            }
            listIterator2 = list.listIterator();
            listIterator = new ArrayList().listIterator();
            block14: while (true) {
                if (listIterator.hasPrevious()) {
                    string2 = (String)listIterator.previous();
                    listIterator.remove();
                } else {
                    if (!listIterator2.hasNext()) break block32;
                    string2 = (String)listIterator2.next();
                }
                int n = string2.length();
                while (true) {
                    String[] stringArray;
                    int n2;
                    if (!treeMap.containsKey(object2 = string2.substring(0, n))) {
                        if (n == 0) break block14;
                        sortedMap = treeMap.headMap(object2);
                        n2 = sortedMap.isEmpty() ? 0 : ((String)sortedMap.lastKey()).length();
                        n = Math.min(n2, n - 1);
                        object2 = string2.substring(0, n);
                        continue;
                    }
                    object2 = ((String)object2).intern();
                    assert (string2.startsWith((String)object2));
                    assert (((String)object2).length() == n);
                    sortedMap = string2.substring(n);
                    n2 = 0;
                    boolean bl = false;
                    int n3 = listIterator.nextIndex();
                    block16: for (String string4 : stringArray = (String[])treeMap.get(object2)) {
                        boolean bl2;
                        if (string4.length() == 0) continue;
                        if (string4.startsWith("#")) break;
                        int n4 = 0;
                        char c = string4.charAt(n4++);
                        switch (c) {
                            case '+': {
                                bl2 = ((String)((Object)sortedMap)).length() != 0;
                                c = string4.charAt(n4++);
                                break;
                            }
                            case '*': {
                                bl2 = true;
                                c = string4.charAt(n4++);
                                break;
                            }
                            default: {
                                boolean bl3 = bl2 = ((String)((Object)sortedMap)).length() == 0;
                            }
                        }
                        if (!bl2) continue;
                        String string5 = string4.substring(n4);
                        switch (c) {
                            case '.': {
                                object = string5.length() != 0 ? string5.intern() : object2;
                                break block32;
                            }
                            case '?': {
                                object = string5.length() != 0 ? string5.intern() : string2;
                                bl = true;
                                break block16;
                            }
                            case '@': {
                                object2 = string5.intern();
                                continue block16;
                            }
                            case '>': {
                                listIterator.add(string5 + (String)((Object)sortedMap));
                                sortedMap = "";
                                continue block16;
                            }
                            case '!': {
                                Object object3 = string5.length() != 0 ? string5.intern() : object2;
                                map.remove(object3);
                                map.put((String)object3, null);
                                n2 = 1;
                                continue block16;
                            }
                            case '$': {
                                String string6;
                                String string7 = string5.length() != 0 ? string5 : ((string6 = map.get(object2)) == null || string6.length() == 0 ? "1" : "" + (1 + Integer.parseInt(string6)));
                                map.put((String)object2, string7);
                                n2 = 1;
                                continue block16;
                            }
                            case '&': 
                            case '=': {
                                String string8;
                                String string9;
                                boolean bl4;
                                boolean bl5 = bl4 = c == '&';
                                if (listIterator.hasPrevious()) {
                                    string9 = (String)listIterator.previous();
                                    listIterator.remove();
                                } else if (listIterator2.hasNext()) {
                                    string9 = (String)listIterator2.next();
                                } else {
                                    object = string2 + " ?";
                                    bl = true;
                                    break block16;
                                }
                                if (bl4 && (string8 = map.get(object2)) != null) {
                                    String string10 = string5;
                                    if (string10.length() == 0) {
                                        string10 = " ";
                                    }
                                    string9 = string8 + string5 + string9;
                                }
                                map.put((String)object2, string9);
                                n2 = 1;
                                continue block16;
                            }
                            default: {
                                throw new RuntimeException("bad spec for " + (String)object2 + ": " + string4);
                            }
                        }
                    }
                    if (n2 != 0 && !bl) continue block14;
                    while (listIterator.nextIndex() > n3) {
                        listIterator.previous();
                        listIterator.remove();
                    }
                    if (bl) {
                        throw new IllegalArgumentException((String)object);
                    }
                    if (n == 0) break block14;
                    --n;
                }
                break;
            }
            listIterator.add(string2);
        }
        list.subList(0, listIterator2.nextIndex()).clear();
        while (listIterator.hasPrevious()) {
            list.add(0, (String)listIterator.previous());
        }
        return object;
    }
}

