/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.dom;

import com.sun.org.apache.xerces.internal.dom.AttrNSImpl;
import com.sun.org.apache.xerces.internal.dom.TextImpl;
import com.sun.org.apache.xerces.internal.impl.xs.dom.ElementNSImpl;

public final class DOMNodePool {
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private ElementNSImpl[][] fElements = new ElementNSImpl[4][];
    private int fElementIndex = 0;
    private TextImpl[][] fTextNode = new TextImpl[4][];
    private int fTextNodeIndex = 0;
    private AttrNSImpl[][] fAttrNode = new AttrNSImpl[4][];
    private int fAttrNodeIndex = 0;

    public final ElementNSImpl getElementNode() {
        int n = this.fElementIndex >> 8;
        int n2 = this.fElementIndex & 0xFF;
        this.ensureElementsCapacity(n);
        if (this.fElements[n][n2] == null) {
            this.fElements[n][n2] = new ElementNSImpl();
        }
        ++this.fElementIndex;
        return this.fElements[n][n2];
    }

    private void ensureElementsCapacity(int n) {
        if (this.fElements.length <= n) {
            this.fElements = DOMNodePool.resize(this.fElements, this.fElements.length * 2);
        } else if (this.fElements[n] != null) {
            return;
        }
        this.fElements[n] = new ElementNSImpl[256];
    }

    private static ElementNSImpl[][] resize(ElementNSImpl[][] elementNSImplArray, int n) {
        ElementNSImpl[][] elementNSImplArray2 = new ElementNSImpl[n][];
        System.arraycopy(elementNSImplArray, 0, elementNSImplArray2, 0, elementNSImplArray.length);
        return elementNSImplArray2;
    }

    public final TextImpl getTextNode() {
        int n = this.fTextNodeIndex >> 8;
        int n2 = this.fTextNodeIndex & 0xFF;
        this.ensureTextCapacity(n);
        if (this.fTextNode[n][n2] == null) {
            this.fTextNode[n][n2] = new TextImpl();
        }
        ++this.fTextNodeIndex;
        return this.fTextNode[n][n2];
    }

    private void ensureTextCapacity(int n) {
        if (this.fTextNode.length <= n) {
            this.fTextNode = DOMNodePool.resize(this.fTextNode, this.fTextNode.length * 2);
        } else if (this.fTextNode[n] != null) {
            return;
        }
        this.fTextNode[n] = new TextImpl[256];
    }

    private static TextImpl[][] resize(TextImpl[][] textImplArray, int n) {
        TextImpl[][] textImplArray2 = new TextImpl[n][];
        System.arraycopy(textImplArray, 0, textImplArray2, 0, textImplArray.length);
        return textImplArray2;
    }

    public final AttrNSImpl getAttrNode() {
        int n = this.fAttrNodeIndex >> 8;
        int n2 = this.fAttrNodeIndex & 0xFF;
        this.ensureAttrsCapacity(n);
        if (this.fAttrNode[n][n2] == null) {
            this.fAttrNode[n][n2] = new AttrNSImpl();
        }
        ++this.fAttrNodeIndex;
        return this.fAttrNode[n][n2];
    }

    private void ensureAttrsCapacity(int n) {
        if (this.fAttrNode.length <= n) {
            this.fAttrNode = DOMNodePool.resize(this.fAttrNode, this.fAttrNode.length * 2);
        } else if (this.fAttrNode[n] != null) {
            return;
        }
        this.fAttrNode[n] = new AttrNSImpl[256];
    }

    private static AttrNSImpl[][] resize(AttrNSImpl[][] attrNSImplArray, int n) {
        AttrNSImpl[][] attrNSImplArray2 = new AttrNSImpl[n][];
        System.arraycopy(attrNSImplArray, 0, attrNSImplArray2, 0, attrNSImplArray.length);
        return attrNSImplArray2;
    }

    public void reset() {
        this.fElementIndex = 0;
        this.fTextNodeIndex = 0;
        this.fAttrNodeIndex = 0;
    }
}

