/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.dom;

import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.impl.xs.SchemaSymbols;
import com.sun.org.apache.xerces.internal.impl.xs.XSMessageFormatter;
import com.sun.org.apache.xerces.internal.impl.xs.dom.DOMNodePool;
import com.sun.org.apache.xerces.internal.impl.xs.dom.DocumentImpl;
import com.sun.org.apache.xerces.internal.parsers.NonValidatingConfiguration;
import com.sun.org.apache.xerces.internal.util.MessageFormatter;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.org.apache.xerces.internal.xni.Augmentations;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLLocator;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import org.w3c.dom.Element;

public class DOMParser
extends com.sun.org.apache.xerces.internal.parsers.DOMParser {
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String DOCUMENT_CLASS = "http://apache.org/xml/properties/dom/document-class-name";
    protected static final String DEFER_EXPANSION = "http://apache.org/xml/features/dom/defer-node-expansion";
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected XMLLocator fLocator;
    public DocumentImpl fDocumentImpl;
    private DOMNodePool fNodePool;
    private int fAnnotationDepth = -1;
    private int fDepth = -1;
    XMLErrorReporter fErrorReporter;

    public DOMParser() {
        super(new NonValidatingConfiguration());
        try {
            this.setProperty(DOCUMENT_CLASS, "com.sun.org.apache.xerces.internal.impl.xs.dom.DocumentImpl");
            this.setFeature(DEFER_EXPANSION, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fNodePool = new DOMNodePool();
    }

    public void resetNodePool() {
        this.fNodePool.reset();
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        super.startDocument(xMLLocator, string, namespaceContext, augmentations);
        this.fDocumentImpl = (DocumentImpl)((com.sun.org.apache.xerces.internal.parsers.DOMParser)this).fDocumentImpl;
        this.fDocumentImpl.fNodePool = this.fNodePool;
        this.fLocator = xMLLocator;
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        super.startElement(qName, xMLAttributes, augmentations);
        ++this.fDepth;
        if (this.fAnnotationDepth == -1 && qName.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && (qName.localpart == SchemaSymbols.ELT_APPINFO || qName.localpart == SchemaSymbols.ELT_DOCUMENTATION)) {
            this.fAnnotationDepth = this.fDepth;
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fAnnotationDepth == -1) {
            for (int i = xMLString.offset; i < xMLString.offset + xMLString.length; ++i) {
                Object object;
                if (XMLChar.isSpace(xMLString.ch[i])) continue;
                if (this.fErrorReporter == null) {
                    try {
                        this.fErrorReporter = (XMLErrorReporter)this.getProperty(ERROR_REPORTER);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
                        object = new XSMessageFormatter();
                        this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", (MessageFormatter)object);
                    }
                }
                object = new String(xMLString.ch, i, xMLString.length + xMLString.offset - i);
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "s4s-elt-character", new Object[]{object}, (short)1);
                break;
            }
        } else {
            super.characters(xMLString, augmentations);
        }
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        super.endElement(qName, augmentations);
        if (this.fAnnotationDepth == this.fDepth) {
            this.fAnnotationDepth = -1;
        }
        --this.fDepth;
    }

    protected Element createElementNode(QName qName) {
        return this.fDocumentImpl.createElementNS(qName.uri, qName.rawname, qName.localpart, this.fLocator.getLineNumber(), this.fLocator.getColumnNumber());
    }
}

