/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.xinclude;

import com.sun.org.apache.xerces.internal.xinclude.SecuritySupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

class ObjectFactory {
    private static final String DEFAULT_PROPERTIES_FILENAME = "xerces.properties";
    private static final boolean DEBUG = false;
    private static final int DEFAULT_LINE_LENGTH = 80;
    private static Properties fXercesProperties = null;
    private static long fLastModified = -1L;

    ObjectFactory() {
    }

    static Object createObject(String string, String string2) throws ConfigurationError {
        return ObjectFactory.createObject(string, null, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object createObject(String string, String string2, String string3) throws ConfigurationError {
        Object object;
        String string4;
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        ClassLoader classLoader = ObjectFactory.findClassLoader();
        try {
            string4 = securitySupport.getSystemProperty(string);
            if (string4 != null) {
                return ObjectFactory.newInstance(string4, classLoader, true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        string4 = null;
        if (string2 == null) {
            Object object2;
            object = null;
            boolean bl = false;
            try {
                object2 = securitySupport.getSystemProperty("java.home");
                string2 = (String)object2 + File.separator + "lib" + File.separator + DEFAULT_PROPERTIES_FILENAME;
                object = new File(string2);
                bl = securitySupport.getFileExists((File)object);
            }
            catch (SecurityException securityException) {
                fLastModified = -1L;
                fXercesProperties = null;
            }
            object2 = ObjectFactory.class;
            synchronized (ObjectFactory.class) {
                boolean bl2 = false;
                try {
                    if (fLastModified >= 0L) {
                        if (bl && fLastModified < (fLastModified = securitySupport.getLastModified((File)object))) {
                            bl2 = true;
                        } else if (!bl) {
                            fLastModified = -1L;
                            fXercesProperties = null;
                        }
                    } else if (bl) {
                        bl2 = true;
                        fLastModified = securitySupport.getLastModified((File)object);
                    }
                    if (bl2) {
                        fXercesProperties = new Properties();
                        FileInputStream fileInputStream = securitySupport.getFileInputStream((File)object);
                        fXercesProperties.load(fileInputStream);
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    fXercesProperties = null;
                    fLastModified = -1L;
                }
                if (fXercesProperties != null) {
                    string4 = fXercesProperties.getProperty(string);
                }
            }
        } else {
            try {
                object = securitySupport.getFileInputStream(new File(string2));
                Properties properties = new Properties();
                properties.load((InputStream)object);
                ((FileInputStream)object).close();
                string4 = properties.getProperty(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        {
            if (string4 != null) {
                return ObjectFactory.newInstance(string4, classLoader, true);
            }
            object = ObjectFactory.findJarServiceProvider(string);
            if (object != null) {
                return object;
            }
            if (string3 == null) {
                throw new ConfigurationError("Provider for " + string + " cannot be found", null);
            }
            return ObjectFactory.newInstance(string3, classLoader, true);
        }
    }

    private static void debugPrintln(String string) {
    }

    static ClassLoader findClassLoader() throws ConfigurationError {
        ClassLoader classLoader;
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        ClassLoader classLoader2 = securitySupport.getContextClassLoader();
        ClassLoader classLoader3 = classLoader = securitySupport.getSystemClassLoader();
        while (true) {
            if (classLoader2 == classLoader3) {
                ClassLoader classLoader4 = ObjectFactory.class.getClassLoader();
                classLoader3 = classLoader;
                while (true) {
                    if (classLoader4 == classLoader3) {
                        return classLoader;
                    }
                    if (classLoader3 == null) break;
                    classLoader3 = securitySupport.getParentClassLoader(classLoader3);
                }
                return classLoader4;
            }
            if (classLoader3 == null) break;
            classLoader3 = securitySupport.getParentClassLoader(classLoader3);
        }
        return classLoader2;
    }

    static Object newInstance(String string, ClassLoader classLoader, boolean bl) throws ConfigurationError {
        try {
            Class clazz = ObjectFactory.findProviderClass(string, classLoader, bl);
            Object t = clazz.newInstance();
            return t;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    static Class findProviderClass(String string, ClassLoader classLoader, boolean bl) throws ClassNotFoundException, ConfigurationError {
        Class<?> clazz;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            int n = string.lastIndexOf(".");
            String string2 = string;
            if (n != -1) {
                string2 = string.substring(0, n);
            }
            securityManager.checkPackageAccess(string2);
        }
        if (classLoader == null) {
            clazz = Class.forName(string);
        } else {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl) {
                    ClassLoader classLoader2 = ObjectFactory.class.getClassLoader();
                    if (classLoader2 == null) {
                        clazz = Class.forName(string);
                    }
                    if (classLoader != classLoader2) {
                        classLoader = classLoader2;
                        clazz = classLoader.loadClass(string);
                    }
                    throw classNotFoundException;
                }
                throw classNotFoundException;
            }
        }
        return clazz;
    }

    private static Object findJarServiceProvider(String string) throws ConfigurationError {
        Object object;
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        String string2 = "META-INF/services/" + string;
        InputStream inputStream = null;
        ClassLoader classLoader = ObjectFactory.findClassLoader();
        inputStream = securitySupport.getResourceAsStream(classLoader, string2);
        if (inputStream == null && classLoader != (object = ObjectFactory.class.getClassLoader())) {
            classLoader = object;
            inputStream = securitySupport.getResourceAsStream(classLoader, string2);
        }
        if (inputStream == null) {
            return null;
        }
        try {
            object = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new BufferedReader(new InputStreamReader(inputStream), 80);
        }
        String string3 = null;
        try {
            string3 = ((BufferedReader)object).readLine();
            ((BufferedReader)object).close();
        }
        catch (IOException iOException) {
            return null;
        }
        if (string3 != null && !"".equals(string3)) {
            return ObjectFactory.newInstance(string3, classLoader, false);
        }
        return null;
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String string, Exception exception) {
            super(string);
            this.exception = exception;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

