/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class WriterToUTF8
extends Writer {
    private static final boolean DEBUG_OUT = false;
    private final OutputStream m_os;

    public WriterToUTF8(OutputStream outputStream) throws UnsupportedEncodingException {
        this.m_os = outputStream;
    }

    public void write(int n) throws IOException {
        if (n < 128) {
            this.m_os.write(n);
        } else if (n < 2048) {
            this.m_os.write(192 + (n >> 6));
            this.m_os.write(128 + (n & 0x3F));
        } else {
            this.m_os.write(224 + (n >> 12));
            this.m_os.write(128 + (n >> 6 & 0x3F));
            this.m_os.write(128 + (n & 0x3F));
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        OutputStream outputStream = this.m_os;
        int n3 = n2 + n;
        for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            if (c < '\u0080') {
                outputStream.write(c);
                continue;
            }
            if (c < '\u0800') {
                outputStream.write(192 + (c >> 6));
                outputStream.write(128 + (c & 0x3F));
                continue;
            }
            outputStream.write(224 + (c >> 12));
            outputStream.write(128 + (c >> 6 & 0x3F));
            outputStream.write(128 + (c & 0x3F));
        }
    }

    public void write(String string) throws IOException {
        int n = string.length();
        OutputStream outputStream = this.m_os;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') {
                outputStream.write(c);
                continue;
            }
            if (c < '\u0800') {
                outputStream.write(192 + (c >> 6));
                outputStream.write(128 + (c & 0x3F));
                continue;
            }
            outputStream.write(224 + (c >> 12));
            outputStream.write(128 + (c >> 6 & 0x3F));
            outputStream.write(128 + (c & 0x3F));
        }
    }

    public void flush() throws IOException {
        this.m_os.flush();
    }

    public void close() throws IOException {
        this.m_os.close();
    }

    public OutputStream getOutputStream() {
        return this.m_os;
    }
}

