/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.axes;

import com.sun.org.apache.xml.internal.dtm.DTMIterator;
import com.sun.org.apache.xml.internal.utils.WrappedRuntimeException;
import java.io.Serializable;
import java.util.Vector;

public class IteratorPool
implements Serializable {
    private final DTMIterator m_orig;
    private final Vector m_freeStack;

    public IteratorPool(DTMIterator dTMIterator) {
        this.m_orig = dTMIterator;
        this.m_freeStack = new Vector();
    }

    public synchronized DTMIterator getInstanceOrThrow() throws CloneNotSupportedException {
        if (this.m_freeStack.isEmpty()) {
            return (DTMIterator)this.m_orig.clone();
        }
        DTMIterator dTMIterator = (DTMIterator)this.m_freeStack.lastElement();
        this.m_freeStack.setSize(this.m_freeStack.size() - 1);
        return dTMIterator;
    }

    public synchronized DTMIterator getInstance() {
        if (this.m_freeStack.isEmpty()) {
            try {
                return (DTMIterator)this.m_orig.clone();
            }
            catch (Exception exception) {
                throw new WrappedRuntimeException(exception);
            }
        }
        DTMIterator dTMIterator = (DTMIterator)this.m_freeStack.lastElement();
        this.m_freeStack.setSize(this.m_freeStack.size() - 1);
        return dTMIterator;
    }

    public synchronized void freeInstance(DTMIterator dTMIterator) {
        this.m_freeStack.addElement(dTMIterator);
    }
}

