/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.operations;

import com.sun.org.apache.xalan.internal.res.XSLMessages;
import com.sun.org.apache.xml.internal.utils.PrefixResolver;
import com.sun.org.apache.xml.internal.utils.QName;
import com.sun.org.apache.xml.internal.utils.WrappedRuntimeException;
import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.ExpressionOwner;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.XPathVisitor;
import com.sun.org.apache.xpath.internal.axes.PathComponent;
import com.sun.org.apache.xpath.internal.objects.XNodeSet;
import com.sun.org.apache.xpath.internal.objects.XObject;
import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class Variable
extends Expression
implements PathComponent {
    private boolean m_fixUpWasCalled = false;
    protected QName m_qname;
    protected int m_index;
    protected boolean m_isGlobal = false;
    static final String PSUEDOVARNAMESPACE = "http://xml.apache.org/xalan/psuedovar";

    public void setIndex(int n) {
        this.m_index = n;
    }

    public int getIndex() {
        return this.m_index;
    }

    public void setIsGlobal(boolean bl) {
        this.m_isGlobal = bl;
    }

    public boolean getGlobal() {
        return this.m_isGlobal;
    }

    public void fixupVariables(Vector vector, int n) {
        Serializable serializable;
        this.m_fixUpWasCalled = true;
        int n2 = vector.size();
        for (int i = vector.size() - 1; i >= 0; --i) {
            serializable = (QName)vector.elementAt(i);
            if (!serializable.equals(this.m_qname)) continue;
            if (i < n) {
                this.m_isGlobal = true;
                this.m_index = i;
            } else {
                this.m_index = i - n;
            }
            return;
        }
        String string = XSLMessages.createXPATHMessage("ER_COULD_NOT_FIND_VAR", new Object[]{this.m_qname.toString()});
        serializable = new TransformerException(string, this);
        throw new WrappedRuntimeException((Exception)serializable);
    }

    public void setQName(QName qName) {
        this.m_qname = qName;
    }

    public QName getQName() {
        return this.m_qname;
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        return this.execute(xPathContext, false);
    }

    public XObject execute(XPathContext xPathContext, boolean bl) throws TransformerException {
        PrefixResolver prefixResolver = xPathContext.getNamespaceContext();
        XObject xObject = this.m_fixUpWasCalled ? (this.m_isGlobal ? xPathContext.getVarStack().getGlobalVariable(xPathContext, this.m_index, bl) : xPathContext.getVarStack().getLocalVariable(xPathContext, this.m_index, bl)) : xPathContext.getVarStack().getVariableOrParam(xPathContext, this.m_qname);
        if (null == xObject) {
            this.warn(xPathContext, "WG_ILLEGAL_VARIABLE_REFERENCE", new Object[]{this.m_qname.getLocalPart()});
            xObject = new XNodeSet(xPathContext.getDTMManager());
        }
        return xObject;
    }

    public boolean isStableNumber() {
        return true;
    }

    public int getAnalysisBits() {
        return 0x4000000;
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        xPathVisitor.visitVariableRef(expressionOwner, this);
    }

    public boolean deepEquals(Expression expression) {
        if (!this.isSameClass(expression)) {
            return false;
        }
        return this.m_qname.equals(((Variable)expression).m_qname);
    }

    public boolean isPsuedoVarRef() {
        String string = this.m_qname.getNamespaceURI();
        return null != string && string.equals(PSUEDOVARNAMESPACE) && this.m_qname.getLocalName().startsWith("#");
    }
}

