/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class AffineTransform
implements Cloneable,
Serializable {
    private static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_IDENTITY = 0;
    public static final int TYPE_TRANSLATION = 1;
    public static final int TYPE_UNIFORM_SCALE = 2;
    public static final int TYPE_GENERAL_SCALE = 4;
    public static final int TYPE_MASK_SCALE = 6;
    public static final int TYPE_FLIP = 64;
    public static final int TYPE_QUADRANT_ROTATION = 8;
    public static final int TYPE_GENERAL_ROTATION = 16;
    public static final int TYPE_MASK_ROTATION = 24;
    public static final int TYPE_GENERAL_TRANSFORM = 32;
    static final int APPLY_IDENTITY = 0;
    static final int APPLY_TRANSLATE = 1;
    static final int APPLY_SCALE = 2;
    static final int APPLY_SHEAR = 4;
    private static final int HI_SHIFT = 3;
    private static final int HI_IDENTITY = 0;
    private static final int HI_TRANSLATE = 8;
    private static final int HI_SCALE = 16;
    private static final int HI_SHEAR = 32;
    double m00;
    double m10;
    double m01;
    double m11;
    double m02;
    double m12;
    transient int state;
    private transient int type;
    private static int[] rot90conversion = new int[]{4, 5, 4, 5, 2, 3, 6, 7};

    private AffineTransform(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        this.m00 = d;
        this.m10 = d2;
        this.m01 = d3;
        this.m11 = d4;
        this.m02 = d5;
        this.m12 = d6;
        this.state = n;
        this.type = -1;
    }

    public AffineTransform() {
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    public AffineTransform(AffineTransform affineTransform) {
        this.m00 = affineTransform.m00;
        this.m10 = affineTransform.m10;
        this.m01 = affineTransform.m01;
        this.m11 = affineTransform.m11;
        this.m02 = affineTransform.m02;
        this.m12 = affineTransform.m12;
        this.state = affineTransform.state;
        this.type = affineTransform.type;
    }

    public AffineTransform(float f, float f2, float f3, float f4, float f5, float f6) {
        this.m00 = f;
        this.m10 = f2;
        this.m01 = f3;
        this.m11 = f4;
        this.m02 = f5;
        this.m12 = f6;
        this.updateState();
    }

    public AffineTransform(float[] fArray) {
        this.m00 = fArray[0];
        this.m10 = fArray[1];
        this.m01 = fArray[2];
        this.m11 = fArray[3];
        if (fArray.length > 5) {
            this.m02 = fArray[4];
            this.m12 = fArray[5];
        }
        this.updateState();
    }

    public AffineTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.m00 = d;
        this.m10 = d2;
        this.m01 = d3;
        this.m11 = d4;
        this.m02 = d5;
        this.m12 = d6;
        this.updateState();
    }

    public AffineTransform(double[] dArray) {
        this.m00 = dArray[0];
        this.m10 = dArray[1];
        this.m01 = dArray[2];
        this.m11 = dArray[3];
        if (dArray.length > 5) {
            this.m02 = dArray[4];
            this.m12 = dArray[5];
        }
        this.updateState();
    }

    public static AffineTransform getTranslateInstance(double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(d, d2);
        return affineTransform;
    }

    public static AffineTransform getRotateInstance(double d) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToRotation(d);
        return affineTransform;
    }

    public static AffineTransform getRotateInstance(double d, double d2, double d3) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToRotation(d, d2, d3);
        return affineTransform;
    }

    public static AffineTransform getScaleInstance(double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToScale(d, d2);
        return affineTransform;
    }

    public static AffineTransform getShearInstance(double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToShear(d, d2);
        return affineTransform;
    }

    public int getType() {
        if (this.type == -1) {
            this.calculateType();
        }
        return this.type;
    }

    private void calculateType() {
        int n = 0;
        this.updateState();
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                n = 1;
            }
            case 6: {
                boolean bl;
                double d = this.m00;
                double d2 = this.m01;
                double d3 = this.m10;
                double d4 = this.m11;
                if (d * d2 + d3 * d4 != 0.0) {
                    this.type = 32;
                    return;
                }
                boolean bl2 = d >= 0.0;
                boolean bl3 = bl = d4 >= 0.0;
                if (bl2 == bl) {
                    if (d != d4 || d2 != -d3) {
                        n |= 0x14;
                        break;
                    }
                    if (d * d4 - d2 * d3 != 1.0) {
                        n |= 0x12;
                        break;
                    }
                    n |= 0x10;
                    break;
                }
                if (d != -d4 || d2 != d3) {
                    n |= 0x54;
                    break;
                }
                if (d * d4 - d2 * d3 != 1.0) {
                    n |= 0x52;
                    break;
                }
                n |= 0x50;
                break;
            }
            case 5: {
                n = 1;
            }
            case 4: {
                double d;
                boolean bl;
                double d5;
                double d6 = this.m01;
                boolean bl4 = d5 >= 0.0;
                double d7 = this.m10;
                boolean bl5 = bl = d >= 0.0;
                if (bl4 != bl) {
                    if (d6 != -d7) {
                        n |= 0xC;
                        break;
                    }
                    if (d6 != 1.0 && d6 != -1.0) {
                        n |= 0xA;
                        break;
                    }
                    n |= 8;
                    break;
                }
                if (d6 == d7) {
                    n |= 0x4A;
                    break;
                }
                n |= 0x4C;
                break;
            }
            case 3: {
                n = 1;
            }
            case 2: {
                double d;
                boolean bl;
                double d8;
                double d9 = this.m00;
                boolean bl6 = d8 >= 0.0;
                double d10 = this.m11;
                boolean bl7 = bl = d >= 0.0;
                if (bl6 == bl) {
                    if (bl6) {
                        if (d9 == d10) {
                            n |= 2;
                            break;
                        }
                        n |= 4;
                        break;
                    }
                    if (d9 != d10) {
                        n |= 0xC;
                        break;
                    }
                    if (d9 != -1.0) {
                        n |= 0xA;
                        break;
                    }
                    n |= 8;
                    break;
                }
                if (d9 == -d10) {
                    if (d9 == 1.0 || d9 == -1.0) {
                        n |= 0x40;
                        break;
                    }
                    n |= 0x42;
                    break;
                }
                n |= 0x44;
                break;
            }
            case 1: {
                n = 1;
            }
            case 0: 
        }
        this.type = n;
    }

    public double getDeterminant() {
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 6: 
            case 7: {
                return this.m00 * this.m11 - this.m01 * this.m10;
            }
            case 4: 
            case 5: {
                return -(this.m01 * this.m10);
            }
            case 2: 
            case 3: {
                return this.m00 * this.m11;
            }
            case 0: 
            case 1: 
        }
        return 1.0;
    }

    void updateState() {
        if (this.m01 == 0.0 && this.m10 == 0.0) {
            if (this.m00 == 1.0 && this.m11 == 1.0) {
                if (this.m02 == 0.0 && this.m12 == 0.0) {
                    this.state = 0;
                    this.type = 0;
                } else {
                    this.state = 1;
                    this.type = 1;
                }
            } else if (this.m02 == 0.0 && this.m12 == 0.0) {
                this.state = 2;
                this.type = -1;
            } else {
                this.state = 3;
                this.type = -1;
            }
        } else if (this.m00 == 0.0 && this.m11 == 0.0) {
            if (this.m02 == 0.0 && this.m12 == 0.0) {
                this.state = 4;
                this.type = -1;
            } else {
                this.state = 5;
                this.type = -1;
            }
        } else if (this.m02 == 0.0 && this.m12 == 0.0) {
            this.state = 6;
            this.type = -1;
        } else {
            this.state = 7;
            this.type = -1;
        }
    }

    private void stateError() {
        throw new InternalError("missing case in transform state switch");
    }

    public void getMatrix(double[] dArray) {
        dArray[0] = this.m00;
        dArray[1] = this.m10;
        dArray[2] = this.m01;
        dArray[3] = this.m11;
        if (dArray.length > 5) {
            dArray[4] = this.m02;
            dArray[5] = this.m12;
        }
    }

    public double getScaleX() {
        return this.m00;
    }

    public double getScaleY() {
        return this.m11;
    }

    public double getShearX() {
        return this.m01;
    }

    public double getShearY() {
        return this.m10;
    }

    public double getTranslateX() {
        return this.m02;
    }

    public double getTranslateY() {
        return this.m12;
    }

    public void translate(double d, double d2) {
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                this.m02 = d * this.m00 + d2 * this.m01 + this.m02;
                this.m12 = d * this.m10 + d2 * this.m11 + this.m12;
                if (this.m02 == 0.0 && this.m12 == 0.0) {
                    this.state = 6;
                    if (this.type != -1) {
                        --this.type;
                    }
                }
                return;
            }
            case 6: {
                this.m02 = d * this.m00 + d2 * this.m01;
                this.m12 = d * this.m10 + d2 * this.m11;
                if (this.m02 != 0.0 || this.m12 != 0.0) {
                    this.state = 7;
                    this.type |= 1;
                }
                return;
            }
            case 5: {
                this.m02 = d2 * this.m01 + this.m02;
                this.m12 = d * this.m10 + this.m12;
                if (this.m02 == 0.0 && this.m12 == 0.0) {
                    this.state = 4;
                    if (this.type != -1) {
                        --this.type;
                    }
                }
                return;
            }
            case 4: {
                this.m02 = d2 * this.m01;
                this.m12 = d * this.m10;
                if (this.m02 != 0.0 || this.m12 != 0.0) {
                    this.state = 5;
                    this.type |= 1;
                }
                return;
            }
            case 3: {
                this.m02 = d * this.m00 + this.m02;
                this.m12 = d2 * this.m11 + this.m12;
                if (this.m02 == 0.0 && this.m12 == 0.0) {
                    this.state = 2;
                    if (this.type != -1) {
                        --this.type;
                    }
                }
                return;
            }
            case 2: {
                this.m02 = d * this.m00;
                this.m12 = d2 * this.m11;
                if (this.m02 != 0.0 || this.m12 != 0.0) {
                    this.state = 3;
                    this.type |= 1;
                }
                return;
            }
            case 1: {
                this.m02 = d + this.m02;
                this.m12 = d2 + this.m12;
                if (this.m02 == 0.0 && this.m12 == 0.0) {
                    this.state = 0;
                    this.type = 0;
                }
                return;
            }
            case 0: 
        }
        this.m02 = d;
        this.m12 = d2;
        if (d != 0.0 || d2 != 0.0) {
            this.state = 1;
            this.type = 1;
        }
    }

    public void rotate(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        if (Math.abs(d2) < 1.0E-15) {
            if (d3 < 0.0) {
                this.m00 = -this.m00;
                this.m11 = -this.m11;
                int n = this.state;
                if ((n & 4) != 0) {
                    this.m01 = -this.m01;
                    this.m10 = -this.m10;
                } else {
                    this.state = this.m00 == 1.0 && this.m11 == 1.0 ? n & 0xFFFFFFFD : n | 2;
                }
                this.type = -1;
            }
            return;
        }
        if (Math.abs(d3) < 1.0E-15) {
            double d4;
            if (d2 < 0.0) {
                d4 = this.m00;
                this.m00 = -this.m01;
                this.m01 = d4;
                d4 = this.m10;
                this.m10 = -this.m11;
                this.m11 = d4;
            } else {
                d4 = this.m00;
                this.m00 = this.m01;
                this.m01 = -d4;
                d4 = this.m10;
                this.m10 = this.m11;
                this.m11 = -d4;
            }
            int n = rot90conversion[this.state];
            if ((n & 6) == 2 && this.m00 == 1.0 && this.m11 == 1.0) {
                n -= 2;
            }
            this.state = n;
            this.type = -1;
            return;
        }
        double d5 = this.m00;
        double d6 = this.m01;
        this.m00 = d3 * d5 + d2 * d6;
        this.m01 = -d2 * d5 + d3 * d6;
        d5 = this.m10;
        d6 = this.m11;
        this.m10 = d3 * d5 + d2 * d6;
        this.m11 = -d2 * d5 + d3 * d6;
        this.updateState();
    }

    public void rotate(double d, double d2, double d3) {
        this.translate(d2, d3);
        this.rotate(d);
        this.translate(-d2, -d3);
    }

    public void scale(double d, double d2) {
        int n = this.state;
        switch (n) {
            default: {
                this.stateError();
            }
            case 6: 
            case 7: {
                this.m00 *= d;
                this.m11 *= d2;
            }
            case 4: 
            case 5: {
                this.m01 *= d2;
                this.m10 *= d;
                if (this.m01 == 0.0 && this.m10 == 0.0) {
                    this.state = n - 4;
                }
                this.type = -1;
                return;
            }
            case 2: 
            case 3: {
                this.m00 *= d;
                this.m11 *= d2;
                if (this.m00 == 1.0 && this.m11 == 1.0) {
                    this.state = n &= 1;
                    this.type = n == 0 ? 0 : 1;
                } else {
                    this.type = -1;
                }
                return;
            }
            case 0: 
            case 1: 
        }
        this.m00 = d;
        this.m11 = d2;
        if (d != 1.0 || d2 != 1.0) {
            this.state = n | 2;
            this.type = -1;
        }
    }

    public void shear(double d, double d2) {
        int n = this.state;
        switch (n) {
            default: {
                this.stateError();
            }
            case 6: 
            case 7: {
                double d3 = this.m00;
                double d4 = this.m01;
                this.m00 = d3 + d4 * d2;
                this.m01 = d3 * d + d4;
                d3 = this.m10;
                d4 = this.m11;
                this.m10 = d3 + d4 * d2;
                this.m11 = d3 * d + d4;
                this.updateState();
                return;
            }
            case 4: 
            case 5: {
                this.m00 = this.m01 * d2;
                this.m11 = this.m10 * d;
                if (this.m00 != 0.0 || this.m11 != 0.0) {
                    this.state = n | 2;
                }
                this.type = -1;
                return;
            }
            case 2: 
            case 3: {
                this.m01 = this.m00 * d;
                this.m10 = this.m11 * d2;
                if (this.m01 != 0.0 || this.m10 != 0.0) {
                    this.state = n | 4;
                }
                this.type = -1;
                return;
            }
            case 0: 
            case 1: 
        }
        this.m01 = d;
        this.m10 = d2;
        if (this.m01 != 0.0 || this.m10 != 0.0) {
            this.state = n | 2 | 4;
            this.type = -1;
        }
    }

    public void setToIdentity() {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m12 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m10 = 0.0;
        this.state = 0;
        this.type = 0;
    }

    public void setToTranslation(double d, double d2) {
        this.m00 = 1.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m11 = 1.0;
        this.m02 = d;
        this.m12 = d2;
        if (d != 0.0 || d2 != 0.0) {
            this.state = 1;
            this.type = 1;
        } else {
            this.state = 0;
            this.type = 0;
        }
    }

    public void setToRotation(double d) {
        this.m02 = 0.0;
        this.m12 = 0.0;
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        if (Math.abs(d2) < 1.0E-15) {
            this.m10 = 0.0;
            this.m01 = 0.0;
            if (d3 < 0.0) {
                this.m11 = -1.0;
                this.m00 = -1.0;
                this.state = 2;
                this.type = 8;
            } else {
                this.m11 = 1.0;
                this.m00 = 1.0;
                this.state = 0;
                this.type = 0;
            }
            return;
        }
        if (Math.abs(d3) < 1.0E-15) {
            this.m11 = 0.0;
            this.m00 = 0.0;
            if (d2 < 0.0) {
                this.m01 = 1.0;
                this.m10 = -1.0;
            } else {
                this.m01 = -1.0;
                this.m10 = 1.0;
            }
            this.state = 4;
            this.type = 8;
            return;
        }
        this.m00 = d3;
        this.m01 = -d2;
        this.m10 = d2;
        this.m11 = d3;
        this.state = 6;
        this.type = 16;
    }

    public void setToRotation(double d, double d2, double d3) {
        this.setToRotation(d);
        double d4 = this.m10;
        double d5 = 1.0 - this.m00;
        this.m02 = d2 * d5 + d3 * d4;
        this.m12 = d3 * d5 - d2 * d4;
        if (this.m02 != 0.0 || this.m12 != 0.0) {
            this.state |= 1;
            this.type |= 1;
        }
    }

    public void setToScale(double d, double d2) {
        this.m00 = d;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m11 = d2;
        this.m02 = 0.0;
        this.m12 = 0.0;
        if (d != 1.0 || d2 != 1.0) {
            this.state = 2;
            this.type = -1;
        } else {
            this.state = 0;
            this.type = 0;
        }
    }

    public void setToShear(double d, double d2) {
        this.m00 = 1.0;
        this.m01 = d;
        this.m10 = d2;
        this.m11 = 1.0;
        this.m02 = 0.0;
        this.m12 = 0.0;
        if (d != 0.0 || d2 != 0.0) {
            this.state = 6;
            this.type = -1;
        } else {
            this.state = 0;
            this.type = 0;
        }
    }

    public void setTransform(AffineTransform affineTransform) {
        this.m00 = affineTransform.m00;
        this.m10 = affineTransform.m10;
        this.m01 = affineTransform.m01;
        this.m11 = affineTransform.m11;
        this.m02 = affineTransform.m02;
        this.m12 = affineTransform.m12;
        this.state = affineTransform.state;
        this.type = affineTransform.type;
    }

    public void setTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.m00 = d;
        this.m10 = d2;
        this.m01 = d3;
        this.m11 = d4;
        this.m02 = d5;
        this.m12 = d6;
        this.updateState();
    }

    public void concatenate(AffineTransform affineTransform) {
        int n = this.state;
        int n2 = affineTransform.state;
        switch (n2 << 3 | n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            case 56: {
                this.m01 = affineTransform.m01;
                this.m10 = affineTransform.m10;
            }
            case 24: {
                this.m00 = affineTransform.m00;
                this.m11 = affineTransform.m11;
            }
            case 8: {
                this.m02 = affineTransform.m02;
                this.m12 = affineTransform.m12;
                this.state = n2;
                this.type = affineTransform.type;
                return;
            }
            case 48: {
                this.m01 = affineTransform.m01;
                this.m10 = affineTransform.m10;
            }
            case 16: {
                this.m00 = affineTransform.m00;
                this.m11 = affineTransform.m11;
                this.state = n2;
                this.type = affineTransform.type;
                return;
            }
            case 40: {
                this.m02 = affineTransform.m02;
                this.m12 = affineTransform.m12;
            }
            case 32: {
                this.m01 = affineTransform.m01;
                this.m10 = affineTransform.m10;
                this.m11 = 0.0;
                this.m00 = 0.0;
                this.state = n2;
                this.type = affineTransform.type;
                return;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.translate(affineTransform.m02, affineTransform.m12);
                return;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                this.scale(affineTransform.m00, affineTransform.m11);
                return;
            }
            case 38: 
            case 39: {
                double d = affineTransform.m01;
                double d2 = affineTransform.m10;
                double d3 = this.m00;
                this.m00 = this.m01 * d2;
                this.m01 = d3 * d;
                d3 = this.m10;
                this.m10 = this.m11 * d2;
                this.m11 = d3 * d;
                this.type = -1;
                return;
            }
            case 36: 
            case 37: {
                this.m00 = this.m01 * affineTransform.m10;
                this.m01 = 0.0;
                this.m11 = this.m10 * affineTransform.m01;
                this.m10 = 0.0;
                this.state = n ^ 6;
                this.type = -1;
                return;
            }
            case 34: 
            case 35: {
                this.m01 = this.m00 * affineTransform.m01;
                this.m00 = 0.0;
                this.m10 = this.m11 * affineTransform.m10;
                this.m11 = 0.0;
                this.state = n ^ 6;
                this.type = -1;
                return;
            }
            case 33: {
                this.m00 = 0.0;
                this.m01 = affineTransform.m01;
                this.m10 = affineTransform.m10;
                this.m11 = 0.0;
                this.state = 5;
                this.type = -1;
                return;
            }
        }
        double d = affineTransform.m00;
        double d4 = affineTransform.m01;
        double d5 = affineTransform.m02;
        double d6 = affineTransform.m10;
        double d7 = affineTransform.m11;
        double d8 = affineTransform.m12;
        switch (n) {
            default: {
                this.stateError();
            }
            case 6: {
                this.state = n | n2;
            }
            case 7: {
                double d9 = this.m00;
                double d10 = this.m01;
                this.m00 = d * d9 + d6 * d10;
                this.m01 = d4 * d9 + d7 * d10;
                this.m02 += d5 * d9 + d8 * d10;
                d9 = this.m10;
                d10 = this.m11;
                this.m10 = d * d9 + d6 * d10;
                this.m11 = d4 * d9 + d7 * d10;
                this.m12 += d5 * d9 + d8 * d10;
                this.type = -1;
                return;
            }
            case 4: 
            case 5: {
                double d11 = this.m01;
                this.m00 = d6 * d11;
                this.m01 = d7 * d11;
                this.m02 += d8 * d11;
                d11 = this.m10;
                this.m10 = d * d11;
                this.m11 = d4 * d11;
                this.m12 += d5 * d11;
                break;
            }
            case 2: 
            case 3: {
                double d12 = this.m00;
                this.m00 = d * d12;
                this.m01 = d4 * d12;
                this.m02 += d5 * d12;
                d12 = this.m11;
                this.m10 = d6 * d12;
                this.m11 = d7 * d12;
                this.m12 += d8 * d12;
                break;
            }
            case 1: {
                this.m00 = d;
                this.m01 = d4;
                this.m02 += d5;
                this.m10 = d6;
                this.m11 = d7;
                this.m12 += d8;
                this.state = n2 | 1;
                this.type = -1;
                return;
            }
        }
        this.updateState();
    }

    public void preConcatenate(AffineTransform affineTransform) {
        int n = this.state;
        int n2 = affineTransform.state;
        switch (n2 << 3 | n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                this.m02 = affineTransform.m02;
                this.m12 = affineTransform.m12;
                this.state = n | 1;
                this.type |= 1;
                return;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                this.m02 += affineTransform.m02;
                this.m12 += affineTransform.m12;
                return;
            }
            case 16: 
            case 17: {
                this.state = n | 2;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                double d = affineTransform.m00;
                double d2 = affineTransform.m11;
                if ((n & 4) != 0) {
                    this.m01 *= d;
                    this.m10 *= d2;
                    if ((n & 2) != 0) {
                        this.m00 *= d;
                        this.m11 *= d2;
                    }
                } else {
                    this.m00 *= d;
                    this.m11 *= d2;
                }
                if ((n & 1) != 0) {
                    this.m02 *= d;
                    this.m12 *= d2;
                }
                this.type = -1;
                return;
            }
            case 36: 
            case 37: {
                n |= 2;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                this.state = n ^ 4;
            }
            case 38: 
            case 39: {
                double d = affineTransform.m01;
                double d3 = affineTransform.m10;
                double d4 = this.m00;
                this.m00 = this.m10 * d;
                this.m10 = d4 * d3;
                d4 = this.m01;
                this.m01 = this.m11 * d;
                this.m11 = d4 * d3;
                d4 = this.m02;
                this.m02 = this.m12 * d;
                this.m12 = d4 * d3;
                this.type = -1;
                return;
            }
        }
        double d = affineTransform.m00;
        double d5 = affineTransform.m01;
        double d6 = affineTransform.m02;
        double d7 = affineTransform.m10;
        double d8 = affineTransform.m11;
        double d9 = affineTransform.m12;
        switch (n) {
            default: {
                this.stateError();
            }
            case 7: {
                double d10 = this.m02;
                double d11 = this.m12;
                d6 += d10 * d + d11 * d5;
                d9 += d10 * d7 + d11 * d8;
            }
            case 6: {
                this.m02 = d6;
                this.m12 = d9;
                double d10 = this.m00;
                double d11 = this.m10;
                this.m00 = d10 * d + d11 * d5;
                this.m10 = d10 * d7 + d11 * d8;
                d10 = this.m01;
                d11 = this.m11;
                this.m01 = d10 * d + d11 * d5;
                this.m11 = d10 * d7 + d11 * d8;
                break;
            }
            case 5: {
                double d12 = this.m02;
                double d13 = this.m12;
                d6 += d12 * d + d13 * d5;
                d9 += d12 * d7 + d13 * d8;
            }
            case 4: {
                this.m02 = d6;
                this.m12 = d9;
                double d12 = this.m10;
                this.m00 = d12 * d5;
                this.m10 = d12 * d8;
                d12 = this.m01;
                this.m01 = d12 * d;
                this.m11 = d12 * d7;
                break;
            }
            case 3: {
                double d14 = this.m02;
                double d15 = this.m12;
                d6 += d14 * d + d15 * d5;
                d9 += d14 * d7 + d15 * d8;
            }
            case 2: {
                this.m02 = d6;
                this.m12 = d9;
                double d14 = this.m00;
                this.m00 = d14 * d;
                this.m10 = d14 * d7;
                d14 = this.m11;
                this.m01 = d14 * d5;
                this.m11 = d14 * d8;
                break;
            }
            case 1: {
                double d16 = this.m02;
                double d17 = this.m12;
                d6 += d16 * d + d17 * d5;
                d9 += d16 * d7 + d17 * d8;
            }
            case 0: {
                this.m02 = d6;
                this.m12 = d9;
                this.m00 = d;
                this.m10 = d7;
                this.m01 = d5;
                this.m11 = d8;
                this.state = n | n2;
                this.type = -1;
                return;
            }
        }
        this.updateState();
    }

    public AffineTransform createInverse() throws NoninvertibleTransformException {
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double d = this.m00 * this.m11 - this.m01 * this.m10;
                if (Math.abs(d) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d);
                }
                return new AffineTransform(this.m11 / d, -this.m10 / d, -this.m01 / d, this.m00 / d, (this.m01 * this.m12 - this.m11 * this.m02) / d, (this.m10 * this.m02 - this.m00 * this.m12) / d, 7);
            }
            case 6: {
                double d = this.m00 * this.m11 - this.m01 * this.m10;
                if (Math.abs(d) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d);
                }
                return new AffineTransform(this.m11 / d, -this.m10 / d, -this.m01 / d, this.m00 / d, 0.0, 0.0, 6);
            }
            case 5: {
                if (this.m01 == 0.0 || this.m10 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(0.0, 1.0 / this.m01, 1.0 / this.m10, 0.0, -this.m12 / this.m10, -this.m02 / this.m01, 5);
            }
            case 4: {
                if (this.m01 == 0.0 || this.m10 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(0.0, 1.0 / this.m01, 1.0 / this.m10, 0.0, 0.0, 0.0, 4);
            }
            case 3: {
                if (this.m00 == 0.0 || this.m11 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(1.0 / this.m00, 0.0, 0.0, 1.0 / this.m11, -this.m02 / this.m00, -this.m12 / this.m11, 3);
            }
            case 2: {
                if (this.m00 == 0.0 || this.m11 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(1.0 / this.m00, 0.0, 0.0, 1.0 / this.m11, 0.0, 0.0, 2);
            }
            case 1: {
                return new AffineTransform(1.0, 0.0, 0.0, 1.0, -this.m02, -this.m12, 1);
            }
            case 0: 
        }
        return new AffineTransform();
    }

    public Point2D transform(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = point2D instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                point2D2.setLocation(d * this.m00 + d2 * this.m01 + this.m02, d * this.m10 + d2 * this.m11 + this.m12);
                return point2D2;
            }
            case 6: {
                point2D2.setLocation(d * this.m00 + d2 * this.m01, d * this.m10 + d2 * this.m11);
                return point2D2;
            }
            case 5: {
                point2D2.setLocation(d2 * this.m01 + this.m02, d * this.m10 + this.m12);
                return point2D2;
            }
            case 4: {
                point2D2.setLocation(d2 * this.m01, d * this.m10);
                return point2D2;
            }
            case 3: {
                point2D2.setLocation(d * this.m00 + this.m02, d2 * this.m11 + this.m12);
                return point2D2;
            }
            case 2: {
                point2D2.setLocation(d * this.m00, d2 * this.m11);
                return point2D2;
            }
            case 1: {
                point2D2.setLocation(d + this.m02, d2 + this.m12);
                return point2D2;
            }
            case 0: 
        }
        point2D2.setLocation(d, d2);
        return point2D2;
    }

    public void transform(Point2D[] point2DArray, int n, Point2D[] point2DArray2, int n2, int n3) {
        int n4 = this.state;
        block10: while (--n3 >= 0) {
            Point2D point2D;
            Point2D point2D2 = point2DArray[n++];
            double d = point2D2.getX();
            double d2 = point2D2.getY();
            if ((point2D = point2DArray2[n2++]) == null) {
                point2D = point2D2 instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
                point2DArray2[n2 - 1] = point2D;
            }
            switch (n4) {
                default: {
                    this.stateError();
                }
                case 7: {
                    point2D.setLocation(d * this.m00 + d2 * this.m01 + this.m02, d * this.m10 + d2 * this.m11 + this.m12);
                    continue block10;
                }
                case 6: {
                    point2D.setLocation(d * this.m00 + d2 * this.m01, d * this.m10 + d2 * this.m11);
                    continue block10;
                }
                case 5: {
                    point2D.setLocation(d2 * this.m01 + this.m02, d * this.m10 + this.m12);
                    continue block10;
                }
                case 4: {
                    point2D.setLocation(d2 * this.m01, d * this.m10);
                    continue block10;
                }
                case 3: {
                    point2D.setLocation(d * this.m00 + this.m02, d2 * this.m11 + this.m12);
                    continue block10;
                }
                case 2: {
                    point2D.setLocation(d * this.m00, d2 * this.m11);
                    continue block10;
                }
                case 1: {
                    point2D.setLocation(d + this.m02, d2 + this.m12);
                    continue block10;
                }
                case 0: 
            }
            point2D.setLocation(d, d2);
        }
    }

    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray2 == fArray && n2 > n && n2 < n + n3 * 2) {
            System.arraycopy(fArray, n, fArray2, n2, n3 * 2);
            n = n2;
        }
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double d = this.m00;
                double d2 = this.m01;
                double d3 = this.m02;
                double d4 = this.m10;
                double d5 = this.m11;
                double d6 = this.m12;
                while (--n3 >= 0) {
                    double d7 = fArray[n++];
                    double d8 = fArray[n++];
                    fArray2[n2++] = (float)(d * d7 + d2 * d8 + d3);
                    fArray2[n2++] = (float)(d4 * d7 + d5 * d8 + d6);
                }
                return;
            }
            case 6: {
                double d = this.m00;
                double d9 = this.m01;
                double d10 = this.m10;
                double d11 = this.m11;
                while (--n3 >= 0) {
                    double d12 = fArray[n++];
                    double d13 = fArray[n++];
                    fArray2[n2++] = (float)(d * d12 + d9 * d13);
                    fArray2[n2++] = (float)(d10 * d12 + d11 * d13);
                }
                return;
            }
            case 5: {
                double d = this.m01;
                double d14 = this.m02;
                double d15 = this.m10;
                double d16 = this.m12;
                while (--n3 >= 0) {
                    double d17 = fArray[n++];
                    fArray2[n2++] = (float)(d * (double)fArray[n++] + d14);
                    fArray2[n2++] = (float)(d15 * d17 + d16);
                }
                return;
            }
            case 4: {
                double d = this.m01;
                double d18 = this.m10;
                while (--n3 >= 0) {
                    double d19 = fArray[n++];
                    fArray2[n2++] = (float)(d * (double)fArray[n++]);
                    fArray2[n2++] = (float)(d18 * d19);
                }
                return;
            }
            case 3: {
                double d = this.m00;
                double d20 = this.m02;
                double d21 = this.m11;
                double d22 = this.m12;
                while (--n3 >= 0) {
                    fArray2[n2++] = (float)(d * (double)fArray[n++] + d20);
                    fArray2[n2++] = (float)(d21 * (double)fArray[n++] + d22);
                }
                return;
            }
            case 2: {
                double d = this.m00;
                double d23 = this.m11;
                while (--n3 >= 0) {
                    fArray2[n2++] = (float)(d * (double)fArray[n++]);
                    fArray2[n2++] = (float)(d23 * (double)fArray[n++]);
                }
                return;
            }
            case 1: {
                double d = this.m02;
                double d24 = this.m12;
                while (--n3 >= 0) {
                    fArray2[n2++] = (float)((double)fArray[n++] + d);
                    fArray2[n2++] = (float)((double)fArray[n++] + d24);
                }
                return;
            }
            case 0: 
        }
        if (fArray != fArray2 || n != n2) {
            System.arraycopy(fArray, n, fArray2, n2, n3 * 2);
        }
    }

    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray2 == dArray && n2 > n && n2 < n + n3 * 2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
            n = n2;
        }
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double d = this.m00;
                double d2 = this.m01;
                double d3 = this.m02;
                double d4 = this.m10;
                double d5 = this.m11;
                double d6 = this.m12;
                while (--n3 >= 0) {
                    double d7 = dArray[n++];
                    double d8 = dArray[n++];
                    dArray2[n2++] = d * d7 + d2 * d8 + d3;
                    dArray2[n2++] = d4 * d7 + d5 * d8 + d6;
                }
                return;
            }
            case 6: {
                double d = this.m00;
                double d9 = this.m01;
                double d10 = this.m10;
                double d11 = this.m11;
                while (--n3 >= 0) {
                    double d12 = dArray[n++];
                    double d13 = dArray[n++];
                    dArray2[n2++] = d * d12 + d9 * d13;
                    dArray2[n2++] = d10 * d12 + d11 * d13;
                }
                return;
            }
            case 5: {
                double d = this.m01;
                double d14 = this.m02;
                double d15 = this.m10;
                double d16 = this.m12;
                while (--n3 >= 0) {
                    double d17 = dArray[n++];
                    dArray2[n2++] = d * dArray[n++] + d14;
                    dArray2[n2++] = d15 * d17 + d16;
                }
                return;
            }
            case 4: {
                double d = this.m01;
                double d18 = this.m10;
                while (--n3 >= 0) {
                    double d19 = dArray[n++];
                    dArray2[n2++] = d * dArray[n++];
                    dArray2[n2++] = d18 * d19;
                }
                return;
            }
            case 3: {
                double d = this.m00;
                double d20 = this.m02;
                double d21 = this.m11;
                double d22 = this.m12;
                while (--n3 >= 0) {
                    dArray2[n2++] = d * dArray[n++] + d20;
                    dArray2[n2++] = d21 * dArray[n++] + d22;
                }
                return;
            }
            case 2: {
                double d = this.m00;
                double d23 = this.m11;
                while (--n3 >= 0) {
                    dArray2[n2++] = d * dArray[n++];
                    dArray2[n2++] = d23 * dArray[n++];
                }
                return;
            }
            case 1: {
                double d = this.m02;
                double d24 = this.m12;
                while (--n3 >= 0) {
                    dArray2[n2++] = dArray[n++] + d;
                    dArray2[n2++] = dArray[n++] + d24;
                }
                return;
            }
            case 0: 
        }
        if (dArray != dArray2 || n != n2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
        }
    }

    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double d = this.m00;
                double d2 = this.m01;
                double d3 = this.m02;
                double d4 = this.m10;
                double d5 = this.m11;
                double d6 = this.m12;
                while (--n3 >= 0) {
                    double d7 = fArray[n++];
                    double d8 = fArray[n++];
                    dArray[n2++] = d * d7 + d2 * d8 + d3;
                    dArray[n2++] = d4 * d7 + d5 * d8 + d6;
                }
                return;
            }
            case 6: {
                double d = this.m00;
                double d9 = this.m01;
                double d10 = this.m10;
                double d11 = this.m11;
                while (--n3 >= 0) {
                    double d12 = fArray[n++];
                    double d13 = fArray[n++];
                    dArray[n2++] = d * d12 + d9 * d13;
                    dArray[n2++] = d10 * d12 + d11 * d13;
                }
                return;
            }
            case 5: {
                double d = this.m01;
                double d14 = this.m02;
                double d15 = this.m10;
                double d16 = this.m12;
                while (--n3 >= 0) {
                    double d17 = fArray[n++];
                    dArray[n2++] = d * (double)fArray[n++] + d14;
                    dArray[n2++] = d15 * d17 + d16;
                }
                return;
            }
            case 4: {
                double d = this.m01;
                double d18 = this.m10;
                while (--n3 >= 0) {
                    double d19 = fArray[n++];
                    dArray[n2++] = d * (double)fArray[n++];
                    dArray[n2++] = d18 * d19;
                }
                return;
            }
            case 3: {
                double d = this.m00;
                double d20 = this.m02;
                double d21 = this.m11;
                double d22 = this.m12;
                while (--n3 >= 0) {
                    dArray[n2++] = d * (double)fArray[n++] + d20;
                    dArray[n2++] = d21 * (double)fArray[n++] + d22;
                }
                return;
            }
            case 2: {
                double d = this.m00;
                double d23 = this.m11;
                while (--n3 >= 0) {
                    dArray[n2++] = d * (double)fArray[n++];
                    dArray[n2++] = d23 * (double)fArray[n++];
                }
                return;
            }
            case 1: {
                double d = this.m02;
                double d24 = this.m12;
                while (--n3 >= 0) {
                    dArray[n2++] = (double)fArray[n++] + d;
                    dArray[n2++] = (double)fArray[n++] + d24;
                }
                return;
            }
            case 0: 
        }
        while (--n3 >= 0) {
            dArray[n2++] = fArray[n++];
            dArray[n2++] = fArray[n++];
        }
    }

    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double d = this.m00;
                double d2 = this.m01;
                double d3 = this.m02;
                double d4 = this.m10;
                double d5 = this.m11;
                double d6 = this.m12;
                while (--n3 >= 0) {
                    double d7 = dArray[n++];
                    double d8 = dArray[n++];
                    fArray[n2++] = (float)(d * d7 + d2 * d8 + d3);
                    fArray[n2++] = (float)(d4 * d7 + d5 * d8 + d6);
                }
                return;
            }
            case 6: {
                double d = this.m00;
                double d9 = this.m01;
                double d10 = this.m10;
                double d11 = this.m11;
                while (--n3 >= 0) {
                    double d12 = dArray[n++];
                    double d13 = dArray[n++];
                    fArray[n2++] = (float)(d * d12 + d9 * d13);
                    fArray[n2++] = (float)(d10 * d12 + d11 * d13);
                }
                return;
            }
            case 5: {
                double d = this.m01;
                double d14 = this.m02;
                double d15 = this.m10;
                double d16 = this.m12;
                while (--n3 >= 0) {
                    double d17 = dArray[n++];
                    fArray[n2++] = (float)(d * dArray[n++] + d14);
                    fArray[n2++] = (float)(d15 * d17 + d16);
                }
                return;
            }
            case 4: {
                double d = this.m01;
                double d18 = this.m10;
                while (--n3 >= 0) {
                    double d19 = dArray[n++];
                    fArray[n2++] = (float)(d * dArray[n++]);
                    fArray[n2++] = (float)(d18 * d19);
                }
                return;
            }
            case 3: {
                double d = this.m00;
                double d20 = this.m02;
                double d21 = this.m11;
                double d22 = this.m12;
                while (--n3 >= 0) {
                    fArray[n2++] = (float)(d * dArray[n++] + d20);
                    fArray[n2++] = (float)(d21 * dArray[n++] + d22);
                }
                return;
            }
            case 2: {
                double d = this.m00;
                double d23 = this.m11;
                while (--n3 >= 0) {
                    fArray[n2++] = (float)(d * dArray[n++]);
                    fArray[n2++] = (float)(d23 * dArray[n++]);
                }
                return;
            }
            case 1: {
                double d = this.m02;
                double d24 = this.m12;
                while (--n3 >= 0) {
                    fArray[n2++] = (float)(dArray[n++] + d);
                    fArray[n2++] = (float)(dArray[n++] + d24);
                }
                return;
            }
            case 0: 
        }
        while (--n3 >= 0) {
            fArray[n2++] = (float)dArray[n++];
            fArray[n2++] = (float)dArray[n++];
        }
    }

    public Point2D inverseTransform(Point2D point2D, Point2D point2D2) throws NoninvertibleTransformException {
        if (point2D2 == null) {
            point2D2 = point2D instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                d -= this.m02;
                d2 -= this.m12;
            }
            case 6: {
                double d3 = this.m00 * this.m11 - this.m01 * this.m10;
                if (Math.abs(d3) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d3);
                }
                point2D2.setLocation((d * this.m11 - d2 * this.m01) / d3, (d2 * this.m00 - d * this.m10) / d3);
                return point2D2;
            }
            case 5: {
                d -= this.m02;
                d2 -= this.m12;
            }
            case 4: {
                if (this.m01 == 0.0 || this.m10 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                point2D2.setLocation(d2 / this.m10, d / this.m01);
                return point2D2;
            }
            case 3: {
                d -= this.m02;
                d2 -= this.m12;
            }
            case 2: {
                if (this.m00 == 0.0 || this.m11 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                point2D2.setLocation(d / this.m00, d2 / this.m11);
                return point2D2;
            }
            case 1: {
                point2D2.setLocation(d - this.m02, d2 - this.m12);
                return point2D2;
            }
            case 0: 
        }
        point2D2.setLocation(d, d2);
        return point2D2;
    }

    public void inverseTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws NoninvertibleTransformException {
        if (dArray2 == dArray && n2 > n && n2 < n + n3 * 2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
            n = n2;
        }
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double d = this.m00;
                double d2 = this.m01;
                double d3 = this.m02;
                double d4 = this.m10;
                double d5 = this.m11;
                double d6 = this.m12;
                double d7 = d * d5 - d2 * d4;
                if (Math.abs(d7) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d7);
                }
                while (--n3 >= 0) {
                    double d8 = dArray[n++] - d3;
                    double d9 = dArray[n++] - d6;
                    dArray2[n2++] = (d8 * d5 - d9 * d2) / d7;
                    dArray2[n2++] = (d9 * d - d8 * d4) / d7;
                }
                return;
            }
            case 6: {
                double d = this.m00;
                double d10 = this.m01;
                double d11 = this.m10;
                double d12 = this.m11;
                double d13 = d * d12 - d10 * d11;
                if (Math.abs(d13) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d13);
                }
                while (--n3 >= 0) {
                    double d14 = dArray[n++];
                    double d15 = dArray[n++];
                    dArray2[n2++] = (d14 * d12 - d15 * d10) / d13;
                    dArray2[n2++] = (d15 * d - d14 * d11) / d13;
                }
                return;
            }
            case 5: {
                double d = this.m01;
                double d16 = this.m02;
                double d17 = this.m10;
                double d18 = this.m12;
                if (d == 0.0 || d17 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--n3 >= 0) {
                    double d19 = dArray[n++] - d16;
                    dArray2[n2++] = (dArray[n++] - d18) / d17;
                    dArray2[n2++] = d19 / d;
                }
                return;
            }
            case 4: {
                double d = this.m01;
                double d20 = this.m10;
                if (d == 0.0 || d20 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--n3 >= 0) {
                    double d21 = dArray[n++];
                    dArray2[n2++] = dArray[n++] / d20;
                    dArray2[n2++] = d21 / d;
                }
                return;
            }
            case 3: {
                double d = this.m00;
                double d22 = this.m02;
                double d23 = this.m11;
                double d24 = this.m12;
                if (d == 0.0 || d23 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--n3 >= 0) {
                    dArray2[n2++] = (dArray[n++] - d22) / d;
                    dArray2[n2++] = (dArray[n++] - d24) / d23;
                }
                return;
            }
            case 2: {
                double d = this.m00;
                double d25 = this.m11;
                if (d == 0.0 || d25 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--n3 >= 0) {
                    dArray2[n2++] = dArray[n++] / d;
                    dArray2[n2++] = dArray[n++] / d25;
                }
                return;
            }
            case 1: {
                double d = this.m02;
                double d26 = this.m12;
                while (--n3 >= 0) {
                    dArray2[n2++] = dArray[n++] - d;
                    dArray2[n2++] = dArray[n++] - d26;
                }
                return;
            }
            case 0: 
        }
        if (dArray != dArray2 || n != n2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
        }
    }

    public Point2D deltaTransform(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = point2D instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 6: 
            case 7: {
                point2D2.setLocation(d * this.m00 + d2 * this.m01, d * this.m10 + d2 * this.m11);
                return point2D2;
            }
            case 4: 
            case 5: {
                point2D2.setLocation(d2 * this.m01, d * this.m10);
                return point2D2;
            }
            case 2: 
            case 3: {
                point2D2.setLocation(d * this.m00, d2 * this.m11);
                return point2D2;
            }
            case 0: 
            case 1: 
        }
        point2D2.setLocation(d, d2);
        return point2D2;
    }

    public void deltaTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray2 == dArray && n2 > n && n2 < n + n3 * 2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
            n = n2;
        }
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 6: 
            case 7: {
                double d = this.m00;
                double d2 = this.m01;
                double d3 = this.m10;
                double d4 = this.m11;
                while (--n3 >= 0) {
                    double d5 = dArray[n++];
                    double d6 = dArray[n++];
                    dArray2[n2++] = d5 * d + d6 * d2;
                    dArray2[n2++] = d5 * d3 + d6 * d4;
                }
                return;
            }
            case 4: 
            case 5: {
                double d = this.m01;
                double d7 = this.m10;
                while (--n3 >= 0) {
                    double d8 = dArray[n++];
                    dArray2[n2++] = dArray[n++] * d;
                    dArray2[n2++] = d8 * d7;
                }
                return;
            }
            case 2: 
            case 3: {
                double d = this.m00;
                double d9 = this.m11;
                while (--n3 >= 0) {
                    dArray2[n2++] = dArray[n++] * d;
                    dArray2[n2++] = dArray[n++] * d9;
                }
                return;
            }
            case 0: 
            case 1: 
        }
        if (dArray != dArray2 || n != n2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
        }
    }

    public Shape createTransformedShape(Shape shape) {
        if (shape == null) {
            return null;
        }
        if (shape instanceof GeneralPath) {
            return ((GeneralPath)shape).createTransformedShape(this);
        }
        PathIterator pathIterator = shape.getPathIterator(this);
        GeneralPath generalPath = new GeneralPath(pathIterator.getWindingRule());
        generalPath.append(pathIterator, false);
        return generalPath;
    }

    private static double _matround(double d) {
        return Math.rint(d * 1.0E15) / 1.0E15;
    }

    public String toString() {
        return "AffineTransform[[" + AffineTransform._matround(this.m00) + ", " + AffineTransform._matround(this.m01) + ", " + AffineTransform._matround(this.m02) + "], [" + AffineTransform._matround(this.m10) + ", " + AffineTransform._matround(this.m11) + ", " + AffineTransform._matround(this.m12) + "]]";
    }

    public boolean isIdentity() {
        return this.state == 0 || this.getType() == 0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.m00);
        l = l * 31L + Double.doubleToLongBits(this.m01);
        l = l * 31L + Double.doubleToLongBits(this.m02);
        l = l * 31L + Double.doubleToLongBits(this.m10);
        l = l * 31L + Double.doubleToLongBits(this.m11);
        l = l * 31L + Double.doubleToLongBits(this.m12);
        return (int)l ^ (int)(l >> 32);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AffineTransform)) {
            return false;
        }
        AffineTransform affineTransform = (AffineTransform)object;
        return this.m00 == affineTransform.m00 && this.m01 == affineTransform.m01 && this.m02 == affineTransform.m02 && this.m10 == affineTransform.m10 && this.m11 == affineTransform.m11 && this.m12 == affineTransform.m12;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.updateState();
    }
}

