/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOnWriteArrayList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8673264195747942595L;
    private volatile transient E[] array;

    private E[] array() {
        return this.array;
    }

    public CopyOnWriteArrayList() {
        this.array = new Object[0];
    }

    public CopyOnWriteArrayList(Collection<? extends E> collection) {
        this.array = new Object[collection.size()];
        Iterator<E> iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.array[n++] = iterator.next();
        }
    }

    public CopyOnWriteArrayList(E[] EArray) {
        this.copyIn(EArray, 0, EArray.length);
    }

    private synchronized void copyIn(E[] EArray, int n, int n2) {
        this.array = new Object[n2];
        System.arraycopy(EArray, n, this.array, 0, n2);
    }

    @Override
    public int size() {
        return this.array().length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object object) {
        int n;
        Object[] objectArray = this.array();
        return CopyOnWriteArrayList.indexOf(object, objectArray, n = objectArray.length) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        Object[] objectArray = this.array();
        int n = objectArray.length;
        return CopyOnWriteArrayList.indexOf(object, objectArray, n);
    }

    private static int indexOf(Object object, Object[] objectArray, int n) {
        if (object == null) {
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(E e, int n) {
        E[] EArray = this.array();
        int n2 = EArray.length;
        if (e == null) {
            for (int i = n; i < n2; ++i) {
                if (EArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i < n2; ++i) {
                if (!e.equals(EArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        Object[] objectArray = this.array();
        int n = objectArray.length;
        return CopyOnWriteArrayList.lastIndexOf(object, objectArray, n);
    }

    private static int lastIndexOf(Object object, Object[] objectArray, int n) {
        if (object == null) {
            for (int i = n - 1; i >= 0; --i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n - 1; i >= 0; --i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(E e, int n) {
        E[] EArray = this.array();
        if (e == null) {
            for (int i = n; i >= 0; --i) {
                if (EArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i >= 0; --i) {
                if (!e.equals(EArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            E[] EArray = this.array();
            CopyOnWriteArrayList copyOnWriteArrayList = (CopyOnWriteArrayList)super.clone();
            copyOnWriteArrayList.array = new Object[EArray.length];
            System.arraycopy(EArray, 0, copyOnWriteArrayList.array, 0, EArray.length);
            return copyOnWriteArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        E[] EArray = this.array();
        Object[] objectArray = new Object[EArray.length];
        System.arraycopy(EArray, 0, objectArray, 0, EArray.length);
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        E[] EArray = this.array();
        if (objectArray.length < EArray.length) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), EArray.length);
        }
        System.arraycopy(EArray, 0, objectArray, 0, EArray.length);
        if (objectArray.length > EArray.length) {
            objectArray[EArray.length] = null;
        }
        return objectArray;
    }

    @Override
    public E get(int n) {
        E[] EArray = this.array();
        this.rangeCheck(n, EArray.length);
        return EArray[n];
    }

    @Override
    public synchronized E set(int n, E e) {
        boolean bl;
        int n2 = this.array.length;
        this.rangeCheck(n, n2);
        E e2 = this.array[n];
        boolean bl2 = bl = e2 == e || e != null && e.equals(e2);
        if (!bl) {
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.array, 0, objectArray, 0, n2);
            objectArray[n] = e;
            this.array = objectArray;
        }
        return e2;
    }

    @Override
    public synchronized boolean add(E e) {
        int n = this.array.length;
        Object[] objectArray = new Object[n + 1];
        System.arraycopy(this.array, 0, objectArray, 0, n);
        objectArray[n] = e;
        this.array = objectArray;
        return true;
    }

    @Override
    public synchronized void add(int n, E e) {
        int n2 = this.array.length;
        if (n > n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
        Object[] objectArray = new Object[n2 + 1];
        System.arraycopy(this.array, 0, objectArray, 0, n);
        objectArray[n] = e;
        System.arraycopy(this.array, n, objectArray, n + 1, n2 - n);
        this.array = objectArray;
    }

    @Override
    public synchronized E remove(int n) {
        int n2 = this.array.length;
        this.rangeCheck(n, n2);
        E e = this.array[n];
        Object[] objectArray = new Object[n2 - 1];
        System.arraycopy(this.array, 0, objectArray, 0, n);
        int n3 = n2 - n - 1;
        if (n3 > 0) {
            System.arraycopy(this.array, n + 1, objectArray, n, n3);
        }
        this.array = objectArray;
        return e;
    }

    @Override
    public synchronized boolean remove(Object object) {
        int n = this.array.length;
        if (n == 0) {
            return false;
        }
        int n2 = n - 1;
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            if (object == this.array[i] || object != null && object.equals(this.array[i])) {
                for (int j = i + 1; j < n; ++j) {
                    objectArray[j - 1] = this.array[j];
                }
                this.array = objectArray;
                return true;
            }
            objectArray[i] = this.array[i];
        }
        if (object == this.array[n2] || object != null && object.equals(this.array[n2])) {
            this.array = objectArray;
            return true;
        }
        return false;
    }

    private synchronized void removeRange(int n, int n2) {
        int n3 = this.array.length;
        if (n < 0 || n >= n3 || n2 > n3 || n2 < n) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n3 - n2;
        int n5 = n3 - (n2 - n);
        Object[] objectArray = new Object[n5];
        System.arraycopy(this.array, 0, objectArray, 0, n);
        System.arraycopy(this.array, n2, objectArray, n, n4);
        this.array = objectArray;
    }

    public synchronized boolean addIfAbsent(E e) {
        int n = this.array.length;
        Object[] objectArray = new Object[n + 1];
        for (int i = 0; i < n; ++i) {
            if (e == this.array[i] || e != null && e.equals(this.array[i])) {
                return false;
            }
            objectArray[i] = this.array[i];
        }
        objectArray[n] = e;
        this.array = objectArray;
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Object[] objectArray = this.array();
        int n = objectArray.length;
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (CopyOnWriteArrayList.indexOf(iterator.next(), objectArray, n) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> collection) {
        E[] EArray = this.array;
        int n = EArray.length;
        if (n == 0) {
            return false;
        }
        Object[] objectArray = new Object[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            E e = EArray[i];
            if (collection.contains(e)) continue;
            objectArray[n2++] = e;
        }
        if (n2 == n) {
            return false;
        }
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        this.array = objectArray2;
        return true;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> collection) {
        E[] EArray = this.array;
        int n = EArray.length;
        if (n == 0) {
            return false;
        }
        Object[] objectArray = new Object[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            E e = EArray[i];
            if (!collection.contains(e)) continue;
            objectArray[n2++] = e;
        }
        if (n2 == n) {
            return false;
        }
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        this.array = objectArray2;
        return true;
    }

    public synchronized int addAllAbsent(Collection<? extends E> collection) {
        Object object2;
        int n = collection.size();
        if (n == 0) {
            return 0;
        }
        Object[] objectArray = this.array;
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n];
        int n3 = 0;
        for (Object object2 : collection) {
            if (CopyOnWriteArrayList.indexOf(object2, objectArray, n2) >= 0 || CopyOnWriteArrayList.indexOf(object2, objectArray2, n3) >= 0) continue;
            objectArray2[n3++] = object2;
        }
        if (n3 == 0) {
            return 0;
        }
        object2 = new Object[n2 + n3];
        System.arraycopy(objectArray, 0, object2, 0, n2);
        System.arraycopy(objectArray2, 0, object2, n2, n3);
        this.array = object2;
        return n3;
    }

    @Override
    public synchronized void clear() {
        this.array = new Object[0];
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> collection) {
        int n = collection.size();
        if (n == 0) {
            return false;
        }
        int n2 = this.array.length;
        Object[] objectArray = new Object[n2 + n];
        System.arraycopy(this.array, 0, objectArray, 0, n2);
        Iterator<E> iterator = collection.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray[n2++] = iterator.next();
        }
        this.array = objectArray;
        return true;
    }

    @Override
    public synchronized boolean addAll(int n, Collection<? extends E> collection) {
        int n2 = this.array.length;
        if (n > n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
        int n3 = collection.size();
        if (n3 == 0) {
            return false;
        }
        Object[] objectArray = new Object[n2 + n3];
        System.arraycopy(this.array, 0, objectArray, 0, n2);
        int n4 = n2 - n;
        if (n4 > 0) {
            System.arraycopy(this.array, n, objectArray, n + n3, n4);
        }
        Iterator<E> iterator = collection.iterator();
        for (int i = 0; i < n3; ++i) {
            objectArray[n++] = iterator.next();
        }
        this.array = objectArray;
        return true;
    }

    private void rangeCheck(int n, int n2) {
        if (n >= n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        E[] EArray = this.array();
        objectOutputStream.writeInt(EArray.length);
        for (int i = 0; i < EArray.length; ++i) {
            objectOutputStream.writeObject(EArray[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = objectInputStream.readObject();
        }
        this.array = objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<E> iterator = this.iterator();
        stringBuffer.append("[");
        int n = this.size() - 1;
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(String.valueOf(iterator.next()));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        ListIterator<E> listIterator = this.listIterator();
        ListIterator listIterator2 = list.listIterator();
        while (listIterator.hasNext()) {
            E e = listIterator.next();
            Object e2 = listIterator2.next();
            if (e != null ? e.equals(e2) : e2 == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (E e : this) {
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    @Override
    public Iterator<E> iterator() {
        return new COWIterator(this.array(), 0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new COWIterator(this.array(), 0);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        E[] EArray = this.array();
        int n2 = EArray.length;
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        return new COWIterator(this.array(), n);
    }

    @Override
    public synchronized List<E> subList(int n, int n2) {
        int n3 = this.array.length;
        if (n < 0 || n2 > n3 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return new COWSubList(this, n, n2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class COWIterator<E>
    implements ListIterator<E> {
        private final E[] array;
        private int cursor;

        private COWIterator(E[] EArray, int n) {
            this.array = EArray;
            this.cursor = n;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            try {
                return this.array[this.cursor++];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public E previous() {
            try {
                return this.array[--this.cursor];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class COWSubList<E>
    extends AbstractList<E> {
        private final CopyOnWriteArrayList<E> l;
        private final int offset;
        private int size;
        private E[] expectedArray;

        private COWSubList(CopyOnWriteArrayList<E> copyOnWriteArrayList, int n, int n2) {
            this.l = copyOnWriteArrayList;
            this.expectedArray = ((CopyOnWriteArrayList)this.l).array();
            this.offset = n;
            this.size = n2 - n;
        }

        private void checkForComodification() {
            if (((CopyOnWriteArrayList)this.l).array != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
        }

        private void rangeCheck(int n) {
            if (n < 0 || n >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ",Size: " + this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int n, E e) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n);
                this.checkForComodification();
                E e2 = this.l.set(n + this.offset, e);
                this.expectedArray = ((CopyOnWriteArrayList)this.l).array;
                return e2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int n) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n);
                this.checkForComodification();
                return this.l.get(n + this.offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int n, E e) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n < 0 || n > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                this.l.add(n + this.offset, e);
                this.expectedArray = ((CopyOnWriteArrayList)this.l).array;
                ++this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                ((CopyOnWriteArrayList)this.l).removeRange(this.offset, this.offset + this.size);
                this.expectedArray = ((CopyOnWriteArrayList)this.l).array;
                this.size = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int n) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n);
                this.checkForComodification();
                E e = this.l.remove(n + this.offset);
                this.expectedArray = ((CopyOnWriteArrayList)this.l).array;
                --this.size;
                return e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<E> iterator() {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return new COWSubListIterator(this.l, 0, this.offset, this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<E> listIterator(int n) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n < 0 || n > this.size) {
                    throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
                }
                return new COWSubListIterator(this.l, n, this.offset, this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int n, int n2) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n < 0 || n2 > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                return new COWSubList<E>(this.l, n + this.offset, n2 + this.offset);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class COWSubListIterator<E>
    implements ListIterator<E> {
        private final ListIterator<E> i;
        private final int index;
        private final int offset;
        private final int size;

        private COWSubListIterator(List<E> list, int n, int n2, int n3) {
            this.index = n;
            this.offset = n2;
            this.size = n3;
            this.i = list.listIterator(n + n2);
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex() < this.size;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.i.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        @Override
        public E previous() {
            if (this.hasPrevious()) {
                return this.i.previous();
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex() - this.offset;
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex() - this.offset;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

