/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.trace.Trace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.XMLParseException;
import sun.reflect.misc.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorSupport
implements Descriptor {
    private static final long oldSerialVersionUID = 8071560848919417985L;
    private static final long newSerialVersionUID = -6292969195866300415L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("descriptor", HashMap.class), new ObjectStreamField("currClass", String.class)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("descriptor", HashMap.class)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final String serialForm;
    private transient SortedMap<String, Object> descriptorMap;
    private static final int DEFAULT_SIZE = 20;
    private static final String currClass = "DescriptorSupport";
    private static final String[] entities;
    private static final Map<String, Character> entityToCharMap;
    private static final String[] charToEntityMap;

    public DescriptorSupport() {
        if (this.tracing()) {
            this.trace("DescriptorSupport()", "Constructor");
        }
        this.init(null);
    }

    public DescriptorSupport(int n) throws MBeanException, RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("Descriptor(initNumFields=" + n + ")", "Constructor");
        }
        if (n <= 0) {
            if (this.tracing()) {
                this.trace("Descriptor(maxNumFields)", "Illegal arguments: initNumFields <= 0");
            }
            String string = "Descriptor field limit invalid: " + n;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            throw new RuntimeOperationsException(illegalArgumentException, string);
        }
        this.init(null);
    }

    public DescriptorSupport(DescriptorSupport descriptorSupport) {
        if (this.tracing()) {
            this.trace("Descriptor(Descriptor)", "Constructor");
        }
        if (descriptorSupport == null) {
            this.init(null);
        } else {
            this.init(descriptorSupport.descriptorMap);
        }
    }

    public DescriptorSupport(String string) throws MBeanException, RuntimeOperationsException, XMLParseException {
        if (this.tracing()) {
            this.trace("Descriptor(String ='" + string + "')", "Constructor");
        }
        if (string == null) {
            if (this.tracing()) {
                this.trace("Descriptor(String = null)", "Illegal arguments");
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("String in parameter is null");
            throw new RuntimeOperationsException(illegalArgumentException, "String in parameter is null");
        }
        String string2 = string.toLowerCase();
        if (!string2.startsWith("<descriptor>") || !string2.endsWith("</descriptor>")) {
            throw new XMLParseException("No <descriptor>, </descriptor> pair");
        }
        this.init(null);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<> \t\n\r\f");
        boolean bl = false;
        boolean bl2 = false;
        String string3 = null;
        String string4 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string5;
            String string6 = stringTokenizer.nextToken();
            if (string6.equalsIgnoreCase("FIELD")) {
                bl = true;
                continue;
            }
            if (string6.equalsIgnoreCase("/FIELD")) {
                if (string3 != null && string4 != null) {
                    string3 = string3.substring(string3.indexOf(34) + 1, string3.lastIndexOf(34));
                    Object object = DescriptorSupport.parseQuotedFieldValue(string4);
                    this.setField(string3, object);
                }
                string3 = null;
                string4 = null;
                bl = false;
                continue;
            }
            if (string6.equalsIgnoreCase("DESCRIPTOR")) {
                bl2 = true;
                continue;
            }
            if (string6.equalsIgnoreCase("/DESCRIPTOR")) {
                bl2 = false;
                string3 = null;
                string4 = null;
                bl = false;
                continue;
            }
            if (!bl || !bl2) continue;
            int n = string6.indexOf("=");
            if (n > 0) {
                string5 = string6.substring(0, n);
                String string7 = string6.substring(n + 1);
                if (string5.equalsIgnoreCase("NAME")) {
                    string3 = string7;
                    continue;
                }
                if (string5.equalsIgnoreCase("VALUE")) {
                    string4 = string7;
                    continue;
                }
                String string8 = "Expected `name' or `value', got `" + string6 + "'";
                throw new XMLParseException(string8);
            }
            string5 = "Expected `keyword=value', got `" + string6 + "'";
            throw new XMLParseException(string5);
        }
        if (this.tracing()) {
            this.trace("Descriptor(XMLString)", "Exit");
        }
    }

    public DescriptorSupport(String[] stringArray, Object[] objectArray) throws RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("Descriptor(fieldNames, fieldObjects)", "Constructor");
        }
        if (stringArray == null || objectArray == null || stringArray.length != objectArray.length) {
            if (this.tracing()) {
                this.trace("Descriptor(String[],Object[])", "Illegal arguments");
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Null or invalid fieldNames or fieldValues");
            throw new RuntimeOperationsException(illegalArgumentException, "Null or invalid fieldNames or fieldValues");
        }
        this.init(null);
        for (int i = 0; i < stringArray.length; ++i) {
            this.setField(stringArray[i], objectArray[i]);
        }
        if (this.tracing()) {
            this.trace("Descriptor(fieldNames, fieldObjects)", "Exit");
        }
    }

    public DescriptorSupport(String[] stringArray) {
        if (this.tracing()) {
            this.trace("Descriptor(fields)", "Constructor");
        }
        this.init(null);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        this.init(null);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (stringArray[i] == null || stringArray[i].equals("")) continue;
            int n = stringArray[i].indexOf("=");
            if (n < 0) {
                if (this.tracing()) {
                    this.trace("Descriptor(String[])", "Illegal arguments: field does not have '=' as a name and value separator");
                }
                object = new IllegalArgumentException("Field in invalid format: no equals sign");
                throw new RuntimeOperationsException((RuntimeException)object, "Field in invalid format: no equals sign");
            }
            String string = stringArray[i].substring(0, n);
            object = null;
            if (n < stringArray[i].length()) {
                object = stringArray[i].substring(n + 1);
            }
            if (string.equals("")) {
                if (this.tracing()) {
                    this.trace("Descriptor(String[])", "Illegal arguments: fieldName is empty");
                }
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Field in invalid format: no fieldName");
                throw new RuntimeOperationsException(illegalArgumentException, "Field in invalid format: no fieldName");
            }
            this.setField(string, object);
        }
        if (this.tracing()) {
            this.trace("Descriptor(fields)", "Exit");
        }
    }

    private void init(Map<String, ?> map) {
        this.descriptorMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        if (map != null) {
            this.descriptorMap.putAll(map);
        }
    }

    @Override
    public synchronized Object getFieldValue(String string) throws RuntimeOperationsException {
        if (string == null || string.equals("")) {
            if (this.tracing()) {
                this.trace("getField()", "Illegal arguments: null field name.");
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Fieldname requested is null");
            throw new RuntimeOperationsException(illegalArgumentException, "Fieldname requested is null");
        }
        Object v = this.descriptorMap.get(string);
        if (this.tracing()) {
            this.trace("getField(" + string + ")", "Returns '" + v + "'");
        }
        return v;
    }

    @Override
    public synchronized void setField(String string, Object object) throws RuntimeOperationsException {
        if (string == null || string.equals("")) {
            if (this.tracing()) {
                this.trace("setField(String,String)", "Illegal arguments: null or empty field name");
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Fieldname to be set is null or empty");
            throw new RuntimeOperationsException(illegalArgumentException, "Fieldname to be set is null or empty");
        }
        if (!this.validateField(string, object)) {
            if (this.tracing()) {
                this.trace("setField(fieldName,FieldValue)", "Illegal arguments");
            }
            String string2 = "Field value invalid: " + string + "=" + object;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
            throw new RuntimeOperationsException(illegalArgumentException, string2);
        }
        if (this.tracing() && object != null) {
            this.trace("setField(fieldName, fieldValue)", "Entry: setting '" + string + "' to '" + object + "'.");
        }
        this.descriptorMap.put(string, object);
    }

    @Override
    public synchronized String[] getFields() {
        if (this.tracing()) {
            this.trace("getFields()", "Entry");
        }
        int n = this.descriptorMap.size();
        String[] stringArray = new String[n];
        Set set = this.descriptorMap.entrySet();
        int n2 = 0;
        Object object = null;
        Map.Entry entry2 = null;
        if (this.tracing()) {
            this.trace("getFields()", "Returning " + n + " fields");
        }
        for (Map.Entry entry2 : set) {
            if (entry2 == null) {
                if (this.tracing()) {
                    this.trace("getFields()", "Element is null");
                }
            } else {
                object = entry2.getValue();
                stringArray[n2] = object == null ? entry2.getKey() + "=" : (object instanceof String ? entry2.getKey() + "=" + object.toString() : entry2.getKey() + "=(" + object.toString() + ")");
            }
            ++n2;
        }
        if (this.tracing()) {
            this.trace("getFields()", "Exit");
        }
        return stringArray;
    }

    @Override
    public synchronized String[] getFieldNames() {
        if (this.tracing()) {
            this.trace("getFieldNames()", "Entry");
        }
        int n = this.descriptorMap.size();
        String[] stringArray = new String[n];
        Set set = this.descriptorMap.entrySet();
        int n2 = 0;
        if (this.tracing()) {
            this.trace("getFieldNames()", "Returning " + n + " fields");
        }
        for (Map.Entry entry : set) {
            if (entry == null || entry.getKey() == null) {
                if (this.tracing()) {
                    this.trace("getFieldNames()", "Field is null");
                }
            } else {
                stringArray[n2] = entry.getKey().toString();
            }
            ++n2;
        }
        if (this.tracing()) {
            this.trace("getFieldNames()", "Exit");
        }
        return stringArray;
    }

    @Override
    public synchronized Object[] getFieldValues(String[] stringArray) {
        int n;
        if (this.tracing()) {
            this.trace("getFieldValues(fieldNames)", "Entry");
        }
        if ((n = this.descriptorMap.size()) == 0) {
            return new Object[0];
        }
        Object[] objectArray = stringArray != null ? new Object[stringArray.length] : new Object[n];
        int n2 = 0;
        if (this.tracing()) {
            this.trace("getFieldValues()", "Returning " + n + " fields");
        }
        if (stringArray == null) {
            Iterator iterator = this.descriptorMap.values().iterator();
            while (iterator.hasNext()) {
                objectArray[n2] = iterator.next();
                ++n2;
            }
        } else {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                objectArray[n2] = stringArray[n2] == null || stringArray[n2].equals("") ? null : this.getFieldValue(stringArray[n2]);
            }
        }
        if (this.tracing()) {
            this.trace("getFieldValues()", "Exit");
        }
        return objectArray;
    }

    @Override
    public synchronized void setFields(String[] stringArray, Object[] objectArray) throws RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("setFields(fieldNames, ObjectValues)", "Entry");
        }
        if (stringArray == null || objectArray == null || stringArray.length != objectArray.length) {
            if (this.tracing()) {
                this.trace("Descriptor.setFields(String[],Object[])", "Illegal arguments");
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("FieldNames and FieldValues are null or invalid");
            throw new RuntimeOperationsException(illegalArgumentException, "FieldNames and FieldValues are null or invalid");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].equals("")) {
                if (this.tracing()) {
                    this.trace("Descriptor.setFields(String[],Object[])", "Null field name encountered at " + i + " element");
                }
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("FieldNames is null or invalid");
                throw new RuntimeOperationsException(illegalArgumentException, "FieldNames is null or invalid");
            }
            this.setField(stringArray[i], objectArray[i]);
        }
        if (this.tracing()) {
            this.trace("Descriptor.setFields(fieldNames, fieldObjects)", "Exit");
        }
    }

    @Override
    public synchronized Object clone() throws RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("Descriptor.clone()", "Executed");
        }
        return new DescriptorSupport(this);
    }

    @Override
    public synchronized void removeField(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.descriptorMap.remove(string);
    }

    @Override
    public synchronized boolean isValid() throws RuntimeOperationsException {
        Set set;
        if (this.tracing()) {
            this.trace("Descriptor.isValid()", "Executed");
        }
        if ((set = this.descriptorMap.entrySet()) == null) {
            if (this.tracing()) {
                this.trace("Descriptor.isValid()", "returns false (null set)");
            }
            return false;
        }
        String string = (String)this.getFieldValue("name");
        String string2 = (String)this.getFieldValue("descriptorType");
        if (string == null || string2 == null || string.equals("") || string2.equals("")) {
            return false;
        }
        for (Map.Entry entry : set) {
            if (entry == null || entry.getValue() == null || this.validateField(entry.getKey().toString(), entry.getValue().toString())) continue;
            if (this.tracing()) {
                this.trace("isValid()", "Field " + entry.getKey() + "=" + entry.getValue() + " is not valid");
            }
            return false;
        }
        if (this.tracing()) {
            this.trace("Descriptor.isValid()", "returns true");
        }
        return true;
    }

    private boolean validateField(String string, Object object) {
        boolean bl;
        if (string == null || string.equals("")) {
            return false;
        }
        String string2 = "";
        boolean bl2 = false;
        if (object != null && object instanceof String) {
            string2 = (String)object;
            bl2 = true;
        }
        boolean bl3 = bl = string.equalsIgnoreCase("Name") || string.equalsIgnoreCase("DescriptorType");
        if (bl || string.equalsIgnoreCase("SetMethod") || string.equalsIgnoreCase("GetMethod") || string.equalsIgnoreCase("Role") || string.equalsIgnoreCase("Class")) {
            if (object == null || !bl2) {
                return false;
            }
            return !bl || !string2.equals("");
        }
        if (string.equalsIgnoreCase("visibility")) {
            long l;
            if (object != null && bl2) {
                l = this.toNumeric(string2);
            } else if (object instanceof Integer) {
                l = ((Integer)object).intValue();
            } else {
                return false;
            }
            return l >= 1L && l <= 4L;
        }
        if (string.equalsIgnoreCase("severity")) {
            long l;
            if (object != null && bl2) {
                l = this.toNumeric(string2);
            } else if (object instanceof Integer) {
                l = ((Integer)object).intValue();
            } else {
                return false;
            }
            return l >= 0L && l <= 6L;
        }
        if (string.equalsIgnoreCase("PersistPolicy")) {
            return object != null && bl2 && (string2.equalsIgnoreCase("OnUpdate") || string2.equalsIgnoreCase("OnTimer") || string2.equalsIgnoreCase("NoMoreOftenThan") || string2.equalsIgnoreCase("Always") || string2.equalsIgnoreCase("Never"));
        }
        if (string.equalsIgnoreCase("PersistPeriod") || string.equalsIgnoreCase("CurrencyTimeLimit") || string.equalsIgnoreCase("LastUpdatedTimeStamp") || string.equalsIgnoreCase("LastReturnedTimeStamp")) {
            long l;
            if (object != null && bl2) {
                l = this.toNumeric(string2);
            } else if (object instanceof Number) {
                l = ((Number)object).longValue();
            } else {
                return false;
            }
            return l >= -1L;
        }
        if (string.equalsIgnoreCase("log")) {
            return object instanceof Boolean || bl2 && (string2.equalsIgnoreCase("T") || string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("F") || string2.equalsIgnoreCase("false"));
        }
        return true;
    }

    public synchronized String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer("<Descriptor>");
        Set set = this.descriptorMap.entrySet();
        for (Map.Entry entry : set) {
            String string;
            String string2 = entry.getKey().toString();
            Object v = entry.getValue();
            String string3 = null;
            if (!(!(v instanceof String) || (string = (String)v).startsWith("(") && string.endsWith(")"))) {
                string3 = DescriptorSupport.quote(string);
            }
            if (string3 == null) {
                string3 = DescriptorSupport.makeFieldValue(v);
            }
            stringBuffer.append("<field name=\"").append(string2).append("\" value=\"").append(string3).append("\"></field>");
        }
        stringBuffer.append("</Descriptor>");
        return stringBuffer.toString();
    }

    private static boolean isMagic(char c) {
        return c < charToEntityMap.length && charToEntityMap[c] != null;
    }

    private static String quote(String string) {
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (!DescriptorSupport.isMagic(string.charAt(i))) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (DescriptorSupport.isMagic(c)) {
                stringBuffer.append(charToEntityMap[c]);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String unquote(String string) throws XMLParseException {
        if (!string.startsWith("\"") || !string.endsWith("\"")) {
            throw new XMLParseException("Value must be quoted: <" + string + ">");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length() - 1;
        for (int i = 1; i < n; ++i) {
            Character c;
            int n2;
            char c2 = string.charAt(i);
            if (c2 == '&' && (n2 = string.indexOf(59, i + 1)) >= 0 && (c = entityToCharMap.get(string.substring(i, n2 + 1))) != null) {
                stringBuffer.append(c);
                i = n2;
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private static String makeFieldValue(Object object) {
        if (object == null) {
            return "(null)";
        }
        Class<? extends Object> clazz = object.getClass();
        try {
            clazz.getConstructor(String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = "Class " + clazz + " does not have a public " + "constructor with a single string arg";
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            throw new RuntimeOperationsException(illegalArgumentException, "Cannot make XML descriptor");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        String string = DescriptorSupport.quote(object.toString());
        return "(" + clazz.getName() + "/" + string + ")";
    }

    private static Object parseQuotedFieldValue(String string) throws XMLParseException {
        Constructor<?> constructor;
        Object object;
        if ((string = DescriptorSupport.unquote(string)).equalsIgnoreCase("(null)")) {
            return null;
        }
        if (!string.startsWith("(") || !string.endsWith(")")) {
            return string;
        }
        int n = string.indexOf(47);
        if (n < 0) {
            return string.substring(1, string.length() - 1);
        }
        String string2 = string.substring(1, n);
        try {
            object = Thread.currentThread().getContextClassLoader();
            if (object == null) {
                ReflectUtil.checkPackageAccess(string2);
            }
            Class<?> clazz = Class.forName(string2, false, (ClassLoader)object);
            constructor = clazz.getConstructor(String.class);
        }
        catch (Exception exception) {
            throw new XMLParseException(exception, "Cannot parse value: <" + string + ">");
        }
        object = string.substring(n + 1, string.length() - 1);
        try {
            return constructor.newInstance(object);
        }
        catch (Exception exception) {
            String string3 = "Cannot construct instance of " + string2 + " with arg: <" + string + ">";
            throw new XMLParseException(exception, string3);
        }
    }

    public synchronized String toString() {
        if (this.tracing()) {
            this.trace("Descriptor.toString()", "Entry");
        }
        String string = "";
        String[] stringArray = this.getFields();
        if (this.tracing()) {
            this.trace("Descriptor.toString()", "Printing " + stringArray.length + " fields");
        }
        if (stringArray == null || stringArray.length == 0) {
            if (this.tracing()) {
                this.trace("Descriptor.toString()", "Empty Descriptor");
            }
            return string;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string = i == stringArray.length - 1 ? string.concat(stringArray[i]) : string.concat(stringArray[i] + ", ");
        }
        if (this.tracing()) {
            this.trace("Descriptor.toString()", "Exit returning " + string);
        }
        return string;
    }

    private long toNumeric(String string) {
        long l = -2L;
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            return -2L;
        }
        return l;
    }

    private boolean tracing() {
        return Trace.isSelected(1, 128);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 128, string, string2, Integer.toHexString(this.hashCode()) + " " + string3);
    }

    private void trace(String string, String string2) {
        this.trace(currClass, string, string2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Map map = (Map)getField.get("descriptor", null);
        this.init(null);
        this.descriptorMap.putAll(map);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        HashMap<Object, Object> hashMap;
        SortedMap<String, Object> sortedMap;
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        boolean bl = "1.0".equals(serialForm);
        if (bl) {
            putField.put("currClass", currClass);
        }
        if ((sortedMap = this.descriptorMap).containsKey("targetObject")) {
            sortedMap = new TreeMap<String, Object>(this.descriptorMap);
            sortedMap.remove("targetObject");
        }
        if (bl || "1.2.0".equals(serialForm) || "1.2.1".equals(serialForm)) {
            hashMap = new HashMap();
            for (Map.Entry entry : sortedMap.entrySet()) {
                hashMap.put(((String)entry.getKey()).toLowerCase(), entry.getValue());
            }
        } else {
            hashMap = new HashMap<String, Object>(sortedMap);
        }
        putField.put("descriptor", hashMap);
        objectOutputStream.writeFields();
    }

    static {
        String string = null;
        int n = 0;
        try {
            GetPropertyAction getPropertyAction = new GetPropertyAction("jmx.serial.form");
            string = (String)AccessController.doPrivileged(getPropertyAction);
            n = "1.0".equals(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        serialForm = string;
        if (n != 0) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = 8071560848919417985L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = -6292969195866300415L;
        }
        entities = new String[]{" &#32;", "\"&quot;", "<&lt;", ">&gt;", "&&amp;", "\r&#13;", "\t&#9;", "\n&#10;", "\f&#12;"};
        entityToCharMap = new HashMap<String, Character>();
        char c = '\u0000';
        for (n = 0; n < entities.length; ++n) {
            char c2 = entities[n].charAt(0);
            if (c2 <= c) continue;
            c = c2;
        }
        charToEntityMap = new String[c + 1];
        for (n = 0; n < entities.length; ++n) {
            String string2;
            char c3 = entities[n].charAt(0);
            DescriptorSupport.charToEntityMap[c3] = string2 = entities[n].substring(1);
            entityToCharMap.put(string2, new Character(c3));
        }
    }
}

