/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.SystemEventQueueUtilities;
import sun.security.action.GetPropertyAction;

public class RepaintManager {
    private Map volatileMap = new HashMap(1);
    Hashtable dirtyComponents = new Hashtable();
    Hashtable tmpDirtyComponents = new Hashtable();
    Vector invalidComponents;
    boolean doubleBufferingEnabled = true;
    private Dimension doubleBufferMaxSize;
    DoubleBufferInfo standardDoubleBuffer;
    private static final Object repaintManagerKey = RepaintManager.class;
    static boolean volatileImageBufferEnabled = true;
    static final int VOLATILE_LOOP_MAX = 2;
    Rectangle tmp = new Rectangle();

    public static RepaintManager currentManager(Component component) {
        RepaintManager repaintManager = (RepaintManager)SwingUtilities.appContextGet(repaintManagerKey);
        if (repaintManager == null) {
            repaintManager = new RepaintManager();
            SwingUtilities.appContextPut(repaintManagerKey, repaintManager);
        }
        return repaintManager;
    }

    public static RepaintManager currentManager(JComponent jComponent) {
        return RepaintManager.currentManager((Component)jComponent);
    }

    public static void setCurrentManager(RepaintManager repaintManager) {
        if (repaintManager != null) {
            SwingUtilities.appContextPut(repaintManagerKey, repaintManager);
        } else {
            SwingUtilities.appContextRemove(repaintManagerKey);
        }
    }

    public RepaintManager() {
        Object t = AccessController.doPrivileged(new GetPropertyAction("awt.nativeDoubleBuffering"));
        boolean bl = t != null ? Boolean.valueOf(t.toString()) : false;
        this.doubleBufferingEnabled = !bl;
    }

    public synchronized void addInvalidComponent(JComponent jComponent) {
        Component component;
        Component component2 = null;
        for (component = jComponent; component != null; component = component.getParent()) {
            if (component instanceof CellRendererPane || component.getPeer() == null) {
                return;
            }
            if (!(component instanceof JComponent) || !component.isValidateRoot()) continue;
            component2 = component;
            break;
        }
        if (component2 == null) {
            return;
        }
        component = null;
        for (Component component3 = component2; component3 != null; component3 = component3.getParent()) {
            if (!component3.isVisible() || component3.getPeer() == null) {
                return;
            }
            if (!(component3 instanceof Window) && !(component3 instanceof Applet)) continue;
            component = component3;
            break;
        }
        if (component == null) {
            return;
        }
        if (this.invalidComponents == null) {
            this.invalidComponents = new Vector();
        } else {
            int n = this.invalidComponents.size();
            for (int i = 0; i < n; ++i) {
                if (component2 != (Component)this.invalidComponents.elementAt(i)) continue;
                return;
            }
        }
        this.invalidComponents.addElement(component2);
        SystemEventQueueUtilities.queueComponentWorkRequest(component);
    }

    public synchronized void removeInvalidComponent(JComponent jComponent) {
        int n;
        if (this.invalidComponents != null && (n = this.invalidComponents.indexOf(jComponent)) != -1) {
            this.invalidComponents.removeElementAt(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
        Object object;
        if (n3 <= 0 || n4 <= 0 || jComponent == null) {
            return;
        }
        if (jComponent.getWidth() <= 0 || jComponent.getHeight() <= 0) {
            return;
        }
        if (this.extendDirtyRegion(jComponent, n, n2, n3, n4)) {
            return;
        }
        Object object2 = null;
        for (object = jComponent; object != null; object = ((Component)object).getParent()) {
            if (!((Component)object).isVisible() || ((Component)object).getPeer() == null) {
                return;
            }
            if (!(object instanceof Window) && !(object instanceof Applet)) continue;
            if (object instanceof Frame && (((Frame)object).getExtendedState() & 1) == 1) {
                return;
            }
            object2 = object;
            break;
        }
        if (object2 == null) {
            return;
        }
        object = this;
        synchronized (object) {
            if (this.extendDirtyRegion(jComponent, n, n2, n3, n4)) {
                return;
            }
            this.dirtyComponents.put(jComponent, new Rectangle(n, n2, n3, n4));
        }
        SystemEventQueueUtilities.queueComponentWorkRequest((Component)object2);
    }

    private synchronized boolean extendDirtyRegion(Component component, int n, int n2, int n3, int n4) {
        Rectangle rectangle = (Rectangle)this.dirtyComponents.get(component);
        if (rectangle != null) {
            SwingUtilities.computeUnion(n, n2, n3, n4, rectangle);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getDirtyRegion(JComponent jComponent) {
        Rectangle rectangle = null;
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            rectangle = (Rectangle)this.dirtyComponents.get(jComponent);
        }
        if (rectangle == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(rectangle);
    }

    public void markCompletelyDirty(JComponent jComponent) {
        this.addDirtyRegion(jComponent, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCompletelyClean(JComponent jComponent) {
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            this.dirtyComponents.remove(jComponent);
        }
    }

    public boolean isCompletelyDirty(JComponent jComponent) {
        Rectangle rectangle = this.getDirtyRegion(jComponent);
        return rectangle.width == Integer.MAX_VALUE && rectangle.height == Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateInvalidComponents() {
        Vector vector;
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            if (this.invalidComponents == null) {
                return;
            }
            vector = this.invalidComponents;
            this.invalidComponents = null;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((Component)vector.elementAt(i)).validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDirtyRegions() {
        JComponent jComponent;
        Object object = this;
        synchronized (object) {
            Hashtable hashtable = this.tmpDirtyComponents;
            this.tmpDirtyComponents = this.dirtyComponents;
            this.dirtyComponents = hashtable;
            this.dirtyComponents.clear();
        }
        int n = this.tmpDirtyComponents.size();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Vector vector = new Vector(n);
        Enumeration enumeration = this.tmpDirtyComponents.keys();
        while (enumeration.hasMoreElements()) {
            jComponent = (JComponent)enumeration.nextElement();
            this.collectDirtyComponents(this.tmpDirtyComponents, jComponent, vector);
        }
        n = vector.size();
        for (int i = 0; i < n; ++i) {
            ComponentPeer componentPeer;
            Container container;
            jComponent = (JComponent)vector.elementAt(i);
            object = (Rectangle)this.tmpDirtyComponents.get(jComponent);
            n4 = jComponent.getHeight();
            n5 = jComponent.getWidth();
            SwingUtilities.computeIntersection(n2, n3, n5, n4, (Rectangle)object);
            if (((Rectangle)object).x == 0 && ((Rectangle)object).y == 0 && ((Rectangle)object).width == jComponent.getWidth() && ((Rectangle)object).height == jComponent.getHeight() && (container = jComponent.getParent()) != null && !container.isLightweight() && (componentPeer = container.getPeer()) != null) {
                ((ContainerPeer)componentPeer).cancelPendingPaint(jComponent.getX(), jComponent.getY(), ((Rectangle)object).width, ((Rectangle)object).height);
            }
            jComponent.paintImmediately(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
        }
        this.tmpDirtyComponents.clear();
    }

    void collectDirtyComponents(Hashtable hashtable, JComponent jComponent, Vector vector) {
        Container container;
        Container container2 = jComponent;
        Container container3 = container2;
        int n = jComponent.getX();
        int n2 = jComponent.getY();
        int n3 = jComponent.getWidth();
        int n4 = jComponent.getHeight();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        this.tmp.setBounds((Rectangle)hashtable.get(jComponent));
        SwingUtilities.computeIntersection(0, 0, n3, n4, this.tmp);
        if (this.tmp.isEmpty()) {
            return;
        }
        while ((container = container3.getParent()) != null && container instanceof JComponent) {
            container3 = container;
            n6 += n;
            n8 += n2;
            this.tmp.setLocation(this.tmp.x + n, this.tmp.y + n2);
            n = container3.getX();
            n2 = container3.getY();
            n3 = container3.getWidth();
            n4 = container3.getHeight();
            this.tmp = SwingUtilities.computeIntersection(0, 0, n3, n4, this.tmp);
            if (this.tmp.isEmpty()) {
                return;
            }
            if (hashtable.get(container3) == null) continue;
            container2 = container3;
            n5 = n6;
            n7 = n8;
        }
        if (jComponent != container2) {
            this.tmp.setLocation(this.tmp.x + n5 - n6, this.tmp.y + n7 - n8);
            Rectangle rectangle = (Rectangle)hashtable.get(container2);
            SwingUtilities.computeUnion(this.tmp.x, this.tmp.y, this.tmp.width, this.tmp.height, rectangle);
        }
        if (!vector.contains(container2)) {
            vector.addElement(container2);
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.dirtyComponents != null) {
            stringBuffer.append("" + this.dirtyComponents);
        }
        return stringBuffer.toString();
    }

    public Image getOffscreenBuffer(Component component, int n, int n2) {
        return this._getOffscreenBuffer(component, n, n2);
    }

    public Image getVolatileOffscreenBuffer(Component component, int n, int n2) {
        int n3;
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Dimension dimension = this.getDoubleBufferMaximumSize();
        int n4 = n < 1 ? 1 : (n3 = n > dimension.width ? dimension.width : n);
        int n5 = n2 < 1 ? 1 : (n2 > dimension.height ? dimension.height : n2);
        VolatileImage volatileImage = (VolatileImage)this.volatileMap.get(graphicsConfiguration);
        if (volatileImage == null || volatileImage.getWidth() < n3 || volatileImage.getHeight() < n5) {
            if (volatileImage != null) {
                volatileImage.flush();
            }
            volatileImage = graphicsConfiguration.createCompatibleVolatileImage(n3, n5);
            this.volatileMap.put(graphicsConfiguration, volatileImage);
        }
        return volatileImage;
    }

    private Image _getOffscreenBuffer(Component component, int n, int n2) {
        int n3;
        int n4;
        Dimension dimension = this.getDoubleBufferMaximumSize();
        DoubleBufferInfo doubleBufferInfo = null;
        if (this.standardDoubleBuffer == null) {
            this.standardDoubleBuffer = new DoubleBufferInfo();
        }
        doubleBufferInfo = this.standardDoubleBuffer;
        int n5 = n < 1 ? 1 : (n4 = n > dimension.width ? dimension.width : n);
        int n6 = n2 < 1 ? 1 : (n3 = n2 > dimension.height ? dimension.height : n2);
        if (doubleBufferInfo.needsReset || doubleBufferInfo.image != null && (doubleBufferInfo.size.width < n4 || doubleBufferInfo.size.height < n3)) {
            doubleBufferInfo.needsReset = false;
            if (doubleBufferInfo.image != null) {
                doubleBufferInfo.image.flush();
                doubleBufferInfo.image = null;
            }
            n4 = Math.max(doubleBufferInfo.size.width, n4);
            n3 = Math.max(doubleBufferInfo.size.height, n3);
        }
        Image image = doubleBufferInfo.image;
        if (doubleBufferInfo.image == null) {
            image = component.createImage(n4, n3);
            doubleBufferInfo.size = new Dimension(n4, n3);
            if (component instanceof JComponent) {
                ((JComponent)component).setCreatedDoubleBuffer(true);
                doubleBufferInfo.image = image;
            }
        }
        return image;
    }

    public void setDoubleBufferMaximumSize(Dimension dimension) {
        this.doubleBufferMaxSize = dimension;
        if (this.standardDoubleBuffer != null && this.standardDoubleBuffer.image != null && (this.standardDoubleBuffer.image.getWidth(null) > dimension.width || this.standardDoubleBuffer.image.getHeight(null) > dimension.height)) {
            this.standardDoubleBuffer.image = null;
        }
        Iterator iterator = this.volatileMap.keySet().iterator();
        while (iterator.hasNext()) {
            GraphicsConfiguration graphicsConfiguration = (GraphicsConfiguration)iterator.next();
            VolatileImage volatileImage = (VolatileImage)this.volatileMap.get(graphicsConfiguration);
            if (volatileImage.getWidth() <= dimension.width && volatileImage.getHeight() <= dimension.height) continue;
            volatileImage.flush();
            iterator.remove();
        }
    }

    public Dimension getDoubleBufferMaximumSize() {
        if (this.doubleBufferMaxSize == null) {
            try {
                Rectangle rectangle = new Rectangle();
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                for (GraphicsDevice graphicsDevice : graphicsEnvironment.getScreenDevices()) {
                    GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
                    rectangle = rectangle.union(graphicsConfiguration.getBounds());
                }
                this.doubleBufferMaxSize = new Dimension(rectangle.width, rectangle.height);
            }
            catch (HeadlessException headlessException) {
                this.doubleBufferMaxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
        }
        return this.doubleBufferMaxSize;
    }

    public void setDoubleBufferingEnabled(boolean bl) {
        this.doubleBufferingEnabled = bl;
    }

    public boolean isDoubleBufferingEnabled() {
        return this.doubleBufferingEnabled;
    }

    void resetDoubleBuffer() {
        if (this.standardDoubleBuffer != null) {
            this.standardDoubleBuffer.needsReset = true;
        }
    }

    void resetVolatileDoubleBuffer(GraphicsConfiguration graphicsConfiguration) {
        Image image = (Image)this.volatileMap.remove(graphicsConfiguration);
        if (image != null) {
            image.flush();
        }
    }

    boolean useVolatileDoubleBuffer() {
        return volatileImageBufferEnabled;
    }

    static {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("swing.volatileImageBufferEnabled"));
        volatileImageBufferEnabled = string == null || string.equals("true");
    }

    private class DoubleBufferInfo {
        public Image image;
        public Dimension size;
        public boolean needsReset = false;

        private DoubleBufferInfo() {
        }
    }
}

