/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthProgressBarUI
extends BasicProgressBarUI
implements SynthUI,
PropertyChangeListener {
    private SynthStyle style;
    private int progressPadding;

    SynthProgressBarUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthProgressBarUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.progressBar.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.progressBar.removePropertyChangeListener(this);
    }

    protected void installDefaults() {
        this.updateStyle(this.progressBar);
    }

    private void updateStyle(JProgressBar jProgressBar) {
        SynthContext synthContext = this.getContext(jProgressBar, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.setCellLength(this.style.getInt(synthContext, "ProgressBar.cellLength", 1));
            this.setCellSpacing(this.style.getInt(synthContext, "ProgressBar.cellSpacing", 0));
            this.progressPadding = this.style.getInt(synthContext, "ProgressBar.progressPadding", 0);
        }
        synthContext.dispose();
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.progressBar, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintProgressBarBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        JProgressBar jProgressBar = (JProgressBar)synthContext.getComponent();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (!jProgressBar.isIndeterminate()) {
            Insets insets = jProgressBar.getInsets();
            double d = jProgressBar.getPercentComplete();
            if (d != 0.0) {
                if (jProgressBar.getOrientation() == 0) {
                    n = insets.left + this.progressPadding;
                    n2 = insets.top + this.progressPadding;
                    n3 = (int)(d * (double)(jProgressBar.getWidth() - (insets.left + this.progressPadding + insets.right + this.progressPadding)));
                    n4 = jProgressBar.getHeight() - (insets.top + this.progressPadding + insets.bottom + this.progressPadding);
                    if (!SynthLookAndFeel.isLeftToRight(jProgressBar)) {
                        n = jProgressBar.getWidth() - insets.right - n3 - this.progressPadding;
                    }
                } else {
                    n = insets.left + this.progressPadding;
                    n3 = jProgressBar.getWidth() - (insets.left + this.progressPadding + insets.right + this.progressPadding);
                    n4 = (int)(d * (double)(jProgressBar.getHeight() - (insets.top + this.progressPadding + insets.bottom + this.progressPadding)));
                    n2 = jProgressBar.getHeight() - insets.bottom - n4 - this.progressPadding;
                }
            }
        } else {
            this.boxRect = this.getBox(this.boxRect);
            n = this.boxRect.x + this.progressPadding;
            n2 = this.boxRect.y + this.progressPadding;
            n3 = this.boxRect.width - this.progressPadding - this.progressPadding;
            n4 = this.boxRect.height - this.progressPadding - this.progressPadding;
        }
        synthContext.getPainter().paintProgressBarForeground(synthContext, graphics, n, n2, n3, n4, jProgressBar.getOrientation());
        if (jProgressBar.isStringPainted() && !jProgressBar.isIndeterminate()) {
            this.paintText(synthContext, graphics, jProgressBar.getString());
        }
    }

    protected void paintText(SynthContext synthContext, Graphics graphics, String string) {
        Font font = synthContext.getStyle().getFont(synthContext);
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(this.progressBar, graphics, font);
        if (this.progressBar.isStringPainted()) {
            String string2 = this.progressBar.getString();
            Rectangle rectangle = this.progressBar.getBounds();
            int n = synthContext.getStyle().getGraphicsUtils(synthContext).computeStringWidth(synthContext, font, fontMetrics, string2);
            Rectangle rectangle2 = new Rectangle(rectangle.width / 2 - n / 2, (rectangle.height - (fontMetrics.getAscent() + fontMetrics.getDescent())) / 2, 0, 0);
            if (rectangle2.y < 0) {
                return;
            }
            SynthStyle synthStyle = synthContext.getStyle();
            graphics.setColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            graphics.setFont(synthStyle.getFont(synthContext));
            synthStyle.getGraphicsUtils(synthContext).paintText(synthContext, graphics, string, rectangle2.x, rectangle2.y, -1);
        }
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintProgressBarBorder(synthContext, graphics, n, n2, n3, n4);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JProgressBar)propertyChangeEvent.getSource());
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Insets insets = this.progressBar.getInsets();
        FontMetrics fontMetrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
        Dimension dimension = this.progressBar.getOrientation() == 0 ? new Dimension(this.getPreferredInnerHorizontal()) : new Dimension(this.getPreferredInnerVertical());
        if (this.progressBar.isStringPainted()) {
            int n;
            String string = this.progressBar.getString();
            int n2 = fontMetrics.getHeight() + fontMetrics.getDescent();
            if (n2 > dimension.height) {
                dimension.height = n2;
            }
            if ((n = SwingUtilities2.stringWidth(this.progressBar, fontMetrics, string)) > dimension.width) {
                dimension.width = n;
            }
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }
}

