/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.io.Serializable;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class DefaultTableModel
extends AbstractTableModel
implements Serializable {
    protected Vector dataVector;
    protected Vector columnIdentifiers;

    public DefaultTableModel() {
        this(0, 0);
    }

    private static Vector newVector(int n) {
        Vector vector = new Vector(n);
        vector.setSize(n);
        return vector;
    }

    public DefaultTableModel(int n, int n2) {
        this(DefaultTableModel.newVector(n2), n);
    }

    public DefaultTableModel(Vector vector, int n) {
        this.setDataVector(DefaultTableModel.newVector(n), vector);
    }

    public DefaultTableModel(Object[] objectArray, int n) {
        this(DefaultTableModel.convertToVector(objectArray), n);
    }

    public DefaultTableModel(Vector vector, Vector vector2) {
        this.setDataVector(vector, vector2);
    }

    public DefaultTableModel(Object[][] objectArray, Object[] objectArray2) {
        this.setDataVector(objectArray, objectArray2);
    }

    public Vector getDataVector() {
        return this.dataVector;
    }

    private static Vector nonNullVector(Vector vector) {
        return vector != null ? vector : new Vector();
    }

    public void setDataVector(Vector vector, Vector vector2) {
        this.dataVector = DefaultTableModel.nonNullVector(vector);
        this.columnIdentifiers = DefaultTableModel.nonNullVector(vector2);
        this.justifyRows(0, this.getRowCount());
        this.fireTableStructureChanged();
    }

    public void setDataVector(Object[][] objectArray, Object[] objectArray2) {
        this.setDataVector(DefaultTableModel.convertToVector(objectArray), DefaultTableModel.convertToVector(objectArray2));
    }

    public void newDataAvailable(TableModelEvent tableModelEvent) {
        this.fireTableChanged(tableModelEvent);
    }

    private void justifyRows(int n, int n2) {
        this.dataVector.setSize(this.getRowCount());
        for (int i = n; i < n2; ++i) {
            if (this.dataVector.elementAt(i) == null) {
                this.dataVector.setElementAt(new Vector(), i);
            }
            ((Vector)this.dataVector.elementAt(i)).setSize(this.getColumnCount());
        }
    }

    public void newRowsAdded(TableModelEvent tableModelEvent) {
        this.justifyRows(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow() + 1);
        this.fireTableChanged(tableModelEvent);
    }

    public void rowsRemoved(TableModelEvent tableModelEvent) {
        this.fireTableChanged(tableModelEvent);
    }

    public void setNumRows(int n) {
        int n2 = this.getRowCount();
        if (n2 == n) {
            return;
        }
        this.dataVector.setSize(n);
        if (n <= n2) {
            this.fireTableRowsDeleted(n, n2 - 1);
        } else {
            this.justifyRows(n2, n);
            this.fireTableRowsInserted(n2, n - 1);
        }
    }

    public void setRowCount(int n) {
        this.setNumRows(n);
    }

    public void addRow(Vector vector) {
        this.insertRow(this.getRowCount(), vector);
    }

    public void addRow(Object[] objectArray) {
        this.addRow(DefaultTableModel.convertToVector(objectArray));
    }

    public void insertRow(int n, Vector vector) {
        this.dataVector.insertElementAt(vector, n);
        this.justifyRows(n, n + 1);
        this.fireTableRowsInserted(n, n);
    }

    public void insertRow(int n, Object[] objectArray) {
        this.insertRow(n, DefaultTableModel.convertToVector(objectArray));
    }

    private static int gcd(int n, int n2) {
        return n2 == 0 ? n : DefaultTableModel.gcd(n2, n % n2);
    }

    private static void rotate(Vector vector, int n, int n2, int n3) {
        int n4 = n2 - n;
        int n5 = n4 - n3;
        int n6 = DefaultTableModel.gcd(n4, n5);
        for (int i = 0; i < n6; ++i) {
            int n7 = i;
            Object e = vector.elementAt(n + n7);
            int n8 = (n7 + n5) % n4;
            while (n8 != i) {
                vector.setElementAt(vector.elementAt(n + n8), n + n7);
                n7 = n8;
                n8 = (n7 + n5) % n4;
            }
            vector.setElementAt(e, n + n7);
        }
    }

    public void moveRow(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n3 - n;
        if (n6 < 0) {
            n5 = n3;
            n4 = n2;
        } else {
            n5 = n;
            n4 = n3 + n2 - n;
        }
        DefaultTableModel.rotate(this.dataVector, n5, n4 + 1, n6);
        this.fireTableRowsUpdated(n5, n4);
    }

    public void removeRow(int n) {
        this.dataVector.removeElementAt(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void setColumnIdentifiers(Vector vector) {
        this.setDataVector(this.dataVector, vector);
    }

    public void setColumnIdentifiers(Object[] objectArray) {
        this.setColumnIdentifiers(DefaultTableModel.convertToVector(objectArray));
    }

    public void setColumnCount(int n) {
        this.columnIdentifiers.setSize(n);
        this.justifyRows(0, this.getRowCount());
        this.fireTableStructureChanged();
    }

    public void addColumn(Object object) {
        this.addColumn(object, (Vector)null);
    }

    public void addColumn(Object object, Vector vector) {
        this.columnIdentifiers.addElement(object);
        if (vector != null) {
            int n = vector.size();
            if (n > this.getRowCount()) {
                this.dataVector.setSize(n);
            }
            this.justifyRows(0, this.getRowCount());
            int n2 = this.getColumnCount() - 1;
            for (int i = 0; i < n; ++i) {
                Vector vector2 = (Vector)this.dataVector.elementAt(i);
                vector2.setElementAt(vector.elementAt(i), n2);
            }
        } else {
            this.justifyRows(0, this.getRowCount());
        }
        this.fireTableStructureChanged();
    }

    public void addColumn(Object object, Object[] objectArray) {
        this.addColumn(object, DefaultTableModel.convertToVector(objectArray));
    }

    public int getRowCount() {
        return this.dataVector.size();
    }

    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    public String getColumnName(int n) {
        Object object = null;
        if (n < this.columnIdentifiers.size()) {
            object = this.columnIdentifiers.elementAt(n);
        }
        return object == null ? super.getColumnName(n) : object.toString();
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public Object getValueAt(int n, int n2) {
        Vector vector = (Vector)this.dataVector.elementAt(n);
        return vector.elementAt(n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        Vector vector = (Vector)this.dataVector.elementAt(n);
        vector.setElementAt(object, n2);
        this.fireTableCellUpdated(n, n2);
    }

    protected static Vector convertToVector(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.addElement(objectArray[i]);
        }
        return vector;
    }

    protected static Vector convertToVector(Object[][] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Vector<Vector> vector = new Vector<Vector>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.addElement(DefaultTableModel.convertToVector(objectArray[i]));
        }
        return vector;
    }
}

