/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class InternationalFormatter
extends DefaultFormatter {
    private static final Format.Field[] EMPTY_FIELD_ARRAY = new Format.Field[0];
    private Format format;
    private Comparable max;
    private Comparable min;
    private transient BitSet literalMask;
    private transient AttributedCharacterIterator iterator;
    private transient boolean validMask;
    private transient String string;
    private transient boolean ignoreDocumentMutate;

    public InternationalFormatter() {
        this.setOverwriteMode(false);
    }

    public InternationalFormatter(Format format) {
        this();
        this.setFormat(format);
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setMinimum(Comparable comparable) {
        if (this.getValueClass() == null && comparable != null) {
            this.setValueClass(comparable.getClass());
        }
        this.min = comparable;
    }

    public Comparable getMinimum() {
        return this.min;
    }

    public void setMaximum(Comparable comparable) {
        if (this.getValueClass() == null && comparable != null) {
            this.setValueClass(comparable.getClass());
        }
        this.max = comparable;
    }

    public Comparable getMaximum() {
        return this.max;
    }

    public void install(JFormattedTextField jFormattedTextField) {
        super.install(jFormattedTextField);
        this.updateMaskIfNecessary();
        this.positionCursorAtInitialLocation();
    }

    public String valueToString(Object object) throws ParseException {
        if (object == null) {
            return "";
        }
        Format format = this.getFormat();
        if (format == null) {
            return object.toString();
        }
        return format.format(object);
    }

    public Object stringToValue(String string) throws ParseException {
        Object object = this.stringToValue(string, this.getFormat());
        if (object != null && this.getValueClass() != null && !this.getValueClass().isInstance(object)) {
            object = super.stringToValue(object.toString());
        }
        try {
            if (!this.isValidValue(object, true)) {
                throw new ParseException("Value not within min/max range", 0);
            }
        }
        catch (ClassCastException classCastException) {
            throw new ParseException("Class cast exception comparing values: " + classCastException, 0);
        }
        return object;
    }

    public Format.Field[] getFields(int n) {
        Map map;
        if (this.getAllowsInvalid()) {
            this.updateMask();
        }
        if ((map = this.getAttributes(n)) != null && map.size() > 0) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(map.keySet());
            return arrayList.toArray(EMPTY_FIELD_ARRAY);
        }
        return EMPTY_FIELD_ARRAY;
    }

    public Object clone() throws CloneNotSupportedException {
        InternationalFormatter internationalFormatter = (InternationalFormatter)super.clone();
        internationalFormatter.literalMask = null;
        internationalFormatter.iterator = null;
        internationalFormatter.validMask = false;
        internationalFormatter.string = null;
        return internationalFormatter;
    }

    protected Action[] getActions() {
        if (this.getSupportsIncrement()) {
            return new Action[]{new IncrementAction("increment", 1), new IncrementAction("decrement", -1)};
        }
        return null;
    }

    Object stringToValue(String string, Format format) throws ParseException {
        if (format == null) {
            return string;
        }
        return format.parseObject(string);
    }

    boolean isValidValue(Object object, boolean bl) {
        Comparable comparable = this.getMinimum();
        try {
            if (comparable != null && comparable.compareTo(object) > 0) {
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            if (bl) {
                throw classCastException;
            }
            return false;
        }
        Comparable comparable2 = this.getMaximum();
        try {
            if (comparable2 != null && comparable2.compareTo(object) < 0) {
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            if (bl) {
                throw classCastException;
            }
            return false;
        }
        return true;
    }

    Map getAttributes(int n) {
        if (this.isValidMask()) {
            AttributedCharacterIterator attributedCharacterIterator = this.getIterator();
            if (n >= 0 && n <= attributedCharacterIterator.getEndIndex()) {
                attributedCharacterIterator.setIndex(n);
                return attributedCharacterIterator.getAttributes();
            }
        }
        return null;
    }

    int getAttributeStart(AttributedCharacterIterator.Attribute attribute) {
        if (this.isValidMask()) {
            AttributedCharacterIterator attributedCharacterIterator = this.getIterator();
            attributedCharacterIterator.first();
            while (attributedCharacterIterator.current() != '\uffff') {
                if (attributedCharacterIterator.getAttribute(attribute) != null) {
                    return attributedCharacterIterator.getIndex();
                }
                attributedCharacterIterator.next();
            }
        }
        return -1;
    }

    AttributedCharacterIterator getIterator() {
        return this.iterator;
    }

    void updateMaskIfNecessary() {
        if (!this.getAllowsInvalid() && this.getFormat() != null) {
            if (!this.isValidMask()) {
                this.updateMask();
            } else {
                String string = this.getFormattedTextField().getText();
                if (!string.equals(this.string)) {
                    this.updateMask();
                }
            }
        }
    }

    void updateMask() {
        if (this.getFormat() != null) {
            Document document = this.getFormattedTextField().getDocument();
            this.validMask = false;
            if (document != null) {
                try {
                    this.string = document.getText(0, document.getLength());
                }
                catch (BadLocationException badLocationException) {
                    this.string = null;
                }
                if (this.string != null) {
                    try {
                        Object object = this.stringToValue(this.string);
                        AttributedCharacterIterator attributedCharacterIterator = this.getFormat().formatToCharacterIterator(object);
                        this.updateMask(attributedCharacterIterator);
                    }
                    catch (ParseException parseException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    int getLiteralCountTo(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.isLiteral(i)) continue;
            ++n2;
        }
        return n2;
    }

    boolean isLiteral(int n) {
        if (this.isValidMask() && n < this.string.length()) {
            return this.literalMask.get(n);
        }
        return false;
    }

    char getLiteral(int n) {
        if (this.isValidMask() && this.string != null && n < this.string.length()) {
            return this.string.charAt(n);
        }
        return '\u0000';
    }

    boolean isNavigatable(int n) {
        return !this.isLiteral(n);
    }

    void updateValue(Object object) {
        super.updateValue(object);
        this.updateMaskIfNecessary();
    }

    void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.ignoreDocumentMutate) {
            filterBypass.replace(n, n2, string, attributeSet);
            return;
        }
        super.replace(filterBypass, n, n2, string, attributeSet);
    }

    private int getNextNonliteralIndex(int n, int n2) {
        int n3 = this.getFormattedTextField().getDocument().getLength();
        while (n >= 0 && n < n3) {
            if (this.isLiteral(n)) {
                n += n2;
                continue;
            }
            return n;
        }
        return n2 == -1 ? 0 : n3;
    }

    boolean canReplace(DefaultFormatter.ReplaceHolder replaceHolder) {
        if (!this.getAllowsInvalid()) {
            int n;
            String string = replaceHolder.text;
            int n2 = n = string != null ? string.length() : 0;
            if (n == 0 && replaceHolder.length == 1 && this.getFormattedTextField().getSelectionStart() != replaceHolder.offset) {
                replaceHolder.offset = this.getNextNonliteralIndex(replaceHolder.offset, -1);
            }
            if (this.getOverwriteMode()) {
                StringBuffer stringBuffer = null;
                int n3 = 0;
                int n4 = Math.max(n, replaceHolder.length);
                for (int i = 0; i < n4; ++i) {
                    if (this.isLiteral(replaceHolder.offset + i)) {
                        if (stringBuffer != null) {
                            stringBuffer.append(this.getLiteral(replaceHolder.offset + i));
                        }
                        if (n3 < n && string.charAt(n3) == this.getLiteral(replaceHolder.offset + i)) {
                            ++n3;
                            continue;
                        }
                        if (n3 == 0) {
                            ++replaceHolder.offset;
                            --replaceHolder.length;
                            --i;
                            --n4;
                            continue;
                        }
                        if (stringBuffer != null) continue;
                        stringBuffer = new StringBuffer(n4);
                        stringBuffer.append(string.substring(0, n3));
                        stringBuffer.append(this.getLiteral(replaceHolder.offset + i));
                        continue;
                    }
                    if (n3 < n) {
                        if (stringBuffer != null) {
                            stringBuffer.append(string.charAt(n3));
                        }
                        ++n3;
                        continue;
                    }
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(n4);
                        if (n3 > 0) {
                            stringBuffer.append(string.substring(0, n3));
                        }
                    }
                    if (stringBuffer == null) continue;
                    stringBuffer.append(' ');
                }
                if (stringBuffer != null) {
                    replaceHolder.text = stringBuffer.toString();
                }
            } else {
                replaceHolder.offset = n > 0 ? this.getNextNonliteralIndex(replaceHolder.offset, 1) : this.getNextNonliteralIndex(replaceHolder.offset, -1);
            }
            ((ExtendedReplaceHolder)replaceHolder).endOffset = replaceHolder.offset;
            ((ExtendedReplaceHolder)replaceHolder).endTextLength = replaceHolder.text != null ? replaceHolder.text.length() : 0;
        } else {
            ((ExtendedReplaceHolder)replaceHolder).endOffset = replaceHolder.offset;
            ((ExtendedReplaceHolder)replaceHolder).endTextLength = replaceHolder.text != null ? replaceHolder.text.length() : 0;
        }
        boolean bl = super.canReplace(replaceHolder);
        if (bl && !this.getAllowsInvalid()) {
            ((ExtendedReplaceHolder)replaceHolder).resetFromValue(this);
        }
        return bl;
    }

    boolean replace(DefaultFormatter.ReplaceHolder replaceHolder) throws BadLocationException {
        int n = -1;
        int n2 = 1;
        int n3 = -1;
        if (!(replaceHolder.length <= 0 || replaceHolder.text != null && replaceHolder.text.length() != 0 || this.getFormattedTextField().getSelectionStart() == replaceHolder.offset && replaceHolder.length <= 1)) {
            n2 = -1;
        }
        if (!this.getAllowsInvalid()) {
            n = (replaceHolder.text == null || replaceHolder.text.length() == 0) && replaceHolder.length > 0 ? this.getFormattedTextField().getSelectionStart() : replaceHolder.offset;
            n3 = this.getLiteralCountTo(n);
        }
        if (super.replace(replaceHolder)) {
            if (n != -1) {
                int n4 = ((ExtendedReplaceHolder)replaceHolder).endOffset;
                this.repositionCursor(n3, n4 += ((ExtendedReplaceHolder)replaceHolder).endTextLength, n2);
            } else {
                n = ((ExtendedReplaceHolder)replaceHolder).endOffset;
                if (n2 == 1) {
                    n += ((ExtendedReplaceHolder)replaceHolder).endTextLength;
                }
                this.repositionCursor(n, n2);
            }
            return true;
        }
        return false;
    }

    private void repositionCursor(int n, int n2, int n3) {
        int n4 = this.getLiteralCountTo(n2);
        if (n4 != n2) {
            n2 -= n;
            for (int i = 0; i < n2; ++i) {
                if (!this.isLiteral(i)) continue;
                ++n2;
            }
        }
        this.repositionCursor(n2, 1);
    }

    char getBufferedChar(int n) {
        if (this.isValidMask() && this.string != null && n < this.string.length()) {
            return this.string.charAt(n);
        }
        return '\u0000';
    }

    boolean isValidMask() {
        return this.validMask;
    }

    boolean isLiteral(Map map) {
        return map == null || map.size() == 0;
    }

    private void updateMask(AttributedCharacterIterator attributedCharacterIterator) {
        if (attributedCharacterIterator != null) {
            this.validMask = true;
            this.iterator = attributedCharacterIterator;
            if (this.literalMask == null) {
                this.literalMask = new BitSet();
            } else {
                for (int i = this.literalMask.length() - 1; i >= 0; --i) {
                    this.literalMask.clear(i);
                }
            }
            attributedCharacterIterator.first();
            while (attributedCharacterIterator.current() != '\uffff') {
                int n;
                Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
                boolean bl = this.isLiteral(map);
                int n2 = attributedCharacterIterator.getRunLimit();
                for (n = attributedCharacterIterator.getIndex(); n < n2; ++n) {
                    if (bl) {
                        this.literalMask.set(n);
                        continue;
                    }
                    this.literalMask.clear(n);
                }
                attributedCharacterIterator.setIndex(n);
            }
        }
    }

    boolean canIncrement(Object object, int n) {
        return object != null;
    }

    void selectField(Object object, int n) {
        AttributedCharacterIterator attributedCharacterIterator = this.getIterator();
        if (attributedCharacterIterator != null && object instanceof AttributedCharacterIterator.Attribute) {
            AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)object;
            attributedCharacterIterator.first();
            while (attributedCharacterIterator.current() != '\uffff') {
                while (attributedCharacterIterator.getAttribute(attribute) == null && attributedCharacterIterator.next() != '\uffff') {
                }
                if (attributedCharacterIterator.current() == '\uffff') continue;
                int n2 = attributedCharacterIterator.getRunLimit(attribute);
                if (--n <= 0) {
                    this.getFormattedTextField().select(attributedCharacterIterator.getIndex(), n2);
                    break;
                }
                attributedCharacterIterator.setIndex(n2);
                attributedCharacterIterator.next();
            }
        }
    }

    Object getAdjustField(int n, Map map) {
        return null;
    }

    private int getFieldTypeCountTo(Object object, int n) {
        AttributedCharacterIterator attributedCharacterIterator = this.getIterator();
        int n2 = 0;
        if (attributedCharacterIterator != null && object instanceof AttributedCharacterIterator.Attribute) {
            AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)object;
            boolean bl = false;
            attributedCharacterIterator.first();
            while (attributedCharacterIterator.getIndex() < n) {
                while (attributedCharacterIterator.getAttribute(attribute) == null && attributedCharacterIterator.next() != '\uffff') {
                }
                if (attributedCharacterIterator.current() == '\uffff') break;
                attributedCharacterIterator.setIndex(attributedCharacterIterator.getRunLimit(attribute));
                attributedCharacterIterator.next();
                ++n2;
            }
        }
        return n2;
    }

    Object adjustValue(Object object, Map map, Object object2, int n) throws BadLocationException, ParseException {
        return null;
    }

    boolean getSupportsIncrement() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetValue(Object object) throws BadLocationException, ParseException {
        Document document = this.getFormattedTextField().getDocument();
        String string = this.valueToString(object);
        try {
            this.ignoreDocumentMutate = true;
            document.remove(0, document.getLength());
            document.insertString(0, string, null);
        }
        finally {
            this.ignoreDocumentMutate = false;
        }
        this.updateValue(object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.updateMaskIfNecessary();
    }

    DefaultFormatter.ReplaceHolder getReplaceHolder(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) {
        if (this.replaceHolder == null) {
            this.replaceHolder = new ExtendedReplaceHolder();
        }
        return super.getReplaceHolder(filterBypass, n, n2, string, attributeSet);
    }

    static class ExtendedReplaceHolder
    extends DefaultFormatter.ReplaceHolder {
        int endOffset;
        int endTextLength;

        ExtendedReplaceHolder() {
        }

        void resetFromValue(InternationalFormatter internationalFormatter) {
            this.offset = 0;
            try {
                this.text = internationalFormatter.valueToString(this.value);
            }
            catch (ParseException parseException) {
                this.text = "";
            }
            this.length = this.fb.getDocument().getLength();
        }
    }

    private class IncrementAction
    extends AbstractAction {
        private int direction;

        IncrementAction(String string, int n) {
            super(string);
            this.direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (InternationalFormatter.this.getAllowsInvalid()) {
                InternationalFormatter.this.updateMask();
            }
            boolean bl = false;
            if (InternationalFormatter.this.isValidMask() && (n = InternationalFormatter.this.getFormattedTextField().getSelectionStart()) != -1) {
                AttributedCharacterIterator attributedCharacterIterator = InternationalFormatter.this.getIterator();
                attributedCharacterIterator.setIndex(n);
                Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
                Object object = InternationalFormatter.this.getAdjustField(n, map);
                if (InternationalFormatter.this.canIncrement(object, n)) {
                    try {
                        Object object2 = InternationalFormatter.this.stringToValue(InternationalFormatter.this.getFormattedTextField().getText());
                        int n2 = InternationalFormatter.this.getFieldTypeCountTo(object, n);
                        object2 = InternationalFormatter.this.adjustValue(object2, map, object, this.direction);
                        if (object2 != null && InternationalFormatter.this.isValidValue(object2, false)) {
                            InternationalFormatter.this.resetValue(object2);
                            InternationalFormatter.this.updateMask();
                            if (InternationalFormatter.this.isValidMask()) {
                                InternationalFormatter.this.selectField(object, n2);
                            }
                            bl = true;
                        }
                    }
                    catch (ParseException parseException) {
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            if (!bl) {
                InternationalFormatter.this.invalidEdit();
            }
        }
    }
}

