/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.IXAnyEvent;
import sun.awt.X11.Native;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XEmbed;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XQueryTree;
import sun.awt.X11.XReparentEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindowPeer;

public class XEmbedder
extends XEmbed
implements XEventDispatcher {
    private static final Logger xembedLog = Logger.getLogger("sun.awt.X11.xembed");
    private XWindowPeer embedded;
    private boolean active;
    private long server;
    private boolean applicationActive;

    XEmbedder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void install(XWindowPeer xWindowPeer) {
        this.embedded = xWindowPeer;
        if (xembedLog.isLoggable(Level.FINE)) {
            xembedLog.fine("Installing xembedder on " + xWindowPeer);
        }
        XToolkit.addEventDispatcher(xWindowPeer.getWindow(), this);
        long[] lArray = new long[]{0L, 1L};
        long l = Native.card32ToData(lArray);
        try {
            XEmbedInfo.setAtomData(xWindowPeer.getWindow(), l, 2);
        }
        finally {
            unsafe.freeMemory(l);
        }
    }

    void handleClientMessage(long l) {
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent(l);
        if (xembedLog.isLoggable(Level.FINE)) {
            xembedLog.fine(xClientMessageEvent.toString());
        }
        if (xClientMessageEvent.get_message_type() == XEmbed.getAtom()) {
            if (xembedLog.isLoggable(Level.FINE)) {
                xembedLog.fine("Embedded message: " + XEmbedder.msgidToString((int)xClientMessageEvent.get_data(1)));
            }
            switch ((int)xClientMessageEvent.get_data(1)) {
                case 0: {
                    this.active = true;
                    this.server = this.getEmbedder(this.embedded, xClientMessageEvent);
                    if (this.embedded.reparented) break;
                    this.embedded.reparented = true;
                    this.embedded.updateSizeHints();
                    break;
                }
                case 1: {
                    this.applicationActive = true;
                    break;
                }
                case 2: {
                    this.applicationActive = false;
                    break;
                }
                case 4: {
                    this.embedded.handleWindowFocusInSync(0L);
                    break;
                }
                case 5: {
                    this.embedded.handleWindowFocusOutSync(null, 0L);
                }
            }
        }
    }

    public void dispatchEvent(IXAnyEvent iXAnyEvent) {
        switch (iXAnyEvent.get_type()) {
            case 33: {
                this.handleClientMessage(iXAnyEvent.getPData());
                break;
            }
            case 21: {
                this.handleReparentNotify(iXAnyEvent.getPData());
            }
        }
    }

    public void handleReparentNotify(long l) {
        XReparentEvent xReparentEvent = new XReparentEvent(l);
        this.server = xReparentEvent.get_parent();
    }

    void requestFocus() {
        if (this.active) {
            this.sendMessage(this.server, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getEmbedder(XWindowPeer xWindowPeer, XClientMessageEvent xClientMessageEvent) {
        XQueryTree xQueryTree = new XQueryTree(xWindowPeer.getWindow());
        try {
            xQueryTree.execute();
            long l = xQueryTree.get_parent();
            return l;
        }
        finally {
            xQueryTree.dispose();
        }
    }

    boolean isApplicationActive() {
        return this.applicationActive;
    }

    boolean isActive() {
        return this.active;
    }

    void traverseOutForward() {
        if (this.active) {
            this.sendMessage(this.server, 6);
        }
    }

    void traverseOutBackward() {
        if (this.active) {
            this.sendMessage(this.server, 7);
        }
    }
}

