/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.security.AccessController;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.SunClipboard;
import sun.awt.motif.X11Selection;
import sun.awt.motif.X11SelectionHolder;
import sun.security.action.GetIntegerAction;

public class X11Clipboard
extends SunClipboard
implements X11SelectionHolder {
    private final X11Selection clipboardSelection;
    private static final Object classLock = new Object();
    private static final int defaultPollInterval = 200;
    private static int pollInterval;
    private static int listenedClipboardsCount;

    public X11Clipboard(String string, String string2) {
        super(string);
        this.clipboardSelection = new X11Selection(string2, this);
    }

    protected void setContentsNative(Transferable transferable) {
        if (!this.clipboardSelection.getSelectionOwnership(transferable, this)) {
            this.owner = null;
            this.contents = null;
        }
    }

    public long getID() {
        return this.clipboardSelection.atom;
    }

    public void lostSelectionOwnership() {
        this.lostOwnershipImpl();
    }

    protected void clearNativeContext() {
        this.clipboardSelection.clearNativeContext();
    }

    protected long[] getClipboardFormats() {
        return X11Clipboard.getClipboardFormats(this.getID());
    }

    private static native long[] getClipboardFormats(long var0);

    protected byte[] getClipboardData(long l) throws IOException {
        return X11Clipboard.getClipboardData(this.getID(), l);
    }

    private static native byte[] getClipboardData(long var0, long var2) throws IOException;

    public void checkChange(long[] lArray) {
        if (!this.clipboardSelection.isOwner()) {
            super.checkChange(lArray);
        }
    }

    void checkChangeHere(Transferable transferable) {
        if (this.areFlavorListenersRegistered()) {
            super.checkChange(DataTransferer.getInstance().getFormatsForTransferableAsArray(transferable, flavorMap));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerClipboardViewerChecked() {
        if (pollInterval <= 0 && (pollInterval = ((Integer)AccessController.doPrivileged(new GetIntegerAction("awt.datatransfer.clipboard.poll.interval", 200))).intValue()) <= 0) {
            pollInterval = 200;
        }
        Object object = classLock;
        synchronized (object) {
            if (listenedClipboardsCount++ == 0) {
                this.registerClipboardViewer(pollInterval);
            }
        }
    }

    private native void registerClipboardViewer(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterClipboardViewerChecked() {
        Object object = classLock;
        synchronized (object) {
            if (--listenedClipboardsCount == 0) {
                this.unregisterClipboardViewer();
            }
        }
    }

    private native void unregisterClipboardViewer();
}

