/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.nio.ByteBuffer;
import java.util.Locale;
import sun.font.CMap;
import sun.font.CharToGlyphMapper;
import sun.font.FontManager;
import sun.font.TrueTypeFont;

public class TrueTypeGlyphMapper
extends CharToGlyphMapper {
    static final char REVERSE_SOLIDUS = '\\';
    static final char JA_YEN = '\u00a5';
    static final char JA_FULLWIDTH_TILDE_CHAR = '\uff5e';
    static final char JA_WAVE_DASH_CHAR = '\u301c';
    static final boolean isJAlocale = Locale.JAPAN.equals(Locale.getDefault());
    private final boolean needsJAremapping;
    private boolean remapJAWaveDash;
    TrueTypeFont font;
    CMap cmap;
    int numGlyphs;

    public TrueTypeGlyphMapper(TrueTypeFont trueTypeFont) {
        this.font = trueTypeFont;
        try {
            this.cmap = CMap.initialize(trueTypeFont);
        }
        catch (Exception exception) {
            this.cmap = null;
        }
        if (this.cmap == null && this.cmap == null) {
            if (FontManager.logging) {
                FontManager.logger.severe("Null Cmap for " + trueTypeFont + "substituting for this font");
            }
            FontManager.deRegisterBadFont(trueTypeFont);
            this.cmap = CMap.theNullCmap;
        }
        this.missingGlyph = 0;
        ByteBuffer byteBuffer = trueTypeFont.getTableBuffer(1835104368);
        this.numGlyphs = byteBuffer.getChar(4);
        if (FontManager.isSolaris && isJAlocale && trueTypeFont.supportsJA()) {
            this.needsJAremapping = true;
            if (FontManager.isSolaris8 && this.cmap.getGlyph(12316) == this.missingGlyph) {
                this.remapJAWaveDash = true;
            }
        } else {
            this.needsJAremapping = false;
        }
    }

    public int getNumGlyphs() {
        return this.numGlyphs;
    }

    private final char remapJAChar(char c) {
        switch (c) {
            case '\\': {
                return '\u00a5';
            }
            case '\u301c': {
                if (!this.remapJAWaveDash) break;
                return '\uff5e';
            }
        }
        return c;
    }

    private final int remapJAIntChar(int n) {
        switch (n) {
            case 92: {
                return 165;
            }
            case 12316: {
                if (!this.remapJAWaveDash) break;
                return 65374;
            }
        }
        return n;
    }

    public int charToGlyph(char c) {
        if (this.needsJAremapping) {
            c = this.remapJAChar(c);
        }
        char c2 = this.cmap.getGlyph(c);
        if (this.font.useNatives && c2 < this.font.glyphToCharMap.length) {
            this.font.glyphToCharMap[c2] = c;
        }
        return c2;
    }

    public int charToGlyph(int n) {
        if (this.needsJAremapping) {
            n = this.remapJAIntChar(n);
        }
        char c = this.cmap.getGlyph(n);
        if (this.font.useNatives && c < this.font.glyphToCharMap.length) {
            this.font.glyphToCharMap[c] = (char)n;
        }
        return c;
    }

    public void charsToGlyphs(int n, int[] nArray, int[] nArray2) {
        if (this.cmap != null) {
            for (int i = 0; i < n; ++i) {
                nArray2[i] = this.needsJAremapping ? (int)this.cmap.getGlyph(this.remapJAIntChar(nArray[i])) : (int)this.cmap.getGlyph(nArray[i]);
                if (!this.font.useNatives || nArray2[i] >= this.font.glyphToCharMap.length) continue;
                this.font.glyphToCharMap[nArray2[i]] = (char)nArray[i];
            }
        }
    }

    public void charsToGlyphs(int n, char[] cArray, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            char c;
            int n2 = this.needsJAremapping ? this.remapJAChar(cArray[i]) : cArray[i];
            if (n2 >= 55296 && n2 <= 56319 && i < n - 1 && (c = cArray[i + 1]) >= '\udc00' && c <= '\udfff') {
                n2 = (n2 - 55296) * 1024 + c - 56320 + 65536;
                nArray[i] = this.cmap.getGlyph(n2);
                nArray[++i] = 65535;
                continue;
            }
            nArray[i] = this.cmap.getGlyph(n2);
            if (!this.font.useNatives || nArray[i] >= this.font.glyphToCharMap.length) continue;
            this.font.glyphToCharMap[nArray[i]] = (char)n2;
        }
    }

    public boolean charsToGlyphsNS(int n, char[] cArray, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            char c;
            int n2 = this.needsJAremapping ? this.remapJAChar(cArray[i]) : cArray[i];
            if (n2 >= 55296 && n2 <= 56319 && i < n - 1 && (c = cArray[i + 1]) >= '\udc00' && c <= '\udfff') {
                n2 = (n2 - 55296) * 1024 + c - 56320 + 65536;
                nArray[i + 1] = 65535;
            }
            nArray[i] = this.cmap.getGlyph(n2);
            if (this.font.useNatives && nArray[i] < this.font.glyphToCharMap.length) {
                this.font.glyphToCharMap[nArray[i]] = (char)n2;
            }
            if (n2 < 1424) continue;
            if (n2 <= 1535) {
                return true;
            }
            if (n2 >= 1536 && n2 <= 1791) {
                return true;
            }
            if (n2 >= 2304 && n2 <= 3455) {
                return true;
            }
            if (n2 >= 3584 && n2 <= 3711) {
                return true;
            }
            if (n2 >= 8204 && n2 <= 8205) {
                return true;
            }
            if (n2 >= 8234 && n2 <= 8238) {
                return true;
            }
            if (n2 >= 8298 && n2 <= 8303) {
                return true;
            }
            if (n2 < 65536) continue;
            ++i;
        }
        return false;
    }
}

