/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Transparency;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImagingOpException;
import java.awt.image.IndexColorModel;
import java.awt.image.VolatileImage;
import sun.awt.image.BytePackedRaster;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.RemoteOffScreenImage;
import sun.awt.image.ToolkitImage;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.BlitBg;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.ScaledBlit;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.DrawImagePipe;
import sun.java2d.pipe.Region;

public class DrawImage
implements DrawImagePipe {
    private static final double MAX_TX_ERROR = 1.0E-4;

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, Color color) {
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        if (DrawImage.isSimpleTranslate(sunGraphics2D)) {
            return this.renderImageCopy(sunGraphics2D, image, color, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, 0, 0, n3, n4);
        }
        AffineTransform affineTransform = sunGraphics2D.transform;
        if ((n | n2) != 0) {
            affineTransform = new AffineTransform(affineTransform);
            affineTransform.translate(n, n2);
        }
        this.transformImage(sunGraphics2D, image, affineTransform, sunGraphics2D.interpolationType, 0, 0, n3, n4, color);
        return true;
    }

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, Color color) {
        if (DrawImage.isSimpleTranslate(sunGraphics2D)) {
            return this.renderImageCopy(sunGraphics2D, image, color, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4, n5, n6);
        }
        this.scaleImage(sunGraphics2D, image, n, n2, n + n5, n2 + n6, n3, n4, n3 + n5, n4 + n6, color);
        return true;
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, Color color) {
        double d;
        double d2;
        double d3;
        double d4;
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        if (n3 > 0 && n4 > 0 && DrawImage.isSimpleTranslate(sunGraphics2D) && this.renderImageScale(sunGraphics2D, image, color, sunGraphics2D.interpolationType, 0, 0, n5, n6, d4 = (double)(n + sunGraphics2D.transX), d3 = (double)(n2 + sunGraphics2D.transY), d2 = d4 + (double)n3, d = d3 + (double)n4)) {
            return true;
        }
        AffineTransform affineTransform = sunGraphics2D.transform;
        if ((n | n2) != 0 || n3 != n5 || n4 != n6) {
            affineTransform = new AffineTransform(affineTransform);
            affineTransform.translate(n, n2);
            affineTransform.scale((double)n3 / (double)n5, (double)n4 / (double)n6);
        }
        this.transformImage(sunGraphics2D, image, affineTransform, sunGraphics2D.interpolationType, 0, 0, n5, n6, color);
        return true;
    }

    protected void transformImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, AffineTransform affineTransform, int n3) {
        boolean bl;
        int n4 = affineTransform.getType();
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        if (sunGraphics2D.transformState <= 2 && (n4 == 0 || n4 == 1)) {
            double d = affineTransform.getTranslateX();
            double d2 = affineTransform.getTranslateY();
            int n7 = (int)Math.floor((d += sunGraphics2D.transform.getTranslateX()) + 0.5);
            int n8 = (int)Math.floor((d2 += sunGraphics2D.transform.getTranslateY()) + 0.5);
            if (n3 == 1 || DrawImage.closeToInteger(n7, d) && DrawImage.closeToInteger(n8, d2)) {
                this.renderImageCopy(sunGraphics2D, image, null, n + n7, n2 + n8, 0, 0, n5, n6);
                return;
            }
            bl = false;
        } else if (sunGraphics2D.transformState <= 3 && (n4 & 0x78) == 0) {
            double[] dArray = new double[]{0.0, 0.0, n5, n6};
            affineTransform.transform(dArray, 0, dArray, 0, 2);
            dArray[0] = dArray[0] + (double)n;
            dArray[1] = dArray[1] + (double)n2;
            dArray[2] = dArray[2] + (double)n;
            dArray[3] = dArray[3] + (double)n2;
            sunGraphics2D.transform.transform(dArray, 0, dArray, 0, 2);
            if (this.tryCopyOrScale(sunGraphics2D, image, 0, 0, n5, n6, null, n3, dArray)) {
                return;
            }
            bl = false;
        } else {
            bl = true;
        }
        AffineTransform affineTransform2 = new AffineTransform(sunGraphics2D.transform);
        affineTransform2.translate(n, n2);
        affineTransform2.concatenate(affineTransform);
        if (bl) {
            this.transformImage(sunGraphics2D, image, affineTransform2, n3, 0, 0, n5, n6, null);
        } else {
            this.renderImageXform(sunGraphics2D, image, affineTransform2, n3, 0, 0, n5, n6, null);
        }
    }

    protected void transformImage(SunGraphics2D sunGraphics2D, Image image, AffineTransform affineTransform, int n, int n2, int n3, int n4, int n5, Color color) {
        double[] dArray = new double[6];
        dArray[2] = n4 - n2;
        dArray[3] = dArray[5] = (double)(n5 - n3);
        affineTransform.transform(dArray, 0, dArray, 0, 3);
        if (Math.abs(dArray[0] - dArray[4]) < 1.0E-4 && Math.abs(dArray[3] - dArray[5]) < 1.0E-4 && this.tryCopyOrScale(sunGraphics2D, image, n2, n3, n4, n5, color, n, dArray)) {
            return;
        }
        this.renderImageXform(sunGraphics2D, image, affineTransform, n, n2, n3, n4, n5, color);
    }

    protected boolean tryCopyOrScale(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, Color color, int n5, double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2] - d;
        double d4 = dArray[3] - d2;
        if (DrawImage.closeToInteger(n3 - n, d3) && DrawImage.closeToInteger(n4 - n2, d4)) {
            int n6 = (int)Math.floor(d + 0.5);
            int n7 = (int)Math.floor(d2 + 0.5);
            if (n5 == 1 || DrawImage.closeToInteger(n6, d) && DrawImage.closeToInteger(n7, d2)) {
                this.renderImageCopy(sunGraphics2D, image, color, n6, n7, n, n2, n3 - n, n4 - n2);
                return true;
            }
        }
        return d3 > 0.0 && d4 > 0.0 && this.renderImageScale(sunGraphics2D, image, color, n5, n, n2, n3, n4, dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderImageXform(SunGraphics2D sunGraphics2D, Image image, AffineTransform affineTransform, int n, int n2, int n3, int n4, int n5, Color color) {
        Object object;
        Object object2;
        Transparency transparency;
        Transparency transparency2 = this.getBufferedImage(image);
        int n6 = ((BufferedImage)transparency2).getWidth();
        int n7 = ((BufferedImage)transparency2).getHeight();
        if ((n2 | n3) != 0 || n4 < n6 || n5 < n7) {
            n4 -= n2;
            n5 -= n3;
            n2 += ((BufferedImage)transparency2).getMinX();
            n3 += ((BufferedImage)transparency2).getMinY();
            transparency2 = ((BufferedImage)transparency2).getSubimage(n2, n3, n4, n5);
            n6 = n4;
            n7 = n5;
        }
        Region region = sunGraphics2D.getCompClip();
        if (n != 1 && ((BufferedImage)transparency2).getColorModel() instanceof IndexColorModel) {
            transparency = new BufferedImage(n6, n7, 3);
            object2 = ((BufferedImage)transparency).createGraphics();
            try {
                ((Graphics2D)object2).setComposite(AlphaComposite.Src);
                ((Graphics)object2).drawImage((Image)((Object)transparency2), 0, 0, null);
            }
            finally {
                ((Graphics)object2).dispose();
            }
            transparency2 = transparency;
        }
        transparency = this.getTransformColorModel(sunGraphics2D, (BufferedImage)transparency2, affineTransform);
        try {
            object2 = new AffineTransformOp(affineTransform, n);
        }
        catch (ImagingOpException imagingOpException) {
            return;
        }
        Rectangle rectangle = ((AffineTransformOp)object2).getBounds2D((BufferedImage)transparency2).getBounds();
        region = region.getBoundsIntersection(rectangle);
        if (region.isEmpty()) {
            return;
        }
        int n8 = region.getLoX();
        int n9 = region.getLoY();
        n6 = region.getWidth();
        n7 = region.getHeight();
        if ((n8 | n9) != 0) {
            object = AffineTransform.getTranslateInstance(-n8, -n9);
            ((AffineTransform)object).concatenate(affineTransform);
            try {
                object2 = new AffineTransformOp((AffineTransform)object, n);
            }
            catch (ImagingOpException imagingOpException) {
                return;
            }
        }
        if ((transparency2 = ((AffineTransformOp)object2).filter((BufferedImage)transparency2, (BufferedImage)(object = transparency == ((BufferedImage)transparency2).getColorModel() ? new BufferedImage((ColorModel)transparency, ((BufferedImage)transparency2).getRaster().createCompatibleWritableRaster(n6, n7), ((ColorModel)transparency).isAlphaPremultiplied(), null) : new BufferedImage((ColorModel)transparency, ((ColorModel)transparency).createCompatibleWritableRaster(n6, n7), ((ColorModel)transparency).isAlphaPremultiplied(), null)))) == null) {
            return;
        }
        this.renderImageCopy(sunGraphics2D, (Image)((Object)transparency2), color, region.getLoX(), region.getLoY(), 0, 0, region.getWidth(), region.getHeight());
    }

    protected boolean renderImageCopy(SunGraphics2D sunGraphics2D, Image image, Color color, int n, int n2, int n3, int n4, int n5, int n6) {
        Region region = sunGraphics2D.getCompClip();
        SurfaceData surfaceData = SurfaceData.getSourceSurfaceData(image, sunGraphics2D.surfaceData, sunGraphics2D.imageComp, color, false);
        if (surfaceData == null) {
            return false;
        }
        int n7 = 0;
        while (true) {
            try {
                SurfaceType surfaceType = surfaceData.getSurfaceType();
                SurfaceType surfaceType2 = sunGraphics2D.surfaceData.getSurfaceType();
                this.blitSurfaceData(sunGraphics2D, region, surfaceData, sunGraphics2D.surfaceData, surfaceType, surfaceType2, n3, n4, n, n2, n5, n6, color);
                return true;
            }
            catch (NullPointerException nullPointerException) {
                if (!SurfaceData.isNull(sunGraphics2D.surfaceData) && !SurfaceData.isNull(surfaceData)) {
                    throw nullPointerException;
                }
                return false;
            }
            catch (InvalidPipeException invalidPipeException) {
                surfaceData = surfaceData.getReplacement();
                region = sunGraphics2D.getCompClip();
                if (!SurfaceData.isNull(sunGraphics2D.surfaceData) && !SurfaceData.isNull(surfaceData) && ++n7 <= 1) continue;
                return false;
            }
            break;
        }
    }

    protected boolean renderImageScale(SunGraphics2D sunGraphics2D, Image image, Color color, int n, int n2, int n3, int n4, int n5, double d, double d2, double d3, double d4) {
        if (n != 1) {
            return false;
        }
        Region region = sunGraphics2D.getCompClip();
        SurfaceData surfaceData = SurfaceData.getSourceSurfaceData(image, sunGraphics2D.surfaceData, sunGraphics2D.imageComp, color, true);
        if (surfaceData == null || DrawImage.isBgOperation(surfaceData, color)) {
            return false;
        }
        int n6 = 0;
        while (true) {
            try {
                SurfaceType surfaceType = surfaceData.getSurfaceType();
                SurfaceType surfaceType2 = sunGraphics2D.surfaceData.getSurfaceType();
                return this.scaleSurfaceData(sunGraphics2D, region, surfaceData, sunGraphics2D.surfaceData, surfaceType, surfaceType2, n2, n3, n4, n5, d, d2, d3, d4);
            }
            catch (NullPointerException nullPointerException) {
                if (!SurfaceData.isNull(sunGraphics2D.surfaceData)) {
                    throw nullPointerException;
                }
                return false;
            }
            catch (InvalidPipeException invalidPipeException) {
                surfaceData = surfaceData.getReplacement();
                region = sunGraphics2D.getCompClip();
                if (!SurfaceData.isNull(sunGraphics2D.surfaceData) && !SurfaceData.isNull(surfaceData) && ++n6 <= 1) continue;
                return false;
            }
            break;
        }
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
        double d;
        double d2;
        double d3;
        double d4;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (n7 > n5) {
            n16 = n7 - n5;
            n15 = n5;
        } else {
            bl = true;
            n16 = n5 - n7;
            n15 = n7;
        }
        if (n8 > n6) {
            n14 = n8 - n6;
            n13 = n6;
        } else {
            bl2 = true;
            n14 = n6 - n8;
            n13 = n8;
        }
        if (n3 > n) {
            n12 = n3 - n;
            n11 = n;
        } else {
            n12 = n - n3;
            bl3 = true;
            n11 = n3;
        }
        if (n4 > n2) {
            n10 = n4 - n2;
            n9 = n2;
        } else {
            n10 = n2 - n4;
            bl4 = true;
            n9 = n4;
        }
        if (n16 <= 0 || n14 <= 0) {
            return true;
        }
        if (bl == bl3 && bl2 == bl4 && DrawImage.isSimpleTranslate(sunGraphics2D) && this.renderImageScale(sunGraphics2D, image, color, sunGraphics2D.interpolationType, n15, n13, n15 + n16, n13 + n14, d4 = (double)(n11 + sunGraphics2D.transX), d3 = (double)(n9 + sunGraphics2D.transY), d2 = d4 + (double)n12, d = d3 + (double)n10)) {
            return true;
        }
        AffineTransform affineTransform = new AffineTransform(sunGraphics2D.transform);
        affineTransform.translate(n, n2);
        double d5 = (double)(n3 - n) / (double)(n7 - n5);
        double d6 = (double)(n4 - n2) / (double)(n8 - n6);
        affineTransform.scale(d5, d6);
        affineTransform.translate(n15 - n5, n13 - n6);
        int n17 = image.getWidth(null);
        int n18 = image.getHeight(null);
        n14 += n13;
        if ((n16 += n15) > n17) {
            n16 = n17;
        }
        if (n14 > n18) {
            n14 = n18;
        }
        if (n15 < 0) {
            affineTransform.translate(-n15, 0.0);
            n15 = 0;
        }
        if (n13 < 0) {
            affineTransform.translate(0.0, -n13);
            n13 = 0;
        }
        if (n15 >= n16 || n13 >= n14) {
            return true;
        }
        this.transformImage(sunGraphics2D, image, affineTransform, sunGraphics2D.interpolationType, n15, n13, n16, n14, color);
        return true;
    }

    public static boolean closeToInteger(int n, double d) {
        return Math.abs(d - (double)n) < 1.0E-4;
    }

    public static boolean isSimpleTranslate(SunGraphics2D sunGraphics2D) {
        int n = sunGraphics2D.transformState;
        if (n <= 1) {
            return true;
        }
        if (n >= 3) {
            return false;
        }
        return sunGraphics2D.interpolationType == 1;
    }

    protected static boolean isBgOperation(SurfaceData surfaceData, Color color) {
        return surfaceData == null || color != null && surfaceData.getTransparency() != 1;
    }

    protected BufferedImage getBufferedImage(Image image) {
        if (image instanceof RemoteOffScreenImage) {
            return ((RemoteOffScreenImage)image).getSnapshot();
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        return ((VolatileImage)image).getSnapshot();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ColorModel getTransformColorModel(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, AffineTransform affineTransform) {
        Object object;
        boolean bl;
        ColorModel colorModel;
        ColorModel colorModel2 = colorModel = bufferedImage.getColorModel();
        if (affineTransform.isIdentity()) {
            return colorModel2;
        }
        int n = affineTransform.getType();
        boolean bl2 = bl = (n & (0x18 | 0x20)) != 0;
        if (!bl) {
            if (n != 1) {
                if (n != 0) {
                    object = new double[4];
                    affineTransform.getMatrix((double[])object);
                    boolean bl3 = bl = object[0] != (double)((int)object[0]) || object[3] != (double)((int)object[3]);
                }
            }
        }
        if (sunGraphics2D.renderHint != 2) {
            if (colorModel instanceof IndexColorModel) {
                object = bufferedImage.getRaster();
                IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                if (!bl) return colorModel2;
                if (colorModel.getTransparency() != 1) return colorModel2;
                if (object instanceof BytePackedRaster) {
                    return ColorModel.getRGBdefault();
                }
                double[] dArray = new double[6];
                affineTransform.getMatrix(dArray);
                if (dArray[1] == 0.0 && dArray[2] == 0.0 && dArray[4] == 0.0 && dArray[5] == 0.0) return colorModel2;
                int n2 = indexColorModel.getMapSize();
                if (n2 >= 256) return ColorModel.getRGBdefault();
                int[] nArray = new int[n2 + 1];
                indexColorModel.getRGBs(nArray);
                nArray[n2] = 0;
                return new IndexColorModel(indexColorModel.getPixelSize(), n2 + 1, nArray, 0, true, n2, 0);
            }
            if (!bl) return colorModel2;
            if (colorModel.getTransparency() != 1) return colorModel2;
            return ColorModel.getRGBdefault();
        }
        if (colorModel instanceof IndexColorModel) return ColorModel.getRGBdefault();
        if (!bl) return colorModel2;
        if (colorModel.getTransparency() != 1) return colorModel2;
        return ColorModel.getRGBdefault();
    }

    protected void blitSurfaceData(SunGraphics2D sunGraphics2D, Region region, SurfaceData surfaceData, SurfaceData surfaceData2, SurfaceType surfaceType, SurfaceType surfaceType2, int n, int n2, int n3, int n4, int n5, int n6, Color color) {
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        CompositeType compositeType = sunGraphics2D.imageComp;
        if (CompositeType.SrcOverNoEa.equals(compositeType) && (surfaceData.getTransparency() == 1 || color != null && color.getTransparency() == 1)) {
            compositeType = CompositeType.SrcNoEa;
        }
        if (!DrawImage.isBgOperation(surfaceData, color)) {
            Blit blit = Blit.getFromCache(surfaceType, compositeType, surfaceType2);
            blit.Blit(surfaceData, surfaceData2, sunGraphics2D.composite, region, n, n2, n3, n4, n5, n6);
        } else {
            BlitBg blitBg = BlitBg.getFromCache(surfaceType, compositeType, surfaceType2);
            blitBg.BlitBg(surfaceData, surfaceData2, sunGraphics2D.composite, region, color, n, n2, n3, n4, n5, n6);
        }
    }

    protected boolean scaleSurfaceData(SunGraphics2D sunGraphics2D, Region region, SurfaceData surfaceData, SurfaceData surfaceData2, SurfaceType surfaceType, SurfaceType surfaceType2, int n, int n2, int n3, int n4, double d, double d2, double d3, double d4) {
        ScaledBlit scaledBlit;
        CompositeType compositeType = sunGraphics2D.imageComp;
        if (CompositeType.SrcOverNoEa.equals(compositeType) && surfaceData.getTransparency() == 1) {
            compositeType = CompositeType.SrcNoEa;
        }
        if ((scaledBlit = ScaledBlit.getFromCache(surfaceType, compositeType, surfaceType2)) != null) {
            scaledBlit.Scale(surfaceData, surfaceData2, sunGraphics2D.composite, region, n, n2, n3, n4, d, d2, d3, d4);
            return true;
        }
        return false;
    }

    protected static boolean imageReady(ToolkitImage toolkitImage, ImageObserver imageObserver) {
        if (toolkitImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(toolkitImage, 192, -1, -1, -1, -1);
            }
            return false;
        }
        return true;
    }

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        if (!(image instanceof ToolkitImage)) {
            return this.copyImage(sunGraphics2D, image, n, n2, color);
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        if (!DrawImage.imageReady(toolkitImage, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = toolkitImage.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, toolkitImage, n, n2, color, imageObserver);
    }

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, Color color, ImageObserver imageObserver) {
        if (!(image instanceof ToolkitImage)) {
            return this.copyImage(sunGraphics2D, image, n, n2, n3, n4, n5, n6, color);
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        if (!DrawImage.imageReady(toolkitImage, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = toolkitImage.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, toolkitImage, n, n2, n + n5, n2 + n6, n3, n4, n3 + n5, n4 + n6, color, imageObserver);
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (!(image instanceof ToolkitImage)) {
            return this.scaleImage(sunGraphics2D, image, n, n2, n3, n4, color);
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        if (!DrawImage.imageReady(toolkitImage, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = toolkitImage.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, toolkitImage, n, n2, n3, n4, color, imageObserver);
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (!(image instanceof ToolkitImage)) {
            return this.scaleImage(sunGraphics2D, image, n, n2, n3, n4, n5, n6, n7, n8, color);
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        if (!DrawImage.imageReady(toolkitImage, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = toolkitImage.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, toolkitImage, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    public boolean transformImage(SunGraphics2D sunGraphics2D, Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        if (!(image instanceof ToolkitImage)) {
            this.transformImage(sunGraphics2D, image, 0, 0, affineTransform, sunGraphics2D.interpolationType);
            return true;
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        if (!DrawImage.imageReady(toolkitImage, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = toolkitImage.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, toolkitImage, affineTransform, imageObserver);
    }

    public void transformImage(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        if (bufferedImageOp != null) {
            if (bufferedImageOp instanceof AffineTransformOp) {
                AffineTransformOp affineTransformOp = (AffineTransformOp)bufferedImageOp;
                this.transformImage(sunGraphics2D, bufferedImage, n, n2, affineTransformOp.getTransform(), affineTransformOp.getInterpolationType());
                return;
            }
            bufferedImage = bufferedImageOp.filter(bufferedImage, null);
        }
        this.copyImage(sunGraphics2D, bufferedImage, n, n2, null);
    }
}

