/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import sun.io.CharToByteConverter;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcBoundCol;
import sun.jdbc.odbc.JdbcOdbcInputStream;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPseudoCol;
import sun.jdbc.odbc.JdbcOdbcResultSetInterface;
import sun.jdbc.odbc.JdbcOdbcResultSetMetaData;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;
import sun.jdbc.odbc.JdbcOdbcStatement;
import sun.jdbc.odbc.JdbcOdbcUtils;
import sun.jdbc.odbc.OdbcDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcOdbcResultSet
extends JdbcOdbcObject
implements JdbcOdbcResultSetInterface {
    protected JdbcOdbc OdbcApi = null;
    protected long hDbc = 0L;
    protected long hStmt = 0L;
    protected SQLWarning lastWarning = null;
    protected boolean keepHSTMT = false;
    protected JdbcOdbcBoundCol[] boundCols;
    protected int numberOfCols;
    protected int numResultCols = -1;
    protected int firstPseudoCol;
    protected int lastPseudoCol;
    protected JdbcOdbcPseudoCol[] pseudoCols;
    protected int[] colMappings;
    protected ResultSetMetaData rsmd;
    private Hashtable colNameToNum;
    private Hashtable colNumToName;
    private boolean lastColumnNull = false;
    private boolean closed;
    private int sqlTypeColumn;
    private boolean freed;
    private JdbcOdbcUtils utils = new JdbcOdbcUtils();
    private boolean ownInsertsAreVisible;
    private boolean ownDeletesAreVisible;
    protected JdbcOdbcStatement ownerStatement;
    protected int numberOfRows;
    protected int rowPosition;
    protected int lastRowPosition;
    protected int[] rowStatusArray;
    protected boolean atInsertRow;
    protected int lastForwardRecord;
    protected int lastColumnData;
    protected int rowSet;
    protected boolean blockCursor;
    protected int fetchCount;
    protected int currentBlockCell;
    protected int lastBlockPosition;
    protected boolean moveUpBlock;
    protected boolean moveDownBlock;
    protected short odbcCursorType;
    protected boolean rowUpdated;
    protected long[] pA;

    protected void finalize() {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("ResultSet.finalize " + this);
        }
        try {
            if (!this.closed) {
                this.hStmt = 0L;
                this.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void initialize(JdbcOdbc jdbcOdbc, long l, long l2, boolean bl, JdbcOdbcStatement jdbcOdbcStatement) throws SQLException {
        int n;
        this.OdbcApi = jdbcOdbc;
        this.hDbc = l;
        this.hStmt = l2;
        this.keepHSTMT = bl;
        this.numberOfCols = this.getColumnCount();
        this.boundCols = new JdbcOdbcBoundCol[this.numberOfCols];
        for (n = 0; n < this.numberOfCols; ++n) {
            this.boundCols[n] = new JdbcOdbcBoundCol();
        }
        this.ownerStatement = jdbcOdbcStatement;
        this.rowPosition = 0;
        this.lastForwardRecord = 0;
        this.lastRowPosition = 0;
        this.lastColumnData = 0;
        this.currentBlockCell = 0;
        this.blockCursor = false;
        this.rowSet = 1;
        if (this.getType() != 1003) {
            if (this.ownerStatement != null) {
                this.rowSet = this.ownerStatement.getBlockCursorSize();
            }
            this.setRowStatusPtr();
            this.setResultSetVisibilityIndicators();
            this.calculateRowCount();
            if (this.numberOfRows >= 0) {
                n = 0;
                n = this.setRowArraySize() ? 1 : 0;
                if (n == 0) {
                    this.rowSet = 1;
                }
                if (this.pA != null && this.pA[0] != 0L) {
                    JdbcOdbc.ReleaseStoredIntegers(this.pA[0], this.pA[1]);
                    this.pA[0] = 0L;
                    this.pA[1] = 0L;
                }
                this.setRowStatusPtr();
                if (this.rowSet > 1) {
                    this.blockCursor = true;
                    this.setCursorType();
                }
                for (int i = 0; i < this.numberOfCols; ++i) {
                    this.boundCols[i].initStagingArea(this.rowSet);
                }
            }
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastColumnNull;
    }

    public void setAliasColumnName(String string, int n) {
        if (n > 0 && n <= this.numberOfCols) {
            this.boundCols[n - 1].setAliasName(string);
        }
    }

    @Override
    public String mapColumnName(String string, int n) {
        if (n > 0 && n <= this.numberOfCols) {
            return this.boundCols[n - 1].mapAliasName(string);
        }
        return string;
    }

    @Override
    public String getString(int n) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        this.consecutiveFetch(n);
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            return null;
        }
        int n2 = this.getMaxCharLen(n);
        int n3 = this.getColumnLength(n);
        String string = null;
        if (n3 > Short.MAX_VALUE) {
            JdbcOdbcInputStream jdbcOdbcInputStream = (JdbcOdbcInputStream)this.getAsciiStream(n);
            try {
                byte[] byArray = jdbcOdbcInputStream.readAllData();
                if (byArray != null) {
                    if (byArray.length > 2 && byArray[1] == 0) {
                        string = this.BytesToChars("UnicodeLittleUnmarked", byArray);
                    }
                    if (byArray.length >= 2 && byArray[0] == 0) {
                        string = this.BytesToChars("UnicodeBigUnmarked", byArray);
                    }
                    string = this.BytesToChars(this.OdbcApi.charSet, byArray);
                }
                this.lastColumnNull = true;
            }
            catch (Exception exception) {
                SQLException sQLException = new SQLException(exception.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        } else {
            if (n2 == -1) {
                this.lastColumnNull = true;
                return null;
            }
            boolean bl = true;
            int n4 = this.getColumnType(n);
            switch (n4) {
                case -1: 
                case 1: 
                case 12: {
                    bl = false;
                    break;
                }
            }
            string = this.getDataString(n, ++n2, bl);
            if (string == null) {
                this.lastColumnNull = true;
                return string;
            }
            int n5 = string.length();
            if (n5 == n2 - 1 && !bl) {
                string = string.substring(0, n2 - 1);
            }
            if ((n4 == -1 || n4 == -4) && n5 == n2 - 1) {
                String string2 = string;
                while (string2.length() == Short.MAX_VALUE && (string2 = this.getDataString(n, n2, bl)) != null) {
                    if (this.OdbcApi.getTracer().isTracing()) {
                        this.OdbcApi.getTracer().trace("" + string2.length() + " byte(s) read");
                    }
                    if (string2.length() == n2) {
                        string2 = string2.substring(0, n2 - 1);
                    }
                    string = string + string2;
                    if (!this.OdbcApi.getTracer().isTracing()) continue;
                    this.OdbcApi.getTracer().trace("" + string.length() + " bytes total");
                }
            }
        }
        return string;
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        this.checkOpen();
        boolean bl = false;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        this.consecutiveFetch(n);
        if (this.getPseudoCol(n) == null) {
            bl = this.getInt(n) != 0;
        } else {
            this.lastColumnNull = true;
        }
        return bl;
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(int n) throws SQLException {
        this.checkOpen();
        byte by = 0;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        this.consecutiveFetch(n);
        if (this.getPseudoCol(n) == null) {
            by = (byte)this.getInt(n);
        } else {
            this.lastColumnNull = true;
        }
        return by;
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public short getShort(int n) throws SQLException {
        this.checkOpen();
        short s = 0;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        this.consecutiveFetch(n);
        if (this.getPseudoCol(n) == null) {
            s = (short)this.getInt(n);
        } else {
            this.lastColumnNull = true;
        }
        return s;
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(int n) throws SQLException {
        this.checkOpen();
        int n2 = 0;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        this.consecutiveFetch(n);
        if (this.getPseudoCol(n) == null) {
            Integer n3 = this.getDataInteger(n);
            if (n3 != null) {
                n2 = n3;
            }
        } else {
            this.lastColumnNull = true;
        }
        return n2;
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(int n) throws SQLException {
        this.checkOpen();
        long l = 0L;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        this.consecutiveFetch(n);
        if (this.getPseudoCol(n) == null) {
            Double d = this.getDataDouble(n);
            if (d != null) {
                l = d.longValue();
            }
        } else {
            this.lastColumnNull = true;
        }
        return l;
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(int n) throws SQLException {
        return (float)this.getDouble(n);
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(int n) throws SQLException {
        this.checkOpen();
        double d = 0.0;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        this.consecutiveFetch(n);
        if (this.getPseudoCol(n) == null) {
            Double d2 = this.getDataDouble(n);
            if (d2 != null) {
                d = d2;
            }
        } else {
            this.lastColumnNull = true;
        }
        return d;
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.checkOpen();
        BigDecimal bigDecimal = null;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        this.consecutiveFetch(n);
        if (this.getPseudoCol(n) == null) {
            String string = this.getDataString(n, 300, true);
            if (string != null) {
                bigDecimal = new BigDecimal(string);
                bigDecimal = bigDecimal.setScale(n2, 6);
            }
        } else {
            this.lastColumnNull = true;
        }
        return bigDecimal;
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    @Override
    public synchronized byte[] getBytes(int n) throws SQLException {
        int n2;
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        this.consecutiveFetch(n);
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            return null;
        }
        int n3 = this.getMaxBinaryLen(n);
        if (n3 == -1) {
            this.lastColumnNull = true;
            return null;
        }
        int n4 = this.getColumnLength(n);
        if (n4 > Short.MAX_VALUE) {
            JdbcOdbcInputStream jdbcOdbcInputStream = (JdbcOdbcInputStream)this.getBinaryStream(n);
            try {
                return jdbcOdbcInputStream.readAllData();
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        int n5 = this.getColumnType(n);
        byte[] byArray = new byte[n3];
        try {
            n2 = this.OdbcApi.SQLGetDataBinary(this.hStmt, n, byArray);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            Integer n6 = (Integer)jdbcOdbcSQLWarning.value;
            n2 = n6;
        }
        if (n2 == -1) {
            this.lastColumnNull = true;
            byArray = null;
        }
        if (n5 != -2 && n2 != n3 && byArray != null) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Date getDate(int n) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        this.consecutiveFetch(n);
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            return null;
        }
        String string = this.getDataStringDate(n);
        if (string == null) {
            return null;
        }
        return Date.valueOf(string);
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Time getTime(int n) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        this.consecutiveFetch(n);
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            return null;
        }
        String string = this.getDataStringTime(n);
        if (string == null) {
            return null;
        }
        return Time.valueOf(string);
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        this.consecutiveFetch(n);
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            return null;
        }
        String string = this.getDataStringTimestamp(n);
        if (string == null) {
            return null;
        }
        if (string.length() == 10) {
            string = string + " 00:00:00";
        }
        return Timestamp.valueOf(string);
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        this.consecutiveFetch(n);
        int n2 = this.getColumnType(n);
        int n3 = -2;
        switch (n2) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                n3 = 1;
            }
        }
        JdbcOdbcInputStream jdbcOdbcInputStream = new JdbcOdbcInputStream(this.OdbcApi, this.hStmt, n, 1, n3, this.ownerStatement);
        this.setInputStream(n, jdbcOdbcInputStream);
        return jdbcOdbcInputStream;
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        this.consecutiveFetch(n);
        int n2 = this.getColumnType(n);
        int n3 = -2;
        switch (n2) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                n3 = 1;
            }
        }
        JdbcOdbcInputStream jdbcOdbcInputStream = new JdbcOdbcInputStream(this.OdbcApi, this.hStmt, n, 2, n3, this.ownerStatement);
        this.setInputStream(n, jdbcOdbcInputStream);
        return jdbcOdbcInputStream;
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        this.consecutiveFetch(n);
        int n2 = this.getColumnType(n);
        int n3 = -2;
        switch (n2) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                n3 = 1;
            }
        }
        JdbcOdbcInputStream jdbcOdbcInputStream = new JdbcOdbcInputStream(this.OdbcApi, this.hStmt, n, 3, n3, this.ownerStatement);
        this.setInputStream(n, jdbcOdbcInputStream);
        return jdbcOdbcInputStream;
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public boolean next() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            boolean bl = false;
            boolean bl2 = false;
            if (this.getFetchDirection() == 1000) {
                if (this.rowPosition == this.numberOfRows) {
                    this.afterLast();
                    return false;
                }
                if (this.blockCursor) {
                    bl = this.relative(1, false);
                } else {
                    ++this.rowPosition;
                    bl = this.fetchScrollOption(this.rowPosition, (short)5);
                }
            } else {
                if (this.rowPosition == 1) {
                    this.beforeFirst();
                    return false;
                }
                if (this.blockCursor) {
                    bl = this.relative(-1, false);
                } else {
                    --this.rowPosition;
                    bl = this.fetchScrollOption(this.rowPosition, (short)5);
                }
            }
            return bl;
        }
        boolean bl = true;
        this.lastColumnNull = false;
        this.closeInputStreams();
        this.clearWarnings();
        try {
            bl = this.OdbcApi.SQLFetch(this.hStmt);
        }
        catch (SQLWarning sQLWarning) {
            this.setWarning(sQLWarning);
        }
        if (bl) {
            ++this.rowPosition;
        } else if (!bl) {
            if (this.lastForwardRecord == 0) {
                this.lastForwardRecord = this.rowPosition;
                this.rowPosition = 0;
            } else {
                this.rowPosition = 0;
            }
        }
        return bl;
    }

    public int getRowNumber() throws SQLException {
        this.checkOpen();
        int n = 0;
        this.clearWarnings();
        try {
            n = (int)this.OdbcApi.SQLGetStmtOption(this.hStmt, (short)14);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n = bigDecimal.intValue();
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return n;
    }

    @Override
    public int getColumnCount() throws SQLException {
        this.checkOpen();
        int n = 0;
        this.clearWarnings();
        if (this.lastPseudoCol > 0) {
            return this.lastPseudoCol;
        }
        if (this.colMappings != null) {
            return this.colMappings.length;
        }
        try {
            n = this.numResultCols = this.OdbcApi.SQLNumResultCols(this.hStmt);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n = bigDecimal.intValue();
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return n;
    }

    public int getRowCount() throws SQLException {
        this.checkOpen();
        return this.numberOfRows;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSet.close");
        }
        this.closeInputStreams();
        this.clearWarnings();
        this.lastColumnNull = false;
        if (this.OdbcApi != null && this.hStmt != 0L) {
            if (!this.keepHSTMT) {
                this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                this.hStmt = 0L;
            }
            this.closed = true;
            this.FreeCols();
            if (this.pA != null && this.pA[0] != 0L) {
                JdbcOdbc.ReleaseStoredIntegers(this.pA[0], this.pA[1]);
                this.pA[0] = 0L;
                this.pA[1] = 0L;
            }
            if (this.ownerStatement != null) {
                this.ownerStatement.myResultSet = null;
            }
            if (this.OdbcApi.getTracer().isTracing()) {
                this.OdbcApi.getTracer().trace("*ResultSet has been closed");
            }
        }
    }

    public synchronized void FreeCols() throws NullPointerException {
        try {
            for (int i = 0; i < this.boundCols.length; ++i) {
                if (this.boundCols[i].pA1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundCols[i].pA1, this.boundCols[i].pA2);
                    this.boundCols[i].pA1 = 0L;
                    this.boundCols[i].pA2 = 0L;
                }
                if (this.boundCols[i].pB1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundCols[i].pB1, this.boundCols[i].pB2);
                    this.boundCols[i].pB1 = 0L;
                    this.boundCols[i].pB2 = 0L;
                }
                if (this.boundCols[i].pC1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundCols[i].pC1, this.boundCols[i].pC2);
                    this.boundCols[i].pC1 = 0L;
                    this.boundCols[i].pC2 = 0L;
                }
                if (this.boundCols[i].pS1 == 0L) continue;
                JdbcOdbc.ReleaseStoredChars(this.boundCols[i].pS1, this.boundCols[i].pS2);
                this.boundCols[i].pS1 = 0L;
                this.boundCols[i].pS2 = 0L;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkOpen();
        String string = "";
        this.clearWarnings();
        try {
            string = this.OdbcApi.SQLGetCursorName(this.hStmt);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return string.trim();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSet.getMetaData");
        }
        if (this.closed) {
            throw new SQLException("ResultSet is closed");
        }
        return new JdbcOdbcResultSetMetaData(this.OdbcApi, this);
    }

    @Override
    public Object getObject(int n) throws SQLException {
        this.checkOpen();
        Object object = null;
        int n2 = this.getColumnType(n);
        int n3 = n;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        this.consecutiveFetch(n);
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            return null;
        }
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                object = this.getString(n);
                break;
            }
            case 2: 
            case 3: {
                object = this.getBigDecimal(n, this.getScale(n3));
                break;
            }
            case -7: {
                object = new Boolean(this.getBoolean(n));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                object = new Integer(this.getInt(n));
                break;
            }
            case -5: {
                object = new Long(this.getLong(n));
                break;
            }
            case 7: {
                object = new Float(this.getFloat(n));
                break;
            }
            case 6: 
            case 8: {
                object = new Double(this.getDouble(n));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = this.getBytes(n);
                break;
            }
            case 91: {
                object = this.getDate(n);
                break;
            }
            case 92: {
                object = this.getTime(n);
                break;
            }
            case 93: {
                object = this.getTimestamp(n);
            }
        }
        if (this.wasNull()) {
            object = null;
        }
        return object;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this.lastWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this.lastWarning = null;
    }

    @Override
    public void setWarning(SQLWarning sQLWarning) throws SQLException {
        this.checkOpen();
        this.lastWarning = sQLWarning;
    }

    @Override
    public long getHSTMT() {
        return this.hStmt;
    }

    @Override
    public synchronized int findColumn(String string) throws SQLException {
        Integer n;
        if (this.rsmd == null) {
            this.rsmd = this.getMetaData();
            this.colNameToNum = new Hashtable();
            this.colNumToName = new Hashtable();
        }
        if ((n = (Integer)this.colNameToNum.get(string)) == null) {
            for (int i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                String string2 = (String)this.colNumToName.get(new Integer(i));
                if (string2 == null) {
                    string2 = this.rsmd.getColumnName(i);
                    this.colNameToNum.put(string2, new Integer(i));
                    this.colNumToName.put(new Integer(i), string2);
                }
                if (!string2.equalsIgnoreCase(string)) continue;
                return i;
            }
            throw new SQLException("Column not found", "S0022");
        }
        return n;
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        this.checkOpen();
        InputStreamReader inputStreamReader = null;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        this.consecutiveFetch(n);
        int n2 = this.getColumnType(n);
        int n3 = -2;
        switch (n2) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                n3 = 1;
            }
        }
        String string = this.OdbcApi.charSet;
        JdbcOdbcInputStream jdbcOdbcInputStream = new JdbcOdbcInputStream(this.OdbcApi, this.hStmt, n, 5, n3, this.ownerStatement);
        this.setInputStream(n, jdbcOdbcInputStream);
        try {
            inputStreamReader = new InputStreamReader((InputStream)jdbcOdbcInputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("getCharacterStream() with Encoding ('encoding') :" + unsupportedEncodingException.getMessage());
        }
        return inputStreamReader;
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getCharacterStream(n);
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkOpen();
        BigDecimal bigDecimal = null;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        this.consecutiveFetch(n);
        if (this.getPseudoCol(n) == null) {
            String string = this.getDataString(n, 300, true);
            if (string != null) {
                bigDecimal = new BigDecimal(string);
            }
        } else {
            this.lastColumnNull = true;
        }
        return bigDecimal;
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBigDecimal(n);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                return this.rowPosition == 0;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkOpen();
        if (this.closed) {
            throw new SQLException("ResultSet is closed");
        }
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                return this.rowPosition > this.numberOfRows;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                return this.rowPosition == 1;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                return this.rowPosition == this.numberOfRows;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            boolean bl = false;
            bl = this.fetchScrollOption(0, (short)5);
            this.rowPosition = 0;
            this.currentBlockCell = 0;
            if (this.atInsertRow) {
                this.lastRowPosition = 0;
                this.lastBlockPosition = 0;
                this.atInsertRow = false;
            }
        } else {
            throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
        }
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkOpen();
        boolean bl = false;
        if (this.getType() != 1003) {
            bl = this.fetchScrollOption(this.numberOfRows + 1, (short)5);
            this.rowPosition = this.numberOfRows + 1;
            this.currentBlockCell = this.rowSet + 1;
            if (this.atInsertRow) {
                this.lastRowPosition = 0;
                this.lastBlockPosition = 0;
                this.atInsertRow = false;
            }
        } else {
            throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
        }
    }

    @Override
    public boolean first() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                boolean bl = false;
                boolean bl2 = false;
                if (this.blockCursor && !(bl = this.blockFetch(1, (short)2))) {
                    bl2 = true;
                }
                if (!this.blockCursor || bl) {
                    this.resetInsertRow();
                    this.lastColumnNull = false;
                    this.closeInputStreams();
                    this.clearWarnings();
                    bl2 = this.fetchScrollOption(this.rowPosition, (short)2);
                }
                if (bl2) {
                    this.currentBlockCell = this.rowPosition = 1;
                }
                return bl2;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean last() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                this.moveToCurrentRow();
                boolean bl = false;
                boolean bl2 = false;
                if (this.blockCursor) {
                    bl = this.blockFetch(this.numberOfRows, (short)3);
                    if (!bl) {
                        this.setPos(this.currentBlockCell, 0);
                        bl2 = true;
                    } else {
                        bl2 = true;
                    }
                }
                if (!this.blockCursor || bl) {
                    this.resetInsertRow();
                    this.lastColumnNull = false;
                    this.closeInputStreams();
                    this.clearWarnings();
                    bl2 = bl ? this.fetchScrollOption(this.numberOfRows, (short)5) : this.fetchScrollOption(this.numberOfRows, (short)3);
                    if (bl2) {
                        this.rowPosition = this.numberOfRows;
                    }
                    this.currentBlockCell = 1;
                }
                return bl2;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    @Override
    public int getRow() throws SQLException {
        this.checkOpen();
        if (this.getType() == 1003) {
            if (this.lastForwardRecord == 0) {
                return this.rowPosition;
            }
            return 0;
        }
        if (this.numberOfRows > 0) {
            if (this.rowPosition <= 0 || this.rowPosition > this.numberOfRows) {
                return 0;
            }
            return this.rowPosition;
        }
        return 0;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                boolean bl = false;
                boolean bl2 = false;
                if (n != 0) {
                    if (this.blockCursor) {
                        if (this.atInsertRow) {
                            this.rowPosition = this.lastRowPosition;
                            this.currentBlockCell = this.lastBlockPosition;
                            this.atInsertRow = false;
                        }
                        if (bl2 = this.blockFetch(n, (short)5)) {
                            this.currentBlockCell = 1;
                        } else {
                            this.setPos(this.currentBlockCell, 0);
                            bl = true;
                        }
                    }
                    if (!this.blockCursor || bl2) {
                        this.rowPosition = n >= 0 ? n : this.numberOfRows + 1 + n;
                        if (this.rowPosition > this.numberOfRows) {
                            this.afterLast();
                            return false;
                        }
                        if (this.rowPosition < 1) {
                            this.beforeFirst();
                            return false;
                        }
                        this.lastColumnNull = false;
                        this.closeInputStreams();
                        this.clearWarnings();
                        bl = this.fetchScrollOption(n, (short)5);
                    }
                    return bl;
                }
                throw new SQLException("Cursor position (" + n + ") is invalid");
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    protected boolean fetchScrollOption(int n, short s) throws SQLException {
        if (this.numberOfRows > 0) {
            try {
                this.OdbcApi.SQLFetchScroll(this.hStmt, s, n);
            }
            catch (SQLWarning sQLWarning) {
                this.setWarning(sQLWarning);
                return true;
            }
            catch (SQLException sQLException) {
                return false;
            }
            return true;
        }
        return false;
    }

    protected void consecutiveFetch(int n) throws SQLException {
        boolean bl = false;
        if (this.blockCursor && this.rowUpdated) {
            bl = true;
        }
        if (this.rowSet != 1) {
            if (this.lastColumnData == n || bl) {
                try {
                    this.OdbcApi.SQLFetchScroll(this.hStmt, (short)5, this.getRow());
                    this.lastColumnData = 0;
                    if (this.blockCursor) {
                        this.currentBlockCell = 1;
                    }
                }
                catch (SQLWarning sQLWarning) {
                    this.setWarning(sQLWarning);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.rowUpdated = false;
            } else {
                this.lastColumnData = n;
            }
        }
    }

    @Override
    public boolean relative(int n) throws SQLException {
        this.checkOpen();
        return this.relative(n, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean relative(int n, boolean bl) throws SQLException {
        int n2;
        boolean bl2;
        boolean bl3;
        block13: {
            block12: {
                this.checkOpen();
                if (this.getType() == 1003) throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
                if (this.numberOfRows <= 0) throw new SQLException("Call to relative(" + n + ") when there is no current row.");
                this.moveToCurrentRow();
                bl3 = false;
                bl2 = false;
                n2 = -1;
                if (bl) {
                    if (this.rowPosition == 0) {
                        throw new SQLException("Cursor is positioned before the ResultSet");
                    }
                    if (this.rowPosition > this.numberOfRows) {
                        throw new SQLException("Cursor is positioned after the ResultSet");
                    }
                }
                if (!this.blockCursor) break block12;
                bl2 = this.blockFetch(this.rowPosition + n, (short)5);
                if (bl2) {
                    n2 = this.rowPosition;
                    n2 += n;
                    break block13;
                } else if (n == 0) {
                    n2 = n;
                    bl2 = true;
                }
                break block13;
            }
            n2 = this.rowPosition;
            n2 += n;
        }
        if (n2 <= 1 && n < 0) {
            this.beforeFirst();
            if (bl) {
                return false;
            }
            if (n2 != 1) return false;
            return true;
        }
        if (n2 >= this.numberOfRows && n > 0) {
            this.afterLast();
            if (bl) {
                return false;
            }
            if (n2 != this.numberOfRows) return false;
            return true;
        }
        this.lastColumnNull = false;
        this.closeInputStreams();
        this.clearWarnings();
        if (!this.blockCursor) {
            bl3 = this.fetchScrollOption(n, (short)6);
            if (!bl3) return bl3;
            this.rowPosition = n2;
            return bl3;
        }
        if (bl2) {
            bl3 = this.fetchScrollOption(n2, (short)5);
            if (!bl3) return bl3;
            this.rowPosition = n2;
            this.currentBlockCell = 1;
            return bl3;
        }
        this.setPos(this.currentBlockCell, 0);
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            int n = 0;
            if (this.numberOfRows > 0) {
                if (this.atInsertRow) {
                    n = this.lastRowPosition;
                }
                this.moveToCurrentRow();
                if (this.getFetchDirection() == 1000) {
                    if (n > 0) {
                        return this.absolute(n - 1);
                    }
                    if (this.rowPosition > 1) {
                        return this.absolute(this.rowPosition - 1);
                    }
                    if (this.rowPosition == 1) {
                        this.beforeFirst();
                        return false;
                    }
                    if (this.isBeforeFirst()) {
                        return false;
                    }
                    return false;
                }
                if (n > 0) {
                    return this.absolute(n + 1);
                }
                if (this.rowPosition < this.numberOfRows) {
                    return this.absolute(this.rowPosition + 1);
                }
                if (this.rowPosition == this.numberOfRows) {
                    this.afterLast();
                    return false;
                }
                if (this.isAfterLast()) {
                    return false;
                }
                return false;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    protected boolean blockFetch(int n, short s) throws SQLException {
        boolean bl = false;
        if (this.isBeforeFirst() || this.isAfterLast()) {
            return true;
        }
        switch (s) {
            case 2: {
                if (this.rowPosition == 1) break;
                if (!this.isRowWithinTheBlock(1)) {
                    bl = true;
                    break;
                }
                this.currentBlockCell = this.rowPosition = 1;
                break;
            }
            case 3: {
                if (this.rowPosition < this.numberOfRows) {
                    if (!this.isRowWithinTheBlock(this.numberOfRows)) {
                        bl = true;
                        break;
                    }
                    while (this.rowPosition != this.numberOfRows) {
                        ++this.rowPosition;
                        ++this.currentBlockCell;
                    }
                    bl = false;
                    break;
                }
                if (this.rowPosition != this.numberOfRows) break;
                bl = false;
                break;
            }
            case 5: {
                if (this.rowPosition == n) break;
                if (n < 0 || n > this.numberOfRows) {
                    bl = true;
                    break;
                }
                if (!this.isRowWithinTheBlock(n)) {
                    bl = true;
                    break;
                }
                while (this.rowPosition != n) {
                    if (this.moveUpBlock) {
                        --this.rowPosition;
                        --this.currentBlockCell;
                        continue;
                    }
                    if (!this.moveDownBlock) continue;
                    ++this.rowPosition;
                    ++this.currentBlockCell;
                }
                bl = false;
                break;
            }
        }
        return bl;
    }

    protected boolean isRowWithinTheBlock(int n) {
        boolean bl = false;
        if (this.rowPosition != 0) {
            int n2 = this.rowPosition - (this.currentBlockCell - 1);
            int n3 = this.rowPosition + (this.rowSet - this.currentBlockCell);
            if (n3 < n || n2 > n) {
                bl = false;
            } else if (n > this.rowPosition) {
                bl = true;
                this.moveUpBlock = false;
                this.moveDownBlock = true;
            } else if (n < this.rowPosition) {
                bl = true;
                this.moveUpBlock = true;
                this.moveDownBlock = false;
            }
        }
        return bl;
    }

    protected int getRowIndex() {
        int n = 0;
        if (this.blockCursor) {
            n = this.currentBlockCell - 1;
        } else if (this.atInsertRow) {
            n = this.rowSet;
        }
        return n;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.checkOpen();
        this.ownerStatement.setFetchDirection(n);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this.ownerStatement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.checkOpen();
        this.ownerStatement.setFetchSize(n);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.ownerStatement.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        this.checkOpen();
        if (this.ownerStatement != null) {
            return this.ownerStatement.getResultSetType();
        }
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkOpen();
        return this.ownerStatement.getResultSetConcurrency();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkOpen();
        if (this.numberOfRows > 0) {
            int n = this.getRowIndex();
            if (this.blockCursor) {
                return this.rowStatusArray[n] == 2;
            }
            return this.rowStatusArray[this.rowSet - 1] == 2;
        }
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkOpen();
        if (this.numberOfRows > 0) {
            int n = this.getRowIndex();
            if (this.blockCursor) {
                return this.rowStatusArray[n] == 4;
            }
            return this.rowStatusArray[this.rowSet - 1] == 4;
        }
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkOpen();
        if (this.numberOfRows > 0) {
            int n = this.getRowIndex();
            if (this.blockCursor) {
                return this.rowStatusArray[n] == 1;
            }
            return this.rowStatusArray[this.rowSet - 1] == 1;
        }
        return false;
    }

    @Override
    public void updateNull(int n) throws SQLException {
        this.checkOpen();
        int n2 = this.getRowIndex();
        if (n > 0 && n <= this.numberOfCols) {
            int n3 = this.getColumnType(n);
            if (n3 != 9999) {
                this.boundCols[n - 1].setRowValues(n2, null, -1);
            } else {
                throw new SQLException("Unknown Data Type for column [#" + n + "]");
            }
        }
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.checkOpen();
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        this.updateInt(n, n2);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        this.checkOpen();
        int n2 = this.getRowIndex();
        if (n > 0 && n <= this.numberOfCols) {
            int n3 = this.getColumnType(n);
            if (n3 != -6) {
                this.boundCols[n - 1].setType(-6);
            }
            this.boundCols[n - 1].setRowValues(n2, new Integer(by), 4);
        }
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        this.checkOpen();
        int n2 = this.getRowIndex();
        if (n > 0 && n <= this.numberOfCols) {
            int n3 = this.getColumnType(n);
            if (n3 != 5) {
                this.boundCols[n - 1].setType(5);
            }
            this.boundCols[n - 1].setRowValues(n2, new Integer(s), 4);
        }
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        this.checkOpen();
        int n3 = this.getRowIndex();
        if (n > 0 && n <= this.numberOfCols) {
            int n4 = this.getColumnType(n);
            if (n4 != 4) {
                this.boundCols[n - 1].setType(4);
            }
            this.boundCols[n - 1].setRowValues(n3, new Integer(n2), 4);
        }
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        this.checkOpen();
        this.updateFloat(n, (float)l);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        this.checkOpen();
        int n2 = this.getRowIndex();
        if (n > 0 && n <= this.numberOfCols) {
            int n3 = this.getColumnType(n);
            if (n3 != 6) {
                this.boundCols[n - 1].setType(6);
            }
            this.boundCols[n - 1].setRowValues(n2, new Float(f), 4);
        }
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        this.checkOpen();
        int n2 = this.getRowIndex();
        if (n > 0 && n <= this.numberOfCols) {
            int n3 = this.getColumnType(n);
            if (n3 != 8) {
                this.boundCols[n - 1].setType(8);
            }
            this.boundCols[n - 1].setRowValues(n2, new Double(d), 8);
        }
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkOpen();
        int n2 = this.getColumnType(n);
        if (n2 == 3 || n2 == 2) {
            if (bigDecimal == null) {
                this.updateChar(n, n2, null);
            } else {
                this.updateChar(n, n2, bigDecimal.toString());
            }
        } else if (bigDecimal == null) {
            this.updateChar(n, 2, null);
        } else {
            this.updateChar(n, 2, bigDecimal.toString());
        }
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        byte[] byArray;
        this.checkOpen();
        try {
            byArray = string == null ? null : string.getBytes(this.OdbcApi.charSet);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        this.updateBytes(n, byArray);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.checkOpen();
        int n2 = this.getRowIndex();
        if (byArray != null && byArray.length > 8000) {
            this.updateBinaryStream(n, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
        }
        if (n > 0 && n <= this.numberOfCols) {
            int n3 = this.getColumnType(n);
            if (n3 != -2 && n3 != -3) {
                this.boundCols[n - 1].setType(-2);
                if (byArray != null) {
                    this.boundCols[n - 1].setLength(byArray.length);
                }
            }
            if (byArray == null) {
                this.updateNull(n);
                return;
            }
            if (byArray.length > this.boundCols[n - 1].getLength()) {
                this.boundCols[n - 1].setLength(byArray.length);
            }
            this.boundCols[n - 1].setRowValues(n2, byArray, byArray.length);
        }
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        this.checkOpen();
        int n2 = this.getRowIndex();
        if (n > 0 && n <= this.numberOfCols) {
            if (this.getColumnType(n) != 91) {
                this.boundCols[n - 1].setType(91);
            }
            if (date == null) {
                this.updateNull(n);
                return;
            }
            this.boundCols[n - 1].setRowValues(n2, date, 6);
        }
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        this.checkOpen();
        int n2 = this.getRowIndex();
        if (n > 0 && n <= this.numberOfCols) {
            if (this.getColumnType(n) != 92) {
                this.boundCols[n - 1].setType(92);
            }
            if (time == null) {
                this.updateNull(n);
                return;
            }
            this.boundCols[n - 1].setRowValues(n2, time, 6);
        }
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkOpen();
        int n2 = this.getRowIndex();
        if (n > 0 && n <= this.numberOfCols) {
            if (this.getColumnType(n) != 93) {
                this.boundCols[n - 1].setType(93);
            }
            if (timestamp == null) {
                this.updateNull(n);
                return;
            }
            this.boundCols[n - 1].setRowValues(n2, timestamp, 16);
        }
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkOpen();
        int n3 = this.getRowIndex();
        if (n > 0 && n <= this.numberOfCols) {
            if (this.getColumnType(n) != -1) {
                this.boundCols[n - 1].setType(-1);
            }
            if (inputStream == null) {
                this.updateNull(n);
                return;
            }
            if (n2 != this.boundCols[n - 1].getLength()) {
                this.boundCols[n - 1].setLength(n2);
            }
            this.boundCols[n - 1].setRowValues(n3, inputStream, n2);
            this.boundCols[n - 1].setStreamType(1);
        }
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkOpen();
        int n3 = this.getRowIndex();
        if (n > 0 && n <= this.numberOfCols) {
            if (this.getColumnType(n) != -4) {
                this.boundCols[n - 1].setType(-4);
            }
            if (inputStream == null) {
                this.updateNull(n);
                return;
            }
            if (n2 != this.boundCols[n - 1].getLength()) {
                this.boundCols[n - 1].setLength(n2);
            }
            this.boundCols[n - 1].setRowValues(n3, inputStream, n2);
            this.boundCols[n - 1].setStreamType(3);
        }
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkOpen();
        int n3 = this.getRowIndex();
        BufferedReader bufferedReader = null;
        BufferedOutputStream bufferedOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        String string = this.OdbcApi.charSet;
        int n4 = 300;
        if (n2 < n4) {
            n4 = n2;
        }
        int n5 = 0;
        int n6 = 0;
        try {
            CharToByteConverter charToByteConverter = CharToByteConverter.getConverter(string);
            n6 = charToByteConverter.getMaxBytesPerChar();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (n6 == 0) {
            n6 = 1;
        }
        try {
            if (reader != null) {
                boolean bl = false;
                int n7 = 0;
                bufferedReader = new BufferedReader(reader);
                byteArrayOutputStream = new ByteArrayOutputStream();
                bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                char[] cArray = new char[n4];
                while (n7 != -1) {
                    int n8;
                    byte[] byArray = new byte[]{};
                    n7 = bufferedReader.read(cArray);
                    if (n7 == -1) continue;
                    char[] cArray2 = new char[n7];
                    for (n8 = 0; n8 < n7; ++n8) {
                        cArray2[n8] = cArray[n8];
                    }
                    byArray = this.CharsToBytes(string, cArray2);
                    n8 = byArray.length - 1;
                    bufferedOutputStream.write(byArray, 0, n8);
                    bufferedOutputStream.flush();
                }
                n5 = byteArrayOutputStream.size();
                byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
        }
        catch (IOException iOException) {
            throw new SQLException("CharsToBytes Reader Conversion: " + iOException.getMessage());
        }
        if (n > 0 && n <= this.numberOfCols) {
            if (this.getColumnType(n) != -1 || this.getColumnType(n) != 12) {
                this.boundCols[n - 1].setType(-1);
            }
            if (reader == null) {
                this.updateNull(n);
                return;
            }
            if (n5 != this.boundCols[n - 1].getLength()) {
                this.boundCols[n - 1].setLength(n5);
            }
            this.boundCols[n - 1].setRowValues(n3, byteArrayInputStream, n5);
            this.boundCols[n - 1].setStreamType(3);
        }
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.updateObject(n, object, n2, this.boundCols[n - 1].getType());
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        this.updateObject(n, object, 0, this.boundCols[n - 1].getType());
    }

    protected void updateObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkOpen();
        if (n3 == 9999 && object != null) {
            n3 = JdbcOdbcStatement.getTypeFromObject(object);
        } else if (object == null) {
            n3 = 0;
        }
        if (n > 0 && n <= this.numberOfCols) {
            switch (n3) {
                case 1: 
                case 12: {
                    this.updateString(n, (String)object);
                    break;
                }
                case -1: {
                    if (object instanceof byte[] && (byte[])object != null) {
                        byte[] byArray = (byte[])object;
                        this.updateAsciiStream(n, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                        break;
                    }
                    if (object instanceof Reader && (Reader)object != null) {
                        throw new SQLException("Unknown length for Reader Object, try updateCharacterStream.");
                    }
                    if (!(object instanceof String) || (String)object == null) break;
                    this.updateString(n, (String)object);
                    break;
                }
                case 2: 
                case 3: {
                    this.updateBigDecimal(n, (BigDecimal)object);
                    break;
                }
                case -7: {
                    this.updateBoolean(n, (boolean)((Boolean)object));
                    break;
                }
                case -6: {
                    this.updateByte(n, (byte)((Integer)object).intValue());
                    break;
                }
                case 5: {
                    this.updateShort(n, (short)((Integer)object).intValue());
                    break;
                }
                case 4: {
                    this.updateInt(n, (int)((Integer)object));
                    break;
                }
                case -5: {
                    this.updateLong(n, ((Integer)object).longValue());
                    break;
                }
                case 6: 
                case 7: {
                    this.updateFloat(n, ((Float)object).floatValue());
                    break;
                }
                case 8: {
                    this.updateDouble(n, (double)((Double)object));
                    break;
                }
                case -2: {
                    if (object instanceof String) {
                        try {
                            this.updateBytes(n, ((String)object).getBytes(this.OdbcApi.charSet));
                            break;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            throw new SQLException(unsupportedEncodingException.getMessage());
                        }
                    }
                    this.updateBytes(n, (byte[])object);
                    break;
                }
                case -4: 
                case -3: {
                    byte[] byArray = null;
                    if (object instanceof String) {
                        try {
                            byArray = ((String)object).getBytes(this.OdbcApi.charSet);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            throw new SQLException(unsupportedEncodingException.getMessage());
                        }
                    } else {
                        byArray = (byte[])object;
                    }
                    if (byArray.length > 8000) {
                        this.updateBinaryStream(n, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                        break;
                    }
                    this.updateBytes(n, byArray);
                    break;
                }
                case 91: {
                    this.updateDate(n, (Date)object);
                    break;
                }
                case 92: {
                    this.updateTime(n, (Time)object);
                    break;
                }
                case 93: {
                    this.updateTimestamp(n, (Timestamp)object);
                    break;
                }
                case 0: {
                    this.updateNull(n);
                    break;
                }
                default: {
                    throw new SQLException("Unknown SQL Type for ResultSet.updateObject SQL Type = " + n3);
                }
            }
        }
    }

    protected void updateChar(int n, int n2, String string) throws SQLException {
        this.checkOpen();
        int n3 = this.getRowIndex();
        if (n > 0 && n <= this.numberOfCols) {
            int n4 = this.getColumnType(n);
            if (n4 != n2) {
                this.boundCols[n - 1].setType(n2);
            }
            if (string == null) {
                this.updateNull(n);
            } else {
                this.boundCols[n - 1].setRowValues(n3, string, -3);
            }
        }
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateInt(this.findColumn(string), (int)by);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.updateInt(this.findColumn(string), (int)s);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.updateFloat(this.findColumn(string), (float)l);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkOpen();
        for (int i = 0; i < this.numberOfCols; ++i) {
            int n = this.boundCols[i].getType();
            this.bindCol(i + 1, n);
        }
        if (this.getType() != 1003) {
            if (this.blockCursor) {
                this.setPos(this.currentBlockCell, 4);
            } else {
                this.setPos(this.rowSet, 4);
            }
            this.FreeCols();
            if (this.ownInsertsAreVisible) {
                ++this.numberOfRows;
            }
        } else {
            throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
        }
        this.resetColumnState();
        this.resetInsertRow();
    }

    @Override
    public void updateRow() throws SQLException {
        this.checkOpen();
        for (int i = 0; i < this.numberOfCols; ++i) {
            int n = this.boundCols[i].getType();
            this.bindCol(i + 1, n);
        }
        if (this.getType() != 1003) {
            if (this.blockCursor) {
                this.setPos(this.currentBlockCell, 2);
            } else {
                this.setPos(this.rowSet, 2);
            }
        } else {
            throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
        }
        this.FreeCols();
        this.resetColumnState();
        this.rowUpdated = true;
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkOpen();
        if (this.blockCursor) {
            this.setPos(this.currentBlockCell, 3);
        } else {
            this.setPos(this.rowSet, 3);
        }
        if (this.ownDeletesAreVisible) {
            --this.numberOfRows;
        }
    }

    private void setResultSetVisibilityIndicators() throws SQLException {
        int n = this.OdbcApi.SQLGetStmtAttr(this.hStmt, 6);
        short s = 0;
        switch (n) {
            case 1: {
                s = 151;
                break;
            }
            case 2: {
                s = 145;
                break;
            }
            case 3: {
                s = 168;
            }
        }
        if (s > 0) {
            try {
                int n2 = this.OdbcApi.SQLGetInfo(this.hDbc, s);
                if ((n2 & 0x20) > 0) {
                    this.ownDeletesAreVisible = true;
                }
                if ((n2 & 0x10) > 0) {
                    this.ownInsertsAreVisible = true;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.atInsertRow || this.getRow() <= 0) {
                throw new SQLException("Cursor position is invalid");
            }
        } else {
            throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
        }
        this.fetchScrollOption(0, (short)6);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkOpen();
        if (this.atInsertRow) {
            throw new SQLException("Cursor position on insert row");
        }
        this.resetColumnState();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("Invalid Cursor Type: " + this.getType());
        }
        this.checkOpen();
        this.atInsertRow = true;
        this.lastRowPosition = this.rowPosition;
        this.lastBlockPosition = this.currentBlockCell;
        if (this.blockCursor) {
            this.currentBlockCell = this.rowSet + 1;
        }
        this.resetInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkOpen();
        boolean bl = false;
        if (this.atInsertRow) {
            this.resetInsertRow();
            this.rowPosition = this.lastRowPosition;
            this.currentBlockCell = this.lastBlockPosition;
            bl = this.absolute(this.rowPosition);
            if (bl) {
                this.lastRowPosition = 0;
                this.lastBlockPosition = 0;
            }
            this.atInsertRow = false;
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkOpen();
        if (this.ownerStatement != null) {
            return this.ownerStatement;
        }
        return null;
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getArray(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getArray(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        long l = 0L;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            return null;
        }
        l = this.getDataLongDate(n, calendar);
        if (l == 0L) {
            return null;
        }
        return new Date(l);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        long l = 0L;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            return null;
        }
        l = this.getDataLongTime(n, calendar);
        if (l == 0L) {
            return null;
        }
        return new Time(l);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        long l = 0L;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            return null;
        }
        l = this.getDataLongTimestamp(n, calendar);
        if (l == 0L) {
            return null;
        }
        return new Timestamp(l);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    protected void setRowStatusPtr() throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.rowStatusArray = new int[this.rowSet + 1];
        this.pA = new long[2];
        this.pA[0] = 0L;
        this.pA[1] = 0L;
        this.OdbcApi.SQLSetStmtAttrPtr(this.hStmt, 25, this.rowStatusArray, 0, this.pA);
    }

    protected boolean setRowArraySize() {
        int n = 0;
        try {
            this.clearWarnings();
            if (this.rowSet > 1) {
                if (this.numberOfRows < this.rowSet) {
                    this.rowSet = this.numberOfRows;
                }
                this.OdbcApi.SQLSetStmtAttr(this.hStmt, 5, 0, 0);
                this.OdbcApi.SQLSetStmtAttr(this.hStmt, 27, this.rowSet, 0);
                n = this.OdbcApi.SQLGetStmtAttr(this.hStmt, 27);
                if (n > 1 && n < this.rowSet) {
                    this.rowSet = n;
                    return true;
                }
            }
        }
        catch (SQLException sQLException) {
            return false;
        }
        return n == this.rowSet;
    }

    protected void resetInsertRow() throws SQLException {
        this.checkOpen();
        int n = this.getRowIndex();
        if (this.atInsertRow) {
            for (int i = 0; i < this.numberOfCols; ++i) {
                this.boundCols[i].resetColumnToIgnoreData();
            }
        }
    }

    protected void resetColumnState() throws SQLException {
        this.checkOpen();
        if (this.hStmt != 0L) {
            this.OdbcApi.SQLFreeStmt(this.hStmt, 2);
        }
        for (int i = 0; i < this.numberOfCols; ++i) {
            this.boundCols[i].resetColumnToIgnoreData();
        }
    }

    protected void bindCol(int n, int n2) throws SQLException {
        boolean bl = false;
        int n3 = 0;
        Object var5_5 = null;
        Object[] objectArray = this.boundCols[n - 1].getRowValues();
        byte[] byArray = this.boundCols[n - 1].getRowLengths();
        if (!this.blockCursor && this.atInsertRow) {
            n3 = 0;
        }
        if (this.blockCursor) {
            n3 = this.currentBlockCell - 1;
        }
        Object object = this.boundCols[n - 1].getRowValue(n3);
        int n4 = this.boundCols[n - 1].getLength();
        if (n4 < 0) {
            n4 = this.getColumnLength(n);
        }
        try {
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 12: {
                    if ((n2 == 2 || n2 == 3) && object != null) {
                        Object object2 = object;
                        String string = object2.toString();
                        n4 = string.length();
                        BigDecimal bigDecimal = new BigDecimal(string);
                        int n5 = bigDecimal.scale();
                        if (n5 <= 0) {
                            ++n4;
                        }
                    }
                    this.bindStringCol(n, n2, objectArray, byArray, n4);
                    break;
                }
                case -1: {
                    int n6 = JdbcOdbcStatement.getTypeFromObject(object);
                    if (n6 == -4 || n6 == 0) {
                        this.bindAtExecCol(n, n2, byArray);
                        break;
                    }
                    if (n6 != -2) break;
                    this.bindBinaryCol(n, objectArray, byArray, n4);
                    break;
                }
                case -7: 
                case -6: 
                case 4: 
                case 5: {
                    this.bindIntegerCol(n, objectArray, byArray);
                    break;
                }
                case 8: {
                    this.bindDoubleCol(n, objectArray, byArray);
                    break;
                }
                case -5: 
                case 6: 
                case 7: {
                    this.bindFloatCol(n, objectArray, byArray);
                    break;
                }
                case 91: {
                    this.bindDateCol(n, objectArray, byArray);
                    break;
                }
                case 92: {
                    this.bindTimeCol(n, objectArray, byArray);
                    break;
                }
                case 93: {
                    this.bindTimestampCol(n, objectArray, byArray);
                    break;
                }
                case -3: 
                case -2: {
                    this.bindBinaryCol(n, objectArray, byArray, n4);
                    break;
                }
                case -4: {
                    this.bindAtExecCol(n, n2, byArray);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SQLException("SQLBinCol (" + n + ") SQLType = " + n2 + ". " + sQLException.getMessage());
        }
    }

    protected void bindStringCol(int n, int n2, Object[] objectArray, byte[] byArray, int n3) throws SQLException {
        byte[] byArray2 = this.boundCols[n - 1].allocBindDataBuffer((n3 + 1) * objectArray.length);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColString(this.hStmt, n, n2, objectArray, n3, byArray, byArray2, lArray);
        this.boundCols[n - 1].pA1 = lArray[0];
        this.boundCols[n - 1].pA2 = lArray[1];
        this.boundCols[n - 1].pC1 = lArray[2];
        this.boundCols[n - 1].pC2 = lArray[3];
    }

    protected void bindIntegerCol(int n, Object[] objectArray, byte[] byArray) throws SQLException {
        byte[] byArray2 = this.boundCols[n - 1].allocBindDataBuffer(4 * objectArray.length);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColInteger(this.hStmt, n, objectArray, byArray, byArray2, lArray);
        this.boundCols[n - 1].pA1 = lArray[0];
        this.boundCols[n - 1].pA2 = lArray[1];
        this.boundCols[n - 1].pC1 = lArray[2];
        this.boundCols[n - 1].pC2 = lArray[3];
    }

    protected void bindFloatCol(int n, Object[] objectArray, byte[] byArray) throws SQLException {
        byte[] byArray2 = this.boundCols[n - 1].allocBindDataBuffer(8 * objectArray.length);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColFloat(this.hStmt, n, objectArray, byArray, byArray2, lArray);
        this.boundCols[n - 1].pA1 = lArray[0];
        this.boundCols[n - 1].pA2 = lArray[1];
        this.boundCols[n - 1].pC1 = lArray[2];
        this.boundCols[n - 1].pC2 = lArray[3];
    }

    protected void bindDoubleCol(int n, Object[] objectArray, byte[] byArray) throws SQLException {
        byte[] byArray2 = this.boundCols[n - 1].allocBindDataBuffer(8 * objectArray.length);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColDouble(this.hStmt, n, objectArray, byArray, byArray2, lArray);
        this.boundCols[n - 1].pA1 = lArray[0];
        this.boundCols[n - 1].pA2 = lArray[1];
        this.boundCols[n - 1].pC1 = lArray[2];
        this.boundCols[n - 1].pC2 = lArray[3];
    }

    protected void bindDateCol(int n, Object[] objectArray, byte[] byArray) throws SQLException {
        byte[] byArray2 = this.boundCols[n - 1].allocBindDataBuffer(10 * objectArray.length);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColDate(this.hStmt, n, objectArray, byArray, byArray2, lArray);
        this.boundCols[n - 1].pA1 = lArray[0];
        this.boundCols[n - 1].pA2 = lArray[1];
        this.boundCols[n - 1].pC1 = lArray[2];
        this.boundCols[n - 1].pC2 = lArray[3];
    }

    protected void bindTimeCol(int n, Object[] objectArray, byte[] byArray) throws SQLException {
        byte[] byArray2 = this.boundCols[n - 1].allocBindDataBuffer(9 * objectArray.length);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColTime(this.hStmt, n, objectArray, byArray, byArray2, lArray);
        this.boundCols[n - 1].pA1 = lArray[0];
        this.boundCols[n - 1].pA2 = lArray[1];
        this.boundCols[n - 1].pC1 = lArray[2];
        this.boundCols[n - 1].pC2 = lArray[3];
    }

    protected void bindTimestampCol(int n, Object[] objectArray, byte[] byArray) throws SQLException {
        byte[] byArray2 = this.boundCols[n - 1].allocBindDataBuffer(30 * objectArray.length);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColTimestamp(this.hStmt, n, objectArray, byArray, byArray2, lArray);
        this.boundCols[n - 1].pA1 = lArray[0];
        this.boundCols[n - 1].pA2 = lArray[1];
        this.boundCols[n - 1].pC1 = lArray[2];
        this.boundCols[n - 1].pC2 = lArray[3];
    }

    protected void bindBinaryCol(int n, Object[] objectArray, byte[] byArray, int n2) throws SQLException {
        byte[] byArray2 = this.boundCols[n - 1].allocBindDataBuffer((n2 + 1) * objectArray.length);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColBinary(this.hStmt, n, objectArray, byArray, n2, byArray2, lArray);
        this.boundCols[n - 1].pA1 = lArray[0];
        this.boundCols[n - 1].pA2 = lArray[1];
        this.boundCols[n - 1].pC1 = lArray[2];
        this.boundCols[n - 1].pC2 = lArray[3];
    }

    protected void bindAtExecCol(int n, int n2, byte[] byArray) throws SQLException {
        byte[] byArray2 = this.boundCols[n - 1].allocBindDataBuffer(4);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColAtExec(this.hStmt, n, n2, byArray, byArray2, lArray);
        this.boundCols[n - 1].pA1 = lArray[0];
        this.boundCols[n - 1].pA2 = lArray[1];
        this.boundCols[n - 1].pC1 = lArray[2];
        this.boundCols[n - 1].pC2 = lArray[3];
    }

    protected void setPos(int n, int n2) throws SQLException {
        SQLWarning sQLWarning = null;
        boolean bl = false;
        try {
            this.clearWarnings();
            bl = this.OdbcApi.SQLSetPos(this.hStmt, n, n2, 0);
            int n3 = 0;
            while (bl) {
                int n4 = this.getRowIndex();
                String string = this.OdbcApi.odbcDriverName;
                n3 = this.blockCursor && string.indexOf("(IV") == -1 ? this.OdbcApi.SQLParamDataInBlock(this.hStmt, n4) : this.OdbcApi.SQLParamData(this.hStmt);
                if (n3 == -1) {
                    bl = false;
                    continue;
                }
                this.putColumnData(n3);
            }
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            throw new SQLException(sQLException.getMessage());
        }
    }

    protected void putColumnData(int n) throws SQLException, JdbcOdbcSQLWarning {
        int n2 = 2000;
        byte[] byArray = new byte[n2];
        boolean bl = false;
        if (n < 1 || n > this.numberOfCols) {
            if (this.OdbcApi.getTracer().isTracing()) {
                this.OdbcApi.getTracer().trace("Invalid index for putColumnData()");
            }
            return;
        }
        InputStream inputStream = null;
        int n3 = this.getRowIndex();
        try {
            inputStream = (InputStream)this.boundCols[n - 1].getRowValue(n3);
        }
        catch (Exception exception) {
            throw new SQLException("Invalid data for columnIndex(" + n + "): " + exception.getMessage());
        }
        int n4 = this.boundCols[n - 1].getLength();
        int n5 = this.boundCols[n - 1].getStreamType();
        while (!bl) {
            int n6;
            try {
                if (this.OdbcApi.getTracer().isTracing()) {
                    this.OdbcApi.getTracer().trace("Reading from input stream");
                }
                n6 = inputStream.read(byArray);
                if (this.OdbcApi.getTracer().isTracing()) {
                    this.OdbcApi.getTracer().trace("Bytes read: " + n6);
                }
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
            if (n6 == -1) {
                if (n4 != 0) {
                    throw new SQLException("End of InputStream reached before satisfying length specified when InputStream was set");
                }
                bl = true;
                break;
            }
            if (n6 > n4) {
                n6 = n4;
                bl = true;
            }
            int n7 = n6;
            try {
                this.OdbcApi.SQLPutData(this.hStmt, byArray, n7);
            }
            catch (SQLWarning sQLWarning) {
                this.setWarning(sQLWarning);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            n4 -= n6;
            if (this.OdbcApi.getTracer().isTracing()) {
                this.OdbcApi.getTracer().trace("" + n4 + " bytes remaining");
            }
            if (n4 != 0) continue;
            bl = true;
        }
    }

    @Override
    public int getColAttribute(int n, int n2) throws SQLException {
        int n3 = 0;
        this.clearWarnings();
        try {
            n3 = this.OdbcApi.SQLColAttributes(this.hStmt, n, n2);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n3 = bigDecimal.intValue();
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return n3;
    }

    protected int getMaxCharLen(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        int n3 = this.getColumnLength(n);
        if (n3 != -1) {
            switch (n2) {
                case -4: 
                case -3: 
                case -2: {
                    n3 *= 2;
                    break;
                }
                case 91: {
                    n3 = 10;
                    break;
                }
                case 92: {
                    n3 = 8;
                    break;
                }
                case 93: {
                    n3 = 29;
                    break;
                }
                case 2: 
                case 3: {
                    n3 += 2;
                    break;
                }
                case -7: {
                    n3 = 1;
                    break;
                }
                case -6: {
                    n3 = 4;
                    break;
                }
                case 5: {
                    n3 = 6;
                    break;
                }
                case 4: {
                    n3 = 11;
                    break;
                }
                case -5: {
                    n3 = 20;
                    break;
                }
                case 7: {
                    n3 = 13;
                    break;
                }
                case 6: 
                case 8: {
                    n3 = 22;
                }
            }
            if (n3 <= 0 || n3 > Short.MAX_VALUE) {
                n3 = Short.MAX_VALUE;
            }
        }
        return n3;
    }

    protected int getMaxBinaryLen(int n) throws SQLException {
        int n2 = this.getColumnLength(n);
        if (n2 != -1 && (n2 <= 0 || n2 > Short.MAX_VALUE)) {
            n2 = Short.MAX_VALUE;
        }
        return n2;
    }

    public Double getDataDouble(int n) throws SQLException {
        Double d;
        this.lastColumnNull = false;
        try {
            d = this.OdbcApi.SQLGetDataDouble(this.hStmt, n);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            d = (Double)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (d == null) {
            this.lastColumnNull = true;
        }
        return d;
    }

    public Float getDataFloat(int n) throws SQLException {
        Float f;
        this.lastColumnNull = false;
        try {
            f = this.OdbcApi.SQLGetDataFloat(this.hStmt, n);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            f = (Float)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (f == null) {
            this.lastColumnNull = true;
        }
        return f;
    }

    public Integer getDataInteger(int n) throws SQLException {
        Integer n2;
        this.lastColumnNull = false;
        try {
            n2 = this.OdbcApi.SQLGetDataInteger(this.hStmt, n);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            n2 = (Integer)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (n2 == null) {
            this.lastColumnNull = true;
        } else if (n == this.sqlTypeColumn) {
            n2 = new Integer(OdbcDef.odbcTypeToJdbc(n2));
        }
        return n2;
    }

    public Long getDataLong(int n) throws SQLException {
        Long l = null;
        Double d = this.getDataDouble(n);
        if (d != null) {
            l = new Long(d.longValue());
        }
        return l;
    }

    public String getDataString(int n, int n2, boolean bl) throws SQLException {
        String string;
        this.lastColumnNull = false;
        try {
            string = this.OdbcApi.SQLGetDataString(this.hStmt, n, n2, bl);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (string == null) {
            this.lastColumnNull = true;
        } else if (n == this.sqlTypeColumn) {
            try {
                int n3 = OdbcDef.odbcTypeToJdbc(Integer.valueOf(string));
                string = "" + n3;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public String getDataStringDate(int n) throws SQLException {
        String string;
        this.lastColumnNull = false;
        try {
            string = this.OdbcApi.SQLGetDataStringDate(this.hStmt, n);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (string == null) {
            this.lastColumnNull = true;
        }
        return string;
    }

    public String getDataStringTime(int n) throws SQLException {
        String string;
        this.lastColumnNull = false;
        try {
            string = this.OdbcApi.SQLGetDataStringTime(this.hStmt, n);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (string == null) {
            this.lastColumnNull = true;
        }
        return string;
    }

    public String getDataStringTimestamp(int n) throws SQLException {
        String string;
        this.lastColumnNull = false;
        try {
            string = this.OdbcApi.SQLGetDataStringTimestamp(this.hStmt, n);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (string == null) {
            this.lastColumnNull = true;
        }
        return string;
    }

    public long getDataLongDate(int n, Calendar calendar) throws SQLException {
        String string;
        this.lastColumnNull = false;
        Date date = null;
        long l = 0L;
        try {
            string = this.OdbcApi.SQLGetDataStringDate(this.hStmt, n);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (string != null) {
            date = Date.valueOf(string);
            l = this.utils.convertFromGMT(date, calendar);
        } else if (string == null) {
            this.lastColumnNull = true;
        }
        return l;
    }

    public long getDataLongTime(int n, Calendar calendar) throws SQLException {
        String string;
        this.lastColumnNull = false;
        Time time = null;
        long l = 0L;
        try {
            string = this.OdbcApi.SQLGetDataStringTime(this.hStmt, n);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (string != null) {
            time = Time.valueOf(string);
            l = this.utils.convertFromGMT(time, calendar);
        } else if (string == null) {
            this.lastColumnNull = true;
        }
        return l;
    }

    public long getDataLongTimestamp(int n, Calendar calendar) throws SQLException {
        String string;
        this.lastColumnNull = false;
        Timestamp timestamp = null;
        long l = 0L;
        try {
            string = this.OdbcApi.SQLGetDataStringTimestamp(this.hStmt, n);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (string != null) {
            timestamp = Timestamp.valueOf(string);
            l = this.utils.convertFromGMT(timestamp, calendar);
        } else if (string == null) {
            this.lastColumnNull = true;
        }
        return l;
    }

    public int getColumnLength(int n) throws SQLException {
        int n2 = -1;
        if (n > 0 && n <= this.numberOfCols) {
            n2 = this.boundCols[n - 1].getLength();
        }
        if (n2 == -1) {
            n2 = this.getColAttribute(n, 3);
            if (n > 0 && n <= this.numberOfCols) {
                this.boundCols[n - 1].setLength(n2);
            }
        }
        return n2;
    }

    @Override
    public int getScale(int n) throws SQLException {
        int n2;
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            n2 = 0;
        } else {
            n2 = this.getColAttribute(n, 5);
        }
        return n2;
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        int n2 = 9999;
        if (n > 0 && n <= this.numberOfCols) {
            n2 = this.boundCols[n - 1].getType();
        }
        if (n2 == 9999) {
            n2 = this.getColAttribute(n, 2);
            n2 = OdbcDef.odbcTypeToJdbc(n2);
            if (n > 0 && n <= this.numberOfCols) {
                this.boundCols[n - 1].setType(n2);
            }
        }
        return n2;
    }

    public void setPseudoCols(int n, int n2, JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray) {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("Setting pseudo columns, first=" + n + ", last=" + n2);
        }
        this.firstPseudoCol = n;
        this.lastPseudoCol = n2;
        this.pseudoCols = jdbcOdbcPseudoColArray;
    }

    @Override
    public JdbcOdbcPseudoCol getPseudoCol(int n) {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol = null;
        if (n > 0 && n >= this.firstPseudoCol && n <= this.lastPseudoCol) {
            jdbcOdbcPseudoCol = this.pseudoCols[n - this.firstPseudoCol];
        }
        return jdbcOdbcPseudoCol;
    }

    public void setSQLTypeColumn(int n) {
        this.sqlTypeColumn = n;
    }

    protected void setInputStream(int n, JdbcOdbcInputStream jdbcOdbcInputStream) {
        if (n > 0 && n <= this.numberOfCols) {
            this.boundCols[n - 1].setInputStream(jdbcOdbcInputStream);
        }
    }

    protected void closeInputStreams() {
        for (int i = 0; i < this.numberOfCols; ++i) {
            this.boundCols[i].closeInputStream();
        }
    }

    public void setColumnMappings(int[] nArray) {
        this.colMappings = nArray;
    }

    @Override
    public int mapColumn(int n) {
        int n2 = n;
        if (this.colMappings != null) {
            n2 = n > 0 && n <= this.colMappings.length ? this.colMappings[n - 1] : -1;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculateRowCount() throws SQLException {
        Object object;
        try {
            this.numberOfRows = this.OdbcApi.SQLRowCount(this.hStmt);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            object = (BigDecimal)jdbcOdbcSQLWarning.value;
            this.numberOfRows = ((BigDecimal)object).intValue();
        }
        if (this.numberOfRows > 0) {
            return;
        }
        try {
            this.OdbcApi.SQLFetchScroll(this.hStmt, (short)3, 0);
            this.numberOfRows = (int)this.OdbcApi.SQLGetStmtOption(this.hStmt, (short)14);
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.OdbcApi.SQLFetchScroll(this.hStmt, (short)5, 0);
        }
        if (this.numberOfRows > 0) {
            this.OdbcApi.SQLFetchScroll(this.hStmt, (short)5, 0);
            return;
        }
        if (this.ownerStatement != null) {
            Connection connection = this.ownerStatement.getConnection();
            object = this.ownerStatement.getSql();
            String string = null;
            String string2 = this.ownerStatement.getClass().getName();
            int n = 0;
            n = this.ownerStatement.getParamCount();
            if (n > 0) {
                if (string2.indexOf("CallableStatement") > 0) {
                    throw new SQLException("Unable to obtain result set row count. From " + (String)object);
                }
                if (string2.indexOf("PreparedStatement") > 0) {
                    if (((String)object).toLowerCase().indexOf("select") == -1) {
                        throw new SQLException("Cannot obtain result set row count for " + (String)object);
                    }
                    string = this.reWordAsCountQuery((String)object);
                    if (string.indexOf("?") > 0) {
                        this.numberOfRows = this.parameterQuery(connection.prepareStatement(string));
                    } else {
                        n = 0;
                    }
                }
            }
            if (string2.indexOf("Statement") > 0 && n == 0) {
                Statement statement = connection.createStatement();
                if (object != null && ((String)object).startsWith("SELECT")) {
                    if (string == null) {
                        string = this.reWordAsCountQuery((String)object);
                    }
                    ResultSet resultSet = statement.executeQuery(string);
                    resultSet.next();
                    this.numberOfRows = resultSet.getInt(1);
                    if (string.indexOf("COUNT(*)") < 0 && this.numberOfRows > 0) {
                        this.numberOfRows = 1;
                        this.setWarning(new SQLWarning("ResultSet is not updatable."));
                    }
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (this.numberOfRows > 0) {
            return;
        }
        this.setWarning(new SQLWarning("Can not determine result set row count."));
    }

    protected int parameterQuery(PreparedStatement preparedStatement) throws SQLException {
        int n = 0;
        Object[] objectArray = null;
        int[] nArray = null;
        if (preparedStatement != null) {
            try {
                objectArray = this.ownerStatement.getObjects();
                nArray = this.ownerStatement.getObjectTypes();
                for (int i = 0; i < objectArray.length; ++i) {
                    preparedStatement.setObject(i + 1, objectArray[i], nArray[i]);
                }
            }
            catch (Exception exception) {
                throw new SQLException("while calculating row count: " + exception.getMessage());
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            n = resultSet.getInt(1);
            preparedStatement.close();
        }
        return n;
    }

    protected String reWordAsCountQuery(String string) {
        int n = string.indexOf(" COUNT(*) ");
        int n2 = -1;
        int n3 = string.indexOf(" FROM ");
        int n4 = string.indexOf("'");
        int n5 = -1;
        if (n4 > 0) {
            n5 = string.indexOf("'", n4 + 2);
        }
        if (n3 > n4 && n5 > n3) {
            n3 = string.indexOf(" FROM ", n5);
        }
        if (n > n4 && n5 > n) {
            n = -1;
        }
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = string.indexOf("WHERE");
        int n12 = -1;
        if (n11 < n3) {
            n11 = string.indexOf("WHERE", n11 + 2);
        }
        String string2 = "";
        if (n10 < 0) {
            n6 = string.lastIndexOf("ORDER BY");
            if (n6 > n11) {
                n10 = n6;
            }
            string2 = "ORDER BY";
        }
        if (n10 < 0) {
            n7 = string.lastIndexOf("GROUP BY");
            if (n7 > n11 && n7 > n6) {
                n10 = n7;
            }
            string2 = "GROUP BY";
        }
        if (n10 < 0) {
            n8 = string.lastIndexOf("FOR UPDATE");
            if (n8 > n11 && n8 > n7) {
                n10 = n8;
            }
            string2 = "FOR UPDATE";
        }
        if (n10 < 0) {
            n9 = string.lastIndexOf("UNION");
            if (n9 > n11 && n9 > n8) {
                n10 = n9;
            }
            string2 = "UNION";
        }
        if (n10 > 0 && n10 > n3) {
            if (n11 > 0 && n11 > n3) {
                int n13 = string.indexOf("'", n11);
                int n14 = -1;
                if (n13 > 0) {
                    n14 = string.indexOf("'", n13 + 2);
                }
                if (n10 > n13 && n5 > n10) {
                    n10 = string.indexOf(string2, n14);
                }
                if (n10 > n14) {
                    string = string.substring(0, n10);
                }
            } else {
                string = string.substring(0, n10);
            }
        }
        String string3 = string.substring(0, n3);
        StringBuffer stringBuffer = new StringBuffer(string);
        if (n < 0 && n2 < 0 && (n2 = string3.lastIndexOf(")")) > 0) {
            int n15 = string.indexOf(" (");
            if (n15 > 0) {
                if (n15 < n4 && n15 < n5) {
                    n2 = -1;
                }
            } else if (n15 < 0) {
                n2 = -1;
                n = n15;
            }
        }
        if (n2 > 0) {
            stringBuffer.insert(6, " COUNT(*), ");
        } else if (n < 0 && n3 > 0) {
            stringBuffer.replace(6, n3, " COUNT(*) ");
        }
        return stringBuffer.toString();
    }

    protected void setCursorType() throws SQLException {
        this.clearWarnings();
        try {
            long l = this.OdbcApi.SQLGetStmtOption(this.hStmt, (short)6);
            this.odbcCursorType = (short)l;
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            this.odbcCursorType = bigDecimal.shortValue();
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
    }

    protected void checkOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet is closed");
        }
    }
}

