/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSCredentialImpl;
import sun.security.jgss.GSSExceptionImpl;
import sun.security.jgss.GSSHeader;
import sun.security.jgss.GSSManagerImpl;
import sun.security.jgss.GSSNameImpl;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.util.ObjectIdentifier;

class GSSContextImpl
implements GSSContext {
    private GSSManagerImpl gssManager = null;
    private static final int PRE_INIT = 1;
    private static final int IN_PROGRESS = 2;
    private static final int READY = 3;
    private static final int DELETED = 4;
    private int currentState = 1;
    private boolean initiator;
    private GSSContextSpi mechCtxt = null;
    private Oid mechOid = null;
    private ObjectIdentifier objId = null;
    private GSSCredentialImpl myCred = null;
    private GSSCredentialImpl delegCred = null;
    private GSSNameImpl srcName = null;
    private GSSNameImpl targName = null;
    private int reqLifetime = Integer.MAX_VALUE;
    private ChannelBinding channelBindings = null;
    private boolean reqConfState = true;
    private boolean reqIntegState = true;
    private boolean reqMutualAuthState = true;
    private boolean reqReplayDetState = true;
    private boolean reqSequenceDetState = true;
    private boolean reqCredDelegState = false;
    private boolean reqAnonState = false;

    public GSSContextImpl(GSSManagerImpl gSSManagerImpl, GSSName gSSName, Oid oid, GSSCredential gSSCredential, int n) throws GSSException {
        this.gssManager = gSSManagerImpl;
        this.myCred = (GSSCredentialImpl)gSSCredential;
        this.reqLifetime = n;
        this.targName = (GSSNameImpl)gSSName;
        this.mechOid = this.mechOid;
        this.initiator = true;
    }

    public GSSContextImpl(GSSManagerImpl gSSManagerImpl, GSSCredential gSSCredential) throws GSSException {
        this.gssManager = gSSManagerImpl;
        this.myCred = (GSSCredentialImpl)gSSCredential;
        this.initiator = false;
    }

    public GSSContextImpl(GSSManagerImpl gSSManagerImpl, byte[] byArray) throws GSSException {
        this.gssManager = gSSManagerImpl;
    }

    public byte[] initSecContext(byte[] byArray, int n, int n2) throws GSSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(600);
        int n3 = this.initSecContext(byteArrayInputStream, byteArrayOutputStream);
        return n3 == 0 ? null : byteArrayOutputStream.toByteArray();
    }

    public int initSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        if (this.mechCtxt != null && this.currentState != 2) {
            throw new GSSExceptionImpl(11, "Illegal call to initSecContext");
        }
        GSSHeader gSSHeader = null;
        int n = 0;
        try {
            Object object;
            if (this.mechCtxt == null) {
                if (this.myCred == null) {
                    this.myCred = (GSSCredentialImpl)this.gssManager.createCredential(1);
                }
                this.srcName = (GSSNameImpl)this.myCred.getName();
                object = this.myCred.getElement(this.mechOid, true);
                if (this.mechOid == null) {
                    this.mechOid = object.getMechanism();
                }
                this.objId = new ObjectIdentifier(this.mechOid.toString());
                GSSNameSpi gSSNameSpi = this.targName.getElement(this.mechOid);
                this.mechCtxt = this.gssManager.getMechanismContext(gSSNameSpi, (GSSCredentialSpi)object, this.reqLifetime, this.mechOid);
                this.mechCtxt.requestConf(this.reqConfState);
                this.mechCtxt.requestInteg(this.reqIntegState);
                this.mechCtxt.requestCredDeleg(this.reqCredDelegState);
                this.mechCtxt.requestMutualAuth(this.reqMutualAuthState);
                this.mechCtxt.requestReplayDet(this.reqReplayDetState);
                this.mechCtxt.requestSequenceDet(this.reqSequenceDetState);
                this.mechCtxt.requestAnonymity(this.reqAnonState);
                this.mechCtxt.setChannelBinding(this.channelBindings);
                this.currentState = 2;
            } else {
                gSSHeader = new GSSHeader(inputStream);
                if (!gSSHeader.getOid().equals(this.objId)) {
                    throw new GSSExceptionImpl(10, "Mechanism not equal to " + this.mechOid.toString() + " in initSecContext token");
                }
                n = gSSHeader.getMechTokenLength();
            }
            object = this.mechCtxt.initSecContext(inputStream, n);
            int n2 = 0;
            if (object != null) {
                n2 = ((Object)object).length;
                gSSHeader = new GSSHeader(this.objId, ((Object)object).length);
                n2 += gSSHeader.encode(outputStream);
                outputStream.write((byte[])object);
            }
            if (this.mechCtxt.isEstablished()) {
                this.currentState = 3;
            }
            return n2;
        }
        catch (IOException iOException) {
            throw new GSSExceptionImpl(10, iOException.getMessage());
        }
    }

    public byte[] acceptSecContext(byte[] byArray, int n, int n2) throws GSSException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(100);
        this.acceptSecContext(new ByteArrayInputStream(byArray, n, n2), byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void acceptSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        if (this.mechCtxt != null && this.currentState != 2) {
            throw new GSSExceptionImpl(11, "Illegal call to acceptSecContext");
        }
        GSSHeader gSSHeader = null;
        int n = 0;
        try {
            Object object;
            gSSHeader = new GSSHeader(inputStream);
            if (this.mechCtxt == null) {
                this.objId = gSSHeader.getOid();
                this.mechOid = new Oid(this.objId.toString());
                if (this.myCred == null) {
                    this.myCred = (GSSCredentialImpl)this.gssManager.createCredential(null, Integer.MAX_VALUE, this.mechOid, 2);
                }
                this.targName = (GSSNameImpl)this.myCred.getName();
                object = this.myCred.getElement(this.mechOid, false);
                this.mechCtxt = this.gssManager.getMechanismContext((GSSCredentialSpi)object, this.mechOid);
                this.mechCtxt.setChannelBinding(this.channelBindings);
                this.currentState = 2;
            } else if (!gSSHeader.getOid().equals(this.objId)) {
                throw new GSSExceptionImpl(10, "Mechanism not equal to " + this.mechOid.toString() + " in acceptSecContext token");
            }
            n = gSSHeader.getMechTokenLength();
            object = this.mechCtxt.acceptSecContext(inputStream, n);
            if (object != null) {
                int n2 = ((byte[])object).length;
                gSSHeader = new GSSHeader(this.objId, ((byte[])object).length);
                n2 += gSSHeader.encode(outputStream);
                outputStream.write((byte[])object);
            }
            this.srcName = new GSSNameImpl(this.gssManager, this.mechCtxt.getSrcName());
            if (this.mechCtxt.isEstablished()) {
                this.currentState = 3;
            }
        }
        catch (IOException iOException) {
            throw new GSSExceptionImpl(10, iOException.getMessage());
        }
    }

    public boolean isEstablished() {
        if (this.mechCtxt == null) {
            return false;
        }
        return this.currentState == 3;
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getWrapSizeLimit(n, bl, n2);
        }
        throw new GSSExceptionImpl(12, "No mechanism context yet!");
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.mechCtxt != null) {
            return this.mechCtxt.wrap(byArray, n, n2, messageProp);
        }
        throw new GSSExceptionImpl(12, "No mechanism context yet!");
    }

    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.mechCtxt == null) {
            throw new GSSExceptionImpl(12, "No mechanism context yet!");
        }
        this.mechCtxt.wrap(inputStream, outputStream, messageProp);
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.mechCtxt != null) {
            return this.mechCtxt.unwrap(byArray, n, n2, messageProp);
        }
        throw new GSSExceptionImpl(12, "No mechanism context yet!");
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.mechCtxt == null) {
            throw new GSSExceptionImpl(12, "No mechanism context yet!");
        }
        this.mechCtxt.unwrap(inputStream, outputStream, messageProp);
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getMIC(byArray, n, n2, messageProp);
        }
        throw new GSSExceptionImpl(12, "No mechanism context yet!");
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.mechCtxt == null) {
            throw new GSSExceptionImpl(12, "No mechanism context yet!");
        }
        this.mechCtxt.getMIC(inputStream, outputStream, messageProp);
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        if (this.mechCtxt == null) {
            throw new GSSExceptionImpl(12, "No mechanism context yet!");
        }
        this.mechCtxt.verifyMIC(byArray, n, n2, byArray2, n3, n4, messageProp);
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        if (this.mechCtxt == null) {
            throw new GSSExceptionImpl(12, "No mechanism context yet!");
        }
        this.mechCtxt.verifyMIC(inputStream, inputStream2, messageProp);
    }

    public byte[] export() throws GSSException {
        return null;
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqMutualAuthState = bl;
        }
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqReplayDetState = bl;
        }
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqSequenceDetState = bl;
        }
    }

    public void requestCredDeleg(boolean bl) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqCredDelegState = bl;
        }
    }

    public void requestAnonymity(boolean bl) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqAnonState = bl;
        }
    }

    public void requestConf(boolean bl) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqConfState = bl;
        }
    }

    public void requestInteg(boolean bl) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqIntegState = bl;
        }
    }

    public void requestLifetime(int n) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqLifetime = n;
        }
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        if (this.mechCtxt == null) {
            this.channelBindings = channelBinding;
        }
    }

    public boolean getCredDelegState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getCredDelegState();
        }
        return this.reqCredDelegState;
    }

    public boolean getMutualAuthState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getMutualAuthState();
        }
        return this.reqMutualAuthState;
    }

    public boolean getReplayDetState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getReplayDetState();
        }
        return this.reqReplayDetState;
    }

    public boolean getSequenceDetState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getSequenceDetState();
        }
        return this.reqSequenceDetState;
    }

    public boolean getAnonymityState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getAnonymityState();
        }
        return this.reqAnonState;
    }

    public boolean isTransferable() throws GSSException {
        if (this.mechCtxt != null) {
            return this.mechCtxt.isTransferable();
        }
        return false;
    }

    public boolean isProtReady() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.isProtReady();
        }
        return false;
    }

    public boolean getConfState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getConfState();
        }
        return this.reqConfState;
    }

    public boolean getIntegState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getIntegState();
        }
        return this.reqIntegState;
    }

    public int getLifetime() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getLifetime();
        }
        return this.reqLifetime;
    }

    public GSSName getSrcName() throws GSSException {
        return this.srcName;
    }

    public GSSName getTargName() throws GSSException {
        return this.targName;
    }

    public Oid getMech() throws GSSException {
        return this.mechOid;
    }

    public GSSCredential getDelegCred() throws GSSException {
        if (this.mechCtxt == null) {
            throw new GSSExceptionImpl(12, "No mechanism context yet!");
        }
        return new GSSCredentialImpl(this.gssManager, this.mechCtxt.getDelegCred());
    }

    public boolean isInitiator() throws GSSException {
        return this.initiator;
    }

    public void dispose() throws GSSException {
        this.currentState = 4;
        this.mechCtxt = null;
        this.myCred = null;
        this.srcName = null;
        this.targName = null;
    }
}

