/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto.dk;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import sun.security.krb5.internal.crypto.dk.DkCrypto;

public class Des3DkCrypto
extends DkCrypto {
    private static final byte[] ZERO_IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] PARITY_BIT_MASK = new byte[]{-128, 64, 32, 16, 8, 4, 2};

    protected int getKeySeedLength() {
        return 168;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] stringToKey(char[] cArray) throws GeneralSecurityException {
        byte[] byArray = null;
        try {
            byArray = Des3DkCrypto.charToUtf8(cArray);
            byte[] byArray2 = this.stringToKey(byArray, null);
            return byArray2;
        }
        finally {
            if (byArray != null) {
                Arrays.fill(byArray, (byte)0);
            }
        }
    }

    private byte[] stringToKey(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byArray2 != null && byArray2.length > 0) {
            throw new RuntimeException("Invalid parameter to stringToKey");
        }
        byte[] byArray3 = this.randomToKey(Des3DkCrypto.nfold(byArray, this.getKeySeedLength()));
        return this.dk(byArray3, KERBEROS_CONSTANT);
    }

    protected byte[] randomToKey(byte[] byArray) {
        if (byArray.length != 21) {
            throw new IllegalArgumentException("input must be 168 bits");
        }
        byte[] byArray2 = Des3DkCrypto.keyCorrection(Des3DkCrypto.des3Expand(byArray, 0, 7));
        byte[] byArray3 = Des3DkCrypto.keyCorrection(Des3DkCrypto.des3Expand(byArray, 7, 14));
        byte[] byArray4 = Des3DkCrypto.keyCorrection(Des3DkCrypto.des3Expand(byArray, 14, 21));
        byte[] byArray5 = new byte[24];
        System.arraycopy(byArray2, 0, byArray5, 0, 8);
        System.arraycopy(byArray3, 0, byArray5, 8, 8);
        System.arraycopy(byArray4, 0, byArray5, 16, 8);
        return byArray5;
    }

    private static byte[] keyCorrection(byte[] byArray) {
        return byArray;
    }

    private static byte[] des3Expand(byte[] byArray, int n, int n2) {
        if (n2 - n != 7) {
            throw new IllegalArgumentException("Invalid length of DES Key Value:" + n + "," + n2);
        }
        byte[] byArray2 = new byte[8];
        byte by = 0;
        System.arraycopy(byArray, n, byArray2, 0, 7);
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            byte by2 = (byte)(byArray[i] & 1);
            n3 = (byte)(n3 + 1);
            if (by2 == 0) continue;
            by = (byte)(by | by2 << n3);
        }
        byArray2[7] = by;
        Des3DkCrypto.setParityBit(byArray2);
        return byArray2;
    }

    private static void setParityBit(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = 0;
            for (int j = 0; j < PARITY_BIT_MASK.length; ++j) {
                if ((byArray[i] & PARITY_BIT_MASK[j]) != PARITY_BIT_MASK[j]) continue;
                ++n;
            }
            byArray[i] = n & true ? (byte)(byArray[i] & 0xFFFFFFFE) : (byte)(byArray[i] | 1);
        }
    }

    protected Cipher getCipher(byte[] byArray, byte[] byArray2, int n) throws GeneralSecurityException {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("desede");
        DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray, 0);
        SecretKey secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
        if (byArray2 == null) {
            byArray2 = ZERO_IV;
        }
        Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2, 0, byArray2.length);
        cipher.init(n, (Key)secretKey, ivParameterSpec);
        return cipher;
    }

    public int getChecksumLength() {
        return 20;
    }

    protected byte[] getHmac(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(secretKeySpec);
        return mac.doFinal(byArray2);
    }
}

