/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.text.CharTrie;
import sun.text.IntTrie;
import sun.text.Normalizer;
import sun.text.NormalizerDataReader;
import sun.text.Trie;

public final class NormalizerImpl {
    static final NormalizerImpl IMPL;
    static final int UNSIGNED_BYTE_MASK = 255;
    static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;
    private static final String DATA_FILE_NAME = "resources/unorm.icu";
    static final int QC_NFC = 17;
    static final int QC_NFKC = 34;
    static final int QC_NFD = 4;
    static final int QC_NFKD = 8;
    static final int QC_MASK = 63;
    private static final int QC_ANY_NO = 15;
    private static final int COMBINES_FWD = 64;
    private static final int COMBINES_BACK = 128;
    private static final int COMBINES_ANY = 192;
    private static final int CC_SHIFT = 8;
    static final int CC_MASK = 65280;
    private static final int EXTRA_SHIFT = 16;
    private static final long MIN_SPECIAL = 0xFC000000L;
    private static final long SURROGATES_TOP = 0xFFF00000L;
    private static final long MIN_HANGUL = 0xFFF00000L;
    private static final long JAMO_V_TOP = 0xFFF30000L;
    private static final int INDEX_TRIE_SIZE = 0;
    private static final int INDEX_CHAR_COUNT = 1;
    private static final int INDEX_COMBINE_DATA_COUNT = 2;
    private static final int INDEX_COMBINE_FWD_COUNT = 3;
    private static final int INDEX_COMBINE_BOTH_COUNT = 4;
    private static final int INDEX_COMBINE_BACK_COUNT = 5;
    static final int INDEX_MIN_NFC_NO_MAYBE = 6;
    static final int INDEX_MIN_NFKC_NO_MAYBE = 7;
    static final int INDEX_MIN_NFD_NO_MAYBE = 8;
    static final int INDEX_MIN_NFKD_NO_MAYBE = 9;
    private static final int INDEX_FCD_TRIE_SIZE = 10;
    private static final int INDEX_AUX_TRIE_SIZE = 11;
    private static final int INDEX_CANON_SET_COUNT = 12;
    private static final int INDEX_TOP = 32;
    private static final int MAX_BUFFER_SIZE = 20;
    private static FCDTrieImpl fcdTrieImpl;
    private static NormTrieImpl normTrieImpl;
    private static int[] indexes;
    private static char[] combiningTable;
    private static char[] extraData;
    private static boolean isDataLoaded;
    private static final int DATA_BUFFER_SIZE = 25000;
    static final int MIN_WITH_LEAD_CC = 768;
    private static final int DECOMP_FLAG_LENGTH_HAS_CC = 128;
    private static final int DECOMP_LENGTH_MASK = 127;
    private static final int BMP_INDEX_LENGTH = 2048;
    private static final int SURROGATE_BLOCK_BITS = 5;
    private static final int JAMO_L_BASE = 4352;
    private static final int JAMO_V_BASE = 4449;
    private static final int JAMO_T_BASE = 4519;
    private static final int HANGUL_BASE = 44032;
    private static final int JAMO_L_COUNT = 19;
    private static final int JAMO_V_COUNT = 21;
    private static final int JAMO_T_COUNT = 28;
    private static final int HANGUL_COUNT = 11172;

    static int getFromIndexesArr(int n) {
        return indexes[n];
    }

    private NormalizerImpl() throws Exception {
        Object t;
        if (!isDataLoaded && (t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    InputStream inputStream = this.getClass().getResourceAsStream(NormalizerImpl.DATA_FILE_NAME);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 25000);
                    NormalizerDataReader normalizerDataReader = new NormalizerDataReader(bufferedInputStream);
                    NormalizerImpl.access$002(normalizerDataReader.readIndexes(32));
                    byte[] byArray = new byte[indexes[0]];
                    int n = indexes[2];
                    NormalizerImpl.access$102(new char[n]);
                    int n2 = indexes[1];
                    NormalizerImpl.access$202(new char[n2]);
                    byte[] byArray2 = new byte[indexes[10]];
                    fcdTrieImpl = new FCDTrieImpl();
                    NormalizerImpl.normTrieImpl = new NormTrieImpl();
                    normalizerDataReader.read(byArray, byArray2, null, extraData, combiningTable, null);
                    NormTrieImpl.normTrie = new IntTrie(new ByteArrayInputStream(byArray), normTrieImpl);
                    FCDTrieImpl.fcdTrie = new CharTrie(new ByteArrayInputStream(byArray2), fcdTrieImpl);
                    isDataLoaded = true;
                    bufferedInputStream.close();
                    inputStream.close();
                    return null;
                }
                catch (Exception exception) {
                    return exception;
                }
            }
        })) instanceof Exception) {
            throw (Exception)t;
        }
    }

    private static boolean isHangulWithoutJamoT(char c) {
        return (c = (char)(c - 44032)) < '\u2ba4' && c % 28 == 0;
    }

    private static boolean isNorm32Regular(long l) {
        return l < 0xFC000000L;
    }

    private static boolean isNorm32LeadSurrogate(long l) {
        return 0xFC000000L <= l && l < 0xFFF00000L;
    }

    static boolean isNorm32HangulOrJamo(long l) {
        return l >= 0xFFF00000L;
    }

    private static boolean isJamoVTNorm32JamoV(long l) {
        return l < 0xFFF30000L;
    }

    static long getNorm32(char c) {
        return 0xFFFFFFFFL & (long)NormTrieImpl.normTrie.getLeadValue(c);
    }

    static long getNorm32FromSurrogatePair(long l, char c) {
        return 0xFFFFFFFFL & (long)NormTrieImpl.normTrie.getTrailValue((int)l, c);
    }

    private static long getNorm32(int n) {
        return 0xFFFFFFFFL & (long)NormTrieImpl.normTrie.getCodePointValue(n);
    }

    private static long getNorm32(char[] cArray, int n, int n2) {
        long l = NormalizerImpl.getNorm32(cArray[n]);
        if ((l & (long)n2) > 0L && NormalizerImpl.isNorm32LeadSurrogate(l)) {
            l = NormalizerImpl.getNorm32FromSurrogatePair(l, cArray[n + 1]);
        }
        return l;
    }

    public static char getFCD16(char c) {
        return FCDTrieImpl.fcdTrie.getLeadValue(c);
    }

    public static char getFCD16FromSurrogatePair(char c, char c2) {
        return FCDTrieImpl.fcdTrie.getTrailValue(c, c2);
    }

    private static int getExtraDataIndex(long l) {
        return (int)(l >> 16);
    }

    private static int decompose(long l, int n, DecomposeArgs decomposeArgs) {
        int n2 = NormalizerImpl.getExtraDataIndex(l);
        decomposeArgs.length = extraData[n2++];
        if ((l & (long)n & 8L) != 0L && decomposeArgs.length >= 256) {
            n2 += (decomposeArgs.length >> 7 & 1) + (decomposeArgs.length & 0x7F);
            decomposeArgs.length >>= 8;
        }
        if ((decomposeArgs.length & 0x80) > 0) {
            char c = extraData[n2++];
            decomposeArgs.cc = 0xFF & c >> 8;
            decomposeArgs.trailCC = 0xFF & c;
        } else {
            decomposeArgs.trailCC = 0;
            decomposeArgs.cc = 0;
        }
        decomposeArgs.length &= 0x7F;
        return n2;
    }

    private static int decompose(long l, DecomposeArgs decomposeArgs) {
        int n = NormalizerImpl.getExtraDataIndex(l);
        decomposeArgs.length = extraData[n++];
        if ((decomposeArgs.length & 0x80) > 0) {
            char c = extraData[n++];
            decomposeArgs.cc = 0xFF & c >> 8;
            decomposeArgs.trailCC = 0xFF & c;
        } else {
            decomposeArgs.trailCC = 0;
            decomposeArgs.cc = 0;
        }
        decomposeArgs.length &= 0x7F;
        return n;
    }

    private static int getNextCC(NextCCArgs nextCCArgs) {
        nextCCArgs.c = nextCCArgs.source[nextCCArgs.next++];
        long l = NormalizerImpl.getNorm32(nextCCArgs.c);
        if ((l & 0xFF00L) == 0L) {
            nextCCArgs.c2 = '\u0000';
            return 0;
        }
        if (!NormalizerImpl.isNorm32LeadSurrogate(l)) {
            nextCCArgs.c2 = '\u0000';
        } else if (nextCCArgs.next != nextCCArgs.limit && Character.isLowSurrogate(nextCCArgs.c2 = nextCCArgs.source[nextCCArgs.next])) {
            ++nextCCArgs.next;
            l = NormalizerImpl.getNorm32FromSurrogatePair(l, nextCCArgs.c2);
        } else {
            nextCCArgs.c2 = '\u0000';
            return 0;
        }
        return (int)(0xFFL & l >> 8);
    }

    private static long getPrevNorm32(PrevArgs prevArgs, int n, int n2) {
        prevArgs.c = prevArgs.src[--prevArgs.current];
        prevArgs.c2 = '\u0000';
        if (prevArgs.c < n) {
            return 0L;
        }
        if (prevArgs.c < '\ud800' || prevArgs.c > '\udfff') {
            return NormalizerImpl.getNorm32(prevArgs.c);
        }
        if (Character.isHighSurrogate(prevArgs.c)) {
            return 0L;
        }
        if (prevArgs.current != prevArgs.start && Character.isHighSurrogate(prevArgs.c2 = prevArgs.src[prevArgs.current - 1])) {
            --prevArgs.current;
            long l = NormalizerImpl.getNorm32(prevArgs.c2);
            if ((l & (long)n2) == 0L) {
                return 0L;
            }
            return NormalizerImpl.getNorm32FromSurrogatePair(l, prevArgs.c);
        }
        prevArgs.c2 = '\u0000';
        return 0L;
    }

    private static int getPrevCC(PrevArgs prevArgs) {
        return (int)(0xFFL & NormalizerImpl.getPrevNorm32(prevArgs, 768, 65280) >> 8);
    }

    static boolean isNFDSafe(long l, int n, int n2) {
        if ((l & (long)n) == 0L) {
            return true;
        }
        if (NormalizerImpl.isNorm32Regular(l) && (l & (long)n2) != 0L) {
            DecomposeArgs decomposeArgs = new DecomposeArgs();
            NormalizerImpl.decompose(l, n2, decomposeArgs);
            return decomposeArgs.cc == 0;
        }
        return (l & 0xFF00L) == 0L;
    }

    static boolean isTrueStarter(long l, int n, int n2) {
        if ((l & (long)n) == 0L) {
            return true;
        }
        if ((l & (long)n2) != 0L) {
            int n3;
            DecomposeArgs decomposeArgs = new DecomposeArgs();
            int n4 = NormalizerImpl.decompose(l, n2, decomposeArgs);
            if (decomposeArgs.cc == 0 && (NormalizerImpl.getNorm32(extraData, n4, n3 = n & 0x3F) & (long)n3) == 0L) {
                return true;
            }
        }
        return false;
    }

    private static int insertOrdered(char[] cArray, int n, int n2, int n3, char c, char c2, int n4) {
        int n5 = n4;
        if (n < n2 && n4 != 0) {
            int n6;
            int n7 = n6 = n2;
            PrevArgs prevArgs = new PrevArgs();
            prevArgs.current = n2;
            prevArgs.start = n;
            prevArgs.src = cArray;
            int n8 = NormalizerImpl.getPrevCC(prevArgs);
            n7 = prevArgs.current;
            if (n4 < n8) {
                n5 = n8;
                n6 = n7;
                while (n < n7) {
                    n8 = NormalizerImpl.getPrevCC(prevArgs);
                    n7 = prevArgs.current;
                    if (n4 >= n8) break;
                    n6 = n7;
                }
                int n9 = n3;
                do {
                    cArray[--n9] = cArray[--n2];
                } while (n6 != n2);
            }
        }
        cArray[n2] = c;
        if (c2 != '\u0000') {
            cArray[n2 + 1] = c2;
        }
        return n5;
    }

    private static int mergeOrdered(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, boolean bl) {
        int n5 = 0;
        boolean bl2 = n2 == n3;
        NextCCArgs nextCCArgs = new NextCCArgs();
        nextCCArgs.source = cArray2;
        nextCCArgs.next = n3;
        nextCCArgs.limit = n4;
        if (n != n2 || !bl) {
            while (nextCCArgs.next < nextCCArgs.limit) {
                int n6 = NormalizerImpl.getNextCC(nextCCArgs);
                if (n6 == 0) {
                    n5 = 0;
                    if (bl2) {
                        n2 = nextCCArgs.next;
                    } else {
                        cArray2[n2++] = nextCCArgs.c;
                        if (nextCCArgs.c2 != '\u0000') {
                            cArray2[n2++] = nextCCArgs.c2;
                        }
                    }
                    if (bl) break;
                    n = n2;
                    continue;
                }
                int n7 = n2 + (nextCCArgs.c2 == '\u0000' ? 1 : 2);
                n5 = NormalizerImpl.insertOrdered(cArray, n, n2, n7, nextCCArgs.c, nextCCArgs.c2, n6);
                n2 = n7;
            }
        }
        if (nextCCArgs.next == nextCCArgs.limit) {
            return n5;
        }
        if (!bl2) {
            do {
                cArray[n2++] = cArray2[nextCCArgs.next++];
            } while (nextCCArgs.next != nextCCArgs.limit);
            nextCCArgs.limit = n2;
        }
        PrevArgs prevArgs = new PrevArgs();
        prevArgs.src = cArray2;
        prevArgs.start = n;
        prevArgs.current = nextCCArgs.limit;
        return NormalizerImpl.getPrevCC(prevArgs);
    }

    private static int mergeOrdered(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4) {
        return NormalizerImpl.mergeOrdered(cArray, n, n2, cArray2, n3, n4, true);
    }

    static boolean checkFCD(char[] cArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n;
        int n6 = n2;
        while (n5 != n6) {
            char c;
            int n7;
            if ((n7 = cArray[n5++]) < 768) {
                n4 = -n7;
                continue;
            }
            char c2 = NormalizerImpl.getFCD16((char)n7);
            if (c2 == '\u0000') {
                n4 = 0;
                continue;
            }
            if (Character.isHighSurrogate((char)n7)) {
                if (n5 != n6 && Character.isLowSurrogate(c = cArray[n5])) {
                    ++n5;
                    c2 = NormalizerImpl.getFCD16FromSurrogatePair(c2, c);
                } else {
                    c = '\u0000';
                    c2 = '\u0000';
                }
            } else {
                c = '\u0000';
            }
            if (NormalizerImpl.nx_contains(n3, (char)n7, c)) {
                n4 = 0;
                continue;
            }
            int n8 = c2 >> 8;
            if (n8 != 0) {
                if (n4 < 0) {
                    n4 = !NormalizerImpl.nx_contains(n3, -n4) ? FCDTrieImpl.fcdTrie.getBMPValue((char)(-n4)) & 0xFF : 0;
                }
                if (n8 < n4) {
                    return false;
                }
            }
            n4 = c2 & 0xFF;
        }
        return true;
    }

    static Normalizer.QuickCheckResult quickCheck(char[] cArray, int n, int n2, int n3, int n4, boolean bl, int n5) {
        Normalizer.QuickCheckResult quickCheckResult;
        block13: {
            ComposePartArgs composePartArgs = new ComposePartArgs();
            int n6 = n;
            if (!isDataLoaded) {
                return Normalizer.MAYBE;
            }
            int n7 = 0xFF00 | n4;
            quickCheckResult = Normalizer.YES;
            char c = '\u0000';
            while (true) {
                char c2;
                char c3;
                long l;
                char c4;
                if (n == n2) {
                    return quickCheckResult;
                }
                if ((c4 = cArray[n++]) < n3 || ((l = NormalizerImpl.getNorm32(c4)) & (long)n7) == 0L) {
                    c = '\u0000';
                    continue;
                }
                if (NormalizerImpl.isNorm32LeadSurrogate(l)) {
                    if (n != n2 && Character.isLowSurrogate(c3 = cArray[n])) {
                        ++n;
                        l = NormalizerImpl.getNorm32FromSurrogatePair(l, c3);
                    } else {
                        l = 0L;
                        c3 = '\u0000';
                    }
                } else {
                    c3 = '\u0000';
                }
                if (NormalizerImpl.nx_contains(n5, c4, c3)) {
                    l = 0L;
                }
                if ((c2 = (char)(l >> 8 & 0xFFL)) != '\u0000' && c2 < c) {
                    return Normalizer.NO;
                }
                c = c2;
                long l2 = l & (long)n4;
                if ((l2 & 0xFL) >= 1L) {
                    quickCheckResult = Normalizer.NO;
                    break block13;
                }
                if (l2 == 0L) continue;
                if (bl) {
                    quickCheckResult = Normalizer.MAYBE;
                    continue;
                }
                int n8 = n4 << 2 & 0xF;
                int n9 = n - 1;
                if (Character.isLowSurrogate(cArray[n9])) {
                    --n9;
                }
                n9 = NormalizerImpl.findPreviousStarter(cArray, n6, n9, n7, n8, (char)n3);
                n = NormalizerImpl.findNextStarter(cArray, n, n2, n4, n8, (char)n3);
                composePartArgs.prevCC = c;
                char[] cArray2 = NormalizerImpl.composePart(composePartArgs, n9, cArray, n, n2, n4, n5);
                if (0 != NormalizerImpl.strCompare(cArray2, 0, composePartArgs.length, cArray, n9, n - n9, false)) break;
            }
            quickCheckResult = Normalizer.NO;
        }
        return quickCheckResult;
    }

    private static boolean needSingleQuotation(char c) {
        return c >= '\t' && c <= '\r' || c >= ' ' && c <= '/' || c >= ':' && c <= '@' || c >= '[' && c <= '`' || c >= '{' && c <= '~';
    }

    public static String canonicalDecomposeWithSingleQuotation(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = cArray.length;
        Object object = new char[cArray.length * 3];
        int n3 = 0;
        int n4 = ((char[])object).length;
        char[] cArray2 = new char[3];
        int n5 = 4;
        char c = (char)indexes[8];
        int n6 = 0xFF00 | n5;
        int n7 = 0;
        int n8 = 0;
        long l = 0L;
        char c2 = '\u0000';
        int n9 = 0;
        int n10 = -1;
        int n11 = -1;
        while (true) {
            Object object2;
            char[] cArray3;
            char c3;
            int n12;
            int n13 = n;
            while (n != n2 && ((c2 = cArray[n]) < c || ((l = NormalizerImpl.getNorm32(c2)) & (long)n6) == 0L || c2 >= '\uac00' && c2 <= '\ud7a3')) {
                n8 = 0;
                ++n;
            }
            if (n != n13) {
                n12 = n - n13;
                if (n3 + n12 <= n4) {
                    System.arraycopy(cArray, n13, object, n3, n12);
                }
                n7 = n3 += n12;
            }
            if (n == n2) break;
            ++n;
            if (NormalizerImpl.isNorm32Regular(l)) {
                c3 = '\u0000';
                n12 = 1;
            } else if (n != n2 && Character.isLowSurrogate(c3 = cArray[n])) {
                ++n;
                n12 = 2;
                l = NormalizerImpl.getNorm32FromSurrogatePair(l, c3);
            } else {
                c3 = '\u0000';
                n12 = 1;
                l = 0L;
            }
            if ((l & (long)n5) == 0L) {
                n11 = n10 = (int)(0xFFL & l >> 8);
                cArray3 = null;
                n9 = -1;
            } else {
                object2 = new DecomposeArgs();
                n9 = NormalizerImpl.decompose(l, n5, (DecomposeArgs)object2);
                cArray3 = extraData;
                n12 = ((DecomposeArgs)object2).length;
                n11 = ((DecomposeArgs)object2).cc;
                n10 = ((DecomposeArgs)object2).trailCC;
                if (n12 == 1) {
                    c2 = cArray3[n9];
                    c3 = '\u0000';
                    cArray3 = null;
                    n9 = -1;
                }
            }
            if (n3 + n12 * 3 >= n4) {
                object2 = new char[n4 * 2];
                System.arraycopy(object, 0, object2, 0, n3);
                object = object2;
                n4 = ((char[])object).length;
            }
            int n14 = n3;
            if (cArray3 == null) {
                if (NormalizerImpl.needSingleQuotation(c2)) {
                    object[n3++] = 39;
                    object[n3++] = c2;
                    object[n3++] = 39;
                    n10 = 0;
                } else if (n11 != 0 && n11 < n8) {
                    n10 = NormalizerImpl.insertOrdered(object, n7, n14, n3 += n12, c2, c3, n11);
                } else {
                    object[n3++] = c2;
                    if (c3 != '\u0000') {
                        object[n3++] = c3;
                    }
                }
            } else if (NormalizerImpl.needSingleQuotation(cArray3[n9])) {
                object[n3++] = 39;
                object[n3++] = cArray3[n9++];
                object[n3++] = 39;
                --n12;
                do {
                    object[n3++] = cArray3[n9++];
                } while (--n12 > 0);
            } else if (n11 != 0 && n11 < n8) {
                n3 += n12;
                n10 = NormalizerImpl.mergeOrdered(object, n7, n14, cArray3, n9, n9 + n12);
            } else {
                do {
                    object[n3++] = cArray3[n9++];
                } while (--n12 > 0);
            }
            if ((n8 = n10) != 0) continue;
            n7 = n3;
        }
        return new String((char[])object, 0, n3);
    }

    static int decompose(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, boolean bl, int[] nArray, int n5) {
        int n6;
        char c;
        char[] cArray3 = new char[3];
        if (!bl) {
            c = (char)indexes[8];
            n6 = 4;
        } else {
            c = (char)indexes[9];
            n6 = 8;
        }
        int n7 = 0xFF00 | n6;
        int n8 = 0;
        int n9 = 0;
        long l = 0L;
        char c2 = '\u0000';
        int n10 = 0;
        int n11 = -1;
        int n12 = -1;
        while (true) {
            char[] cArray4;
            char c3;
            int n13;
            int n14 = n;
            while (n != n2 && ((c2 = cArray[n]) < c || ((l = NormalizerImpl.getNorm32(c2)) & (long)n7) == 0L)) {
                n9 = 0;
                ++n;
            }
            if (n != n14) {
                n13 = n - n14;
                if (n3 + n13 <= n4) {
                    System.arraycopy(cArray, n14, cArray2, n3, n13);
                }
                n8 = n3 += n13;
            }
            if (n == n2) break;
            ++n;
            if (NormalizerImpl.isNorm32HangulOrJamo(l)) {
                if (NormalizerImpl.nx_contains(n5, c2)) {
                    c3 = '\u0000';
                    cArray4 = null;
                    n13 = 1;
                } else {
                    cArray4 = cArray3;
                    n10 = 0;
                    n11 = 0;
                    n12 = 0;
                    c2 = (char)(c2 - 44032);
                    c3 = (char)(c2 % 28);
                    c2 = (char)(c2 / 28);
                    if (c3 > '\u0000') {
                        cArray3[2] = (char)(4519 + c3);
                        n13 = 3;
                    } else {
                        n13 = 2;
                    }
                    cArray3[1] = (char)(4449 + c2 % 21);
                    cArray3[0] = (char)(4352 + c2 / 21);
                }
            } else {
                if (NormalizerImpl.isNorm32Regular(l)) {
                    c3 = '\u0000';
                    n13 = 1;
                } else if (n != n2 && Character.isLowSurrogate(c3 = cArray[n])) {
                    ++n;
                    n13 = 2;
                    l = NormalizerImpl.getNorm32FromSurrogatePair(l, c3);
                } else {
                    c3 = '\u0000';
                    n13 = 1;
                    l = 0L;
                }
                if (NormalizerImpl.nx_contains(n5, c2, c3)) {
                    n11 = 0;
                    n12 = 0;
                    cArray4 = null;
                } else if ((l & (long)n6) == 0L) {
                    n12 = n11 = (int)(0xFFL & l >> 8);
                    cArray4 = null;
                    n10 = -1;
                } else {
                    DecomposeArgs decomposeArgs = new DecomposeArgs();
                    n10 = NormalizerImpl.decompose(l, n6, decomposeArgs);
                    cArray4 = extraData;
                    n13 = decomposeArgs.length;
                    n12 = decomposeArgs.cc;
                    n11 = decomposeArgs.trailCC;
                    if (n13 == 1) {
                        c2 = cArray4[n10];
                        c3 = '\u0000';
                        cArray4 = null;
                        n10 = -1;
                    }
                }
            }
            if (n3 + n13 <= n4) {
                int n15 = n3;
                if (cArray4 == null) {
                    if (n12 != 0 && n12 < n9) {
                        n11 = NormalizerImpl.insertOrdered(cArray2, n8, n15, n3 += n13, c2, c3, n12);
                    } else {
                        cArray2[n3++] = c2;
                        if (c3 != '\u0000') {
                            cArray2[n3++] = c3;
                        }
                    }
                } else if (n12 != 0 && n12 < n9) {
                    n3 += n13;
                    n11 = NormalizerImpl.mergeOrdered(cArray2, n8, n15, cArray4, n10, n10 + n13);
                } else {
                    do {
                        cArray2[n3++] = cArray4[n10++];
                    } while (--n13 > 0);
                }
            } else {
                n3 += n13;
            }
            if ((n9 = n11) != 0) continue;
            n8 = n3;
        }
        nArray[0] = n9;
        return n3;
    }

    private static int getNextCombining(NextCombiningArgs nextCombiningArgs, int n, int n2) {
        nextCombiningArgs.c = nextCombiningArgs.source[nextCombiningArgs.start++];
        long l = NormalizerImpl.getNorm32(nextCombiningArgs.c);
        nextCombiningArgs.c2 = '\u0000';
        nextCombiningArgs.combiningIndex = 0;
        nextCombiningArgs.cc = '\u0000';
        if ((l & 0xFFC0L) == 0L) {
            return 0;
        }
        if (!NormalizerImpl.isNorm32Regular(l)) {
            if (NormalizerImpl.isNorm32HangulOrJamo(l)) {
                nextCombiningArgs.combiningIndex = (int)(0xFFFFFFFFL & (0xFFF0L | l >> 16));
                return (int)(l & 0xC0L);
            }
            if (nextCombiningArgs.start != n && Character.isLowSurrogate(nextCombiningArgs.c2 = nextCombiningArgs.source[nextCombiningArgs.start])) {
                ++nextCombiningArgs.start;
                l = NormalizerImpl.getNorm32FromSurrogatePair(l, nextCombiningArgs.c2);
            } else {
                nextCombiningArgs.c2 = '\u0000';
                return 0;
            }
        }
        if (NormalizerImpl.nx_contains(n2, nextCombiningArgs.c, nextCombiningArgs.c2)) {
            return 0;
        }
        nextCombiningArgs.cc = (char)(l >> 8);
        int n3 = (int)(l & 0xC0L);
        if (n3 != 0) {
            int n4 = NormalizerImpl.getExtraDataIndex(l);
            nextCombiningArgs.combiningIndex = n4 > 0 ? extraData[n4 - 1] : 0;
        }
        return n3;
    }

    private static int getCombiningIndexFromStarter(char c, char c2) {
        long l = NormalizerImpl.getNorm32(c);
        if (c2 != '\u0000') {
            l = NormalizerImpl.getNorm32FromSurrogatePair(l, c2);
        }
        return extraData[NormalizerImpl.getExtraDataIndex(l) - 1];
    }

    private static int combine(char[] cArray, int n, int n2, int[] nArray) {
        int n3;
        if (nArray.length < 2) {
            throw new IllegalArgumentException();
        }
        while ((n3 = cArray[n++]) < n2) {
            n += (cArray[n] & 0x8000) != 0 ? 2 : 1;
        }
        if ((n3 & Short.MAX_VALUE) == n2) {
            int n4;
            int n5 = cArray[n];
            n3 = (int)(0xFFFFFFFFL & (long)((n5 & 0x2000) + 1));
            if ((n5 & 0x8000) != 0) {
                if ((n5 & 0x4000) != 0) {
                    n5 = (int)(0xFFFFFFFFL & (long)(n5 & 0x3FF | 0xD800));
                    n4 = cArray[n + 1];
                } else {
                    n5 = cArray[n + 1];
                    n4 = 0;
                }
            } else {
                n5 &= 0x1FFF;
                n4 = 0;
            }
            nArray[0] = n5;
            nArray[1] = n4;
            return n3;
        }
        return 0;
    }

    private static char recompose(RecomposeArgs recomposeArgs, int n) {
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[2];
        int n4 = -1;
        int n5 = 0;
        boolean bl = false;
        char c = '\u0000';
        NextCombiningArgs nextCombiningArgs = new NextCombiningArgs();
        nextCombiningArgs.source = recomposeArgs.source;
        nextCombiningArgs.cc = '\u0000';
        nextCombiningArgs.c2 = '\u0000';
        while (true) {
            nextCombiningArgs.start = recomposeArgs.start;
            int n6 = NormalizerImpl.getNextCombining(nextCombiningArgs, recomposeArgs.limit, n);
            int n7 = nextCombiningArgs.combiningIndex;
            recomposeArgs.start = nextCombiningArgs.start;
            if ((n6 & 0x80) != 0 && n4 != -1) {
                int n8;
                int n9;
                int n10;
                int n11;
                if ((n7 & 0x8000) != 0) {
                    n11 = -1;
                    nextCombiningArgs.c2 = recomposeArgs.source[n4];
                    if (n7 == 65522) {
                        nextCombiningArgs.c2 = (char)(nextCombiningArgs.c2 - 4352);
                        if (nextCombiningArgs.c2 < '\u0013') {
                            n11 = recomposeArgs.start - 1;
                            nextCombiningArgs.c = (char)(44032 + (nextCombiningArgs.c2 * 21 + (nextCombiningArgs.c - 4449)) * 28);
                            if (recomposeArgs.start != recomposeArgs.limit && (nextCombiningArgs.c2 = (char)(recomposeArgs.source[recomposeArgs.start] - 4519)) < '\u001c') {
                                ++recomposeArgs.start;
                                nextCombiningArgs.c = (char)(nextCombiningArgs.c + nextCombiningArgs.c2);
                            }
                            if (!NormalizerImpl.nx_contains(n, nextCombiningArgs.c)) {
                                recomposeArgs.source[n4] = nextCombiningArgs.c;
                            } else {
                                if (!NormalizerImpl.isHangulWithoutJamoT(nextCombiningArgs.c)) {
                                    --recomposeArgs.start;
                                }
                                n11 = recomposeArgs.start;
                            }
                        }
                    }
                    if (n11 != -1) {
                        n10 = n11;
                        n9 = recomposeArgs.start;
                        while (n9 < recomposeArgs.limit) {
                            recomposeArgs.source[n10++] = recomposeArgs.source[n9++];
                        }
                        recomposeArgs.start = n11;
                        recomposeArgs.limit = n10;
                    }
                    nextCombiningArgs.c2 = '\u0000';
                } else if (!((n5 & 0x8000) != 0 || c >= nextCombiningArgs.cc && c != '\u0000' || 0 == (n8 = NormalizerImpl.combine(combiningTable, n5, n7, nArray)) || NormalizerImpl.nx_contains(n, (char)n2, (char)n3))) {
                    n2 = nArray[0];
                    n3 = nArray[1];
                    n11 = nextCombiningArgs.c2 == '\u0000' ? recomposeArgs.start - 1 : recomposeArgs.start - 2;
                    recomposeArgs.source[n4] = (char)n2;
                    if (bl) {
                        if (n3 != 0) {
                            recomposeArgs.source[n4 + 1] = (char)n3;
                        } else {
                            bl = false;
                            n10 = n4 + 1;
                            n9 = n10 + 1;
                            while (n9 < n11) {
                                recomposeArgs.source[n10++] = recomposeArgs.source[n9++];
                            }
                            --n11;
                        }
                    } else if (n3 != 0) {
                        bl = true;
                        ++n4;
                        n10 = n11++;
                        n9 = n11;
                        while (n4 < n10) {
                            recomposeArgs.source[--n9] = recomposeArgs.source[--n10];
                        }
                        recomposeArgs.source[n4] = (char)n3;
                        --n4;
                    }
                    if (n11 < recomposeArgs.start) {
                        n10 = n11;
                        n9 = recomposeArgs.start;
                        while (n9 < recomposeArgs.limit) {
                            recomposeArgs.source[n10++] = recomposeArgs.source[n9++];
                        }
                        recomposeArgs.start = n11;
                        recomposeArgs.limit = n10;
                    }
                    if (recomposeArgs.start == recomposeArgs.limit) {
                        return c;
                    }
                    if (n8 > 1) {
                        n5 = NormalizerImpl.getCombiningIndexFromStarter((char)n2, (char)n3);
                        continue;
                    }
                    n4 = -1;
                    continue;
                }
            }
            c = nextCombiningArgs.cc;
            if (recomposeArgs.start == recomposeArgs.limit) {
                return c;
            }
            if (nextCombiningArgs.cc != '\u0000') continue;
            if ((n6 & 0x40) != 0) {
                if (nextCombiningArgs.c2 == '\u0000') {
                    bl = false;
                    n4 = recomposeArgs.start - 1;
                } else {
                    bl = false;
                    n4 = recomposeArgs.start - 2;
                }
                n5 = n7;
                continue;
            }
            n4 = -1;
        }
    }

    private static int findPreviousStarter(char[] cArray, int n, int n2, int n3, int n4, char c) {
        long l;
        PrevArgs prevArgs = new PrevArgs();
        prevArgs.src = cArray;
        prevArgs.start = n;
        prevArgs.current = n2;
        while (prevArgs.start < prevArgs.current && !NormalizerImpl.isTrueStarter(l = NormalizerImpl.getPrevNorm32(prevArgs, c, n3 | n4), n3, n4)) {
        }
        return prevArgs.current;
    }

    private static int findNextStarter(char[] cArray, int n, int n2, int n3, int n4, char c) {
        long l;
        char c2;
        int n5 = 0xFF00 | n3;
        DecomposeArgs decomposeArgs = new DecomposeArgs();
        while (n != n2 && (c2 = cArray[n]) >= c && ((l = NormalizerImpl.getNorm32(c2)) & (long)n5) != 0L) {
            char c3;
            if (NormalizerImpl.isNorm32LeadSurrogate(l)) {
                if (n + 1 == n2 || !Character.isLowSurrogate(c3 = cArray[n + 1]) || ((l = NormalizerImpl.getNorm32FromSurrogatePair(l, c3)) & (long)n5) == 0L) {
                    break;
                }
            } else {
                c3 = '\u0000';
            }
            if ((l & (long)n4) != 0L) {
                int n6 = NormalizerImpl.decompose(l, n4, decomposeArgs);
                if (decomposeArgs.cc == 0 && (NormalizerImpl.getNorm32(extraData, n6, n3) & (long)n3) == 0L) break;
            }
            n += c3 == '\u0000' ? 1 : 2;
        }
        return n;
    }

    private static char[] composePart(ComposePartArgs composePartArgs, int n, char[] cArray, int n2, int n3, int n4, int n5) {
        boolean bl = (n4 & 0x22) != 0;
        int[] nArray = new int[1];
        char[] cArray2 = new char[(n3 - n) * 20];
        while (true) {
            composePartArgs.length = NormalizerImpl.decompose(cArray, n, n2, cArray2, 0, cArray2.length, bl, nArray, n5);
            if (composePartArgs.length <= cArray2.length) break;
            cArray2 = new char[composePartArgs.length];
        }
        int n6 = composePartArgs.length;
        if (composePartArgs.length >= 2) {
            RecomposeArgs recomposeArgs = new RecomposeArgs();
            recomposeArgs.source = cArray2;
            recomposeArgs.start = 0;
            recomposeArgs.limit = n6;
            composePartArgs.prevCC = NormalizerImpl.recompose(recomposeArgs, n5);
            n6 = recomposeArgs.limit;
        }
        composePartArgs.length = n6;
        return cArray2;
    }

    private static boolean composeHangul(char c, char c2, long l, char[] cArray, int[] nArray, int n, boolean bl, char[] cArray2, int n2, int n3) {
        int n4 = nArray[0];
        if (NormalizerImpl.isJamoVTNorm32JamoV(l)) {
            if ((c = (char)(c - 4352)) < '\u0013') {
                c2 = (char)(44032 + (c * 21 + (c2 - 4449)) * 28);
                if (n4 != n) {
                    char c3 = cArray[n4];
                    char c4 = (char)(c3 - 4519);
                    if (c4 < '\u001c') {
                        ++n4;
                        c2 = (char)(c2 + c4);
                    } else if (bl && NormalizerImpl.isNorm32Regular(l = NormalizerImpl.getNorm32(c3)) && (l & 8L) != 0L) {
                        DecomposeArgs decomposeArgs = new DecomposeArgs();
                        int n5 = NormalizerImpl.decompose(l, 8, decomposeArgs);
                        if (decomposeArgs.length == 1 && (c4 = (char)(extraData[n5] - 4519)) < '\u001c') {
                            ++n4;
                            c2 = (char)(c2 + c4);
                        }
                    }
                }
                if (NormalizerImpl.nx_contains(n3, c2)) {
                    if (!NormalizerImpl.isHangulWithoutJamoT(c2)) {
                        --n4;
                    }
                    return false;
                }
                cArray2[n2] = c2;
                nArray[0] = n4;
                return true;
            }
        } else if (NormalizerImpl.isHangulWithoutJamoT(c)) {
            if (NormalizerImpl.nx_contains(n3, c2 = (char)(c + (c2 - 4519)))) {
                return false;
            }
            cArray2[n2] = c2;
            nArray[0] = n4;
            return true;
        }
        return false;
    }

    static int compose(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, boolean bl, int n5) {
        int n6;
        char c;
        int[] nArray = new int[1];
        if (!bl) {
            c = (char)indexes[6];
            n6 = 17;
        } else {
            c = (char)indexes[7];
            n6 = 34;
        }
        int n7 = n;
        int n8 = 0xFF00 | n6;
        int n9 = 0;
        int n10 = 0;
        long l = 0L;
        char c2 = '\u0000';
        while (true) {
            char c3;
            int n11;
            int n12;
            int n13 = n;
            while (n != n2 && ((c2 = cArray[n]) < c || ((l = NormalizerImpl.getNorm32(c2)) & (long)n8) == 0L)) {
                n10 = 0;
                ++n;
            }
            if (n != n13) {
                n12 = n - n13;
                if (n3 + n12 <= n4) {
                    System.arraycopy(cArray, n13, cArray2, n3, n12);
                }
                n9 = n3 += n12;
                n7 = n - 1;
                if (Character.isLowSurrogate(cArray[n7]) && n13 < n7 && Character.isHighSurrogate(cArray[n7 - 1])) {
                    --n7;
                }
                n13 = n;
            }
            if (n == n2) break;
            ++n;
            if (NormalizerImpl.isNorm32HangulOrJamo(l)) {
                n11 = 0;
                n10 = 0;
                n9 = n3;
                nArray[0] = n;
                if (n3 > 0 && NormalizerImpl.composeHangul(cArray[n13 - 1], c2, l, cArray, nArray, n2, bl, cArray2, n3 <= n4 ? n3 - 1 : 0, n5)) {
                    n7 = n = nArray[0];
                    continue;
                }
                n = nArray[0];
                c3 = '\u0000';
                n12 = 1;
                n7 = n13;
            } else {
                if (NormalizerImpl.isNorm32Regular(l)) {
                    c3 = '\u0000';
                    n12 = 1;
                } else if (n != n2 && Character.isLowSurrogate(c3 = cArray[n])) {
                    ++n;
                    n12 = 2;
                    l = NormalizerImpl.getNorm32FromSurrogatePair(l, c3);
                } else {
                    c3 = '\u0000';
                    n12 = 1;
                    l = 0L;
                }
                ComposePartArgs composePartArgs = new ComposePartArgs();
                if (NormalizerImpl.nx_contains(n5, c2, c3)) {
                    n11 = 0;
                } else if ((l & (long)n6) == 0L) {
                    n11 = (int)(0xFFL & l >> 8);
                } else {
                    int n14 = n6 << 2 & 0xF;
                    if (NormalizerImpl.isTrueStarter(l, 0xFF00 | n6, n14)) {
                        n7 = n13;
                    } else {
                        n3 -= n13 - n7;
                    }
                    n = NormalizerImpl.findNextStarter(cArray, n, n2, n6, n14, c);
                    composePartArgs.prevCC = n10;
                    composePartArgs.length = n12;
                    char[] cArray3 = NormalizerImpl.composePart(composePartArgs, n7, cArray, n, n2, n6, n5);
                    if (cArray3 == null) break;
                    n10 = composePartArgs.prevCC;
                    n12 = composePartArgs.length;
                    if (n3 + composePartArgs.length <= n4) {
                        int n15 = 0;
                        while (n15 < composePartArgs.length) {
                            cArray2[n3++] = cArray3[n15++];
                            --n12;
                        }
                    } else {
                        n3 += n12;
                    }
                    n7 = n;
                    continue;
                }
            }
            if (n3 + n12 <= n4) {
                if (n11 != 0 && n11 < n10) {
                    int n16 = n3;
                    n10 = NormalizerImpl.insertOrdered(cArray2, n9, n16, n3 += n12, c2, c3, n11);
                    continue;
                }
                cArray2[n3++] = c2;
                if (c3 != '\u0000') {
                    cArray2[n3++] = c3;
                }
                n10 = n11;
                continue;
            }
            n3 += n12;
            n10 = n11;
        }
        return n3;
    }

    public static int getCombiningClass(int n) {
        long l = NormalizerImpl.getNorm32(n);
        return (char)(l >> 8 & 0xFFL);
    }

    static int getDecompose(int[] nArray, String[] stringArray) {
        DecomposeArgs decomposeArgs = new DecomposeArgs();
        boolean bl = false;
        long l = 0L;
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        while (++n < 195102) {
            if (n == 12543) {
                n = 63744;
            } else if (n == 65536) {
                n = 119134;
            } else if (n == 119233) {
                n = 194560;
            }
            if (((l = NormalizerImpl.getNorm32(n)) & 4L) == 0L || n3 >= nArray.length) continue;
            nArray[n3] = n;
            n2 = NormalizerImpl.decompose(l, decomposeArgs);
            stringArray[n3++] = new String(extraData, n2, decomposeArgs.length);
        }
        return n3;
    }

    private static int strCompare(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, boolean bl) {
        char c;
        char c2;
        int n5;
        int n6;
        int n7 = n;
        int n8 = n3;
        int n9 = n2 - n;
        int n10 = n4 - n3;
        if (n9 < n10) {
            n6 = -1;
            n5 = n7 + n9;
        } else if (n9 == n10) {
            n6 = 0;
            n5 = n7 + n9;
        } else {
            n6 = 1;
            n5 = n7 + n10;
        }
        if (cArray == cArray2) {
            return n6;
        }
        while (true) {
            if (n == n5) {
                return n6;
            }
            c2 = cArray[n];
            c = cArray2[n3];
            if (c2 != c) break;
            ++n;
            ++n3;
        }
        n5 = n7 + n9;
        int n11 = n8 + n10;
        if (c2 >= '\ud800' && c >= '\ud800' && bl) {
            if (!(c2 <= '\udbff' && n + 1 != n5 && Character.isLowSurrogate(cArray[n + 1]) || Character.isLowSurrogate(c2) && n7 != n && Character.isHighSurrogate(cArray[n - 1]))) {
                c2 = (char)(c2 - 10240);
            }
            if (!(c <= '\udbff' && n3 + 1 != n11 && Character.isLowSurrogate(cArray2[n3 + 1]) || Character.isLowSurrogate(c) && n8 != n3 && Character.isHighSurrogate(cArray2[n3 - 1]))) {
                c = (char)(c - 10240);
            }
        }
        return c2 - c;
    }

    private static final boolean nx_contains(int n, int n2) {
        if (n != 1) {
            return false;
        }
        return n2 >= 44032 && n2 <= 55203;
    }

    private static final boolean nx_contains(int n, char c, char c2) {
        if (n != 1) {
            return false;
        }
        return c2 == '\u0000' && c >= '\uac00' && c <= '\ud7a3';
    }

    static /* synthetic */ int[] access$002(int[] nArray) {
        indexes = nArray;
        return nArray;
    }

    static /* synthetic */ char[] access$102(char[] cArray) {
        combiningTable = cArray;
        return cArray;
    }

    static /* synthetic */ char[] access$202(char[] cArray) {
        extraData = cArray;
        return cArray;
    }

    static {
        try {
            IMPL = new NormalizerImpl();
        }
        catch (Exception exception) {
            RuntimeException runtimeException = new RuntimeException(exception.getMessage());
            runtimeException.initCause(exception);
            throw runtimeException;
        }
    }

    private static final class ComposePartArgs {
        int prevCC;
        int length;

        private ComposePartArgs() {
        }
    }

    private static final class DecomposeArgs {
        int cc;
        int trailCC;
        int length;

        private DecomposeArgs() {
        }
    }

    private static final class FCDTrieImpl
    implements Trie.DataManipulate {
        static CharTrie fcdTrie = null;

        private FCDTrieImpl() {
        }

        public int getFoldingOffset(int n) {
            return n;
        }
    }

    private static final class NextCCArgs {
        char[] source;
        int next;
        int limit;
        char c;
        char c2;

        private NextCCArgs() {
        }
    }

    private static final class NextCombiningArgs {
        char[] source;
        int start;
        char c;
        char c2;
        int combiningIndex;
        char cc;

        private NextCombiningArgs() {
        }
    }

    private static final class NormTrieImpl
    implements Trie.DataManipulate {
        static IntTrie normTrie = null;

        private NormTrieImpl() {
        }

        public int getFoldingOffset(int n) {
            return 2048 + (n >> 11 & 0x7FE0);
        }
    }

    private static final class PrevArgs {
        char[] src;
        int start;
        int current;
        char c;
        char c2;

        private PrevArgs() {
        }
    }

    private static final class RecomposeArgs {
        char[] source;
        int start;
        int limit;

        private RecomposeArgs() {
        }
    }
}

