/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERTagDecoder;

public class BERTag
extends BERElement {
    private int m_tag = 0;
    private BERElement m_element = null;
    private boolean m_implicit = false;

    public BERTag(int n, BERElement bERElement, boolean bl) {
        this.m_tag = n;
        this.m_element = bERElement;
        this.m_implicit = bl;
    }

    public BERTag(BERTagDecoder bERTagDecoder, int n, InputStream inputStream, int[] nArray) throws IOException {
        this.m_tag = n;
        boolean[] blArray = new boolean[1];
        this.m_element = bERTagDecoder.getElement(bERTagDecoder, n, inputStream, nArray, blArray);
        this.m_implicit = blArray[0];
    }

    public BERElement getValue() {
        return this.m_element;
    }

    public void setImplicit(boolean bl) {
        this.m_implicit = bl;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.m_tag);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.m_element.write(byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (this.m_implicit) {
            outputStream.write(byArray, 1, byArray.length - 1);
        } else {
            BERTag.sendDefiniteLength(outputStream, byArray.length);
            outputStream.write(byArray);
        }
    }

    public int getType() {
        return -1;
    }

    public int getTag() {
        return this.m_tag;
    }

    public String toString() {
        String string = "";
        if ((this.m_tag & 0xC0) == 0) {
            string = string + "UNIVERSAL-";
        } else if ((this.m_tag & 0x80 & (this.m_tag & 0x40)) > 0) {
            string = string + "PRIVATE-";
        } else if ((this.m_tag & 0x40) > 0) {
            string = string + "APPLICATION-";
        } else if ((this.m_tag & 0x80) > 0) {
            string = string + "CONTEXT-";
        }
        return "[" + string + (this.m_tag & 0x1F) + "] " + this.m_element.toString();
    }
}

