/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.diskmgr.client.Content;
import com.sun.admin.diskmgr.client.ContentEvent;
import com.sun.admin.diskmgr.client.ContentListener;
import com.sun.admin.diskmgr.client.DiskActionsListener;
import com.sun.admin.diskmgr.client.NavigationSelectionListener;
import com.sun.admin.diskmgr.client.TreeNodeData;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.Border;

public class DiskToolBar
extends JToolBar {
    private ContentListener contentListener;
    private Content content;
    private int newButtonPosition;
    private VDiskMgr theApp;
    DiskActionsListener buttonClickListener;

    public DiskToolBar(VDiskMgr vDiskMgr) {
        this.theApp = vDiskMgr;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.buttonClickListener = new DiskActionsListener(vDiskMgr);
        ((Container)this).setLayout(new GridBagLayout());
        Dimension dimension = new Dimension(1, 1);
        Constraints.constrain((Container)this, (Component)new Box.Filler(dimension, dimension, dimension), (int)-1, (int)0, (int)0, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        this.contentListener = new ContentListener(){

            public void itemPressed(ContentEvent contentEvent) {
                Content content = contentEvent.getSource();
                DiskToolBar.this.notifySelectionChange(content.getNumSelections());
            }
        };
        vDiskMgr.addNavigationSelectionListener(new NavigationSelectionListener(){

            public void valueChanged(VScopeNode vScopeNode) {
                if (DiskToolBar.this.content != null) {
                    DiskToolBar.this.content.removeContentListener(DiskToolBar.this.contentListener);
                }
                TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
                DiskToolBar.this.content = treeNodeData.getContent();
                DiskToolBar.this.content.addContentListener(DiskToolBar.this.contentListener);
                DiskToolBar.this.configureForContent();
                DiskToolBar.this.notifySelectionChange(DiskToolBar.this.content.getNumSelections());
            }
        });
    }

    private void configureForContent() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setProperty("vconsole.deleteenabled", "false");
        vConsoleProperties.setProperty("vconsole.findenabled", "false");
        vConsoleProperties.setProperty("vconsole.filterenabled", "false");
        vConsoleProperties.setProperty("vconsole.propertiesenabled", "true");
    }

    private void notifySelectionChange(int n) {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        String string = "false";
        if (n == 1) {
            string = "true";
        }
        vConsoleProperties.setProperty("vconsole.propertiesenabled", string);
    }

    class ToolBarButton
    extends JButton {
        private ImageIcon enabledIcon;
        private Border defaultBorder;

        public ToolBarButton(String string) {
            this(string, "???", "undefined");
        }

        public ToolBarButton(String string, String string2, String string3) {
            ResourceBundle resourceBundle = DiskToolBar.this.theApp.getResourceBundle();
            this.enabledIcon = DiskToolBar.this.theApp.loadImageIcon(String.valueOf(string2) + ".gif");
            if (this.enabledIcon != null && this.enabledIcon.getIconHeight() != -1) {
                this.setIcon(this.enabledIcon);
            } else {
                this.setText(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)string));
            }
            this.setBorderPainted(true);
            this.defaultBorder = this.getBorder();
            this.setFocusPainted(false);
            this.setActionCommand(string3);
            this.setToolTipText(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)(String.valueOf(string) + "Tooltip")));
            this.setMargin(new Insets(0, 0, 0, 0));
            this.addActionListener(DiskToolBar.this.buttonClickListener);
        }

        public void showAsDepressed() {
            this.setBorder(BorderFactory.createBevelBorder(1));
        }

        public void showAsEnabled() {
            this.setBorder(this.defaultBorder);
            this.setEnabled(true);
        }
    }
}

