/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.diskmgr.client.DiskGraphic;
import com.sun.admin.diskmgr.client.DiskGraphicBtnPanel;
import com.sun.admin.diskmgr.client.DiskMgrContextHelpListener;
import com.sun.admin.diskmgr.client.SliceGenPropPanel;
import com.sun.admin.diskmgr.client.SliceModifyPanel;
import com.sun.admin.diskmgr.client.SliceSizePanel;
import com.sun.admin.diskmgr.client.TreeNodeData;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.DiskData;
import com.sun.admin.diskmgr.common.DiskMgrException;
import com.sun.admin.diskmgr.common.SliceData;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.console.gui.VOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SlicePropDialog
extends VOptionPane {
    public static final int HELP_CACHE_SIZE = 1;
    GenInfoPanel infoPanel;
    Vector helpCache;
    DiskMgrContextHelpListener helpListener;
    VDiskMgr theApp;
    ResourceBundle bundle;
    SlicePropDialog dialog;
    private SliceData sliceData;
    private SliceData newSliceData;
    private DiskData diskData = null;
    private SliceGenPropPanel genPanel;
    private JButton okBtn;
    private JButton cancelBtn;
    GridBagConstraints gbc;

    public SlicePropDialog(VDiskMgr vDiskMgr, SliceData sliceData) {
        this.theApp = vDiskMgr;
        this.bundle = vDiskMgr.getResourceBundle();
        this.dialog = this;
        this.sliceData = sliceData;
        this.newSliceData = (SliceData)sliceData.clone();
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SlicePropTitle");
        Object[] objectArray = new Object[]{new Short(sliceData.getPartition()).toString()};
        this.setTitle(MessageFormat.format(string, objectArray));
        this.infoPanel = new GenInfoPanel((VOptionPane)this);
        this.helpCache = new Vector(1);
        String string2 = new String("diskpart");
        if (sliceData.getTag() == 5) {
            string2 = new String("diskpart_backup");
        }
        this.helpListener = new DiskMgrContextHelpListener(vDiskMgr, this.helpCache, this.infoPanel, string2);
        this.infoPanel.setFocusListener((FocusListener)((Object)this.helpListener), true);
        JPanel jPanel = this.buildBtnPanel();
        JComponent jComponent = this.getButtonPane();
        jComponent.setLayout(new GridBagLayout());
        Constraints.constrain((Container)jComponent, (Component)jPanel, (int)0, (int)0, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        this.genPanel = new SliceGenPropPanel(vDiskMgr, this);
        this.genPanel.dialogDataInitialize(this.newSliceData);
        JComponent jComponent2 = this.getContentPane();
        jComponent2.setLayout(new GridBagLayout());
        Constraints.constrain((Container)jComponent2, (Component)this.genPanel, (int)0, (int)0, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
    }

    protected JPanel buildBtnPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        Constraints.constrain((Container)jPanel, (Component)jPanel2, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        BtnListener btnListener = new BtnListener();
        String string = new String(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"okBtn"));
        this.okBtn = new JButton(string);
        this.okBtn.addActionListener(btnListener);
        this.okBtn.setEnabled(this.theApp.getDiskMgr().hasWriteAuthorization());
        Constraints.constrain((Container)jPanel, (Component)this.okBtn, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        string = new String(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"cancelBtn"));
        this.cancelBtn = new JButton(string);
        this.cancelBtn.addActionListener(btnListener);
        Constraints.constrain((Container)jPanel, (Component)this.cancelBtn, (int)2, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)6, (int)0, (int)6, (int)6);
        return jPanel;
    }

    public void doCancel() {
        if (this.theApp.isWaitOn()) {
            this.theApp.waitOff();
        }
        this.getParentFrame().dispose();
    }

    public void doOK() {
        Thread thread = new Thread(){
            JFrame parent;
            {
                this.parent = SlicePropDialog.this.getParentFrame();
            }

            public void run() {
                SlicePropDialog.this.theApp.waitOn();
                ((Component)this.parent).setVisible(false);
                try {
                    SlicePropDialog.this.genPanel.dialogDataExchange(SlicePropDialog.this.newSliceData);
                }
                catch (DiskMgrException diskMgrException) {
                    ((Component)this.parent).setVisible(true);
                    SlicePropDialog.this.theApp.reportErrorException((Exception)((Object)diskMgrException), this.parent);
                    return;
                }
                if (!SlicePropDialog.this.sliceData.equals(SlicePropDialog.this.newSliceData)) {
                    if (!SlicePropDialog.this.getSliceSizePanel().isValid()) {
                        DiskMgrException diskMgrException = new DiskMgrException("EXM_DM_GUI_OVERLAP");
                        ((Component)this.parent).setVisible(true);
                        SlicePropDialog.this.theApp.reportErrorException((Exception)((Object)diskMgrException), this.parent);
                        return;
                    }
                    if (SlicePropDialog.this.sliceData.computeSize() != SlicePropDialog.this.newSliceData.computeSize() && SlicePropDialog.this.sliceData.getFS()) {
                        SliceModifyPanel sliceModifyPanel = new SliceModifyPanel(SlicePropDialog.this.theApp, SlicePropDialog.this.dialog);
                        ActionListener actionListener = sliceModifyPanel.getListener();
                        VFrame vFrame = new VFrame();
                        WarningDialog warningDialog = new WarningDialog((JFrame)vFrame, ResourceStrings.getString((ResourceBundle)SlicePropDialog.this.bundle, (String)"modify_slice_title"), (JPanel)sliceModifyPanel, actionListener, ResourceStrings.getString((ResourceBundle)SlicePropDialog.this.bundle, (String)"continueBtn"));
                    } else {
                        SlicePropDialog.this.modifySlice();
                        SlicePropDialog.this.doCancel();
                    }
                } else {
                    SlicePropDialog.this.doCancel();
                }
                SlicePropDialog.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public DiskGraphicBtnPanel getBtnPanel() {
        return this.genPanel.getBtnPanel();
    }

    public DiskData getDiskData() {
        if (this.diskData == null) {
            TreeNodeData treeNodeData = (TreeNodeData)this.theApp.getTree().getCurrentNode().getPayload();
            this.diskData = treeNodeData.getDiskData();
        }
        return this.diskData;
    }

    public DiskGraphic getDiskGraphic() {
        return this.genPanel.getDiskGraphic();
    }

    protected JFrame getParentFrame() {
        return (JFrame)this.getContainer();
    }

    public SliceData getSliceData() {
        return this.sliceData;
    }

    public SliceSizePanel getSliceSizePanel() {
        return this.genPanel.getSliceSizePanel();
    }

    protected void modifySlice() {
        Thread thread = new Thread(){
            JFrame parent;
            {
                this.parent = SlicePropDialog.this.getParentFrame();
            }

            public void run() {
                try {
                    SlicePropDialog.this.theApp.getDiskMgr().formatSlice(SlicePropDialog.this.newSliceData);
                    Vector vector = SlicePropDialog.this.diskData.getVSlices();
                    vector.removeElement(SlicePropDialog.this.sliceData);
                    vector.addElement(SlicePropDialog.this.newSliceData);
                    SlicePropDialog.this.diskData.setVSlices(vector);
                    SlicePropDialog.this.diskData.sortSlicesByStartCyl();
                    SlicePropDialog.this.theApp.getTree().getCurrentContent().refresh();
                }
                catch (DiskMgrException diskMgrException) {
                    ((Component)this.parent).setVisible(true);
                    SlicePropDialog.this.theApp.reportErrorException((Exception)((Object)diskMgrException), this.parent);
                }
            }
        };
        thread.start();
    }

    class BtnListener
    implements ActionListener {
        BtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == SlicePropDialog.this.okBtn) {
                SlicePropDialog.this.doOK();
            } else {
                SlicePropDialog.this.doCancel();
            }
        }
    }
}

