/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.SelectableLabel;
import com.sun.admin.diskmgr.client.Content;
import com.sun.admin.diskmgr.client.DiskMgrContextHelpListener;
import com.sun.admin.diskmgr.client.SliceFsStep;
import com.sun.admin.diskmgr.client.SliceWizard;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.DiskData;
import com.sun.admin.diskmgr.common.SliceData;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SliceUseStep
extends VWizardCard {
    public static final String NAME = "SliceUseStep";
    public static final int HELP_CACHE_SIZE = 3;
    GenInfoPanel infoPanel;
    Vector helpCache;
    DiskMgrContextHelpListener helpListener;
    DiskData diskData;
    ResourceBundle bundle;
    SliceWizard wizard;
    VDiskMgr theApp;
    SliceFsStep fsStep = null;
    int numSlices;
    int numToCreate;
    boolean backup;
    Vector slices;
    Vector vCombos;

    public SliceUseStep(VDiskMgr vDiskMgr, SliceWizard sliceWizard) {
        this.theApp = vDiskMgr;
        this.wizard = sliceWizard;
        this.diskData = sliceWizard.getDiskData();
        this.bundle = vDiskMgr.getResourceBundle();
        this.infoPanel = new GenInfoPanel((VOptionPane)sliceWizard);
        this.helpCache = new Vector(3);
        this.helpListener = new DiskMgrContextHelpListener(vDiskMgr, this.helpCache, this.infoPanel, "disk_wiz_each");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.helpListener), true);
        this.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SliceWizUseStep"));
        this.constructStep();
    }

    protected JComboBox buildComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("unassigned");
        jComboBox.addItem("boot");
        jComboBox.addItem("root");
        jComboBox.addItem("swap");
        jComboBox.addItem("usr");
        jComboBox.addItem("stand");
        jComboBox.addItem("var");
        jComboBox.addItem("home");
        jComboBox.addItem("altsctr");
        jComboBox.addItem("cache");
        return jComboBox;
    }

    private void constructStep() {
        ((Container)((Object)this)).removeAll();
        this.wizard.resetSliceData();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SliceWizPartition"));
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SliceWizSize"));
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)1, (int)0, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SliceWizUsedFor"));
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)2, (int)0, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        JPanel jPanel2 = new JPanel();
        Constraints.constrain((Container)jPanel, (Component)jPanel2, (int)3, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        int n = 1;
        this.numSlices = this.wizard.getNumSlices();
        this.backup = this.wizard.hasBackup();
        this.numToCreate = this.numSlices;
        if (this.backup) {
            ++this.numToCreate;
        }
        this.vCombos = new Vector(this.numToCreate);
        int n2 = 0;
        while (n2 < this.numToCreate) {
            Object object;
            JLabel jLabel2;
            JLabel jLabel3;
            if (this.backup && this.numSlices == 1 && n2 == 1) {
                jLabel3 = new JLabel(Integer.toString(2));
            } else {
                jLabel3 = new JLabel(Integer.toString(n2));
                if (this.backup && n2 == 2) {
                    jLabel3.setFont(Constants.ITALIC_DIALOG_FONT);
                    jLabel3.setMinimumSize(jLabel3.getPreferredSize());
                }
            }
            Constraints.constrain((Container)jPanel, (Component)jLabel3, (int)0, (int)n, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)3, (int)6, (int)6, (int)6);
            if (this.backup && (n2 == 2 || this.numSlices == 1 && n2 == 1)) {
                jLabel2 = new JLabel(Content.formatSuffix(this.diskData.getSolarisDiskCapacity(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"Megabytes")));
                jLabel2.setFont(Constants.ITALIC_DIALOG_FONT);
                object = new SelectableLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SliceWizBackup"), 8);
                object.setFont(Constants.ITALIC_DIALOG_FONT);
                this.helpListener = new DiskMgrContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "disk_wiz_each_backup");
                this.theApp.addHelpListener(this.helpListener, (Component)object);
            } else {
                float f = this.diskData.computeDiskCapacity() / (long)this.numSlices / 1000000L;
                jLabel2 = new JLabel(Content.formatSuffix(Float.toString(f), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"Megabytes")));
                JComboBox jComboBox = this.buildComboBox();
                jComboBox.setSelectedItem("unassigned");
                object = jComboBox;
                this.helpListener = new DiskMgrContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "disk_wiz_each");
                this.theApp.addHelpListener(this.helpListener, (Component)object);
            }
            this.vCombos.addElement(object);
            Constraints.constrain((Container)jPanel, (Component)jLabel2, (int)1, (int)n, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)3, (int)6, (int)6, (int)6);
            Constraints.constrain((Container)jPanel, (Component)object, (int)2, (int)n, (int)1, (int)1, (int)2, (int)10, (double)0.0, (double)0.0, (int)3, (int)6, (int)6, (int)6);
            jPanel2 = new JPanel();
            Constraints.constrain((Container)jPanel, (Component)jPanel2, (int)3, (int)n, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            ++n;
            ++n2;
        }
        Constraints.constrain((Container)((Object)this), (Component)jPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        jPanel2 = new JPanel();
        Constraints.constrain((Container)((Object)this), (Component)jPanel2, (int)0, (int)1, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
    }

    public boolean isSubStep() {
        return true;
    }

    public void reset() {
    }

    public void start() {
        super.start();
        if (this.numSlices != this.wizard.getNumSlices() || this.backup != this.wizard.hasBackup()) {
            this.constructStep();
        }
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.canmoveforward", "vwp.true");
    }

    public boolean stop(boolean bl) {
        this.getManager().setPrevious(NAME, "SliceNumEqualStep");
        if (bl) {
            if (this.fsStep == null) {
                this.fsStep = new SliceFsStep(this.theApp, this.wizard);
                this.wizard.addCard("SliceFsStep", this.fsStep);
            }
            this.getManager().setNext(NAME, "SliceFsStep");
            SliceData sliceData = null;
            int n = this.diskData.getSolarisCylinders() - 1;
            int n2 = (this.diskData.getSolarisCylinders() - this.numSlices) / this.numSlices;
            int n3 = 0;
            int n4 = -1;
            this.slices = this.wizard.getSlices();
            int n5 = 0;
            while (n5 < this.vCombos.size()) {
                int n6 = n5;
                if (this.backup && this.numToCreate < 3 && n5 == 1) {
                    n6 = 2;
                }
                if ((sliceData = (SliceData)this.slices.elementAt(n6)).getTag() != 5) {
                    JComboBox jComboBox = (JComboBox)this.vCombos.elementAt(n5);
                    short s = (short)jComboBox.getSelectedIndex();
                    if (s >= 5) {
                        s = (short)(s + 1);
                    }
                    sliceData.setTag(s);
                    n3 = n4 + 1;
                    n4 = n3 + n2;
                    sliceData.setStartCylinder(n3);
                    sliceData.setEndCylinder(n4);
                } else {
                    sliceData.setTag((short)5);
                }
                ++n5;
            }
            if (sliceData.getEndCylinder() < n) {
                sliceData.setEndCylinder(n);
            }
        }
        return true;
    }
}

