/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.diskmgr.client.SliceGenStep;
import com.sun.admin.diskmgr.client.SliceReviewStep;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.DiskData;
import com.sun.admin.diskmgr.common.DiskMgrException;
import com.sun.admin.diskmgr.common.SliceData;
import com.sun.management.viper.console.gui.wizard.VWizard;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class SliceWizard
extends VWizard {
    DiskData diskData;
    ResourceBundle bundle;
    VDiskMgr theApp;
    SliceGenStep genStep;
    private int numSlices = 0;
    private boolean backup = true;
    private boolean bCustom = false;
    private boolean bSizeAsPercent = true;

    public SliceWizard(VDiskMgr vDiskMgr, DiskData diskData) {
        this.theApp = vDiskMgr;
        this.diskData = diskData;
        this.bundle = vDiskMgr.getResourceBundle();
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SliceWizTitle");
        Object[] objectArray = new Object[]{new String(this.diskData.getDiskName())};
        this.setTitle(MessageFormat.format(string, objectArray));
        this.genStep = new SliceGenStep(vDiskMgr, this);
        ((JComponent)((Object)this.genStep)).setPreferredSize(SliceReviewStep.getMaxStepSize(this.bundle, this.diskData.getDiskCapacity()));
        this.addCard("SliceGenStep", this.genStep);
    }

    public void cancelWizard() {
        super.cancelWizard();
    }

    public void createBackup(boolean bl) {
        this.backup = bl;
    }

    public void doFinish() {
        Thread thread = new Thread(){
            JFrame parent;
            {
                this.parent = SliceWizard.this.getParentFrame();
            }

            public void run() {
                SliceWizard.this.theApp.waitOn();
                ((Component)this.parent).setVisible(false);
                try {
                    SliceWizard.this.theApp.getDiskMgr().formatDisk(SliceWizard.this.diskData);
                    SliceWizard.this.theApp.getTree().getCurrentContent().refresh();
                    SliceWizard.this.cancelWizard();
                }
                catch (DiskMgrException diskMgrException) {
                    ((Component)this.parent).setVisible(true);
                    SliceWizard.this.theApp.reportErrorException((Exception)((Object)diskMgrException), this.parent);
                }
                SliceWizard.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    protected DiskData getDiskData() {
        return this.diskData;
    }

    public int getNumSlices() {
        return this.numSlices;
    }

    private JFrame getParentFrame() {
        return (JFrame)this.getContainer();
    }

    protected Vector getSlices() {
        this.diskData.sortSlicesByPartition();
        Vector vector = this.diskData.getVSlices();
        return vector;
    }

    public boolean hasBackup() {
        return this.backup;
    }

    public boolean isCustom() {
        return this.bCustom;
    }

    public boolean isSizePercent() {
        return this.bSizeAsPercent;
    }

    protected void resetSliceData() {
        Vector<SliceData> vector = new Vector<SliceData>();
        int n = 0;
        while (n < this.diskData.getVSlices().size()) {
            SliceData sliceData = new SliceData(this.diskData, (short)n);
            if (this.backup && n == 2) {
                sliceData.setTag((short)5);
            }
            vector.addElement(sliceData);
            ++n;
        }
        this.diskData.setVSlices(vector);
        this.diskData.sortSlicesByPartition();
    }

    public void setCustom(boolean bl) {
        this.bCustom = bl;
    }

    public void setNumSlices(int n) {
        this.numSlices = n;
    }

    public void setSizeAsPercent(boolean bl) {
        this.bSizeAsPercent = bl;
    }
}

