/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.common;

import com.sun.admin.diskmgr.common.DiskData;
import java.io.Serializable;

public class FdiskData
implements Serializable,
Cloneable {
    protected static final int MIN_PART_NUM = 0;
    protected static final int MAX_PART_NUM = 3;
    protected static final short SOLARIS = 130;
    public static final String SOLARISSTR = "Solaris";
    protected static final short UNIX = 99;
    public static final String UNIXSTR = "Unix";
    protected static final short LINUX = 65;
    public static final String LINUXSTR = "Linux";
    protected static final short BSD = 165;
    public static final String BSDSTR = "BSD";
    protected static final short PCIXOS = 2;
    public static final String PCIXOSSTR = "PC/IX";
    protected static final short OTHER = 98;
    public static final String OTHERSTR = "Other";
    protected static final short DOSEXT = 5;
    public static final String DOSEXTSTR = "EXT-DOS";
    protected static final short DOSHUGE = 6;
    public static final String DOSHUGESTR = "Huge DOS";
    private DiskData diskData;
    private short partition;
    private short usedFor;
    private int startCylinder = 0;
    private int endCylinder = 0;
    private int numSectors = 0;
    private boolean bActive = false;

    public FdiskData(DiskData diskData, short s) {
        this.diskData = diskData;
        this.partition = s;
        this.startCylinder = 0;
        this.endCylinder = 0;
        this.bActive = false;
    }

    public FdiskData(DiskData diskData, short s, short s2, int n, int n2, boolean bl) {
        this.diskData = diskData;
        this.partition = s;
        this.usedFor = s2;
        this.startCylinder = n;
        this.numSectors = n2;
        this.bActive = bl;
        this.calculateEndCylinder();
    }

    private void calculateEndCylinder() {
        this.endCylinder = this.startCylinder + this.diskData.sectorToCylinder(this.numSectors) - 1;
        if (this.endCylinder < 0) {
            this.endCylinder = 0;
        }
    }

    private void calculateNumSectors() {
        int n = this.endCylinder - this.startCylinder;
        if (n <= 0) {
            this.numSectors = 0;
            return;
        }
        this.numSectors = this.diskData.cylinderToSector(++n);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public float computeSize() {
        int n = this.endCylinder - this.startCylinder;
        return this.diskData.cylinderToMB(n);
    }

    public boolean equals(FdiskData fdiskData) {
        if (fdiskData == null) {
            return false;
        }
        return this.getPartition() == fdiskData.getPartition() && this.getUsedFor() == fdiskData.getUsedFor() && this.getStartCylinder() == fdiskData.getStartCylinder() && this.getEndCylinder() == fdiskData.getEndCylinder();
    }

    public boolean getActive() {
        return this.bActive;
    }

    public int getEndCylinder() {
        return this.endCylinder;
    }

    public int getNumSectors() {
        this.calculateNumSectors();
        return this.numSectors;
    }

    public short getPartition() {
        return this.partition;
    }

    public String getPartitionName() {
        return String.valueOf(this.diskData.getDiskName()) + "p" + this.partition;
    }

    public String getSize() {
        return Float.toString(this.computeSize());
    }

    public int getStartCylinder() {
        return this.startCylinder;
    }

    public short getUsedFor() {
        return this.usedFor;
    }

    public String getUsedForString() {
        String string = null;
        if (this.usedFor == 130) {
            string = SOLARISSTR;
        } else if (this.usedFor == 99) {
            string = UNIXSTR;
        } else if (this.usedFor == 65) {
            string = LINUXSTR;
        } else if (this.usedFor == 165) {
            string = BSDSTR;
        } else if (this.usedFor == 2) {
            string = PCIXOSSTR;
        } else if (this.usedFor == 98) {
            string = OTHERSTR;
        } else if (this.usedFor == 5) {
            string = DOSEXTSTR;
        } else if (this.usedFor == 6) {
            string = DOSHUGESTR;
        }
        return string;
    }

    public void print() {
        System.out.println("*************************************");
        System.out.println("Partition Number:\t" + this.partition);
        System.out.println("UsedFor:\t   \t" + this.getUsedForString());
        System.out.println("Start Cylinder:\t" + this.startCylinder);
        System.out.println("End Cylinder:\t" + this.endCylinder);
        System.out.println("Num Sectors:\t" + this.numSectors);
        System.out.println("Active Partition:\t" + this.bActive);
        System.out.println("*************************************");
    }

    public void setActive(boolean bl) {
        this.bActive = bl;
    }

    public void setEndCylinder(int n) {
        this.endCylinder = n;
        this.calculateNumSectors();
    }

    public void setNumSectors(int n) {
        this.numSectors = n;
        this.calculateEndCylinder();
    }

    public void setPartition(short s) {
        this.partition = s;
    }

    public void setStartCylinder(int n) {
        this.startCylinder = n;
        this.calculateNumSectors();
    }

    public void setUsedFor(String string) {
        if (string.equals(SOLARISSTR)) {
            this.usedFor = (short)130;
        } else if (string.equals(UNIXSTR)) {
            this.usedFor = (short)99;
        } else if (string.equals(LINUXSTR)) {
            this.usedFor = (short)65;
        } else if (string.equals(BSDSTR)) {
            this.usedFor = (short)165;
        } else if (string.equals(PCIXOSSTR)) {
            this.usedFor = (short)2;
        } else if (string.equals(OTHERSTR)) {
            this.usedFor = (short)98;
        } else if (string.equals(DOSEXTSTR)) {
            this.usedFor = (short)5;
        } else if (string.equals(DOSHUGESTR)) {
            this.usedFor = (short)6;
        }
    }

    public void setUsedFor(short s) {
        this.usedFor = s;
    }
}

