/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.scf;

import com.sun.smartcard.scf.CardInfo;
import com.sun.smartcard.scf.CardLockedException;
import com.sun.smartcard.scf.CardManager;
import com.sun.smartcard.scf.CardRemovedException;
import com.sun.smartcard.scf.CardRemovedMonitor;
import com.sun.smartcard.scf.CommException;
import com.sun.smartcard.scf.DoubleLockException;
import com.sun.smartcard.scf.InternalCard;
import com.sun.smartcard.scf.InternalException;
import com.sun.smartcard.scf.InvalidStateException;
import com.sun.smartcard.scf.LockManager;
import com.sun.smartcard.scf.Logger;
import com.sun.smartcard.scf.TimeoutException;
import com.sun.smartcard.scf.spi.CardProvider;

public class Card {
    public static final String INFO_TYPE = "model";
    public static final String INFO_ATR = "atr";
    public static final int TIMEOUT_MAX = 2147483;
    private boolean isActive = false;
    private CardManager cardManager;
    private CardInfo cardInfo;
    private CardProvider cardProvider;
    private final LockManager lockManager;
    private CardRemovedMonitor cardRemovedMonitor;
    private final Logger logger = Logger.createLogger("Card");

    Card() {
        this.lockManager = new LockManager();
    }

    void activate() {
        this.logger.log("activate", "");
        this.cardRemovedMonitor.activate();
        this.isActive = true;
    }

    public void close() {
        this.logger.log("close", "");
        if (this.isActive) {
            this.isActive = false;
            this.cardManager.cardClosed(this);
            this.cardRemovedMonitor.passivate();
            this.lockManager.close();
        }
    }

    public byte[] exchangeAPDU(byte[] byArray) throws InvalidStateException, CommException, InternalException, CardLockedException, CardRemovedException {
        this.verifyState();
        if (byArray == null) {
            throw new IllegalArgumentException("requestAPDU cannot be null.");
        }
        return this.cardProvider.exchangeAPDU(byArray);
    }

    public Object getInfo(String string) throws InvalidStateException, CommException, InternalException {
        this.verifyState();
        return this.cardInfo.get(string);
    }

    void init(InternalCard internalCard, CardManager cardManager) {
        this.logger.log("init", "");
        this.cardManager = cardManager;
        this.cardInfo = internalCard.getCardInfo();
        this.cardProvider = internalCard.getCardProvider();
        this.lockManager.init(this.cardProvider);
        this.cardRemovedMonitor = internalCard.getCardRemovedMonitor();
    }

    public void lock(int n) throws InvalidStateException, CommException, InternalException, TimeoutException, CardRemovedException, DoubleLockException {
        this.logger.log("lock", "");
        this.verifyState();
        if (n < 0) {
            n = 0;
        } else if (n > 2147483) {
            n = 2147483;
        }
        this.lockManager.getLock(n);
        this.verifyState();
    }

    public void reset() throws InvalidStateException, CommException, InternalException, CardLockedException, CardRemovedException {
        this.verifyState();
        this.cardProvider.reset();
    }

    public void unlock() throws InvalidStateException, CommException, InternalException, CardLockedException, CardRemovedException {
        this.logger.log("unlock", "");
        this.verifyState();
        this.lockManager.releaseLock();
    }

    private void verifyState() throws InvalidStateException {
        if (!this.isActive) {
            throw new InvalidStateException();
        }
    }

    public void waitForCardRemoved(int n) throws InvalidStateException, TimeoutException {
        this.verifyState();
        if (n < 0) {
            n = 0;
        }
        this.cardRemovedMonitor.waitForCardRemoved(n);
    }
}

