/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mib2mof;

import com.sun.wbem.compiler.mib2mof.ASTMib;
import com.sun.wbem.compiler.mib2mof.CimGroupGenerator;
import com.sun.wbem.compiler.mib2mof.Generator;
import com.sun.wbem.compiler.mib2mof.MessageHandler;
import com.sun.wbem.compiler.mib2mof.MibNode;
import com.sun.wbem.compiler.mib2mof.MibTree;
import com.sun.wbem.compiler.mib2mof.ResourceManager;
import com.sun.wbem.compiler.mib2mof.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class CimCodeGenerator
extends Generator
implements Serializable {
    protected CimGroupGenerator groupGenerator;

    public CimCodeGenerator(ResourceManager resourceManager, String string, String string2, String string3) {
        super(resourceManager, string, string2, string3);
        this.groupGenerator = new CimGroupGenerator(resourceManager, string, string2, string3);
    }

    public void generateCode(ASTMib aSTMib) throws IOException {
        this.mib = aSTMib;
        aSTMib.buildOidTable();
        MibTree mibTree = aSTMib.getMibTree();
        this.groupGenerator.setMib(aSTMib);
        MibNode mibNode = mibTree.getRoot();
        this.generateCode(mibNode);
    }

    private void generateCode(MibNode mibNode) throws IOException {
        if (mibNode.isGroup()) {
            try {
                mibNode.isValidGroup();
            }
            catch (IOException iOException) {
                String string = iOException.getMessage();
                Trace.error(MessageHandler.getMessage("generate.error.mib", this.getClassName(mibNode.getComputedOid()), this.getClassName(string)));
                throw iOException;
            }
            this.groupGenerator.generateCode(mibNode);
            return;
        }
        Hashtable hashtable = mibNode.getChildren();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            this.generateCode((MibNode)enumeration.nextElement());
        }
    }
}

