/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.analysis;

import com.sun.patchpro.log.PatchProLog;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class DetectorClassLoader
extends SecureClassLoader {
    private File classSource = new File("/tmp/pprodetectors.jar");
    private boolean isJarFile;
    private PatchProLog log = PatchProLog.getInstance();
    private JarFile jarFile = null;
    private Enumeration jarFileEntries = null;

    public DetectorClassLoader(File file) {
        this.classSource = file;
        this.setSourceType(this.classSource);
    }

    public DetectorClassLoader(File file, ClassLoader classLoader) {
        super(classLoader);
        this.classSource = file;
        this.setSourceType(this.classSource);
    }

    public DetectorClassLoader() {
        this.setSourceType(this.classSource);
    }

    private void setSourceType(File file) {
        this.isJarFile = file.getName().indexOf(".jar") >= 0;
    }

    private String mkPathFromClass(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 != null) {
            stringBuffer.append(string2 + System.getProperty("file.separator"));
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '.') {
                stringBuffer.append(System.getProperty("file.separator"));
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    byte[] getBytecodes(String string) throws ClassNotFoundException {
        byte[] byArray = null;
        NameData nameData = new NameData(string);
        if (this.isJarFile) {
            try {
                if (this.jarFile == null) {
                    this.jarFile = new JarFile(this.classSource);
                    this.jarFileEntries = this.jarFile.entries();
                }
                ZipEntry zipEntry = null;
                while (this.jarFileEntries.hasMoreElements()) {
                    zipEntry = (ZipEntry)this.jarFileEntries.nextElement();
                    if (!zipEntry.getName().equals(nameData.pathName)) continue;
                    DataInputStream dataInputStream = new DataInputStream(this.jarFile.getInputStream(zipEntry));
                    int n = (int)zipEntry.getSize();
                    byArray = new byte[n];
                    dataInputStream.readFully(byArray);
                    dataInputStream.close();
                    break;
                }
                return byArray;
            }
            catch (Exception exception) {
                this.jarFile = null;
                this.jarFileEntries = null;
                this.log.printStackTrace(this, 2, exception);
                throw new ClassNotFoundException(nameData.className);
            }
        }
        File file = new File(nameData.pathName);
        System.out.println("class file name: " + file);
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            int n = (int)file.length();
            byArray = new byte[n];
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            return byArray;
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 2, exception);
            throw new ClassNotFoundException(string);
        }
    }

    protected synchronized Class findClass(String string) throws ClassNotFoundException {
        String string2;
        byte[] byArray = this.getBytecodes(string);
        if (string.indexOf(46) != -1 && this.getPackage(string2 = string.substring(0, string.lastIndexOf(46))) == null) {
            this.definePackage(string2, null, null, null, null, null, null, null);
        }
        return this.defineClass(string, byArray, 0, byArray.length);
    }

    public URL getResource(String string) {
        URL uRL = this.findResource(string);
        return uRL;
    }

    protected URL findResource(String string) {
        NameData nameData = new NameData(string);
        try {
            if (this.isJarFile) {
                return new URL("jar:file:" + URLEncoder.encode(this.classSource.getPath()) + "!" + string);
            }
            File file = new File(nameData.pathName);
            String string2 = file.getAbsolutePath().replace(File.separatorChar, '/');
            if (string2.charAt(0) != '/') {
                string2 = '/' + string2;
            }
            System.out.println("resource name: " + string2);
            return new URL("file:" + string2);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    protected Enumeration findResources(String string) throws IOException {
        return new SingleEnum(this.findResource(string));
    }

    private class NameData {
        public String className;
        public String baseClass;
        public String pkgName;
        public String fileName;
        public String pathName;

        public NameData(String string) {
            this.className = this.className;
            if (string.indexOf(".") >= 0) {
                this.baseClass = string.substring(string.lastIndexOf(".") + 1);
                this.pkgName = string.substring(0, string.lastIndexOf("."));
                this.fileName = this.baseClass + ".class";
                this.pathName = DetectorClassLoader.this.mkPathFromClass(this.pkgName, null) + File.separator + this.fileName;
            } else {
                this.baseClass = string;
                this.fileName = this.pathName = this.baseClass + ".class";
            }
        }
    }

    private static class SingleEnum
    implements Enumeration {
        Object element;

        SingleEnum(Object object) {
            this.element = object;
        }

        public boolean hasMoreElements() {
            return this.element == null;
        }

        public Object nextElement() {
            if (this.element == null) {
                throw new NoSuchElementException();
            }
            Object object = this.element;
            this.element = null;
            return object;
        }
    }
}

