/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.analysis;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.InteractiveDetector;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.UnknownRealizationException;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.util.Interaction;
import com.sun.patchpro.util.InteractionSet;
import com.sun.patchpro.util.InvalidVersionException;
import com.sun.patchpro.util.QuestionTrueFalse;
import com.sun.patchpro.util.Version;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class InteractiveDetectorPrtl
implements InteractiveDetector {
    protected InteractionSet interactionSet;
    protected Vector applicableRealizations;
    protected Vector requiredRealizations;
    protected String statusMessage;
    protected PatchProLog log = PatchProLog.getInstance();

    public Enumeration getRealizations() {
        return this.applicableRealizations.elements();
    }

    public InteractionSet getInteractionSet() {
        return this.interactionSet;
    }

    public Enumeration getRequiredRealizations() throws NoSuchRealizationException {
        if (this.hasRealizationDependency()) {
            return this.requiredRealizations.elements();
        }
        throw new NoSuchRealizationException("This Realization detector has no realization dependencies.");
    }

    public boolean hasRealizationDependency() {
        if (this.requiredRealizations == null) {
            return false;
        }
        return !this.requiredRealizations.isEmpty();
    }

    public String getMessage() {
        return this.statusMessage;
    }

    protected void initialize(String[] stringArray) throws DetectorFailedException {
        this.applicableRealizations = new Vector();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                Realization realization = this.constructRealization(stringArray[n]);
                this.applicableRealizations.addElement(realization);
                ++n;
            }
        }
    }

    private Realization constructRealization(String string) throws DetectorFailedException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        try {
            return new Realization(stringTokenizer.nextToken(), new Version(stringTokenizer.nextToken()));
        }
        catch (NoSuchRealizationException noSuchRealizationException) {
            throw new DetectorFailedException(noSuchRealizationException.getMessage());
        }
        catch (InvalidVersionException invalidVersionException) {
            throw new DetectorFailedException(invalidVersionException.getMessage());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new DetectorFailedException(noSuchElementException.getMessage());
        }
    }

    protected InteractionSet constructInteractionSet(Interaction[] interactionArray, int n) {
        InteractionSet interactionSet = new InteractionSet(n);
        int n2 = 0;
        while (n2 < interactionArray.length) {
            interactionSet.addInteraction(interactionArray[n2]);
            ++n2;
        }
        return interactionSet;
    }

    protected InteractionSet precheckInteractionSet(Host host, InteractionSet interactionSet, String[] stringArray) {
        try {
            interactionSet.reset();
            if (interactionSet.nextInteraction() == null) {
                this.log.println(this, 3, "The interactionSet is empty.");
            }
            boolean bl = false;
            int n = 0;
            while (n < stringArray.length) {
                QuestionTrueFalse questionTrueFalse = (QuestionTrueFalse)interactionSet.nextInteraction();
                Realization realization = null;
                realization = new Realization(stringArray[n]);
                questionTrueFalse.setAnswer(host.hasRealization(realization));
                ++n;
            }
        }
        catch (NoSuchRealizationException noSuchRealizationException) {
            this.log.println(this, 4, "No such realization.");
        }
        catch (UnknownRealizationException unknownRealizationException) {
            this.log.println(this, 4, "Unknown realization.");
        }
        catch (NoSuchElementException noSuchElementException) {
            this.log.println(this, 4, "No such interaction.");
        }
        return interactionSet;
    }
}

