/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.analysis;

import com.sun.patchpro.analysis.BaseDataDetector;
import com.sun.patchpro.analysis.DetectorEvent;
import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.DetectorListener;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.FileFinder;
import com.sun.patchpro.util.InstallationParameters;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.Percentage;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class SunOSBaseData
implements BaseDataDetector {
    private Host targetHost;
    private PatchProLog log;
    private PatchProProperties properties;
    private Vector listeners = new Vector();
    private Locale locale;
    private LocalizedMessages catalog;
    private int progress;
    private InstallationParameters instParms = null;
    private int detectorsDone = 0;
    private Vector detectors = new Vector();

    public SunOSBaseData() {
        this.log = PatchProLog.getInstance();
        this.properties = PatchProProperties.getInstance();
        this.instParms = InstallationParameters.getInstance();
        this.catalog = this.locale != null ? new LocalizedMessages(this.locale) : new LocalizedMessages(Locale.ENGLISH);
    }

    public void setHost(Host host) {
        this.targetHost = host;
    }

    public String getMessage() {
        return this.catalog.getMessage("SunOSBaseDataMessage", "Looking for packages, patches, hosts & configuration ...");
    }

    public void run() {
        Object object;
        this.initializeProgress();
        Enumeration enumeration = null;
        FileFinder fileFinder = new FileFinder();
        String string = this.instParms.getClassesDirectoryPath();
        String string2 = this.properties.getProperty("patchpro.basedatadetector.prefix");
        if (string2 == null || string2.equals("")) {
            string2 = this.getOSName();
        }
        String string3 = new String(string2 + "BaseDataExtension.class");
        try {
            enumeration = fileFinder.findAllMatchingFiles(string, string3, FileFinder.FORMAT_CLASSNAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BaseDataDetector baseDataDetector = null;
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            try {
                baseDataDetector = this.getDetectorFromName((String)object);
            }
            catch (Exception exception) {
                this.log.println(this, 4, "SunOSBaseData.analyze(): Class " + (String)object + " not found.");
            }
            baseDataDetector.setHost(this.targetHost);
            DetectorThread detectorThread = new DetectorThread(baseDataDetector, (String)object);
            this.detectors.add(detectorThread);
        }
        object = null;
        int n = 0;
        while (n < this.detectors.size()) {
            object = (DetectorThread)this.detectors.elementAt(n);
            ((DetectorThread)object).start();
            ++n;
        }
        try {
            int n2;
            while (this.detectorsDone < this.detectors.size()) {
                n2 = 0;
                while (n2 < this.detectors.size()) {
                    object = (DetectorThread)this.detectors.elementAt(n2);
                    if (((DetectorThread)object).isAlive()) {
                        ((DetectorThread)object).join(1000);
                        ((DetectorThread)object).yield();
                    }
                    ++n2;
                }
                Thread.sleep(2000L);
            }
            n2 = 0;
            while (n2 < this.detectors.size()) {
                object = (DetectorThread)this.detectors.elementAt(n2);
                ((DetectorThread)object).logTimeout();
                ++n2;
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.println(this, 4, "SunOSBaseData.analyze(): Operation was interrupted.");
        }
        this.dispatchDoneEvent(new DetectorEvent(this));
    }

    public Percentage percentComplete() {
        return new Percentage(this.progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DetectorListener detectorListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(detectorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DetectorListener detectorListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(this.listeners);
        }
    }

    private void initializeProgress() {
        this.progress = 0;
        this.detectorsDone = 0;
    }

    private void evaluateProgress() {
        DetectorThread detectorThread = null;
        long l = 0L;
        int n = 0;
        while (n < this.detectors.size()) {
            try {
                detectorThread = (DetectorThread)this.detectors.elementAt(n);
                l += (long)detectorThread.percentComplete().getPercentage();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        long l2 = l / (long)this.detectors.size();
        this.progress = (int)l2;
        this.dispatchProgressEvent(new DetectorEvent(this));
    }

    private void dispatchProgressEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorProgress(detectorEvent);
        }
    }

    private void dispatchDoneEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorDone(detectorEvent);
        }
    }

    private void dispatchFailedEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            this.log.println(this, 7, "SunOSBaseData: Error Event.");
            detectorListener.detectorFailed(detectorEvent);
        }
    }

    private String getOSName() {
        String string = System.getProperty("os.name");
        if (string.compareTo("Solaris") == 0) {
            string = "SunOS";
        }
        return string;
    }

    private BaseDataDetector getDetectorFromName(String string) throws DetectorFailedException {
        this.log.println(this, 7, "BaseDataDetector analyzerName=" + string);
        try {
            Class<?> clazz = Class.forName(string);
            BaseDataDetector baseDataDetector = (BaseDataDetector)clazz.newInstance();
            return baseDataDetector;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.println(this, 4, "HostAnalyzer.getTargetBase(): Unable to open platform specific analyzer, " + string + ".");
            throw new DetectorFailedException("HostAnalyzer.getTargetBase(): Unable to open platform specific analyzer, " + string + ".");
        }
        catch (InstantiationException instantiationException) {
            this.log.println(this, 4, "HostAnalyzer.getTargetBase(): Unable to instantiate " + string + ".");
            throw new DetectorFailedException("HostAnalyzer.getTargetBase(): Unable to instantiate " + string + ".");
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log.println(this, 4, "HostAnalyzer.getTargetBase(): Unable to access " + string + ".");
            throw new DetectorFailedException("HostAnalyzer.getTargetBase(): Unable to access " + string + ".");
        }
    }

    private class DetectorThread
    implements DetectorListener {
        BaseDataDetector detector;
        Thread detectorThread;
        String name;

        public DetectorThread(BaseDataDetector baseDataDetector, String string) {
            this.detector = baseDataDetector;
            this.name = string;
            baseDataDetector.addListener(this);
            this.detectorThread = new Thread(baseDataDetector);
        }

        public void setPriority() throws IllegalThreadStateException, IllegalArgumentException, SecurityException {
            this.detectorThread.setDaemon(true);
            this.detectorThread.setPriority(1);
        }

        public void start() {
            this.detectorThread.start();
        }

        public boolean isAlive() {
            return this.detectorThread.isAlive();
        }

        public void join(int n) throws InterruptedException {
            this.detectorThread.join(n);
        }

        public void yield() {
            DetectorThread detectorThread = this;
            detectorThread.detectorThread.yield();
        }

        public void logTimeout() {
            if (this.detector.percentComplete().getPercentage() != 100) {
                SunOSBaseData.this.log.println(this, 4, "SunOSBaseData.analyze(): " + this.name + " timed out.");
            }
        }

        public Percentage percentComplete() {
            return this.detector.percentComplete();
        }

        public void detectorProgress(DetectorEvent detectorEvent) {
            SunOSBaseData.this.evaluateProgress();
        }

        public void detectorDone(DetectorEvent detectorEvent) {
            this.detector.removeListener(this);
            SunOSBaseData.this.detectorsDone++;
            SunOSBaseData.this.evaluateProgress();
        }

        public void detectorFailed(DetectorEvent detectorEvent) {
            SunOSBaseData.this.dispatchFailedEvent(detectorEvent);
        }
    }
}

