/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.cli;

import com.sun.patchpro.cli.TTY;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.NonFatalException;
import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProAccessor;
import com.sun.patchpro.model.PatchProEvent;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProListener;
import com.sun.patchpro.model.PatchProModel;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.PatchProRuntimeException;
import com.sun.patchpro.model.PatchPropertyNotFoundException;
import com.sun.patchpro.model.PropertyInfo;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchInfo;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.util.GetOpt;
import com.sun.patchpro.util.GetOptException;
import com.sun.patchpro.util.InstallationParameters;
import com.sun.patchpro.util.LocalizedMessages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public final class PatchServices
implements PatchProListener {
    private static final String validArgs = "D:o:c:C:z:hR:s:p:t:r:l@nd;i;";
    private LocalizedMessages msgcat;
    private PatchPro model;
    private ReadOnlyHost primaryHost;
    private PatchProProperties properties = PatchProProperties.getInstance();
    boolean done = false;
    boolean hostIsAnalyzed = false;
    String hostsToInstall = null;
    Throwable problem = null;
    private static final String LIST_RESULT_FILE = "required_patches.xml";
    private static final String DOWNLOAD_RESULT_FILE = "results.xml";
    private static final String INSTALL_RESULT_FILE = "results.xml";
    private static boolean option_p_Specified = false;
    private static boolean option_o_Specified = false;
    private static String targetHostStr = null;
    private static String patchIDStr = null;
    private static String downloadDirectory = null;
    private static boolean noExit = false;
    private InstallationParameters instParms = InstallationParameters.getInstance();
    private BufferedReader stdin = null;
    public static final String SIGNING_CERT_REVOKED = "The signing certificate has been revoked. All patch download activities have been disabled. ";
    public static final String INSTANTIATION_PROBLEM = "Problem detected during PatchPro initialization process. Please check the log file. Exiting";

    public PatchServices() {
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
    }

    public static void main(String[] stringArray) {
        String string = null;
        PatchProProperties patchProProperties = PatchProProperties.getInstance();
        GetOpt getOpt = new GetOpt(stringArray, validArgs);
        LocalizedMessages localizedMessages = new LocalizedMessages(patchProProperties.getLocale());
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        PatchServices patchServices = new PatchServices();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = true;
        boolean bl16 = true;
        Vector<String> vector = null;
        try {
            int n;
            while ((n = getOpt.getNextOption()) != -1) {
                switch ((char)n) {
                    case 'd': {
                        if (bl4) {
                            bl = true;
                            break;
                        }
                        bl4 = true;
                        break;
                    }
                    case 'h': {
                        if (bl5) {
                            bl = true;
                            break;
                        }
                        bl5 = true;
                        break;
                    }
                    case 'i': {
                        if (bl6) {
                            bl = true;
                            break;
                        }
                        bl6 = true;
                        break;
                    }
                    case 'l': {
                        if (bl7) {
                            bl = true;
                            break;
                        }
                        bl7 = true;
                        break;
                    }
                    case 'o': {
                        if (option_o_Specified) {
                            bl = true;
                        } else {
                            targetHostStr = getOpt.getOptionArg();
                        }
                        option_o_Specified = true;
                        break;
                    }
                    case 'p': {
                        if (option_p_Specified) {
                            bl = true;
                        } else {
                            patchIDStr = getOpt.getOptionArg();
                        }
                        option_p_Specified = true;
                        break;
                    }
                    case 'r': {
                        if (bl9) {
                            bl = true;
                        } else {
                            string = getOpt.getOptionArg();
                        }
                        bl9 = true;
                        break;
                    }
                    case 's': {
                        if (bl10) {
                            bl = true;
                        } else {
                            string4 = getOpt.getOptionArg();
                        }
                        bl10 = true;
                        break;
                    }
                    case 'C': {
                        if (vector == null) {
                            vector = new Vector<String>();
                        }
                        vector.add(getOpt.getOptionArg());
                        bl3 = true;
                        break;
                    }
                    case 'c': {
                        if (bl2) {
                            bl = true;
                            break;
                        }
                        string2 = getOpt.getOptionArg();
                        bl2 = true;
                        break;
                    }
                    case 'D': {
                        if (downloadDirectory != null) {
                            bl = true;
                            break;
                        }
                        downloadDirectory = getOpt.getOptionArg();
                        break;
                    }
                    case 'n': {
                        if (bl8) {
                            bl = true;
                            break;
                        }
                        bl8 = true;
                        break;
                    }
                    case 'R': {
                        if (bl13) {
                            bl = true;
                            break;
                        }
                        string3 = getOpt.getOptionArg();
                        bl13 = true;
                        break;
                    }
                    case 't': {
                        if (bl11) {
                            bl = true;
                        } else {
                            string5 = getOpt.getOptionArg();
                        }
                        bl11 = true;
                        break;
                    }
                    case 'z': {
                        if (bl12) {
                            bl = true;
                            break;
                        }
                        String string6 = getOpt.getOptionArg();
                        noExit = string6.equals("true");
                        bl12 = true;
                        break;
                    }
                    case '@': {
                        if (bl14) {
                            bl = true;
                            break;
                        }
                        bl14 = true;
                        break;
                    }
                    default: {
                        System.out.println(patchServices.msgcat.getMessage("invalidOption", "Ignoring invalid option."));
                    }
                }
            }
            if (bl) {
                System.err.println(localizedMessages.getMessage("errDuplicateDetected", "Error: One or more duplicate options were detected."));
                PatchServices.maybeExit(1);
                return;
            }
            if (bl5 || stringArray.length < 1) {
                PatchServices.usage(localizedMessages);
                System.exit(0);
            }
            if (bl7 && (bl4 || bl6) || bl4 && (bl7 || bl6) || bl6 && (bl7 || bl4)) {
                System.err.println(localizedMessages.getMessage("pprosvcmutex", "Options l, d and i are mutually exclusive"));
                PatchServices.usage(localizedMessages);
                System.exit(1);
            }
            if (bl13) {
                bl15 = patchServices.setRealizationsProvided(string3);
            }
            if (bl3) {
                patchServices.setProperties(vector);
            }
            if (!bl15) {
                System.exit(1);
            } else {
                patchServices.instantiateModel();
                if (downloadDirectory != null) {
                    patchProProperties.setProperty("patchpro.download.directory", downloadDirectory);
                    patchProProperties.setProperty("patchpro.patch.sequester.directory", downloadDirectory + File.separator + "patchproSequester");
                }
                if (string2 != null) {
                    patchServices.changeConfigFile(string2);
                }
                if (option_o_Specified) {
                    bl16 = patchServices.setInstallHost(targetHostStr);
                    if (!bl16) {
                        System.exit(1);
                    }
                    if (option_p_Specified) {
                        if (bl4 || bl6) {
                            patchProProperties.setHostSpecificProperty(targetHostStr, "patchpro.patches.provided", patchIDStr);
                        } else {
                            PatchServices.usage(localizedMessages);
                            System.exit(1);
                        }
                    }
                    patchProProperties.setProperty("patchpro.target.hosts", targetHostStr);
                } else if (option_p_Specified) {
                    if (bl4 || bl6 || bl7) {
                        patchProProperties.setProperty("patchpro.patches.provided", patchIDStr);
                        bl16 = patchServices.setInstallHost(null);
                    } else {
                        PatchServices.usage(localizedMessages);
                        System.exit(1);
                    }
                }
                if (bl8) {
                    if (!bl6) {
                        PatchServices.usage(localizedMessages);
                        System.exit(1);
                    } else {
                        patchServices.setNoninteractive();
                    }
                }
                if (bl7) {
                    if (string == null) {
                        string = LIST_RESULT_FILE;
                    }
                    if (bl14) {
                        PatchList patchList = patchServices.displayPatchMetaData();
                    } else {
                        PatchList patchList = patchServices.displayPatchList();
                    }
                }
                if (bl4) {
                    if (string == null) {
                        string = "results.xml";
                    }
                    patchServices.downloadAllPatches();
                }
                if (bl6) {
                    if (string == null) {
                        string = "results.xml";
                    }
                    patchServices.installPatches();
                }
                if (bl10) {
                    int n2 = 1;
                    if (bl7 || bl4 || bl6) {
                        patchServices.initializeHost();
                        if (bl7) {
                            n2 = 1;
                        } else if (bl4) {
                            n2 = 3;
                        } else if (bl6) {
                            n2 = 16;
                        }
                        patchServices.setSessionID(string4, string, n2);
                    }
                }
            }
        }
        catch (PatchProException patchProException) {
            PatchProLog.getInstance().printStackTrace(patchProException, 7, patchProException);
            System.err.println(patchProException.getLocalizedMessage());
            PatchServices.maybeExit(1);
            return;
        }
        catch (GetOptException getOptException) {
            System.err.println(getOptException.getMessage());
            PatchServices.usage(localizedMessages);
            PatchServices.maybeExit(1);
            return;
        }
        catch (IOException iOException) {
            PatchServices.maybeExit(1);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            PatchServices.maybeExit(1);
            return;
        }
        PatchServices.maybeExit(0);
    }

    private static void usage(LocalizedMessages localizedMessages) {
        System.err.println(localizedMessages.getMessage("pprosvcUsage", "usage:\tpprosvc [-d [-p patch-id[,patch-id,...]]] [-h]\n\t[-i [-n] [-p patch-id[,patch-id,...]]] [-l]\n\n\tWhere:\n"));
        System.err.println("\t-d\t" + localizedMessages.getMessage("usageDownloadAll", "Downloads the patches that are required by this hos\n\t\tsystem"));
        System.err.println("\t-h\t" + localizedMessages.getMessage("usageHelp", "Displays command usage statement"));
        System.err.println("\t-i\t" + localizedMessages.getMessage("usageInstallAll", "Installs the patches from the designated download\n\t\tdirectory"));
        System.err.println("\t-l\t" + localizedMessages.getMessage("usageListPatches", "Analyzes the host system to generate a list of required\n\t\tpatches"));
        System.err.println("\t-n\t" + localizedMessages.getMessage("usageNonInteractive", "Runs Patch Manager in non-interactive mode"));
        System.err.println("\t-p\t" + localizedMessages.getMessage("usagePatchID", "Specifies the particular patches on which to operate"));
    }

    private void instantiateModel() throws PatchProException {
        PatchProAccessor patchProAccessor = new PatchProAccessor();
        this.model = patchProAccessor.getPatchPro();
    }

    private void initializeHost() {
        this.primaryHost = this.model.getHost();
    }

    public PatchList displayPatchList() throws PatchProException {
        PatchList patchList = null;
        System.out.println(this.msgcat.getMessage("assessNeededPatches", "Assessing patches needed for your system..."));
        this.prepForThread();
        this.model.assessNeededPatches();
        this.waitForThread();
        patchList = this.model.getNeededPatches();
        System.out.println(this.msgcat.getMessage("getNeededPatches", "Retrieved patch list..."));
        if (patchList.size() > 0) {
            this.printPatchList(patchList);
        } else {
            System.out.println(this.msgcat.getMessage("noPatches", "No patches required."));
        }
        return patchList;
    }

    public void printPatchList(PatchList patchList) {
        System.out.println(this.msgcat.getMessage("reqPatches", "Required patches."));
        if (patchList.hasAnyErrors()) {
            System.out.println(this.msgcat.getMessage("errorsFound", "Errors were found."));
        }
        int n = 0;
        while (n < patchList.size()) {
            try {
                Patch patch = patchList.getPatchAt(n);
                System.out.println(patch.getPatchID().getPatchID() + " " + patch.getPatchInfo().getSynopsis());
                boolean bl = patchList.hasErrorAt(n);
                if (bl) {
                    System.err.println("    Error: " + patchList.getErrorAt(n));
                }
            }
            catch (NoSuchPatchException noSuchPatchException) {
                System.err.println("Error: The patch list contains a non-existing patch.");
            }
            ++n;
        }
    }

    public PatchList displayPatchMetaData() throws PatchProException {
        this.prepForThread();
        this.model.assessNeededPatches();
        this.waitForThread();
        PatchList patchList = this.model.getNeededPatches();
        Vector vector = PatchServices.convertPatchList(patchList);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
        }
        return patchList;
    }

    public static Vector convertPatchList(PatchList patchList) throws PatchProException {
        Vector vector = new Vector();
        int n = 0;
        while (n < patchList.size()) {
            Patch patch = patchList.getPatchAt(n);
            String string = patch.getPatchID().getPatchID();
            PatchInfo patchInfo = patch.getPatchInfo();
            PatchServices.addData(vector, string, "id", string);
            PatchServices.addData(vector, string, "syn", patchInfo.getSynopsis());
            PatchServices.addData(vector, string, "obs", patchInfo.getObsoletes());
            PatchServices.addData(vector, string, "req", patchInfo.getRequires());
            PatchServices.addData(vector, string, "inc", patchInfo.getIncompat());
            PatchServices.addData(vector, string, "obsc", patchInfo.getObsolesces());
            PatchServices.addData(vector, string, "prf", patchInfo.getPrefers());
            PatchServices.addData(vector, string, "props", PatchServices.translateProps(patchInfo));
            PatchServices.addData(vector, string, "real", PatchServices.translateReal(patchInfo));
            ++n;
        }
        return vector;
    }

    private static void addData(Vector vector, String string, String string2, String string3) {
        if (string3 != null) {
            vector.add(string + "." + string2 + "=" + string3);
        }
    }

    private static String translateReal(PatchInfo patchInfo) throws PatchProException {
        Enumeration enumeration = patchInfo.getRealizations();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            Realization realization = (Realization)enumeration.nextElement();
            stringBuffer.append(" ").append(realization.getRealizationString());
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.substring(1);
        }
        return null;
    }

    private static String translateProps(PatchInfo patchInfo) throws PatchProException {
        PatchProperties patchProperties = patchInfo.getProperties();
        StringBuffer stringBuffer = new StringBuffer();
        if (patchProperties.isDiscontinued()) {
            stringBuffer.append(" discontinued");
        }
        if (patchProperties.isClientroot()) {
            stringBuffer.append(" clientroot");
        }
        if (patchProperties.isClientusr()) {
            stringBuffer.append(" clientusr");
        }
        if (patchProperties.isInteractive()) {
            stringBuffer.append(" interactive");
        }
        if (patchProperties.isNonstandard()) {
            stringBuffer.append(" nonstandard");
        }
        if (patchProperties.isSingleuser()) {
            stringBuffer.append(" singleuser");
        }
        if (patchProperties.isObsolete()) {
            stringBuffer.append(" obsolete");
        }
        if (patchProperties.isNoncontract()) {
            stringBuffer.append(" noncontract");
        }
        if (patchProperties.isRebootimmediate()) {
            stringBuffer.append(" rebootimmediate");
        }
        if (patchProperties.isRebootafter()) {
            stringBuffer.append(" rebootafter");
        }
        if (patchProperties.isReconfigimmediate()) {
            stringBuffer.append(" reconfigimmediate");
        }
        if (patchProperties.isReconfigafter()) {
            stringBuffer.append(" reconfigafter");
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.substring(1);
        }
        return null;
    }

    public static Vector getAllPropsWithTag(Vector vector, String string) {
        string = "." + string;
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n;
            String string2 = (String)enumeration.nextElement();
            String string3 = string2.substring(0, n = string2.indexOf(61));
            if (!string3.endsWith(string)) continue;
            vector2.add(string2.substring(n + 1));
        }
        return vector2;
    }

    public void downloadAllPatches() throws PatchProException {
        System.out.println(this.msgcat.getMessage("assessNeededPatches", "Assessing patches needed for your system..."));
        this.prepForThread();
        this.model.assessNeededPatches();
        this.waitForThread();
        PatchList patchList = this.model.getNeededPatches();
        System.out.println(this.msgcat.getMessage("getNeededPatches", "Retrieved patch list..."));
        if (patchList.size() > 0) {
            System.out.println(this.msgcat.getMessage("downloadingPatches", "Downloading patches to") + " " + this.properties.getProperty("patchpro.download.directory") + "...");
            this.prepForThread();
            this.model.downloadPatches();
            this.waitForThread();
            PatchList patchList2 = this.model.getUnavailablePatches();
            if (patchList2 != null && patchList2.size() != 0) {
                System.out.println(this.msgcat.getMessage("downloaded_not", "The following patches were not downloaded:"));
                int n = 0;
                while (n < patchList2.size()) {
                    IPatch iPatch;
                    try {
                        iPatch = (IPatch)patchList2.getPatchAt(n);
                    }
                    catch (NoSuchPatchException noSuchPatchException) {
                        throw new PatchProException(noSuchPatchException);
                    }
                    if (iPatch != null) {
                        System.out.println("\t" + iPatch.getError());
                    }
                    ++n;
                }
            }
        } else {
            System.out.println(this.msgcat.getMessage("noPatches", "No patches required."));
        }
    }

    public boolean setInstallHost(String string) throws PatchProException {
        ReadOnlyHost readOnlyHost;
        boolean bl = true;
        if (!this.hostIsAnalyzed) {
            this.prepForThread();
            this.model.analyzeHost();
            this.waitForThread();
            this.hostIsAnalyzed = true;
        }
        this.primaryHost = this.model.getHost();
        if (string == null) {
            string = targetHostStr = this.primaryHost.getAddress();
        }
        Enumeration enumeration = this.primaryHost.getAssociates();
        int n = this.primaryHost.getAssociateCount() + 1;
        Vector<ReadOnlyHost> vector = new Vector<ReadOnlyHost>(n);
        vector.add(this.primaryHost);
        while (enumeration.hasMoreElements()) {
            readOnlyHost = (ReadOnlyHost)enumeration.nextElement();
            vector.add(readOnlyHost);
        }
        boolean bl2 = this.validateIP(string);
        if (!bl2) {
            vector.clear();
            bl = false;
        } else {
            if (this.primaryHost.isAddress(string)) {
                vector.remove(this.primaryHost);
            }
            enumeration = this.primaryHost.getAssociates();
            while (enumeration.hasMoreElements()) {
                readOnlyHost = (ReadOnlyHost)enumeration.nextElement();
                if (!readOnlyHost.isAddress(string)) continue;
                vector.remove(readOnlyHost);
            }
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                ReadOnlyHost readOnlyHost2 = (ReadOnlyHost)enumeration2.nextElement();
                readOnlyHost2.getSessionData().setIgnoreStatus(true);
            }
        }
        return bl;
    }

    private boolean validateIP(String string) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        n2 = stringTokenizer.countTokens();
        if (n2 == 4) {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                Integer n3 = new Integer(string2);
                int n4 = 0;
                int n5 = 255;
                if (n3.compareTo(new Integer(n4)) >= 0 && n3.compareTo(new Integer(n5)) <= 255) {
                    ++n;
                    continue;
                }
                System.out.println(this.msgcat.getMessage("invalidIPAddress", "An invalid IP address is specified."));
                break;
            }
            if (n == 4) {
                bl = true;
            }
        } else {
            System.out.println(this.msgcat.getMessage("invalidIPAddress", "An invalid IP address is specified."));
        }
        return bl;
    }

    public void setSessionID(String string, String string2, int n) {
        String string3;
        File file;
        File file2;
        String string4 = "patchpro.sessionid.directory.prefix";
        this.properties.setProperty(string4, "/var/tmp/pprosvc_");
        if (string2 == null || string2.length() == 0) {
            string2 = "results.xml";
        }
        if ((file2 = (file = new File(string3 = "/var/tmp/pprosvc_" + string + "/" + string2)).getParentFile()) != null && !file2.exists()) {
            file2.mkdirs();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            this.primaryHost.printXMLPatchListSet(n, 0, printWriter);
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    private boolean patchesAreRequired(ReadOnlyHost readOnlyHost) {
        SessionData sessionData = readOnlyHost.getSessionData();
        if (!sessionData.getIgnoreStatus() && sessionData.getPatchesRequired().size() > 0) {
            return true;
        }
        Enumeration enumeration = readOnlyHost.getAssociates();
        while (enumeration.hasMoreElements()) {
            Host host = (Host)enumeration.nextElement();
            sessionData = host.getSessionData();
            if (sessionData.getIgnoreStatus() || sessionData.getPatchesRequired().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public void installPatches() throws PatchProException {
        System.out.println(this.msgcat.getMessage("assessNeededPatches", "Assessing patches needed for your system..."));
        this.prepForThread();
        this.model.assessNeededPatches();
        this.waitForThread();
        System.out.println(this.msgcat.getMessage("getNeededPatches", "Retrieved patch list..."));
        if (this.patchesAreRequired(this.model.getHost())) {
            String string = this.properties.getProperty("patchpro.download.directory");
            System.out.println(this.msgcat.getMessage("downloadingPatches", "Downloading patches to") + " " + string + "...");
            this.prepForThread();
            this.model.downloadPatches();
            this.waitForThread();
            String string2 = this.properties.getProperty("patchpro.download.directory");
            System.out.println(this.msgcat.getMessage("installingPatches", "Applying patches from") + " " + string2 + "...");
            this.prepForThread();
            this.model.installPatches();
            this.waitForThread();
        } else {
            System.out.println(this.msgcat.getMessage("noPatches", "No patches required."));
        }
    }

    public boolean setRealizationsProvided(String string) {
        String string2 = "patchpro.realization.provided";
        boolean bl = true;
        if (string == null || string.equals("none")) {
            string = "";
        }
        if (string != "") {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    Realization realization = new Realization(string3);
                }
                catch (NoSuchRealizationException noSuchRealizationException) {
                    System.out.println(this.msgcat.getMessage("noSuchRealization", "Poorly formed realization."));
                    bl = false;
                    return bl;
                }
            }
        }
        this.properties.setProperty(string2, string);
        return bl;
    }

    public void patchproProgress(PatchProEvent patchProEvent) {
    }

    public void patchproDone(PatchProEvent patchProEvent) {
        this.done = true;
    }

    public void patchproFailed(PatchProEvent patchProEvent) {
        Object object = patchProEvent.getSource();
        if (object instanceof PatchProModel) {
            Throwable throwable = ((PatchProModel)object).getPatchProFailure();
            if (throwable instanceof NonFatalException) {
                if (!throwable.getLocalizedMessage().equals("Received a Manipulable event.")) {
                    System.err.println(throwable.getLocalizedMessage());
                }
            } else {
                this.problem = throwable;
            }
        } else {
            this.problem = new RuntimeException("Error: Event source is " + object.getClass().getName() + ", not PatchProModel");
        }
    }

    public void setNoninteractive() {
        this.model.setInteractive(false);
    }

    public void changeConfigFile(String string) throws IOException {
        File file = new File(string);
        try {
            if (!file.isAbsolute()) {
                file = new File(this.instParms.getConfigDirectoryPath(), string);
            }
            this.properties.load(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(this.msgcat.getMessage("config.file.not.found", "The specified configuration file could not be found."));
            throw new IOException("No Such Config File.");
        }
        catch (IOException iOException) {
            System.out.println(this.msgcat.getMessage("config.file.not.readable", "The specified configuration file cannot be read."));
            throw iOException;
        }
    }

    private void prepForThread() {
        this.model.addListener(this);
        this.done = false;
        this.problem = null;
    }

    private void waitForThread() throws PatchProException {
        while (!this.done) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.model.removeListener(this);
        if (this.problem == null) {
            return;
        }
        if (this.problem instanceof RuntimeException) {
            throw (RuntimeException)this.problem;
        }
        if (this.problem instanceof Error) {
            throw (Error)this.problem;
        }
        if (this.problem instanceof PatchProException) {
            throw (PatchProException)this.problem;
        }
        throw new PatchProRuntimeException("Unexpected throwable", this.problem);
    }

    private static void maybeExit(int n) {
        if (noExit) {
            System.out.println("System.exit(" + n + ")");
        } else {
            System.exit(n);
        }
    }

    private void setProperties(Vector vector) throws PatchProException {
        try {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2;
                String string3 = (String)enumeration.nextElement();
                int n = string3.indexOf(61);
                if (n >= 0) {
                    string2 = string3.substring(0, n);
                    string = string3.substring(n + 1);
                } else {
                    string2 = string3;
                    PropertyInfo propertyInfo = this.properties.getPropertyInfo(string2);
                    if (TTY.isaTTY()) {
                        System.err.print(propertyInfo.getDescription() + ": ");
                        if (propertyInfo.getSecretFlag()) {
                            TTY.echoOff();
                        }
                        string = this.readLine();
                        if (propertyInfo.getSecretFlag()) {
                            TTY.echoOn();
                            System.err.println();
                        }
                    } else {
                        string = this.readLine();
                    }
                }
                this.properties.setProperty(string2, string);
            }
        }
        catch (PatchPropertyNotFoundException patchPropertyNotFoundException) {
            throw new PatchProException(patchPropertyNotFoundException.getLocalizedMessage());
        }
    }

    private String readLine() throws PatchProException {
        if (this.stdin == null) {
            this.stdin = new BufferedReader(new InputStreamReader(System.in));
        }
        try {
            return this.stdin.readLine();
        }
        catch (IOException iOException) {
            throw new PatchProException(iOException);
        }
    }
}

