/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.database;

import com.sun.database.simpleadapter.common.PracticalTokenizer;
import com.sun.database.simpleadapter.memory.MemoryAdapter;
import com.sun.database.simpledatabase.DatabaseError;
import com.sun.database.simpledatabase.DuplicateEntryException;
import com.sun.database.simpledatabase.SimpleDatabase;
import com.sun.patchpro.database.DBBuilderFailedException;
import com.sun.patchpro.database.MemoryPatchDB;
import com.sun.patchpro.database.PatchBaseRecord;
import com.sun.patchpro.database.PatchDB;
import com.sun.patchpro.database.PatchDBBuilder;
import com.sun.patchpro.database.RealizationRecord;
import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.DownloadPatchDBEvent;
import com.sun.patchpro.model.DownloadPatchDBListener;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.server.PatchServerProxy;
import com.sun.patchpro.server.PatchServerProxyException;
import com.sun.patchpro.util.CachingDownloader;
import com.sun.patchpro.util.IncompatibleVersionException;
import com.sun.patchpro.util.InvalidVersionException;
import com.sun.patchpro.util.Percentage;
import com.sun.patchpro.util.Version;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class MemoryPatchDBBuilder
implements PatchDBBuilder {
    private final String LISTPROPERTIESNAME = "patchlist.properties";
    private int progress = 0;
    private float loadedPatchCount;
    private float totalPatchCount;
    private float onePercent;
    private float currentThreshold;
    private Vector listeners;
    private PatchProLog log;
    private PatchProProperties properties = PatchProProperties.getInstance();
    private Reader sourceReader;
    private Properties patchlistProperties;
    private SimpleDatabase patchBaseDB = null;
    private SimpleDatabase realizationDB = null;
    private PatchDB patchDB = null;
    private CachingDownloader downloader;
    static final String LISTVERSIONMINIMUM = "1.0";
    static final String LISTVERSION = "list.version";
    static final String PATCHCOUNT = "patch.count";
    static final String PATCHDELIMITER = "patch.delimiter";
    static final String PATCHLISTNAME = "patchlist.name";

    public MemoryPatchDBBuilder() {
        this.log = PatchProLog.getInstance();
        this.listeners = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PatchDB buildDB(String string, String string2, String string3, String string4) throws DBBuilderFailedException, PatchProException {
        if (this.patchDB == null) {
            try {
                this.downloadPatchDB(string);
                this.patchDB = new MemoryPatchDB(string2, string3, string4, this.patchBaseDB, this.realizationDB);
                Object var6_5 = null;
                this.dispatchDoneEvent(new DownloadPatchDBEvent(this));
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.dispatchDoneEvent(new DownloadPatchDBEvent(this));
                throw throwable;
            }
        } else {
            this.dispatchDoneEvent(new DownloadPatchDBEvent(this));
        }
        return this.patchDB;
    }

    public File getCacheFile(URL uRL) {
        return new File(this.properties.getProperty("patchpro.cache.directory"), URLEncoder.encode(uRL.toString()));
    }

    public URL getGetURL(String string) throws MalformedURLException {
        return new URL(this.properties.getProperty("patchpro.database.url.head") + string + this.properties.getProperty("patchpro.database.url.tail"));
    }

    /*
     * Unable to fully structure code
     */
    private synchronized InputStream downloadPatchDBWithPOST(String var1_1) throws IOException, PatchProException {
        block3: {
            var2_2 = null;
            try {
                var2_2 = new PatchServerProxy(this.properties);
                break block3;
            }
            catch (PatchServerProxyException var3_3) {
                this.log.printStackTrace(this, 3, var3_3);
                var4_4 = "";
                var5_5 = new StringTokenizer(var3_3.getMessage(), ":");
                var6_6 = var5_5.countTokens();
                var7_7 = 0;
                ** while (var7_7 < var6_6)
            }
lbl-1000:
            // 1 sources

            {
                var4_4 = var5_5.nextToken();
                ++var7_7;
                continue;
            }
lbl15:
            // 1 sources

            throw new PatchProException(var3_3.toString());
        }
        return new FileInputStream(var2_2.downloadPatchDB(var1_1));
    }

    public synchronized void buildDB(ReadOnlyHost readOnlyHost) throws DBBuilderFailedException, PatchProException {
        this.properties = readOnlyHost.getSessionData().getProperties();
        String string = this.properties.getProperty("patchpro.patchset");
        PatchDB patchDB = this.buildDB(string, readOnlyHost.getOperatingSystem(), readOnlyHost.getOSRelease(), readOnlyHost.getArchitecture());
        readOnlyHost.getSessionData().setPatchDB(patchDB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PatchDB buildDB(String string) throws DBBuilderFailedException, PatchProException {
        try {
            this.downloadPatchDB(string);
            PatchDB patchDB = this.patchDB = new MemoryPatchDB(this.patchBaseDB, this.realizationDB);
            Object var4_3 = null;
            this.dispatchDoneEvent(new DownloadPatchDBEvent(this));
            return patchDB;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.dispatchDoneEvent(new DownloadPatchDBEvent(this));
            throw throwable;
        }
    }

    public Percentage percentComplete() {
        return new Percentage(this.progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DownloadPatchDBListener downloadPatchDBListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(downloadPatchDBListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DownloadPatchDBListener downloadPatchDBListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(this.listeners);
        }
    }

    private InputStream downloadPatchDBWithGET(String string) throws IOException, PatchProException {
        URL uRL = this.getGetURL(string);
        this.log.println(this, 7, "MemoryPatchDBBuilder.setSourceURL(): new CachingDownloader(" + uRL + ")");
        File file = this.getCacheFile(uRL);
        int n = Integer.parseInt(this.properties.getProperty("patchpro.cache.old.age.days.database"));
        int n2 = Integer.parseInt(this.properties.getProperty("patchpro.cache.dead.age.days.database"));
        try {
            this.downloader = new CachingDownloader(string, uRL, file, CachingDownloader.days(n), CachingDownloader.days(n2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PatchProException(fileNotFoundException);
        }
        return this.downloader;
    }

    private void verifyListVersion() throws IOException, IncompatibleVersionException {
        try {
            Version version = new Version(this.patchlistProperties.getProperty(LISTVERSION));
            Version version2 = new Version(LISTVERSIONMINIMUM);
            if (version2.compareTo(version) > 0) {
                if (this.downloader != null) {
                    this.downloader.close();
                }
                throw new IncompatibleVersionException("MemoryPatchDBBuilder: Patch list version of " + version.getVersion() + " is lower than the required " + LISTVERSIONMINIMUM + ".");
            }
        }
        catch (InvalidVersionException invalidVersionException) {
            if (this.downloader != null) {
                this.downloader.close();
            }
            throw new IncompatibleVersionException("MemoryPatchDBBuilder: Patch list version of " + this.patchlistProperties.getProperty(LISTVERSION) + " is malformed.");
        }
    }

    private void initializeProgress(int n) {
        this.totalPatchCount = n;
        this.currentThreshold = this.onePercent = (float)n / 100.0f;
        this.loadedPatchCount = 0.0f;
        this.progress = 0;
    }

    private void incrementProgress() {
        this.loadedPatchCount += 1.0f;
        if (this.loadedPatchCount > this.currentThreshold) {
            this.currentThreshold += this.onePercent;
            this.progress = (int)((double)(this.loadedPatchCount / this.totalPatchCount) * 100.0);
            this.dispatchProgressEvent(new DownloadPatchDBEvent(this));
        }
    }

    public Percentage getPatchDBProgress() {
        Percentage percentage;
        try {
            percentage = new Percentage(this.progress);
        }
        catch (Exception exception) {
            this.log.println(this, 4, "MemoryPatchDBBuilder.getPatchDBProgress(): Unable to create a Percentage from " + this.progress + ".");
            percentage = new Percentage(100);
        }
        return percentage;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void transferFile() throws SecurityException, IllegalAccessException, IOException {
        String string = this.patchlistProperties.getProperty(PATCHCOUNT);
        this.initializeProgress(new Integer(string.trim()));
        PracticalTokenizer practicalTokenizer = new PracticalTokenizer(this.patchlistProperties.getProperty(PATCHDELIMITER), this.sourceReader);
        practicalTokenizer.eolIsSignificant(true);
        String[] stringArray = new String[]{"patchBaseCode"};
        String[] stringArray2 = new String[]{"realization"};
        try {
            this.patchBaseDB = new MemoryAdapter(Class.forName("com.sun.patchpro.database.PatchBaseRecord"), stringArray);
            this.patchBaseDB.allowDuplicates("patchBaseCode", true);
            this.realizationDB = new MemoryAdapter(Class.forName("com.sun.patchpro.database.RealizationRecord"), stringArray2);
            try {
                while (true) {
                    PatchBaseRecord patchBaseRecord = new PatchBaseRecord();
                    this.loadObjects(practicalTokenizer, patchBaseRecord, this.realizationDB);
                    this.storePatchBase(this.patchBaseDB, patchBaseRecord);
                    this.incrementProgress();
                }
            }
            catch (EOFException eOFException) {
                this.log.println(this, 7, "MemoryPatchDBBuilder.transferFile(): Reached end of patchlist stream.");
                try {
                    if (this.downloader != null) {
                        while (this.downloader.skip(10L) != -1L) {
                        }
                        this.downloader.close();
                    }
                    if (this.patchBaseDB != null) {
                        this.patchBaseDB.closeDatabase();
                    }
                    if (this.patchBaseDB == null) return;
                    this.realizationDB.closeDatabase();
                    return;
                }
                catch (Throwable throwable) {
                    this.log.println(this, 2, "MemoryPatchDBBuilder.transferFile: Unexpected throwable " + throwable.toString() + " thrown with message " + throwable.getMessage() + ".");
                    throw new DatabaseError("odd throwable");
                }
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            try {
                this.log.println(this, 2, "MemoryPatchDBBuilder.transferFile: Class in the database does not include a field that was there when it was created!!!");
                throw new DatabaseError("no such field.");
                catch (Exception exception) {
                    this.log.printStackTrace(this, 2, exception);
                    this.log.println(this, 2, "MemoryPatchDBBuilder.transferFile: Unexpected exception " + exception.toString() + " thrown with message " + exception.getMessage() + ".");
                    throw new DatabaseError("odd exception");
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.downloader != null) {
                        while (this.downloader.skip(10L) != -1L) {
                        }
                        this.downloader.close();
                    }
                    if (this.patchBaseDB != null) {
                        this.patchBaseDB.closeDatabase();
                    }
                    if (this.patchBaseDB == null) throw throwable;
                    this.realizationDB.closeDatabase();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    this.log.println(this, 2, "MemoryPatchDBBuilder.transferFile: Unexpected throwable " + throwable2.toString() + " thrown with message " + throwable2.getMessage() + ".");
                    throw new DatabaseError("odd throwable");
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadObjects(PracticalTokenizer practicalTokenizer, PatchBaseRecord patchBaseRecord, SimpleDatabase simpleDatabase) throws IOException, EOFException {
        Object var4_4 = null;
        Object var5_5 = null;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (practicalTokenizer.nextToken() != -2) {
            if (practicalTokenizer.ttype == -3) {
                if (bl2) {
                    bl2 = false;
                    n = 0;
                    continue;
                }
                if (n == 0) {
                    bl3 = true;
                } else {
                    if (n == 16) return;
                    bl2 = true;
                }
            }
            if (bl2) {
                ++n;
                continue;
            }
            switch (n) {
                case 0: {
                    patchBaseRecord.patchBaseCode = practicalTokenizer.sval;
                    break;
                }
                case 1: {
                    patchBaseRecord.patchVersion = practicalTokenizer.sval;
                    break;
                }
                case 2: {
                    patchBaseRecord.synopsis = practicalTokenizer.sval;
                    break;
                }
                case 3: {
                    patchBaseRecord.targetArchitecture = practicalTokenizer.sval;
                    break;
                }
                case 4: {
                    patchBaseRecord.targetOS = practicalTokenizer.sval;
                    break;
                }
                case 5: {
                    patchBaseRecord.targetRelease = practicalTokenizer.sval;
                    break;
                }
                case 6: {
                    patchBaseRecord.requires = practicalTokenizer.sval;
                    break;
                }
                case 7: {
                    patchBaseRecord.obsolesces = practicalTokenizer.sval;
                    break;
                }
                case 8: {
                    patchBaseRecord.incompatibleWith = practicalTokenizer.sval;
                    break;
                }
                case 9: {
                    patchBaseRecord.prefers = practicalTokenizer.sval;
                    break;
                }
                case 10: {
                    patchBaseRecord.obsolescedBy = practicalTokenizer.sval;
                    break;
                }
                case 11: {
                    patchBaseRecord.corrects = practicalTokenizer.sval;
                    if (patchBaseRecord.corrects.length() <= 0) break;
                    StringTokenizer stringTokenizer = new StringTokenizer(patchBaseRecord.corrects);
                    while (stringTokenizer.hasMoreElements()) {
                        RealizationRecord realizationRecord = new RealizationRecord();
                        realizationRecord.realization = (String)stringTokenizer.nextElement();
                        realizationRecord.patchIDs = patchBaseRecord.patchBaseCode + "-" + patchBaseRecord.patchVersion;
                        try {
                            this.storeRealization(simpleDatabase, realizationRecord);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            this.log.println(this, 2, "MemoryPatchDBBuilder.loadObjects: Unexpectedly denied access to the database.");
                            throw new DatabaseError((Exception)illegalAccessException, "MemoryPatchDBBuilder.loadObjects: Denied access to the database.");
                        }
                    }
                    break;
                }
                case 12: {
                    patchBaseRecord.constraint = practicalTokenizer.sval;
                    break;
                }
                case 13: {
                    patchBaseRecord.properties = practicalTokenizer.sval;
                    break;
                }
                case 14: {
                    patchBaseRecord.type = practicalTokenizer.sval;
                    break;
                }
            }
            if (bl3) {
                bl3 = false;
                continue;
            }
            ++n;
        }
        if (!bl) throw new EOFException();
    }

    private void storeRealization(SimpleDatabase simpleDatabase, RealizationRecord realizationRecord) throws IllegalAccessException {
        if (realizationRecord.realization != null && realizationRecord.realization.compareTo("") != 0) {
            try {
                simpleDatabase.addObject((Object)realizationRecord);
            }
            catch (DuplicateEntryException duplicateEntryException) {
                try {
                    String string;
                    int n = simpleDatabase.findObjectHandle(0, (Object)realizationRecord.realization);
                    RealizationRecord realizationRecord2 = (RealizationRecord)simpleDatabase.getObject(n);
                    realizationRecord2.patchIDs = string = new String(realizationRecord2.patchIDs + " " + realizationRecord.patchIDs);
                }
                catch (Exception exception) {
                    throw new IllegalAccessException("MemoryPatchDBBuilder.storeRealization: Unable to clear old database entry");
                }
            }
            catch (Exception exception) {
                this.log.println(this, 2, "MemoryPatchDBBuilder.storeRealization: Unable to store the realization " + realizationRecord.realization + ".");
                throw new DatabaseError(exception, "MemoryPatchDBBuilder.storeRealization: Could not store a new realization.");
            }
        }
    }

    private void storePatchBase(SimpleDatabase simpleDatabase, PatchBaseRecord patchBaseRecord) throws IllegalAccessException {
        try {
            simpleDatabase.addObject((Object)patchBaseRecord);
        }
        catch (Exception exception) {
            this.log.println(this, 2, "MemoryPatchDBBuilder.storePatchBase: Unexpectedly denied access to the database.");
            throw new DatabaseError(exception, "MemoryPatchDBBuilder.storePatchBase: Denied access to the database.");
        }
    }

    private void dispatchProgressEvent(DownloadPatchDBEvent downloadPatchDBEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchDBListener downloadPatchDBListener = (DownloadPatchDBListener)enumeration.nextElement();
            downloadPatchDBListener.downloadPatchDBProgress(downloadPatchDBEvent);
        }
    }

    private void dispatchDoneEvent(DownloadPatchDBEvent downloadPatchDBEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchDBListener downloadPatchDBListener = (DownloadPatchDBListener)enumeration.nextElement();
            downloadPatchDBListener.downloadPatchDBDone(downloadPatchDBEvent);
        }
    }

    private void downloadPatchDB(String string) throws DBBuilderFailedException, PatchProException {
        try {
            String string2 = this.properties.getProperty("patchpro.database.download.method");
            InputStream inputStream = string2.equalsIgnoreCase("post") ? this.downloadPatchDBWithPOST(string) : this.downloadPatchDBWithGET(string);
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            this.log.println(this, 7, "zipInputStream = " + zipInputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            this.patchlistProperties = new Properties();
            this.patchlistProperties.load(zipInputStream);
            zipEntry = zipInputStream.getNextEntry();
            this.sourceReader = new InputStreamReader(zipInputStream);
            this.verifyListVersion();
            this.transferFile();
        }
        catch (IOException iOException) {
            this.log.println(this, 7, "MemoryPatchDBBuilder: IOException during downloadPatchDB()");
            throw new DBBuilderFailedException(iOException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log.println(this, 7, "MemoryPatchDBBuilder: IllegalAccessException during downloadPatchDB()");
            throw new DBBuilderFailedException(illegalAccessException);
        }
    }
}

