/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.host;

import com.sun.patchpro.util.LineParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;

public class SoftwarePackage
implements Serializable {
    static final String REVLEVELPREAMBLE = ",PATCH=";
    private int patchLevel = 0;
    private int instance = 0;
    private Properties pkginfo;
    private String description;
    private String processor;
    private String name;
    private String version;

    public SoftwarePackage() {
    }

    public SoftwarePackage(String string, String string2) {
        this.setName(string);
        this.setVersion(string2);
        this.pkginfo = new Properties();
    }

    public SoftwarePackage(String string, String string2, File file) {
        this(string, string2);
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            LineParser lineParser = new LineParser();
            String string4 = "";
            while ((string3 = bufferedReader.readLine()) != null) {
                String string5;
                try {
                    string5 = lineParser.getTokenPrefix(string3, "=");
                    try {
                        string4 = lineParser.getTokenSuffix(string3, "=");
                        string4 = string4.replace('\"', ' ');
                        string4 = string4.replace('\'', ' ');
                        string4 = string4.trim();
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        string4 = "";
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    string5 = new String(string3);
                    string4 = "";
                }
                this.pkginfo.setProperty(string5, string4);
            }
        }
        catch (IOException iOException) {}
    }

    public void setName(String string) {
        int n = string.indexOf(46);
        if (n > -1) {
            this.name = string.substring(0, n);
            try {
                Integer n2 = new Integer(string.substring(n + 1));
                this.instance = n2;
            }
            catch (Exception exception) {
                this.instance = 0;
            }
        } else {
            this.name = string;
            this.instance = 0;
        }
    }

    public void setVersion(String string) {
        String string2 = string;
        int n = string2.indexOf(REVLEVELPREAMBLE);
        if (n > 0) {
            String string3 = string2.substring(n + REVLEVELPREAMBLE.length());
            try {
                this.patchLevel = new Integer(string3);
            }
            catch (Exception exception) {
                this.patchLevel = 0;
            }
            this.version = string2.substring(0, n);
        } else {
            this.version = string;
        }
    }

    public void setProcessorArch(String string) {
        this.processor = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getBasecode() {
        return this.name;
    }

    public Properties getPkginfo() {
        return this.pkginfo;
    }

    public boolean matches(SoftwarePackage softwarePackage) {
        if (softwarePackage.getName().compareTo(this.getName()) != 0) {
            return false;
        }
        return softwarePackage.getVersion().compareTo(this.getVersion()) == 0;
    }

    public String getFullName() {
        if (this.instance > 0) {
            return this.name + "." + this.instance + "-" + this.version;
        }
        return this.name + "-" + this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public int getPatchLevel() {
        return this.patchLevel;
    }

    public int getInstance() {
        return this.instance;
    }
}

