/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.interpreter;

import com.sun.patchpro.interpreter.Node;
import com.sun.patchpro.interpreter.PatchListExpressionTree;
import com.sun.patchpro.interpreter.PatchListExpressionTreeTreeConstants;
import com.sun.patchpro.interpreter.PatchListExpressionTreeVisitor;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected PatchListExpressionTree parser;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(PatchListExpressionTree patchListExpressionTree, int n) {
        this(n);
        this.parser = patchListExpressionTree;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Object jjtAccept(PatchListExpressionTreeVisitor patchListExpressionTreeVisitor, Object object) {
        return patchListExpressionTreeVisitor.visit(this, object);
    }

    public Object childrenAccept(PatchListExpressionTreeVisitor patchListExpressionTreeVisitor, Object object) {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                this.children[n].jjtAccept(patchListExpressionTreeVisitor, object);
                ++n;
            }
        }
        return object;
    }

    public String toString() {
        return PatchListExpressionTreeTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.dump(string + " ");
                }
                ++n;
            }
        }
    }
}

