/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.patch;

import com.sun.patchpro.database.PatchDB;
import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.interpreter.HostSpecificInterpreter;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.patch.PatchSequencer;
import java.util.Enumeration;
import java.util.Locale;

public class PatchAccumulator {
    SessionData sessionData = null;
    HostSpecificInterpreter interpreter;
    PatchDB db;
    PatchListImpl existingPatches;
    PatchListImpl resultingPatchList = null;
    PatchSequencer sequencer;
    Locale locale;

    public PatchAccumulator(ReadOnlyHost readOnlyHost, Locale locale) {
        PatchListImpl patchListImpl = new PatchListImpl();
        this.sessionData = readOnlyHost.getSessionData();
        this.interpreter = this.sessionData.getInterpreter();
        this.db = this.sessionData.getPatchDB();
        this.locale = locale;
        Enumeration enumeration = readOnlyHost.getAppliedPatches();
        while (enumeration.hasMoreElements()) {
            patchListImpl.addIPatch(new IPatch(new PatchImpl((PatchID)enumeration.nextElement()), 2002));
        }
        this.existingPatches = patchListImpl;
        this.sequencer = new PatchSequencer(this.interpreter, this.db, locale);
        this.resultingPatchList = new PatchListImpl();
    }

    public PatchAccumulator(HostSpecificInterpreter hostSpecificInterpreter, PatchDB patchDB, PatchListImpl patchListImpl, Locale locale) {
        this.interpreter = hostSpecificInterpreter;
        this.db = patchDB;
        this.existingPatches = patchListImpl;
        this.locale = locale;
        this.sequencer = new PatchSequencer(hostSpecificInterpreter, patchDB, locale);
        this.resultingPatchList = new PatchListImpl();
    }

    public PatchList getPatchClosure(PatchID patchID) throws NoSuchPatchException {
        this.resultingPatchList.addIPatch(new IPatch(this.db.getLatestPatch(patchID), 2002));
        this.resultingPatchList = this.sequencer.getPatchList(this.resultingPatchList, this.existingPatches);
        return this.resultingPatchList;
    }
}

